// This TPageControl descendent is used in the Wizard 97 class


unit PageControlEx;

interface

uses
  Windows, Messages, Classes, CommCtrl, ComCtrls;

type
  TPageControlEx=class(TPageControl)
  published
    function FindNextEnabledPage(CurPage: TTabSheet; GoForward: Boolean): TTabSheet;
  protected
    procedure WndProc(var Message:TMessage); override;
  end;

procedure Register;

implementation

// This overriden procedure removes the default border width of the standard TPageControl.
// ,effectively a border between the TabSheet and PageControl

procedure TPageControlEx.WndProc(var Message:TMessage);
begin
  if(Message.Msg=TCM_ADJUSTRECT) then begin
    Inherited WndProc(Message);
    PRect(Message.LParam)^.Left:=0;
    PRect(Message.LParam)^.Right:=ClientWidth;
    PRect(Message.LParam)^.Top:=PRect(Message.LParam)^.Top-6;  // Crucial Change here??
    PRect(Message.LParam)^.Bottom:=ClientHeight;
  end else Inherited WndProc(Message);
end;

// This function is used to find the next enabled Tabsheet
// It is similar to the standard FindNextPage except that it
// checks whether the TabSheet is Enabled, and it doesn't loop around
//to the beginning when reaches the last TabSheet

function TPageControlEx.FindNextEnabledPage(CurPage: TTabSheet; GoForward : Boolean): TTabSheet;
var
  I, StartIndex: Integer;
begin
  if PageCount <> 0 then
  begin
    if CurPage = nil then
      if GoForward then StartIndex := -1 else StartIndex := PageCount
    else
      StartIndex := CurPage.PageIndex;

    I := StartIndex;
    repeat
      if GoForward then
      begin
        Inc(I);
        if I = PageCount then begin
          Result := nil;
          exit;
        end;

      end else
      begin
        if I = 0 then begin
          Result := nil;
          exit;
        end;

        Dec(I);
      end;
      Result := Pages[I];
      if Result.Enabled then Exit;
    until I = StartIndex;
  end;
  Result := nil;
end;



procedure Register;
begin
  RegisterComponents('Win32', [TPageControlEx]);
end;

end.
