{ This is a very simple demo how to use the TDBWestgardRules component.  }
{ The components needs to know the datasource and the mean value and the }
{ standard deviation. To execute the checking call the method "Execute". }
{ The component then verifies if the currently selected record fails     }
{ some of the 6 Westgard rules. If yes, then the  "OnRuleFailed" event is}
{ called.                                                                }
{************************************************************************}
{ This demo is distributed without the component source code.            }
{ If you are interested to get the source (for free !) just              }
{ send me a E-Mail sam_herzog@yahoo.com                                  }

unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  UWGardRu, Db, DBTables, Grids, DBGrids, StdCtrls;

type
  TFMain = class(TForm)
    DBWestGardRules1: TDBWestGardRules;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Button1: TButton;
    Table1: TTable;
    EMeanValue: TEdit;
    LMeanValue: TLabel;
    EDeviation: TEdit;
    LDeviation: TLabel;
    procedure DBWestGardRules1RuleFailed(Sender: TObject; RuleNo,RecordNo: Integer);
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    _temp:string;
  public
    { Public declarations }
  end;

var
  FMain: TFMain;

implementation
uses uCreateDB;
{$R *.DFM}


{******************************************************************************}
{ This will execute the checking for the Westgard rules from the               }
{ currently selected record.                                                   }
{******************************************************************************}
procedure TFMain.Button1Click(Sender: TObject);
begin
  Caption:='';
  _temp:='';
  DBWestGardRules1.execute;
end;

{******************************************************************************}
{ if one of the rules fails, then this event handler is executed.              }
{ The rule number which failed will be displayed in the form caption.          }
{******************************************************************************}
procedure TFMain.DBWestGardRules1RuleFailed(Sender: TObject; RuleNo,RecordNo: Integer);
begin
  if _temp<>'' then _temp:=_temp+','+IntToStr(RuleNo)
               else _temp:=IntToStr(RuleNo);
  Caption:='Westgard rule <'+_temp+'> failed.';
end;

{******************************************************************************}
{ The following two methods are only used for the demo and have nothing to do  }
{ with the TDBWestGardRules component.                                         }
{******************************************************************************}

{******************************************************************************}
{ This will create the demo table and fill it with some demo data.             }
{******************************************************************************}
procedure TFMain.FormShow(Sender: TObject);
begin
  Open_Table(Table1);
  Fill_Table(Table1,'Value',DBWestGardRules1.MeanValue,DBWestGardRules1.StandardDeviation);
  EMeanValue.Text:=floattostr(DBWestGardRules1.meanvalue);
end;

{******************************************************************************}
{ This deletes the demo table when the application terminates.                 }
{******************************************************************************}
procedure TFMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Close_table(Table1);
end;

end.
