unit uCreateDB;

interface

uses DBTables, SysUtils, DB, Dialogs, Windows,FileCtrl;

const
  Table_Name = 'Result';
  TempDir= 'C:\temp\';

function Open_Table(var _table: TTable): Boolean;
procedure Create_table(var _table: TTable);
procedure Close_table(var _table: TTable);
procedure Fill_Table(var _table:TTable;_Fieldname:string;_mean,_deviation:Extended);


implementation

function RandomValue(_mean,_deviation:Extended):Extended;
begin
  Result:=(_mean-(4*_deviation))+Random(trunc(8*_deviation));
end;

procedure Fill_Table(var _table:TTable;_Fieldname:string;_mean,_deviation:Extended);
var
i:integer;
begin
  if _table.RecordCount<100 then
  begin
    for i:=1 to 100 do
    begin
      _table.insert;
      _table.FieldByName('Item').AsInteger:=i;
      _table.FieldByName('IntDateTime').AsDatetime:=Now;
      _table.FieldByName('Value').AsFloat:=RandomValue(_mean,_deviation);
      _table.post;
    end;
  end;
end;


{:============================================================:}
{: PROCEDURE Create_table                                     :}
{: discription :                                              :}
{: programmed by :  SH                                        :}
{: tested by :                                                :}
{: last changes on : 03.08.99                                 :}
{:============================================================:}
procedure Create_table(var _table: TTable);
begin
  with _table do
  begin
    begin
      with FieldDefs do{ Next, describe the fields in the table }
      begin
        Clear;
        Add('Item', ftInteger, 0, True);
        Add('IntDateTime', ftDateTime, 0, True);
        Add('Value', ftFloat, 0, False);
      end;
      with IndexDefs do{ Next, describe any indexes }
      begin
        Clear;
        Add('', 'Item', [ixPrimary, ixUnique]); { The first index has no name because it is a Paradox primary key }
        Add('ixDateTime', 'IntDateTime;Item', []);
      end;
      try
        CreateTable;
        Close;
      except
        on E: Exception do
        begin
          MessageDlg('Could not create the table <' + TableName + '>. Check if the BDE settings are correct.' + E.Message, mtError, [mbOK], 0);
          Halt;
        end;
      end;
    end;
  end;
end;

{:============================================================:}
{: PROCEDURE Close_table                                      :}
{: discription :                                              :}
{: programmed by :  SH                                        :}
{: tested by :                                                :}
{: last changes on : 03.08.99                                 :}
{:============================================================:}
procedure Close_table(var _table: TTable);
begin
  with _table do
  begin
    Close;
    DeleteTable;
  end;
end;

{:============================================================:}
{: PROCEDURE Open_table                                       :}
{: discription : try to open the table, if the table does not :}
{:               exist, then create it.                       :}
{: programmed by :  SH                                        :}
{: tested by :                                                :}
{: last changes on : 03.08.99                                 :}
{:============================================================:}
function Open_Table(var _table: TTable): Boolean;
begin
  Open_Table := False;
  with _table do
  begin
    Active := False; { The Table component must not be active }
    TableName := TempDir + Table_Name;
    if not FileExists(TableName + '.db') then Create_table(_table);
    try
      _table.Open;
      Open_Table := True;
    except
      MessageDlg('Could not open the table <' + TableName + '>.', mtError, [mbOK], 0);
      Halt;
    end;
  end;
end;

end.
