unit Main;

// Demonstration project for TVirtualStringTree to generally show how to get started

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  VirtualTrees, StdCtrls;

type
  TMainForm = class(TForm)
    VST: TVirtualStringTree;
    ClearButton: TButton;
    AddOneButton: TButton;
    Edit1: TEdit;
    Button1: TButton;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure AddOneButtonClick(Sender: TObject);
    procedure VSTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode; Column: Integer; TextType: TVSTTextType;
      var Text: WideString);
    procedure VSTFreeNode(Sender: TBaseVirtualTree; Node: PVirtualNode);
    procedure VSTInitNode(Sender: TBaseVirtualTree; ParentNode, Node: PVirtualNode;
      var InitialStates: TVirtualNodeInitStates);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

//----------------------------------------------------------------------------------------------------------------------

implementation

{$R *.DFM}

type
  PMyRec = ^TMyRec;
  TMyRec = record
    Caption: WideString;
  end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FormCreate(Sender: TObject);

begin
  VST.NodeDataSize := SizeOf(TMyRec);
  VST.RootNodeCount := 20;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ClearButtonClick(Sender: TObject);

var
  Start: Cardinal;

begin
  Screen.Cursor := crHourGlass;
  try
    Start := GetTickCount;
    VST.Clear;
    Label1.Caption := Format('Last operation duration: %d ms', [GetTickCount - Start]);
  finally
    Screen.Cursor := crDefault;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.AddOneButtonClick(Sender: TObject);

var
  Count: Cardinal;
  Start: Cardinal;
  
begin
  Screen.Cursor := crHourGlass;
  with VST do
  try
    Start := GetTickCount;
    case (Sender as TButton).Tag of
      0: // add to root
        begin
          Count := StrToInt(Edit1.Text);
          RootNodeCount := RootNodeCount + Count;
        end;
      1: // add as child
        if Assigned(FocusedNode) then
        begin
          Count := StrToInt(Edit1.Text);
          ChildCount[FocusedNode] := ChildCount[FocusedNode] + Count;
          Expanded[FocusedNode] := True;
          InvalidateToBottom(FocusedNode);
        end;
    end;
    Label1.Caption := Format('Last operation duration: %d ms', [GetTickCount - Start]);
  finally
    Screen.Cursor := crDefault;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.VSTGetText(Sender: TBaseVirtualTree; Node: PVirtualNode; Column: Integer; TextType: TVSTTextType;
  var Text: WideString);

var
  Data: PMyRec;

begin
  Data := Sender.GetNodeData(Node);
  if Assigned(Data) then
    Text := Data.Caption;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.VSTFreeNode(Sender: TBaseVirtualTree; Node: PVirtualNode);

var
  Data: PMyRec;

begin
  Data := Sender.GetNodeData(Node);
  // explicitely free the string, the VCL cannot know that there is one but needs to free
  // it nonetheless
  if Assigned(Data) then
    Data.Caption := '';
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.VSTInitNode(Sender: TBaseVirtualTree; ParentNode, Node: PVirtualNode;
  var InitialStates: TVirtualNodeInitStates);

var
  Data: PMyRec;

begin
  with Sender do
  begin
    Data := GetNodeData(Node);
    Data.Caption := Format('Level %d, Index %d', [GetNodeLevel(Node), Node.Index]);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

end.

