unit ts1;

{  DEMO Program for TsList }
{  ~ Quick and dirty ~     }
{  10.10.2001 /Ts          }

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, SyncObjs, StdCtrls, Contnrs,TsList, Buttons;

type
  TForm1 = class(TForm)
    SendEvent1: TButton;
    SendEvent2: TButton;
    SendEvent3: TButton;
    SendEvent4: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    ClearMemo1: TBitBtn;
    ClearMemo2: TBitBtn;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    procedure InitForm(Sender: TObject);
    procedure EndForm(Sender: TObject);
    procedure SendEvent1Click(Sender: TObject);
    procedure SendEvent2Click(Sender: TObject);
    procedure ClearMemo1Click(Sender: TObject);
    procedure ClearMemo2Click(Sender: TObject);
    procedure SendEvent3Click(Sender: TObject);
    procedure SendEvent4Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public

    { Public-Deklarationen }
  end;

  Ts1Thread = class(TThread)
  private

  protected
    procedure Execute; override;
  public

  end;

  Ts2Thread = class(TThread)
  private

  protected
    procedure Execute; override;
  public

  end;


type
  ta = array [0..9] of char;

  tUserData = record
                s1 : string [100];
                a1 : ta;
                id : integer;
              end;

  tUserPtr = ^tUserData;

var
  Form1  : TForm1;
  TTS1   : Ts1Thread;
  TTS2   : Ts2Thread;

  aPool    : array [0..4] of tTsFrame;
  auPool   : array [0..4] of tUserData;
  pHeader  : tTsHeader;
  uFrame   : tTsFrame;
  u1Frame  : tTsFrame;
  u2Frame  : tTsFrame;
  u3Frame  : tTsFrame;
  u1Header : tTsHeader;
  u2Header : tTsHeader;
  Id1,id2  : Integer;

  data   : tUserData;
  str1   : string;

  pUser    : tUserPtr;


implementation

{$R *.dfm}

procedure showmemo2 (ix : Integer);
Var
 i      : Integer;
 next   : tTsFramePtr;


procedure show (i : Integer);
begin
  str1:= Format ('[%d] %d %d %d',[i, uFrame.prio, uFrame.id, uFrame.Hwnd]);
  if uFrame.UD = nil then
    str1 := str1 + ' nil '
  else
  begin
    pUser := uFrame.UD;
    str1 := str1 + ' s1= ' + pUser.s1 + ' a1= ' + pUser.a1;
  end;
  Form1.Memo2.Lines.Add(str1);
end;


begin
  Form1.Memo2.Lines.Add('+++++++++++++++++ uFrame ++++++++++++++++');
  uFrame := u2Frame;
  Show (0);

  if (ix = 0) OR (ix = 2) then
  begin
    Form1.Memo2.Lines.Add('--- u2Header ---');
    for i := 1 to u2Header.Count do
      if ReadxTs (u2Header, uFrame, i-1) then
      begin
        Show (i);
      end;
    end;

  if (ix = 0) OR (ix = 3) then
  begin
    Form1.Memo2.Lines.Add(' *** pHeader ***');
    for i := 1 to pHeader.Count do
    begin
      if ReadxTs (pHeader, uFrame, i-1) then
      begin
        Show (i);
      end;
    end;
  end;
end;


procedure showmemo1 (ix : Integer);
Var
 s      : string;
 i      : Integer;
 next   : tTsFramePtr;
 uFrame : tTsFrame;


procedure show (i : Integer);
begin
  s:= Format ('[%d] %d %d %d',[i,next.prio, next.id, next.Hwnd]);
  if next.UD = nil then
    s := s + ' nil '
  else
  begin
    pUser := next.UD;
    s := s + ' : ' + pUser.s1;
  end;
  Form1.Memo1.Lines.Add(s);
  next := next.Next;
end;


begin
  Form1.Memo1.Lines.Add('+++++++++++++++++ uFrame ++++++++++++++++');
  next := @u1Frame;
  Show (0);

  if (ix = 0) OR (ix = 1) then
  begin
    Form1.Memo1.Lines.Add('--- u1Header ---');
    next := u1Header.Next;
    for i := 1 to u1Header.Count do
    begin
      if ReadxTs (u1Header, uFrame, i-1) then
      begin
        next := @uFrame;
        Show (i);
      end;
    end;
  end;
end;


procedure Ts1Thread.Execute;
begin
  repeat
    case WaitEventTs (u1Header,30000) of
      WAIT_OBJECT_0 :
      begin
        if GetxULD (u1Header, u1Frame, 0) then
        begin
          If u1Header.Count = 0 then ResetEvent (u1Header.HEvent);
          Form1.Memo1.Lines.Add('***** Thread1 : Signal');
          showmemo1 (1);
          if u1Frame.UD <> nil then
            dispose (u1Frame.UD);
        end;
      end;
      WAIT_TIMEOUT :
        Form1.Memo1.Lines.Add('***** Thread1 : TimeOut');
    else
      Form1.Memo1.Lines.Add('***** Thread1 : Else');
    end;
  until TTS1.Terminated
end;


procedure Ts2Thread.Execute;
begin
  repeat
     case WaitEventTs (u2Header, 30000) of
      WAIT_OBJECT_0 :
      begin
        if GetxUAD (pHeader, u2Header, u2Frame, 0) then
        begin
          If u2Header.Count = 0 then ResetEvent (u2Header.HEvent);
          Form1.Memo2.Lines.Add('***** Thread2 : Signal');
          showmemo2 (0);
        end;
      end;
      WAIT_TIMEOUT :
        Form1.Memo2.Lines.Add('***** Thread2 : TimeOut');
    else
      Form1.Memo2.Lines.Add('***** Thread2 : Else');
    end;
   until TTS2.Terminated
end;



procedure TForm1.InitForm(Sender: TObject);

Var
  i : Integer;


begin
  id1 := 0; id2 := 0;

  TTS1 := Ts1Thread.Create(FALSE);
  TTS1.FreeOnTerminate := TRUE;
  TTS2 := Ts2Thread.Create(FALSE);
  TTS2.FreeOnTerminate := TRUE;

  for i := 0 to High(aPool) do
    if i <= High (auPool) then
      aPool [i].UD := @auPool[i];

  InitArrayPool (pHeader, @aPool, High(APool), FALSE);

  // u1Header List
  InitHeaderTs (u1Header, 0, 0, true);
  // u2 Header Array
  InitHeaderTs (u2Header, 0, 0, false);

  if NOT CreateEventTs (u1Header) then
    ShowMessage ('Error Create Event u1Header');

  if NOT CreateEventTs (u2Header) then
     ShowMessage ('Error Create Event u2Header');


end;

procedure TForm1.EndForm(Sender: TObject);
begin
  TTS1.Terminate;
  TTS2.Terminate;
end;

procedure TForm1.SendEvent1Click(Sender: TObject);

Var
i   : Integer;
s   : string;

begin
  for i := 0 to 2 do
  begin
    Inc(id1);
    InitFrameTs (@u3Frame, 1, Id1, 0, false, nil);
     New (pUser);
     s := 'Thomas'+ IntToStr (id1) +#0;
     pUser^.s1 := s;
     if NOT SendULEvent (u1Header, u3frame, pUser) then
        ShowMessage ('Error Send Event u1Header');
  end;
end;


procedure TForm1.SendEvent2Click(Sender: TObject);
begin
  Inc (id1);
  InitFrameTs (@u3Frame, 2, id1, 0, false, nil);
  if NOT SendULEvent (u1Header, u3frame, nil ) then
    ShowMessage ('Error Create Event u1Header');

end;


procedure TForm1.SendEvent3Click(Sender: TObject);
begin
  Inc (id2);
  InitFrameTs (@u3Frame, 2, id2, 0, false, nil);
  data.s1 := '1-array ' + IntToStr (id2);
  data.a1 := '98765432';
  if NOT SendUAEvent (pHeader, u2Header, u3frame, @data, SizeOf(data)) then
    ShowMessage ('Error Create Event u2Header');
end;


procedure TForm1.SendEvent4Click(Sender: TObject);

begin
  Inc (id2);
  InitFrameTs (@u3Frame, 2, id2, 0, false, nil);
  data.s1 := '2-array '+ IntToStr (id2);
  data.a1 := '12345678';
  if NOT SendUAEvent (pHeader, u2Header, u3frame, @data, SizeOf(data)) then
    ShowMessage ('Error Create Event u2Header');
end;



procedure TForm1.ClearMemo1Click(Sender: TObject);
begin
  Memo1.Clear
end;

procedure TForm1.ClearMemo2Click(Sender: TObject);
begin
  Memo2.Clear;
end;



end.
