//TNyBck compenent V 1.1  26.1.2001
//Nihat Yorganc nyorganci@hotmail.com
// Please send me notes, bugs and problems
//ver 1.1 property
//exchange mport and Export events. This is more useful for TnyBck.
//TexttoDataset method modified Import, DatasettoText method motified Export.
//ExportErrors events and SilentExport propery modified importErrors and silentImport.
//Some Bugs is fixed.

// You can use this component for free in commercial or non-commercial programs
// Please send me the changes you made in source code, and do not forgret my credit!
// Read Readme.txt file included with the package for help and credits.

//This compenent TPgCSV (Khashayar Sadjadi (khashi@pragena.8m.com)) And KDatabase Export pack(delphi@korzh.com) Combined.

//export and import whole database to the text files and binary files.
// Memo and BLOB fields are also supported. TnyBck is saved Total record count in Text file when Export.
//so you can use this count as Gauge Max Value.Please examine to Demo.

//Installation:

// Remove Nybck component previous version.Click Component menu. Select Install Component.
//Select Nybck.pas in Unit File Name with Browse.
//Select Package file name exist your computer(*.dpk).
//or Select into new package, write a new filename in Package file name.Press ok.
//Appear package box and press install. After Save *.dpk file.



//Usage
// 1. Place the component of your Form or DataModule.
// 2. Set the proprties (See properties section in this readme)
// 3. Close dataset
// 4. Call Import or Export methods.
// 5. Open Dataset

//Properties:
//TextFile :String. A Text file. Each record in a seperate line, seperated by CR.
//Delimiter: Char. Seprator character.specifies the delimiter that will separate field values in
// the text files.Default #9 (tab character).

// Dataset :Tdataset. TDataset in Delphi forms or DataModules to link with TNyBck for Import and Export.
//SilentImport    :boolean. Setting this property to True forces TNyBck to do not raise exceptions and call ImportError event
//TotalRecord :integer.Read only. Get Totol record  in BeforeExport and Beforemport events.You get Total Record only this two events.
              // You can use Totol Record your gauge max value.
//Events:

//AfterCloseTable  : Fires after TNyBck closed dataset.

//AfterExport      : Fires after export process of a dataset to a Text Files( and *.Mem files) finishes.

//AfterImport	 : Fires after import process of a Text files (and *.mem) to dataset finishes.

//AfterOpenTable   : Fires after TNyBck opens the dataset.

//BeforeCloseTable : Fires before TNyBck closes the database. 

//BeforeExport	 : Fires before export process starts from a Dataset to a Text files.

//BeforeImport     : Fires before import process starts from a Text files to a Dataset.

//BeforeOpenTable  : Fires before TNyBck opens dataset. 

//ImportError	 : Firest each time an exception occures in Importing a Text to a dataset.
//		   You can force TNyBck to handle ignore error or abort the process.
//		   This event will be fired only if Silentmport property is setted to True.

//ExportProgress	 : Fires each time a new record added to a Text files during exportin a dataset to a textFiles.
//		   You can Stop export progress by setting StopIt parameter to True.

//ImportProgress	 : Fires each time a new record added to a dataset during importing a text fileto a dataset.
//		   You can Stop import progress by setting StopIt parameter to True.

//OnAddRecord	 : Fires each time a new record added to dataset during importing a Text to a dataset.
//Exception handling:

//By setting SilentImport property to True, if an exception occure in Import method, TNyBck will
//not raise exception and will call ImportError event with exception message and record number.
//You can set the Response parameter to nybckIgnore or nybckAbort to make TnyBck handle the exception.
//Setting Response to nybckIgnore will make TNyBck ignore current record and it will continue Importing, but
//nybckAbort will terminate import process at the currect record.
//Default value of Response parameter is nybckIgnore.

//Progress monitoring:

//By writing event handlers for ExportProgress and ImportProgress events, you can monitor Import and/or
//Export progress during the process. You can also stop process by setting StopIt parameter to True within
//event handler.

//Total Record: Readonly.Total record write in text file first line(Export method).
//              Total Record Reading in text file first line(Import mehthod).
//You can get Total record in BeforeExport and BeforeImport events.


unit NyBck;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db;
  type
  TNyError = class(Exception)  //Pgcsv hav'not.
  end;


type

   TNyBckErrorResponse     = (nybckAbort, nybckIgnore);

  TNyBckProgressEvent     = procedure (Sender : TObject; AProgress: LongInt; var StopIt: Boolean) of object;
  TNyBckImportErrorEvent  = procedure (Sender : TObject; Mess: string; RecNo: LongInt; var Response:TNyBckErrorResponse) of object;


  TNyBck = class(TComponent)
  private
    { Private declarations }
    FDataset         : TDataset;
     FTextFile       :string;
     FDelimiter      :char;
     FSilentImport   :Boolean;
     Fstop           :Boolean;
     Ftotal          :longint;//totalrec.

     FBeforeOpenTable,
   FAfterOpenTable,
   FBeforeCloseTable,
   FAfterCloseTable,

   FBeforeExport,
   FAfterExport,
   FBeforeImport,
   FAfterImport,
   FOnAddRecord     : TNotifyEvent;
   FExportProgress,
   FImportProgress  : TNyBckprogressEvent;
   FImportError     : TNyBckImportErrorEvent;
  protected
    { Protected declarations }

    procedure transfer(Fdataset : Tdataset;FtextFile:string);
     procedure ClearFileExt(var FileName : string);
     procedure ChangeFileExtt(var FileName : string; const NewExt :string);
    // function FixPath(const Path : string) : string;
     function DelimitedText(Strings : TStrings; Delimiter, Quote : char) : string;
     function QuotedString(const S : string; Quote : char) : string;
     //Yedekal balyor.

     procedure ComposeText(const S : string; Delimiter, Quote : char; Strings : TStrings);
     function UnquotedString(const S : string; Quote : char) : string;

  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy;override;
  published
    { Published declarations }
     //properties
   Property TotalRecord      :longint                 read Ftotal;
   property Dataset          : TDataset               read FDataset          write FDataset;
   property TextFile          : string                 read FTextFile          write FTextFile;
   property Delimiter        : Char                   read FDelimiter        write FDelimiter;
   property SilentImport     : Boolean                read FSilentImport     write FSilentImport;

    //events
   property BeforeOpenTable  : TNotifyEvent           read FBeforeOpenTable  write FBeforeOpenTable;
   property AfterOpenTable   : TNotifyEvent           read FAfterOpenTable   write FAfterOpenTable;
   property BeforeCloseTable : TNotifyEvent           read FBeforeCloseTable write FBeforeCloseTable;
   property AfterCloseTable  : TNotifyEvent           read FAfterCloseTable  write FAfterCloseTable;

   property BeforeImport     : TNotifyEvent           read FBeforeImport     write FBeforeImport;
   property AfterImport      : TNotifyEvent           read FAfterImport      write FAfterImport;
   property BeforeExport     : TNotifyEvent           read FBeforeExport     write FBeforeExport;
   property AfterExport      : TNotifyEvent           read FAfterExport      write FAfterExport;
   property ExportProgress   : TNyBckProgressEvent    read FExportProgress   write FExportProgress;
   property ImportProgress   : TNyBckProgressEvent    read FImportProgress   write FImportProgress;
   property OnAddRecord      : TNotifyEvent           read FOnAddRecord      write FOnAddRecord;
   property ImportError      : TNyBckImportErrorEvent read FImportError      write FImportError;
   //methodes
   procedure Export;//DatasetToText;
   procedure Import;//TextToDataset;


  end;

procedure Register;

implementation

//published methodes

Procedure TnyBck.Export;//DatasetToText;
begin

 if FTextFile='' then
      raise TNyError.Create('NyBck Error: Please write backup Text file name.');

     if FDataSet = nil then
    raise TNyError.Create('NyBck Error : Dataset is not specified');

      if Assigned(FBeforeOpenTable) then
    FBeforeOpenTable(Self);

     Fdataset.open;
    if Assigned(FAfterOpenTable) then
    FAfterOpenTable(Self);


    try

   //FDataSet := FTable;
      //ClearFileExt(Dosyaadi);
      //dosyayolu:=Dosyaadi;  //FixPath(FWorkDir) + Dosyaadi;
      Transfer(fdataset,FTextFile);
    finally
     if Assigned(FBeforeCloseTable) then
    FBeforeCloseTable(Self);
      Fdataset.Close;
      if Assigned(FAfterCloseTable) then
    FAfterCloseTable(Self);
    end;
end;



procedure TNyBck.Import;//TextToDataset;
var                  //CsvToDataset
  i,j : integer;
  slIn, slValues : TStrings;
  MS1, MS2 : TMemoryStream;
  sz : integer;

  memdosya:string;
   ErrorResponse : TNyBckErrorResponse ;
   C : LongInt;//progresin saysn tutar.
   //CoNoexp:longint;//Key violation hatas nedeniyle kayda girmeyen kaytlar.
begin //g

  if FTextFile='' then
      raise TNyError.Create('NyBck Error: Please write backup Text file name.');


   if FDataSet = nil then
    raise TNyError.Create('NyBck Error : Dataset is not specified');

  slIn := TStringList.Create;
  slValues := TStringList.Create;
  MS1 := TMemoryStream.Create;
  MS2 := TMemoryStream.Create;

      try //e
      if Assigned(FBeforeOpenTable) then
    FBeforeOpenTable(Self);

     Fdataset.Open;
     if Assigned(FAfterOpenTable) then
    FAfterOpenTable(Self);
     //export to table from text file
 //if Assigned(FBeforeExport) then
 // FBeforeExport(Self);
    MS1.Position := 0;
   // FTable.TableName := TableName;
   // Fdataset.Active := true;
     FDataset.DisableControls;//ekran kompenentleri pasif
     C:=0;//lerleme miktar

    Memdosya:=FTextFile;
    ClearFileExt(memdosya);
    slIn.LoadFromFile(FTextFile);
    if FileExists(MemDosya + '.mem') then
      MS1.LoadFromFile(MemDosya + '.mem');

     ComposeText(slIn[0], FDelimiter, '"', slValues);//kayt toplamn al.
      Ftotal:=strtoint(slValues[0]);//toplam kayd integer olarak al.
    //memolar ilk Ms1 e ykle.
         //export to table from text file
 if Assigned(FBeforeImport) then
  FBeforeImport(Self);

    for i := 1 to slIn.Count - 1 do //0 to idi ama ilk kayt toplam kayt adedi olduundan.
    begin  //d
       try//h
      Fdataset.Append;
      ComposeText(slIn[i], FDelimiter, '"', slValues);
      for j := 0 to slValues.Count - 1 do
      begin //c
        if not (Fdataset.Fields[j].DataType in [ftBlob, ftMemo, ftGraphic, ftFmtMemo,
                                              ftParadoxOle, ftDBaseOle, ftTypedBinary]) then
          Fdataset.Fields[j].AsString := slValues[j]
        else begin//b
          sz := StrToInt(slValues[j]);
          if sz > 0 then
          begin //a
            MS2.CopyFrom(MS1,sz);
            MS2.Position := 0;
            (Fdataset.Fields[j] as TBlobField).LoadFromStream(MS2);
            MS2.Clear;
          end; //a
        end;//b
      end; //c
      Fdataset.Post;
      except
      on E:Exception do
     if not FSilentImport then
      raise
     else
     if Assigned(FImportError) then
       begin
        FImportError(Self,E.Message,C,ErrorResponse);
        if ErrorResponse = NyBckAbort then
         Break;
       end;

      end;//h
      if Assigned(FOnAddRecord) then
    FOnAddRecord(Self);
   if Assigned(FImportProgress) then
    FImportProgress(Self, C, FStop);
   Inc(C);

      end;//d
      //Inc(Coexp);//ilerleme miktar.//key violation hatas olsa bile buraya uruyor.


    FDataset.EnableControls;//ekran kompenentleri aktif.dikkat alttaki fdataset.active=false'den nce gelmeli yoksa hata veriyor.
    if Assigned(FAfterImport) then
  FAfterImport(Self);

    Fdataset.close;
   
      if Assigned(FAfterCloseTable) then
    FAfterCloseTable(Self);

  finally
    MS1.Free;
    MS2.Free;
    slValues.Free;
    slIn.Free;

  end;//e

end; //g

procedure TNyBck.ComposeText(const S : string; Delimiter, Quote : char; Strings : TStrings);
var
  i, prev : integer;
  b : boolean;
begin
  prev := 0;
  b := false;
  Strings.Clear;
  for i := 1 to Length(S) do
  begin
    if S[i] = Quote then b := not b;
    if not b and (S[i] = Delimiter) then
    begin
     Strings.Add(UnquotedString(Trim(Copy(S, prev + 1, i - prev - 1)), Quote));
      prev := i;

    end;
  end;
 Strings.Add(UnquotedString(Trim(Copy(S, prev + 1, Length(S))), Quote));
end;

//return unquoted string
function TNyBck.UnquotedString(const S : string; Quote : char) : string;
var
  i : integer;
begin
  if (S = '') or (S[1] <> Quote) then
  begin
    Result := S;
    exit;
  end;
  Result := ''; i := 2;
  while i < Length(S) do
  begin
    if S[i] = Quote then
    begin
      if S[i + 1] = Quote then
      begin
        Result := Result + Quote;
        inc(i, 2);
        continue;
      end;
    end;
    Result := Result + S[i];
    inc(i);
  end;
end;


procedure TNyBck.transfer(Fdataset : Tdataset;FtextFile:string);//export
var
  i : integer;
  C : LongInt;//progresin saysn tutar.

  slOut, slRow : TStrings;
  MS1, MS2 : TMemoryStream;
 // filename:string;
begin
//filename:='selam.txt';
//Transferet;
 //Fdataset:=form1.table1;
 //fdataset.Open;

  slOut := TStringList.Create;
  slRow := TStringList.Create;
  MS1 := TMemoryStream.Create;
  MS2 := TMemoryStream.Create;
 // filename:=dosyaadi;
  try

  C:=0;//lerleme miktar
    FDataSet.First;
    FDataset.DisableControls;//ekran kompenentleri pasif
     slRow.Clear;
      Ftotal:=Fdataset.RecordCount;
       slRow.Add(inttostr(Ftotal)); //toplam rekordu kaydet
        slOut.Add(DelimitedText(slRow, FDelimiter, '"'));
     if Assigned(FBeforeExport) then
  FBeforeExport(Self);
    while not FDataSet.EOF do
    begin
      slRow.Clear;
      for i := 0 to FDataSet.FieldCount - 1 do
      begin
        if not (FDataSet.Fields[i].DataType in [ftBlob, ftMemo, ftGraphic, ftFmtMemo,
                                              ftParadoxOle, ftDBaseOle, ftTypedBinary]) then
          slRow.Add(FDataSet.Fields[i].AsString)
        else begin
          MS2.Clear;
          (FDataSet.Fields[i] as TBlobField).SaveToStream(MS2);
          MS1.CopyFrom(MS2,0);
          slRow.Add(IntToStr(MS2.Size));
        end;
      end;
      slOut.Add(DelimitedText(slRow, FDelimiter, '"'));

      FDataSet.Next;
      if Assigned(FExportProgress) then
    FExportProgress(Self, C, FStop);
       Inc(C);//ilerleme miktar.
    end;
     if ExtractFileExt(FtextFile) = '' then FtextFile := FtextFile + '.txt';
    slOut.SaveToFile(FtextFile);

 if MS1.Size > 0 then
    begin
      ChangeFileExtt(FTextFile, 'mem');
      MS1.SaveToFile(FtextFile);
    end;
  finally
    slRow.Free;
    slOut.Free;
    MS2.Free;
    MS1.Free;
     FDataset.EnableControls;
     if Assigned(FAfterExport) then
  FAfterExport(Self);

  end;
end;


procedure TNyBck.ClearFileExt(var FileName : string);
var
  p : integer;
begin
  p := Length(FileName);
  while (p > 0) and (FileName[p] <> '.') do dec(p);
  if p = 0 then exit;
  Delete(FileName, p, Length(FileName));

end;

procedure TNyBck.ChangeFileExtt(var FileName : string; const NewExt :string);
begin
  ClearFileExt(FileName);
  FileName := FileName + '.' + NewExt;
end;

//add '\' to path end if it does not exist
function FixPath(const Path : string) : string;
begin
  if (Path <> '') and (Path[Length(Path)] <> '\') then
    Result := Path + '\'
  else
    Result := Path;
end;

function TNyBck.DelimitedText(Strings : TStrings; Delimiter, Quote : char) : string;
var
  i : integer;
begin
  Result := '';
  for i := 0 to Strings.Count - 1 do
  begin
    if i <> 0 then Result := Result + Delimiter;
    Result := Result + QuotedString(Strings[i], Quote);
  end;
end;
function TNyBck.QuotedString(const S : string; Quote : char) : string;
var
  i : integer;
begin
  Result := Quote;
  for i := 1 to Length(S) do
  begin
    Result := Result + S[i];
    if S[i] = Quote then
      Result := Result + Quote;
  end;
  Result := Result + Quote;
end;





constructor TNyBck.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 FDelimiter:=#9;
 FSilentImport:=True;
 FStop:=False;
end;
destructor TNyBck.Destroy;
begin
  inherited;
end;


procedure Register;
begin
  RegisterComponents('Nihat', [TNyBck]);
end;

end.
