unit WinGod;

interface

uses
  Windows, Messages, SysUtils, Classes,
  Controls, Forms, MHook_Intf, KBHook_Intf,
  ShHook_Intf;
//-------------------------------------------------
type
  HookError = class(Exception);

  TMouseMsg = procedure(Code:Integer;MesID:Cardinal;MRec:TMouseHookStruct)of object;
  TKeybrdMsg= procedure(Code, VKCode, KSInfo :Integer)of object;
  TShProcMsg= procedure(Code, WParam, LParam :Integer)of object;

  TrasWinGod = class(TComponent)
  private
    { Private declarations }
    // for mouse
    M_DllInst  :hInst;
    FmHooked   :Boolean;
    FmEnabled  :Boolean;
    FmMessageID:Cardinal;
    FmMapStart :PMRec;
    FOnMouseMsg:TMouseMsg;
    // for keyboard
    KB_DllInst  :hInst;
    FkbHooked   :Boolean;
    FkbEnabled  :Boolean;
    FkbMessageID:Cardinal;
    FkbMapStart :PKBRec;
    FOnKeybrdMsg:TKeybrdMsg;
    // for shellproc
    Sh_DllInst  :hInst;
    FshHooked   :Boolean;
    FshEnabled  :Boolean;
    FshMessageID:Cardinal;
    FshMapStart :PShRec;
    FOnShProcMsg:TShProcMsg;
    // common
    FAppHooked  :Boolean;
    // for mouse
    function ExtSetMouseHook(Caller:HWND):Pointer;stdcall;
    procedure ExtRemoveMouseHook(Caller:HWND);stdcall;
    procedure ReceiveMouseMessage;
    // for keyboard
    function ExtSetKBHook(Caller:HWND):Pointer;stdcall;
    procedure ExtRemoveKBHook(Caller:HWND);stdcall;
    procedure ReceiveKBMessage;
    // for shellproc
    function ExtSetShHook(Caller:HWND):Pointer;stdcall;
    procedure ExtRemoveShHook(Caller:HWND);stdcall;
    procedure ReceiveShMessage;
    // common
    function  HookMonitor(var M:TMessage):Boolean;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
    procedure SetMouseHook;
    procedure RemoveMouseHook;
    procedure SetKBHook;
    procedure RemoveKBHook;
    procedure SetShHook;
    procedure RemoveShHook;
    property MouseHookInstalled:Boolean read FmHooked ;
    property KeybrdHookInstalled:Boolean read FkbHooked;
    property ShProcHookInstalled:Boolean read FshHooked;
  published
    { Published declarations }
    property MouseHookEnabled:Boolean read FmEnabled write FmEnabled default True;
    property OnMouseMsg:TMouseMsg read FOnMouseMsg write FOnMouseMsg;
    property KeybrdHookEnabled:Boolean read FkbEnabled write FkbEnabled default True;
    property OnKeybrdMsg:TKeybrdMsg read FOnKeybrdMsg write FOnKeybrdMsg;
    property ShProcHookEnabled:Boolean read FshEnabled write FshEnabled default True;
    property OnShProcMsg:TShProcMsg read FOnShProcMsg write FOnShProcMsg;
  end;

procedure Register;
//-------------------------------------------------
implementation
//-------------------------------------------------
var b:Boolean;
const
  M_DllName='rasM50.dll';
  KB_DllName='rasKB50.dll';
  Sh_DllName='rasSh50.dll';
//-------------------------------------------------
constructor TrasWinGod.Create(AOwner:TComponent);
begin
  inherited;
  FmEnabled:=True;
  FmHooked :=False;
  FkbEnabled:=True;
  FkbHooked :=False;
  FshEnabled:=True;
  FshHooked :=False;
end; { constructor TrasWinGod.Create }
//-------------------------------------------------
destructor TrasWinGod.Destroy;
begin
  RemoveKBHook;
  RemoveMouseHook;
  RemoveShHook;
  inherited;
end; { destructor TrasWinGod.Destroy }
//-------------------------------------------------
procedure TrasWinGod.ExtRemoveKBHook(Caller:HWND);
var
  Proc:procedure(Caller:HWND);stdcall;
begin
  if KB_DllInst<>0 then
  begin
    @Proc:=GetProcAddress(KB_DllInst,PChar('RemoveHook'));
    if @Proc<>nil then Proc(Caller);
  end
end; { procedure TrasWinGod.ExtRemoveKBHook }
//-------------------------------------------------
procedure TrasWinGod.ExtRemoveMouseHook(Caller:HWND);stdcall;
var
  Proc:procedure(Caller:HWND);stdcall;
begin
  if M_DllInst<>0 then
  begin
    @Proc:=GetProcAddress(M_DllInst,PChar('RemoveHook'));
    if @Proc<>nil then Proc(Caller);
  end
end; { procedure TrasWinGod.ExtRemoveMouseHook }
//-------------------------------------------------
procedure TrasWinGod.ExtRemoveShHook(Caller:HWND);
var
  Proc:procedure(Caller:HWND);stdcall;
begin
  if Sh_DllInst<>0 then
  begin
    @Proc:=GetProcAddress(Sh_DllInst,PChar('RemoveHook'));
    if @Proc<>nil then Proc(Caller);
  end
end; { procedure TrasWinGod.ExtRemoveShHook }
//-------------------------------------------------
function TrasWinGod.ExtSetKBHook(Caller:HWND):Pointer;
var
  Proc:function(Caller:HWND):Pointer;stdcall;
begin
  Result:=nil;
  KB_DllInst:=LoadLibrary(KB_DllName);
  if KB_DllInst=0 then Exit;
  @Proc:=GetProcAddress(KB_DllInst,PChar('SetHook'));
  if @Proc<>nil then
    Result:=Proc(Caller);
end; { function TrasWinGod.ExtSetKBHook }
//-------------------------------------------------
function TrasWinGod.ExtSetMouseHook(Caller:HWND):Pointer;
var
  Proc:function(Caller:HWND):Pointer;stdcall;
begin
  Result:=nil;
  M_DllInst:=LoadLibrary(M_DllName);
  if M_DllInst=0 then Exit;
  @Proc:=GetProcAddress(M_DllInst,PChar('SetHook'));
  if @Proc<>nil then
    Result:=Proc(Caller);
end; { function TrasWinGod.ExtSetMouseHook }
//-------------------------------------------------
function TrasWinGod.ExtSetShHook(Caller:HWND):Pointer;
var
  Proc:function(Caller:HWND):Pointer;stdcall;
begin
  Result:=nil;
  Sh_DllInst:=LoadLibrary(Sh_DllName);
  if Sh_DllInst=0 then Exit;
  @Proc:=GetProcAddress(Sh_DllInst,PChar('SetHook'));
  if @Proc<>nil then Result:=Proc(Caller);
end; { function TrasWinGod.ExtSetShHook }
//-------------------------------------------------
function TrasWinGod.HookMonitor;
begin
  Result:=False;
  // check for mouse msg
  if (M.Msg=FmMessageID)and(M.WParam=mPassword)and(M.LParam=mConfirmation)then
    if FmEnabled then
    begin
      ReceiveMouseMessage;
      Result:=True;
      Exit;
    end;
  // check for kb msg
  if (M.Msg=FkbMessageID)and(M.WParam=kbPassword)and(M.LParam=kbConfirmation)then
    if FkbEnabled then
    begin
      ReceiveKBMessage;
      Result:=True;
      Exit;
    end;
  // check for shellproc msg
  if (M.Msg=FshMessageID)and(M.WParam=shPassword)and(M.LParam=shConfirmation)then
    if FshEnabled then
    begin
      ReceiveShMessage;
      Result:=True;
      Exit;
    end;
end; { procedure TrasWinGod.HookMonitor }
//-------------------------------------------------
procedure TrasWinGod.ReceiveKBMessage;
begin
  if Assigned(FOnKeybrdMsg)then
    FOnKeybrdMsg(FkbMapStart^.kbCode,FkbMapStart^.VKCode,FkbMapStart^.KSInfo);
end; { procedure TrasWinGod.ReceiveKBMessage; }
//-------------------------------------------------
procedure TrasWinGod.ReceiveMouseMessage;
begin
  if Assigned(FOnMouseMsg)then
    FOnMouseMsg(FmMapStart^.MCode,FmMapStart^.MesID,FmMapStart^.M_Rec);
end; { procedure ReceiveMessage }
//-------------------------------------------------
procedure TrasWinGod.ReceiveShMessage;
begin
  if not b then
  begin
  if Assigned(FOnShProcMsg)then
    FOnShProcMsg(FshMapStart^.shCode,FshMapStart^.WParam,FshMapStart^.LParam);
  b:=true;
  end
end; { procedure TrasWinGod.ReceiveShMessage; }
//-------------------------------------------------
procedure TrasWinGod.RemoveKBHook;
begin
  if FkbHooked then
  begin
    ExtRemoveKBHook(Application.Handle);
    FkbHooked:=False;
    if FAppHooked and(not FmHooked)and(not FshHooked)then
    begin
      Application.UnhookMainWindow(HookMonitor);
      FAppHooked:=False;
    end;
  end;
end; { procedure TrasWinGod.RemoveKBHook }
//-------------------------------------------------
procedure TrasWinGod.RemoveMouseHook;
begin
  if FmHooked then
  begin
    ExtRemoveMouseHook(Application.Handle);
    FmHooked:=False;
    if FAppHooked and(not FkbHooked)and(not FshHooked)then
    begin
      Application.UnhookMainWindow(HookMonitor);
      FAppHooked:=False;
    end;
  end;
end; { procedure TrasWinGod.RemoveMouseHook }
//-------------------------------------------------
procedure TrasWinGod.RemoveShHook;
begin
  if FshHooked then
  begin
    ExtRemoveShHook(Application.Handle);
    FshHooked:=False;
    if FAppHooked and(not FmHooked)and(not FkbHooked)then
    begin
      Application.UnhookMainWindow(HookMonitor);
      FAppHooked:=False;
    end;
  end;
end; { procedure TrasWinGod.RemoveShHook }
//-------------------------------------------------
procedure TrasWinGod.SetKBHook;
begin
  if not FkbHooked then
  begin
    FkbMapStart:=ExtSetKBHook(Application.Handle);
    if FkbMapStart<>nil then
      FkbHooked:=True
    else
      raise HookError.Create('Unable to install a keyboard hook!');
    FkbMessageID:=RegisterWindowMessage(kbMessageName);
    if not FAppHooked then
    begin
      Application.HookMainWindow(HookMonitor);
      FAppHooked:=True;
    end;
  end;
end; { procedure TrasWinGod.SetKBHook }
//-------------------------------------------------
procedure TrasWinGod.SetMouseHook;
begin
  if not FmHooked then
  begin
    FmMapStart:=ExtSetMouseHook(Application.Handle);
    if FmMapStart<>nil then
      FmHooked:=True
    else
      raise HookError.Create('Unable to install a mouse hook!');
    FmMessageID:=RegisterWindowMessage(mMessageName);
    if not FAppHooked then
    begin
      Application.HookMainWindow(HookMonitor);
      FAppHooked:=True;
    end;
  end;
end; { procedure TrasWinGod.SetMouseHook }
//-------------------------------------------------
procedure TrasWinGod.SetShHook;
begin
  if not FshHooked then
  begin
    FshMapStart:=ExtSetShHook(Application.Handle);
    if FshMapStart<>nil then
      FshHooked:=True
    else
      raise HookError.Create('Unable to install a shellproc hook!');
    FshMessageID:=RegisterWindowMessage(shMessageName);
    if not FAppHooked then
    begin
      Application.HookMainWindow(HookMonitor);
      FAppHooked:=True;
    end;
  end;
end; { procedure TrasWinGod.SetKBHook }
//-------------------------------------------------
procedure Register;
begin
  RegisterComponents('RAS',[TrasWinGod]);
end;

end.
