
{*******************************************************}
{                                                       }
{       Borland Delphi Visual Component Library         }
{       Screen Saver Registration                       }
{                                                       }
{       Copyright (c) 2000 Vino Rodrigues               }
{       vinorodrigues@yahoo.com                         }
{                                                       }
{       Version History:                                }
{       ----------------                                }
{                                                       }
{       1.3  30-Aug-01                                  }
{            First time I included "version history".   }
{                                                       }
{*******************************************************}

unit ScrSavR;

{$IFDEF VER130}
  {$DEFINE NEWDMDESIGNER}
{$ENDIF}

interface

uses
  Windows,
  Exptintf, EditIntf, ToolIntf,
  {$IFDEF VER140}
  DesignIntf, DesignEditors,
  {$ELSE}
  DsgnIntf,
  {$ENDIF}
  ScrSav;

type
  TScrSavModExpert = class(TIExpert)
  public
    function GetName: string; override;
    function GetAuthor: string; override;
    function GetComment: string; override;
    function GetPage: string; override;
    function GetGlyph: HICON; override;
    function GetStyle: TExpertStyle; override;
    function GetState: TExpertState; override;
    function GetIDString: string; override;
    function GetMenuText: string; override;
    procedure Execute;  override;
  end;

type
  TScrSavAppExpert = class(TIExpert)
  public
    function GetName: string; override;
    function GetAuthor: string; override;
    function GetComment: string; override;
    function GetPage: string; override;
    function GetGlyph: HICON; override;
    function GetStyle: TExpertStyle; override;
    function GetState: TExpertState; override;
    function GetIDString: string; override;
    function GetMenuText: string; override;
    procedure Execute;  override;
  end;

procedure Register;

implementation

uses
  {$IFDEF NEWDMDESIGNER} DMDesigner, {$ENDIF}
  SysUtils, Dialogs;

{$R ScrSavR.res}

{ Resources }

resourcestring
  sScrSavModName = 'Screen Saver Module';
  sScrSavModComment = 'Create a new Screen Saver Module';

  sScrSavAppName = 'Screen Saver Application';
  sScrSavAppComment = 'Create a new Win32 Screen Saver Application';

  sMyExpertPage = 'New';

  sAboutMessage = 'TScreenSaver'#13 +
    '_______________________________________'#13#13 +
    'Copyright (c) 1999-2001  Vino Rodrigues'#13 +
    'All Rights Reserved.';

procedure DoAboutBox;
begin
  MessageDlg(sAboutMessage, mtInformation, [mbOk], 0);
end;

{ Helper functions }

function ReplaceWild(const Source, WildCard, NewPattern: string): string;
begin
  Result := StringReplace(Source, '%' + WildCard + '%', NewPattern,
    [rfReplaceAll, rfIgnoreCase]);
end;

function LoadSource(lpName: PChar): string;
var  P: PChar;
begin
  Result := '';
  try
    P := LockResource(
      LoadResource(hInstance,
        FindResource(hInstance, lpName, RT_RCDATA)));
  except
    P := nil;
  end;
  if (P <> nil) then Result := StrPas(P);
end;

{ TScrSavCreator }

type
  TScrSavCreator = class(TIModuleCreatorEx)
  public
    function Existing: Boolean; override;
    function GetAncestorName: string; override;
    function GetFileName: string; override;
    function GetFileSystem: string; override;
    function GetFormName: string; override;
    function NewModuleSource(const UnitIdent, FormIdent,
      AncestorIdent: string): string; override;
    procedure FormCreated(Form: TIFormInterface); override;
    function GetIntfName: string; override;
    function NewIntfSource(const UnitIdent, FormIdent,
      AncestorIdent: string): string; override;
  end;

{ TScrSavAppCreator }

type
  TScrSavAppCreator = class(TIProjectCreatorEx)
  public
    function Existing: Boolean; override;
    function GetFileName: string; override;
    function GetFileSystem: string; override;
    function NewProjectSource(const ProjectName: string): string; override;
    procedure NewDefaultModule; override;
    procedure NewProjectResource(Module: TIModuleInterface); override;
    function GetOptionName: string; override;
    function NewOptionSource(const ProjectName: string): string; override;
  end;

{ TScrSavModExpert }

procedure TScrSavModExpert.Execute;
var
  Creator: TScrSavCreator;
  Module: TIModuleInterface;
begin
  Creator := TScrSavCreator.Create;
  try
    Module := ToolServices.ModuleCreateEx(Creator, [cmAddToProject,
      cmShowSource, cmShowForm, cmUnNamed, cmMarkModified]);
    Module.Free;
  finally
    Creator.Free;
  end;
end;

function TScrSavModExpert.GetAuthor: string;
begin
  Result := 'Vino Rodrigues';
end;

function TScrSavModExpert.GetComment: string;
begin
  Result := sScrSavModComment;
end;

function TScrSavModExpert.GetGlyph: HICON;
begin
  Result := LoadIcon(HInstance, 'SSMODICON');
end;

function TScrSavModExpert.GetIDString: string;
begin
  Result := 'VinoRodrigues.ScreenSaverExpert';
end;

function TScrSavModExpert.GetMenuText: string;
begin
  Result := '';
end;

function TScrSavModExpert.GetName: string;
begin
  Result := sScrSavModName;
end;

function TScrSavModExpert.GetPage: string;
begin
  Result := sMyExpertPage;
end;

function TScrSavModExpert.GetState: TExpertState;
begin
  Result := [esEnabled];
end;

function TScrSavModExpert.GetStyle: TExpertStyle;
begin
  Result := esForm;
end;

{ TScrSavAppExpert }

procedure TScrSavAppExpert.Execute;
var
  Creator: TScrSavAppCreator;
  Module: TIModuleInterface;
begin
  Creator := TScrSavAppCreator.Create;
  try
    Module := ToolServices.ProjectCreateEx(Creator, [cpApplication]);  // cpCanShowSource
    Module.Free;
  finally
    Creator.Free;
  end;
end;

function TScrSavAppExpert.GetAuthor: string;
begin
  Result := 'Vino Rodrigues';
end;

function TScrSavAppExpert.GetComment: string;
begin
  Result := sScrSavAppComment;
end;

function TScrSavAppExpert.GetGlyph: HICON;
begin
  Result := LoadIcon(HInstance, 'SSAPPICON');
end;

function TScrSavAppExpert.GetIDString: string;
begin
  Result := 'VinoRodrigues.ScreenSaverAppExpert';
end;

function TScrSavAppExpert.GetMenuText: string;
begin
  Result := '';
end;

function TScrSavAppExpert.GetName: string;
begin
  Result := sScrSavAppName;
end;

function TScrSavAppExpert.GetPage: string;
begin
  Result := sMyExpertPage;
end;

function TScrSavAppExpert.GetState: TExpertState;
begin
  Result := [esEnabled];
end;

function TScrSavAppExpert.GetStyle: TExpertStyle;
begin
  Result := esProject;
end;

{ TScrSavCreator }

function TScrSavCreator.Existing: Boolean;
begin
  Result := False;
end;

procedure TScrSavCreator.FormCreated(Form: TIFormInterface);
begin
  // Do nothing
  Form.Free;
end;

function TScrSavCreator.GetAncestorName: string;
begin
  Result := 'ScreenSaver';
end;

function TScrSavCreator.GetFileName: string;
begin
  Result := '';
end;

function TScrSavCreator.GetFileSystem: string;
begin
  Result := '';
end;

function TScrSavCreator.GetFormName: string;
begin
  Result := '';
end;

function TScrSavCreator.GetIntfName: string;
begin
  Result := '';
end;

function TScrSavCreator.NewIntfSource(const UnitIdent, FormIdent,
  AncestorIdent: string): string;
begin
  Result := '';
end;

function TScrSavCreator.NewModuleSource(const UnitIdent, FormIdent,
  AncestorIdent: string): string;
begin
  Result := LoadSource('SSMODSOURCE');
  Result := ReplaceWild(Result, 'Unit', UnitIdent);
  Result := ReplaceWild(Result, 'Form', FormIdent);
  Result := ReplaceWild(Result, 'Ancestor', AncestorIdent);
end;

{ TScrSavAppCreator }

function TScrSavAppCreator.Existing: Boolean;
begin
  Result := False;
end;

function TScrSavAppCreator.GetFileName: string;
begin
  Result := '';
end;

function TScrSavAppCreator.GetFileSystem: string;
begin
  Result := '';
end;

function TScrSavAppCreator.GetOptionName: string;
begin
  Result := '';
end;

procedure TScrSavAppCreator.NewDefaultModule;
var
  Creator: TScrSavCreator;
  Module: TIModuleInterface;
begin
  Creator := TScrSavCreator.Create;
  try
    Module := ToolServices.ModuleCreateEx(Creator, [cmAddToProject,
      cmShowSource, cmShowForm, cmUnNamed, cmMainForm, cmMarkModified]);
    Module.Free;
  finally
    Creator.Free;
  end;
end;

function TScrSavAppCreator.NewOptionSource(
  const ProjectName: string): string;
begin
  Result := '';
end;

procedure TScrSavAppCreator.NewProjectResource(Module: TIModuleInterface);
begin
  // Do nothing
end;

function TScrSavAppCreator.NewProjectSource(
  const ProjectName: string): string;
begin
  Result := LoadSource('SSAPPSOURCE');
  Result := ReplaceWild(Result, 'Project', ProjectName);
end;

{ TAboutProperty }

type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetName: string; override;
    function GetValue: string; override;
  end;

resourcestring
  sAboutDescript = 'Component';

{ TAboutProperty }

procedure TAboutProperty.Edit;
begin
  DoAboutBox;
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

function TAboutProperty.GetName: string;
begin
  Result := 'About';
end;

function TAboutProperty.GetValue: string;
begin
  Result := sAboutDescript;
end;

{ Register }

procedure Register;
begin
//  RegisterLibraryExpert(TScrSavModExpert.Create);
  RegisterLibraryExpert(TScrSavAppExpert.Create);
  {$IFDEF NEWDMDESIGNER}
  RegisterCustomModule(TScreenSaver, TDataModuleDesignerCustomModule);
  {$ELSE}
  RegisterCustomModule(TScreenSaver, TCustomModule);
  {$ENDIF}
  RegisterPropertyEditor(TypeInfo(Longint), TScreenSaver, 'About',
    TAboutProperty);
end;

end.
