unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, Buttons, ReportField2, ComCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    RAlignment: TComboBox;
    Label1: TLabel;
    ColorDialog1: TColorDialog;
    RColor: TBitBtn;
    RFixLength: TCheckBox;
    FontDialog1: TFontDialog;
    RFont: TBitBtn;
    Label7: TLabel;
    RMaxLength: TSpinEdit;
    RTransparent: TCheckBox;
    CheckBox1: TCheckBox;
    REnabled: TCheckBox;
    BGet: TButton;
    BPut: TButton;
    Label8: TLabel;
    RWidth: TSpinEdit;
    Label9: TLabel;
    RHeight: TSpinEdit;
    ReportField21: TReportField2;
    PageControl2: TPageControl;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Label19: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    SEBLW: TSpinEdit;
    CBBLS: TComboBox;
    CBBLH: TComboBox;
    TabSheet2: TTabSheet;
    Label16: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    CBBRH: TComboBox;
    CBBRS: TComboBox;
    SEBRW: TSpinEdit;
    TabSheet3: TTabSheet;
    Label10: TLabel;
    Label11: TLabel;
    CBBTS: TComboBox;
    SEBTW: TSpinEdit;
    TabSheet4: TTabSheet;
    Label12: TLabel;
    Label13: TLabel;
    SEBBW: TSpinEdit;
    CBBBS: TComboBox;
    CBDH: TComboBox;
    CBDS: TComboBox;
    Label2: TLabel;
    SEDW: TSpinEdit;
    Label3: TLabel;
    Label20: TLabel;
    CBCS: TComboBox;
    Label21: TLabel;
    Label22: TLabel;
    SECW: TSpinEdit;
    procedure ListBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RAlignmentClick(Sender: TObject);
    procedure RColorClick(Sender: TObject);
    procedure RFixLengthClick(Sender: TObject);
    procedure RFontClick(Sender: TObject);
    procedure RMaxLengthChange(Sender: TObject);
    procedure RTransparentClick(Sender: TObject);

    procedure ControlMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ControlMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ControlMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure CheckBox1Click(Sender: TObject);
    procedure REnabledClick(Sender: TObject);
    procedure BGetClick(Sender: TObject);
    procedure BPutClick(Sender: TObject);
    procedure RWidthChange(Sender: TObject);
    procedure RHeightChange(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ReportField21StyleChange(Sender: TObject);
    procedure SEBLWChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CBBRHChange(Sender: TObject);
    procedure CBBRSChange(Sender: TObject);
    procedure SEBRWChange(Sender: TObject);
    procedure CBBTSChange(Sender: TObject);
    procedure SEBTWChange(Sender: TObject);
    procedure CBBBSChange(Sender: TObject);
    procedure SEBBWChange(Sender: TObject);
    procedure CBDHChange(Sender: TObject);
    procedure CBDSChange(Sender: TObject);
    procedure SEDWChange(Sender: TObject);
    procedure CBCSChange(Sender: TObject);
    procedure SECWChange(Sender: TObject);
    procedure CBBLHClick(Sender: TObject);
    procedure CBBLSClick(Sender: TObject);
  private
    Sh1: TControl;
    Shx, Shy: Integer;
    Mem: TMemoryStream;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ReportField21StyleChange(Sender);
  sh1:=Nil;
  Mem:=TMemoryStream.Create;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Mem.Free;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
begin
  if ListBox1.ItemIndex < 0 then exit;
  ReportField21.Text:=ListBox1.items[ListBox1.ItemIndex];
end;

procedure TForm1.RAlignmentClick(Sender: TObject);
begin
  ReportField21.Alignment:=TAlignment(RAlignment.ItemIndex);
end;

procedure TForm1.RColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute then
    ReportField21.BackColor:=ColorDialog1.Color;
end;

procedure TForm1.REnabledClick(Sender: TObject);
begin
  ReportField21.Enabled:=REnabled.Checked;
end;

procedure TForm1.RFixLengthClick(Sender: TObject);
begin
  ReportField21.FixLength:=RFixLength.Checked;
end;

procedure TForm1.RFontClick(Sender: TObject);
begin
  if FontDialog1.Execute then
    ReportField21.Font:=FontDialog1.Font;
end;

procedure TForm1.RWidthChange(Sender: TObject);
begin
  if Length(RWidth.Text) < 1 then exit;
  if (RWidth.Value >= RWidth.MinValue) and (RWidth.Value <= RWidth.MaxValue) then
    ReportField21.Width:=RWidth.Value;
end;

procedure TForm1.RHeightChange(Sender: TObject);
begin
  if Length(RHeight.Text) < 1 then exit;
  if (RHeight.Value >= RHeight.MinValue) and (RHeight.Value <= RHeight.MaxValue) then
    ReportField21.Height:=RHeight.Value;
end;

procedure TForm1.RMaxLengthChange(Sender: TObject);
begin
  if Length(RMaxLength.Text) < 1 then exit;
  ReportField21.MaxLength:=RMaxLength.Value;
end;

procedure TForm1.RTransparentClick(Sender: TObject);
begin
  ReportField21.Transparent:=RTransparent.Checked;
end;

procedure TForm1.ControlMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) and CheckBox1.Checked then begin
    sh1:=TControl(Sender);
    shx:=x;
    shy:=y;
    sh1.BringToFront;
    Form1.Caption:=Sh1.name + ' [' + IntToStr(Sh1.Left) + '/' + IntToStr(Sh1.Top) + ']';
  end;
end;

procedure TForm1.ControlMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var vx, vy: integer;
begin
  Form1.Caption:=TControl(Sender).Name + ' [' + IntToStr(TControl(Sender).Left) + '/' +
                 IntToStr(TControl(Sender).Top) + ']';
  if (Sh1 <> Nil) and CheckBox1.Checked then begin
    vx:=Sh1.Left - shx + x;
    vy:=Sh1.Top - shy + y;
    //
    if (vx + Sh1.Width) > Form1.ClientWidth then vx:=Form1.ClientWidth - Sh1.Width;
    if (vy + Sh1.Height) > Form1.ClientHeight then vy:=Form1.ClientHeight - Sh1.Height;
    if vx < 1 then vx:=1;
    if vy < 1 then vy:=1;
    //
    Sh1.Left:=vx;
    Sh1.Top:=vy;
    Form1.Caption:=Sh1.name + ' [' + IntToStr(vx) + '/' + IntToStr(vy) + ']';
    Application.ProcessMessages;
  end;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  Form1.Caption:=Form1.Name;
end;

procedure TForm1.ControlMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) and CheckBox1.Checked then begin
    sh1:=Nil;
    Form1.Caption:=Form1.Name;
  end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then
    ReportField21.Cursor:=crHandPoint
  else
    ReportField21.Cursor:=crDefault;
end;

procedure TForm1.BGetClick(Sender: TObject);
begin
  Mem.Clear;
  ReportField21.SaveToStream(Mem);
end;

procedure TForm1.BPutClick(Sender: TObject);
begin
  Mem.Position:=0;
  ReportField21.ReadFromStream(Mem);
end;

procedure TForm1.ReportField21StyleChange(Sender: TObject);
begin
  RAlignment.ItemIndex:=Ord(ReportField21.Alignment);
  CBBLH.ItemIndex:=Ord(ReportField21.Border.Left.Height);
  CBBLS.ItemIndex:=Ord(ReportField21.Border.Left.Style);
  SEBLW.Value:=ReportField21.Border.Left.Width;
  CBBRH.ItemIndex:=Ord(ReportField21.Border.Right.Height);
  CBBRS.ItemIndex:=Ord(ReportField21.Border.Right.Style);
  SEBRW.Value:=ReportField21.Border.Right.Width;
  CBBTS.ItemIndex:=Ord(ReportField21.Border.Top.Style);
  SEBTW.Value:=ReportField21.Border.Top.Width;
  CBBBS.ItemIndex:=Ord(ReportField21.Border.Bottom.Style);
  SEBBW.Value:=ReportField21.Border.Bottom.Width;
  ColorDialog1.Color:=ReportField21.BackColor;
  CBDH.ItemIndex:=Ord(ReportField21.Divider.Height);
  CBDS.ItemIndex:=Ord(ReportField21.Divider.Style);
  SEDW.Value:=ReportField21.Divider.Width;
  CBCS.ItemIndex:=Ord(ReportField21.CrossOut.Style);
  SECW.Value:=ReportField21.CrossOut.Width;
  RFixLength.Checked:=ReportField21.FixLength;
  FontDialog1.Font:=ReportField21.Font;
  RMaxLength.Value:=ReportField21.MaxLength;
  RTransparent.Checked:=ReportField21.Transparent;
  REnabled.Checked:=ReportField21.Enabled;
  RWidth.Value:=ReportField21.Width;
  RHeight.Value:=ReportField21.Height;
end;

procedure TForm1.CBBLHClick(Sender: TObject);
begin
  ReportField21.Border.Left.Height:=TDividerHeight(CBBLH.ItemIndex);
end;

procedure TForm1.CBBLSClick(Sender: TObject);
begin
  ReportField21.Border.Left.Style:=TPenStyle(CBBLS.ItemIndex);
end;

procedure TForm1.SEBLWChange(Sender: TObject);
begin
  ReportField21.Border.Left.Width:=SEBLW.Value;
end;

procedure TForm1.CBBRHChange(Sender: TObject);
begin
  ReportField21.Border.Right.Height:=TDividerHeight(CBBRH.ItemIndex);
end;

procedure TForm1.CBBRSChange(Sender: TObject);
begin
  ReportField21.Border.Right.Style:=TPenStyle(CBBRS.ItemIndex);
end;

procedure TForm1.SEBRWChange(Sender: TObject);
begin
  ReportField21.Border.Right.Width:=SEBRW.Value;
end;

procedure TForm1.CBBTSChange(Sender: TObject);
begin
  ReportField21.Border.Top.Style:=TPenStyle(CBBTS.ItemIndex);
end;

procedure TForm1.SEBTWChange(Sender: TObject);
begin
  ReportField21.Border.Top.Width:=SEBTW.Value;
end;

procedure TForm1.CBBBSChange(Sender: TObject);
begin
  ReportField21.Border.Bottom.Style:=TPenStyle(CBBBS.ItemIndex);
end;

procedure TForm1.SEBBWChange(Sender: TObject);
begin
  ReportField21.Border.Bottom.Width:=SEBBW.Value;
end;

procedure TForm1.CBDHChange(Sender: TObject);
begin
  ReportField21.Divider.Height:=TDividerHeight(CBDH.ItemIndex);
end;

procedure TForm1.CBDSChange(Sender: TObject);
begin
  ReportField21.Divider.Style:=TPenStyle(CBDS.ItemIndex);
end;

procedure TForm1.SEDWChange(Sender: TObject);
begin
  ReportField21.Divider.Width:=SEDW.Value;
end;

procedure TForm1.CBCSChange(Sender: TObject);
begin
  ReportField21.CrossOut.Style:=TCrossOutStyle(CBCS.ItemIndex);
end;

procedure TForm1.SECWChange(Sender: TObject);
begin
  ReportField21.CrossOut.Width:=SECW.Value;
end;

end.
