{
--------------------------------------------------------------------------------

Component
Name:         WinTimeDateBtn
Author:       Reginald P. Zornow
Creation:     February 13, 2001
Version:      1.0.1 (February 14, 2001)
Description:  WinTimeDateBtn will run Windows Control Panel TimeDtae.cpl
              as modal application relative to your application.
Usage:        Application running in a Windows system were the user
              dose not have access to the windows system.

Tested:       I need testers will give credit.
              Delphi         Windows     By                     On
              3.0            98          Reginald P. Zornow     02/14/2001
              5.0            98          Reginald P. Zornow     02/14/2001
Credit:       Users of http://www.delphi3000.com/ were I got hints on how
              to this.
              Mats Asplund for this comment format.
EMail:        RZornow@aol.com
Site:         http://members.aol.com/rzornow/home.htm
Legal issues: Copyright (C) 2000 by Reginald P. Zornow
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail and tell me about it.

Quick Reference:
              TWinTimeDateBtn is a descendant from TButton.

              Published properties:
                None

              Events:

                Click Override event raised by OnClick event

              Defaults Changed:

              All others properties, methods and events are inherited.
--------------------------------------------------------------------------------
}

unit RZTimeDate ;

interface

USES

  Windows, StdCtrls, Buttons, Classes,

  Forms, Sysutils, ShellApi ;

TYPE
    TWinTimeDateBtn = class(TButton)

      private

      public

        PROCEDURE Click ; OVERRIDE ;

        CONSTRUCTOR Create(AOwner: TComponent) ; OVERRIDE ;

      published

END ;

PROCEDURE Register ;

implementation

PROCEDURE TWinTimeDateBtn.CLICK ;

VAR

 result : INTEGER ;

BEGIN

  INHERITED Click ;

  result := ShellExecute(Application.Handle,

                         'Open',

                         PChar('Control'),

                         PChar('TIMEDATE.CPL'),

                         nil,

                         SW_SHOWNORMAL);

  CASE result OF

    0 :

      RAISE Exception.Create(

            'The operating system is ' +

            'out of memory or resources.' ) ;

    ERROR_FILE_NOT_FOUND :

      RAISE Exception.Create(

            'The specified file was not found.' ) ;

    ERROR_PATH_NOT_FOUND :

      RAISE Exception.Create(

            'The specified path was not found.' ) ;

    ERROR_BAD_FORMAT :

      RAISE Exception.Create(

            'The .EXE file is invalid (non-Win32 .EXE ' +

            'or error in .EXE image).' ) ;

    SE_ERR_ACCESSDENIED :

      RAISE Exception.Create(

            'The operating system denied access to the ' +

            'specified file.' ) ;

    SE_ERR_ASSOCINCOMPLETE :

      RAISE Exception.Create(

            'The filename association is incomplete or invalid.' ) ;

    SE_ERR_DDEBUSY :

      RAISE Exception.Create(

            'The DDE transaction could not be completed because ' +

            'other DDE transactions were being processed.' ) ;

    SE_ERR_DDEFAIL :

      RAISE Exception.Create(

            'The DDE transaction failed.' ) ;

    SE_ERR_DDETIMEOUT :

      RAISE Exception.Create(

            'The DDE transaction could not be completed because the ' +

            'request timed out.' ) ;

    SE_ERR_DLLNOTFOUND :

      RAISE Exception.Create(

            'The specified dynamic-link library was not found.' ) ;

    SE_ERR_NOASSOC :

      RAISE Exception.Create(

      'There is no application associated with the given ' +

      'filename extension.' ) ;

    SE_ERR_OOM :

      RAISE Exception.Create(

            'There was not enough memory to complete the ' +

            'operation.' ) ;

    SE_ERR_SHARE :

      RAISE Exception.Create(

            'A sharing violation occurred.' ) ;

  ELSE

    Application.MainForm.Enabled := FALSE ;

    { Give Windows time to load the Program }

    REPEAT

      Application.ProcessMessages ;

    UNTIL FindWindow(nil, PChar('Date/Time Properties')) <> 0 ;

    REPEAT

      Application.ProcessMessages ;

    UNTIL FindWindow(nil,PChar('Date/Time Properties')) = 0 ;

    Application.MainForm.Enabled := TRUE ;

  END; { CASE result OF }

END ; { PROCEDURE TWinTimeDateBtn.CLICK ; }

CONSTRUCTOR TWinTimeDateBtn.Create(AOwner: TComponent) ;

{ Change WinTimeDateBtn Defaults }

BEGIN

  INHERITED Create(AOwner) ;

  Caption := 'Set Time Date' ;

  Height := 25 ;

  Width := 81 ;

END ; { CONSTRUCTOR TWinTimeDateBtn.Create(AOwner: TComponent) }


PROCEDURE Register ;

BEGIN

  RegisterComponents('Free tools', [TWinTimeDateBtn]) ;

END ;

end.
