unit PDJStartUp;

// TPDJStartUp version 2.00
// Freeware Component for D2,D3,D4,D5,D6
// Copyright  2000-2001 by Peric
// Birthday of Component 28.01.2001.
// E-mail: pericddn@ptt.yu
// If I' find any error or rubbish in TPDJStartUp please send me Your suggest or Reclamation.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
   Forms, Dialogs,Registry;

  {$R PDJStartUp.res}


type
  TOnExecuteEvent = procedure(Sender: TObject) of object;
  TOnStopEvent = procedure(Sender: TObject) of object;
  TPDJStartUp = class(TComponent)

  private

    FOnExecute:TOnExecuteEvent;
    FOnStop:TOnStopEvent;
    FActive:boolean;
    FCop: string;
    function GetCop: string;
    procedure SetCop(const Value: string);
    procedure SetActive(AActive: boolean);
    procedure Start;

  protected

  public

    constructor Create(Aowner:Tcomponent);override;
    destructor Destroy; override;
    procedure Execute;
    procedure Stop;

  published

    property OnExecute:TOnExecuteEvent read FOnExecute write FOnExecute;
    property OnStop:TOnStopEvent read FOnStop write FOnStop;
    property Version: string read GetCop write SetCop;

  end;

procedure Register;

implementation


procedure Register;
begin
  RegisterComponents('PDJ', [TPDJStartUp]);
end;

constructor TPDJStartUp.Create(AOwner:TComponent);

begin
inherited;
FCop :='Version 2.00, Copyright  2000-2001 by Peric, E-mail: pericddn@ptt.yu';
FActive:=True;
end;

    function TPDJStartUp.GetCop: string;
begin
     Result:=FCop;
end;

    procedure TPDJStartUp.SetCop(const Value: string);
begin
     FCop:=FCop;
end;

destructor TPDJStartUp.Destroy;
begin
inherited Destroy;
end;

procedure TPDJStartUp.Execute;
begin
SetActive(True);
if Assigned(FOnExecute) then FOnExecute(Self);
end;

procedure TPDJStartUp.Stop;
begin
SetActive(False);
if Assigned(FOnStop) then FOnStop(Self);
end;


 procedure TPDJStartUp.SetActive(AActive: boolean);
 begin
 FActive:=AActive;
 if csDesigning in ComponentState then
 Exit;
 Start;
 end;

  procedure TPDJStartUp.Start;
  const
     RunKey = '\Software\Microsoft\Windows\CurrentVersion\Run';
var
   Registry: TRegistry;
   NazivAplikacije: String;
begin
     NazivAplikacije := Application.Title;  
     Registry := TRegistry.Create;
     try
        Registry.RootKey := HKEY_LOCAL_MACHINE;
        if Registry.OpenKey(RunKey, FALSE) then
        begin
             if not Factive then
              Registry.DeleteValue(NazivAplikacije);
             if FActive then
              Registry.WriteString(NazivAplikacije, ParamStr(0));
             end;

     finally
        Registry.Free;
     end;
end;



end.
