unit Shortcut;

// Shortcut version 2.00
// Package of Components for D3,D4,D5,D6
// Copyright  2000-2001 by Peric
// Birthday of Component 27.01.2001.
// E-mail: pericddn@ptt.yu
// If I' find any error or rubbish in Shortcut please send me Your suggest or Reclamation.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls,ShlObj, ComObj, ActiveX, registry;

  {$R Shortcut.res}

type
  TOnMakeEvent = procedure(Sender: TObject) of object;
  TShortcut = class(TComponent)

  private

  FOnMake:TOnMakeEvent;
  FDirinStartmenu : string;
  FMakeOnDesktop,FMakeOnStarTMenu:boolean;
  FCop: string;
  function GetCop: string;
  function GetDirinStartmenu: string;
  function CreateShortcut(const CmdLine, Args, WorkDir, LinkFile: string):IPersistFile;
  procedure SetDirinStartmenu(ADirinStartmenu: string);
  procedure SetMakeOnDesktop(AMakeOnDesktop:boolean);
  procedure SetMakeOnStarTMenu(AMakeOnStarTMenu:boolean);
  procedure CreateShortcuts;
  procedure SetCop(const Value: string);

  protected

  public

     procedure Make;
     constructor Create(Aowner:Tcomponent);override;

  published

      property MakeOnDesktop:boolean
    read FMakeOnDesktop write SetMakeOnDesktop default True;
      property MakeOnStartMenu:boolean
    read FMakeOnStarTMenu write SetMakeOnStarTMenu default True;
    property NameSubDirInStartMenu:string
    read GetDirinStartmenu write SetDirinStartmenu;
    property Version: string read GetCop write SetCop;
    property OnMake:TOnMakeEvent read FOnMake write FOnMake;
  end;

procedure Register;

implementation


    constructor TShortcut.Create(AOwner:TComponent);

begin
     inherited;
     MakeOnStartMenu:=true;
     MakeOnDesktop:=true;
     FCop:='Version 2.00, Copyright  2000-2001 by Peric, E-mail: pericddn@ptt.yu';
end;

function TShortcut.GetCop: string;
begin
Result:=FCop;
end;


procedure TShortcut.SetCop(const Value: string);
begin
FCop:=FCop;
end;



function TShortcut.CreateShortcut(const CmdLine, Args, WorkDir, LinkFile: string): IPersistFile;

var
MyObject : IUnknown;
MySLink : IShellLink;
MyPFile : IPersistFile;
WideFile : WideString;
begin
MyObject := CreateComObject(CLSID_ShellLink);
MySLink := MyObject as IShellLink;
MyPFile := MyObject as IPersistFile;
with MySLink do
begin
SetPath(PChar(CmdLine));
SetArguments(PChar(Args));
SetWorkingDirectory(PChar(WorkDir));
end;
WideFile := LinkFile;
MyPFile.Save(PWChar(WideFile), False);
Result := MyPFile;
end;

procedure TShortcut.CreateShortcuts;
var Directory, ExecDir,start: String;
MyReg: TRegIniFile;
begin

ExecDir:=ExtractFilePath(application.exename);
MyReg := TRegIniFile.Create('Software\MicroSoft\Windows\CurrentVersion\Explorer');

start := MyReg.ReadString('Shell Folders','Start Menu','')+'\Programs\'+FDirinStartmenu;
if not FMakeOnStarTMenu then
begin
end
else
begin
CreateDir(start);
end;

Directory := MyReg.ReadString('Shell Folders','Desktop','');
CreateDir(Directory);
MyReg.Free;

if FMakeOnDesktop then
CreateShortcut(ExecDir +'/'+Application.Title+'.exe', '', ExecDir,
Directory +'/'+ Application.Title+'.lnk');

If FMakeOnStarTMenu then
CreateShortcut(ExecDir +'/'+Application.Title+'.exe', '', ExecDir,
start +'/'+ Application.Title+'.lnk');

end;

    function TShortcut.GetDirinStartmenu: string;
begin
     Result:=FDirinStartmenu;
end;


    procedure TShortcut.SetDirinStartmenu(ADirinStartmenu:string);
begin
     FDirinStartmenu:=ADirinStartmenu;
end;


procedure TShortcut.Make;
begin
    CreateShortcuts;
    if Assigned(FOnMake) then  FOnMake(Self);
end;

procedure TShortcut.SetMakeOnStarTMenu (AMakeOnStarTMenu :boolean);
begin
     FMakeOnStarTMenu :=AMakeOnStarTMenu ;
end;

procedure TShortcut.SetMakeOnDesktop (AMakeOnDesktop :boolean);
begin
     FMakeOnDesktop :=AMakeOnDesktop ;
end;

procedure Register;
begin
  RegisterComponents('PDJ', [TShortcut]);
end;

end.
