unit PDJScroller;


// TPDJScroller version 1.50
// Freeware Component for D3,D4,D5,D6
// Copyright  2000-2001 by Peric
// Birthday of Component 06.05.2001.
// E-mail: pericddn@ptt.yu
// If I' find any error or rubbish in TPDJScroller please send me Your suggest or Reclamation.

{$IFDEF VER100}
  {$DEFINE PDJ_D3}
{$ELSE}
  {$IFDEF VER120}
    {$DEFINE PDJ_D4}
  {$ELSE}
    {$DEFINE PDJ_D5Up}
  {$ENDIF}
{$ENDIF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs
  ,MMSystem,ExtCtrls,StdCtrls,Buttons,ShellApi;

  {$R PDJScroller.Res}


//******************************************************************************
{TTraka }
  type
  TTraka = class(TCustomPanel)
 private
    FXX,FYY:integer;
    FRepeat: TTimer;
    FStart:  TTimer;
    procedure doRepeat(Sender: TObject);
    procedure doStart(Sender: TObject);
    procedure WMLButtonDblClk (var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
    procedure CMMouseLeave(var AMsg: TMessage);message CM_MOUSELEAVE;
  protected
    procedure Click;override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;

  end;
  
//******************************************************************************
{TButtonUp }
  type
  TButtonUp = class(TSpeedButton)
 private
    FRepeat: TTimer;
    FStart:  TTimer;
    procedure doRepeat(Sender: TObject);
    procedure doStart(Sender: TObject);
    procedure WMLButtonDblClk (var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
  protected
    
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;
    procedure Click;override;
  end;

//******************************************************************************
{TButtonDown }
  type
  TButtonDown = class(TSpeedButton)
 private
    FRepeat: TTimer;
    FStart:  TTimer;
    procedure doRepeat(Sender: TObject);
    procedure doStart(Sender: TObject);
    procedure WMLButtonDblClk (var Message: TWMLButtonDown); message WM_LBUTTONDBLCLK;
  protected
    
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;
    procedure Click;override;
  end;

//******************************************************************************
{TSetac}
  type
  TSetac = class(TCustomPanel)
  private
    FDown: Boolean;
    FOldX, FOldY: Integer;
    FTopLimit: Integer;
    FBottomLimit: Integer;
  protected
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
     X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
     X, Y: Integer); override;
  public
  end;

//******************************************************************************

type
  TOnScroll = procedure (Sender: TObject; ScrollPos: Integer) of object;
  TKind = (sbHorizontal,sbVertical);
  Tkoliki = 10..100;
  TTrk = 1..32767;
type
  TScroller = class(TCustomControl)
  private
    FTrk:TTrk;
    FBojaSetaca,FBojaTrake:Tcolor;
    FShowText:boolean;
    FTraka:TTraka;
    FPosition,FMax,FMin:Integer;
    FKoliki:Tkoliki;
    FSetac:TSetac;
    FOnScroll: TOnScroll;
    FKind:TKind;
    procedure SetTrk(value:TTrk);
    procedure SetBojaSetaca(ABojaSetaca:TColor);
    procedure SetBojaTrake(ABojaTrake:TColor);
    procedure SetShowText(AShowText:boolean);
    procedure SetKoliki(value:Tkoliki);
    procedure SetMax(Value: Integer);
    procedure SetMin(Value: Integer);
    procedure SetKind(Value:TKind);
    function ThumbFromPosition: Integer;
    function PositionFromThumb: Integer;
    procedure SetPosition(Value: Integer);
    procedure DoPositionChange;
    procedure DoScroll;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure CmParentFontChanged(var Message: TWMNoParams); message CM_FONTCHANGED;


  protected
  
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Trk:TTrk read FTrk write SetTrk default 1;
    property BojaSetaca:TColor read FBojaSetaca write SetBojaSetaca default ClBtnFace;
    property Bojatrake:TColor read FBojatrake write SetBojatrake default clBtnFace;
    property ShowText:boolean read FShowText write SetShowText default True;
    property ThumbSize:Tkoliki read Fkoliki write SetKoliki default 25;
    property Min: Integer read FMin write SetMin;// default 0;
    property Max: Integer read FMax write SetMax;// default 100;
    property Kind:TKind read FKind write SetKind;// default sbHorizontal;
    property OnScroll: TOnScroll read FOnScroll write FOnScroll;
    property Position: Integer read FPosition write SetPosition;
    property Align;
    property Color;
    property Visible;
    property Enabled;
    property ParentColor default True;
    property ParentFont  default True;
  end;

//******************************************************************************
{TPDJScroller}
type
  TStep = 1..32767;
  TOnMouseOverEvent = procedure(Sender: TObject) of object;
  TOnMouseOutEvent = procedure(Sender: TObject) of object;
  TKindd = (tbHorizontal,tbVertical);
  TPDJScroller = class(TCustomPanel)
  private

    FHintTwo:String;
    FOnMouseOver: TOnMouseOverEvent;
    FOnMouseOut: TOnMouseOutEvent;
    FStep:TStep;
    FButtonUp:TButtonUp;
    FButtonDown:TButtonDown;
    FKindd:TKindd;
    FScroller:TScroller;
    FCop: string;
    function GetCop: string;
    procedure SetCop(const Value: string);
    function  GetBojaSetaca:TColor;
    procedure SetBojaSetaca(value:TColor);
    function  GetBojaTrake:TColor;
    procedure SetBojaTrake(value:TColor);
    procedure SetStep(value:TStep);
    function  GetShowText:boolean;
    procedure SetShowText(value:boolean);
    function  GetThumbSize:Tkoliki;
    procedure SetThumbSize(value:Tkoliki);
    function  GetTrk:TTrk;
    procedure SetTrk(value:TTrk);
    function  GetPosition:integer;
    procedure SetPosition(value:integer);
    function  GetMax:integer;
    procedure SetMax(value:integer);
    function  GetMin:integer;
    procedure SetMin(value:integer);
    function  GetOnChange: TOnScroll;
    procedure GetMinic(Sender:Tobject);
    procedure GetMaxic(Sender:Tobject);
    procedure GetTrkPlus(Sender:Tobject);
    procedure GetTrkMinus(Sender:Tobject);
    procedure SetOnChange(Value: TOnScroll);
    procedure SetKindd(Value:TKindd);

    function GetOnButtonUpClick: TNotifyEvent;
    procedure SetOnButtonUpClick(Value: TNotifyEvent);
    function GetOnButtonDownClick: TNotifyEvent;
    procedure SetOnButtonDownClick(Value: TNotifyEvent);

    function  GetHintTwo: string;
    procedure SetHintTwo(AHintTwo: string);

    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SETFOCUS;
    procedure WMKillFocus(var Message: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMSize(var Message: TMessage); message WM_SIZE;
    procedure CmEnabledChanged(var Message: TWmNoParams); message CM_ENABLEDCHANGED;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure CMMouseEnter(var AMsg: TMessage);
      message CM_MOUSEENTER;
    procedure CMMouseLeave(var AMsg: TMessage);
      message CM_MOUSELEAVE;
    
  protected
    procedure DoEnter; override;
    procedure DoExit; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Version: string read GetCop write SetCop;
    property HintSecondLine:string read GetHintTwo  write SetHintTwo;
    property OnClickBtnLT: TNotifyEvent read GetOnButtonUpClick write SetOnButtonUpClick;
    property OnClickBtnRD: TNotifyEvent read GetOnButtonDownClick write SetOnButtonDownClick;
    property OnMouseEnter: TOnMouseOverEvent read FOnMouseOver write FOnMouseOver;
    property OnMouseExit: TOnMouseOutEvent read FOnMouseOut write FOnMouseOut;
    property SmallChange:TStep read FStep write SetStep default 1;
    property LargeChange:TTrk read GetTrk write SetTrk default 1;
    property ColorThumb:TColor read GetBojaSetaca write SetBojaSetaca default ClBtnFace;
    property ColorBand:TColor read GetBojaTrake write SetBojaTrake default clBtnHighlight;
    property ThumbShowText:boolean read GetShowText write SetShowText;
    property ThumbSize:Tkoliki read GetThumbSize write SetThumbSize;
    property Min:integer read GetMin write SetMin;
    property Max:integer read GetMax write SetMax;
    property Position:integer read GetPosition write SetPosition;
    property Kind:TKindd read FKindd write SetKindd;//default tbHorizontal;
    property OnChange: TOnScroll read GetOnChange write SetOnChange;
    property Color;
    property Align;
    property Visible;
    property Enabled;
    property Hint;
    property ShowHint;
    property ParentColor;
    property TabStop default True;
    property TabOrder;
    property Font;
    property ParentFont;
    property OnEnter;
    property OnExit;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
    property DragCursor;
    property DragMode;
    property PopupMenu;
          {$IFDEF PDJ_D5up}
     property OnContextPopup;
      {$ENDIF}
  {$IFDEF PDJ_D3}
  {$ELSE}
    property Anchors;
    property Constraints;
    property BiDiMode;
    property ParentBiDiMode;
    property OnStartDock;
  {$ENDIF}

  end;

procedure Register;

implementation
var levo,desno:Tbitmap;


procedure Register;
begin
  RegisterComponents('PDJ', [TPDJScroller]);

end;

constructor TPDJScroller.Create(AOwner: TComponent);

begin
inherited Create(AOwner);
SetBounds(0,0,130,21);
Color:=clBtnFace;
BevelOuter:=bvNone;
FStep:=1;
Caption:=' ';
TabStop:=True;
ControlStyle:= ControlStyle - [csAcceptsControls];
FCop:='Version 1.50; Copyright  2000-2001 by Peric; E-mail:pericddn@ptt.yu';
levo:=Tbitmap.Create;
desno:=Tbitmap.Create;
levo.Handle := LoadBitmap(hInstance, 'levoScroller');
desno.Handle := LoadBitmap(hInstance, 'desnoScroller');
FButtonUp:=TButtonUp.Create(Self);
with FButtonUp do
begin
flat:=true;
glyph.Assign(levo);
end;
InsertControl(FButtonUp);

FScroller:=TScroller.Create(Self);

InsertControl(FScroller);
FButtonDown:=TButtonDown.Create(Self);
with FButtonDown do
begin
flat:=true;
glyph.Assign(Desno);
end;
InsertControl(FButtonDown);

end;

function TPDJScroller.GetCop: string;
begin
Result:=FCop;
end;


procedure TPDJScroller.SetCop(const Value: string);
begin
FCop:=FCop;
end;

procedure TPDJScroller.WMSize(var Message: TMessage);
begin
Case FKindd of
tbHorizontal:
begin
//SetBounds(Left,Top,Width,Height);
levo.Handle := LoadBitmap(hInstance, 'levoScroller');
desno.Handle := LoadBitmap(hInstance, 'desnoScroller');
FbuttonUp.SetBounds(1,1,13,height-2);
FbuttonUp.glyph.Assign(levo);
  FButtonDown.SetBounds((Width-14),1,13,height-2);
FbuttonDown.glyph.Assign(desno);
FScroller.SetBounds(15,0,(Width-30),(Height));
end;
tbVertical:
begin
//SetBounds(Left,Top,Width,Height);
levo.Handle := LoadBitmap(hInstance, 'goreScroller');
desno.Handle := LoadBitmap(hInstance, 'doleScroller');
FbuttonUp.SetBounds(1,1,Width-2,13);
FScroller.SetBounds(0,15,(Width),(Height-30));
 FbuttonUp.glyph.Assign(levo);
FButtonDown.SetBounds(1,(Height-14),Width-2,13);
 FbuttonDown.glyph.Assign(desno);
end;
end;

//jedno veliko sranje koje ce mozda jednog dana da proradi
{Case FKindd of
tbHorizontal:
if (Width>17) and (Width<27)then Width:=28;
tbVertical:
if (Height>17) and (Height<27)then Height:=28;
end; }

end;




destructor TPDJScroller.Destroy;
begin
FButtonUp.Free;
FButtonDown.Free;
FScroller.Free;
inherited Destroy;
end;

function TPDJScroller.GetHintTwo: string;
begin
     Result:=FHintTwo;
end;



procedure TPDJScroller.SetHintTwo(AHintTwo:String);
begin
FHintTwo:=AHintTwo;
if csDesigning in ComponentState then
 Exit;
  if hint<>'' then
  if FHintTwo<>'' then
hint:=hint+#13+FHintTwo else
hint:=hint;
end;

function TPDJScroller.GetOnButtonUpClick: TNotifyEvent;
begin
  Result := FButtonUp.OnClick;
end;

procedure TPDJScroller.SetOnButtonUpClick(Value: TNotifyEvent);
begin
FButtonUp.OnClick:= value;
end;

function TPDJScroller.GetOnButtonDownClick: TNotifyEvent;
begin
  Result := FButtonDown.OnClick;
end;

procedure TPDJScroller.SetOnButtonDownClick(Value: TNotifyEvent);
begin

FButtonDown.OnClick:= value;
end;

procedure TPDJScroller.CMMouseEnter(var AMsg: TMessage);
begin
if Assigned(FOnMouseOver) then FOnMouseOver(Self);
end;

procedure TPDJScroller.CMMouseLeave(var AMsg: TMessage);
begin
if Assigned(FOnMouseOut) then FOnMouseOut(Self);
end;

procedure TPDJScroller.SetStep(value:TStep);
begin
if FStep<>value then
Fstep:=value;
if (csDesigning in ComponentState) and not (csLoading in ComponentState) then
 begin
 if FStep>Max then FStep:=Max;
 end;
end;

function  TPDJScroller.GetShowText:boolean;
begin
  Result := FScroller.ShowText;
end;

procedure TPDJScroller.SetShowText(value:boolean);
begin
 FScroller.ShowText := Value;
end;

function  TPDJScroller.GetBojaSetaca:TColor;
begin
  Result := FScroller.BojaSetaca;
end;

procedure TPDJScroller.SetBojaSetaca(value:TColor);
begin
 FScroller.BojaSetaca := Value;
end;

function  TPDJScroller.GetBojaTrake:TColor;
begin
  Result := FScroller.BojaTrake;
end;

procedure TPDJScroller.SetBojaTrake(value:TColor);
begin
 FScroller.BojaTrake := Value;
end;   

function  TPDJScroller.GetThumbSize:Tkoliki;
begin
  Result := FScroller.ThumbSize;
end;

procedure TPDJScroller.SetThumbSize(value:Tkoliki);
begin
 FScroller.ThumbSize := Value;
end;

function TPDJScroller.GetOnChange: TOnScroll;
begin
  Result := FScroller.OnScroll;
end;

procedure TPDJScroller.SetOnChange(Value: TOnScroll);
begin
 FScroller.onScroll := Value;
end;

function TPDJScroller.GetPosition:integer;
begin
  Result := FScroller.Position;
end;

procedure TPDJScroller.SetPosition(value:integer);
begin
    FScroller.Position := Value;
end;

function  TPDJScroller.GetTrk:TTrk;
begin

if csDesigning in ComponentState then
 begin
 if FScroller.Trk>Max then FScroller.Trk:=Max;
 end;

  Result := FScroller.Trk;

end;

procedure TPDJScroller.SetTrk(value:TTrk);
begin
    FScroller.Trk := Value;

end;


function TPDJScroller.GetMin:integer;
begin
     if csDesigning in ComponentState then
 begin

 if FScroller.FMin>max then begin FScroller.FMin:=max;
 end;
 end;

  Result := FScroller.Min;

end;

procedure TPDJScroller.SetMin(value:integer);
begin
    FScroller.Min := Value;
end;

function TPDJScroller.GetMax:integer;
begin
  Result := FScroller.Max;
end;

procedure TPDJScroller.SetMax(value:integer);
begin
    FScroller.Max := Value;
end;



procedure TPDJScroller.SetKindd(value:TKindd);
var
  i: Integer;
begin
if FKindd <> Value then
begin
FKindd := Value;
if FKindd=tbHorizontal then
FScroller.SetKind(sbHorizontal)
else
FScroller.SetKind(sbVertical);
SendMessage(Handle, WM_Size, 0, 0);
if (csDesigning in ComponentState) and not (csLoading in ComponentState) then
    begin
      i := Width;
      Width := Height;
      Height := i;
    end;
end;
end;

procedure TPDJScroller.CmEnabledChanged(var Message: TWmNoParams);
begin
  inherited;
  FbuttonUp.Enabled:=Enabled;
  FbuttonDown.Enabled:=Enabled;
  if not ThumbShowText then exit;
  if enabled then
  FScroller.FSetac.Caption:=inttostr(Position) else
  FScroller.FSetac.Caption:='';
end;


procedure TPDJScroller.WMSetFocus(var Message: TWMSetFocus);
begin
 FScroller.FSetac.BevelInner:=bvLowered;
end;

procedure TPDJScroller.WMKillFocus(var Message: TWMKillFocus);
begin
  FScroller.FSetac.BevelInner:=bvNone;
end;


procedure TPDJScroller.DoEnter;
begin
  inherited DoEnter;
end;

procedure TPDJScroller.DoExit;
begin
  inherited DoExit;
end;

procedure TPDJScroller.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_UP) or (Key = VK_LEFT)then FbuttonUp.doRepeat(Self)
  else if (Key = VK_DOWN) or (Key = VK_RIGHT) then FbuttonDown.doRepeat (Self);
  if (Key = VK_Home) then GetMinic(Self);
  if (Key = VK_End) then GetMaxic(Self);
  if (Key = VK_PRIOR) then GetTrkMinus(Self);
  if (Key = VK_NEXT) then GetTrkPlus(Self);
  inherited KeyDown(Key, Shift);
end;

procedure TPDJScroller.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  Message.Result := DLGC_WANTARROWS;
end;

procedure TPDJScroller.GetMinic(Sender:Tobject);
begin
Position:=Min;
FScroller.DoPositionChange;
end;

procedure TPDJScroller.GetMaxic(Sender:Tobject);
begin
Position:=Max;
FScroller.DoPositionChange;
end;

procedure TPDJScroller.GetTrkPlus(Sender:Tobject);
begin
Position:=Position+LargeChange;
FScroller.DoPositionChange;
end;

procedure TPDJScroller.GetTrkMinus(Sender:Tobject);
begin
Position:=Position-LargeChange;
FScroller.DoPositionChange;
end;




//*****************************************************************************
{ TSetac }


procedure TSetac.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  iTop: Integer;
begin
if (ssleft in shift) then begin

if ((TScroller(Parent).Fmin)=(TScroller(Parent).Fmax)) and
((TScroller(Parent).Fmax)=(TScroller(Parent).Fposition)) then exit;

  if TScroller(Parent).Kind = sbVertical then
  begin
    FTopLimit := 0;
    FBottomLimit := TScroller(Parent).Height;
    if FDown = True then
    begin
      iTop := Top + Y - FOldY;
      if iTop < FTopLimit then
      begin
        iTop := FTopLimit;
      end;
      if (iTop > FBottomLimit) or ((iTop + Height) > FBottomLimit) then
      begin
        iTop := FBottomLimit - Height;
      end;
      Top := iTop;
    end;
  end
  else
  begin
    FTopLimit := 0;
    FBottomLimit := TScroller(Parent).Width;
    if FDown = True then
    begin
      iTop := Left + X - FOldX;
      if iTop < FTopLimit then
      begin
        iTop := FTopLimit;
      end;
      if (iTop > FBottomLimit) or ((iTop + Width) > FBottomLimit) then
      begin
        iTop := FBottomLimit - Width;
      end;
      Left := iTop;
    end;
  end;   
    TScroller(Parent).FPosition := TScroller(Parent).PositionFromThumb;
    TScroller(Parent).DoPositionChange;
  inherited MouseMove(Shift,X,Y);
end;    end;


procedure TSetac.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbleft) then begin
  FDown := False;
   end;
  inherited MouseUp(Button,Shift,X,Y);
end; 

procedure TSetac.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbleft) and not FDown then begin FDown := True;
  FOldX := X;
  FOldy := Y; end;
  inherited MouseDown(Button,Shift,X,Y);
end;


//**************************************************

constructor TScroller.Create(AOwner: TComponent);
begin
inherited Create(AOwner);
FKind:=sbHorizontal;

FMin := 0;
FMax :=100;


Ftrk:=1;
Fkoliki:=25;
FShowText:=True;
FBojaSetaca:=clBtnFace;
FBojaTrake:= clBtnHighlight;

FTraka:=TTraka.Create(Self);
FTraka.ControlStyle:= ControlStyle - [csAcceptsControls];
FTraka.Left:=1;
FTraka.Height:=6;
FTraka.Top:=(top+((Height div 2)-3));//-1);//-3);
FTraka.Width:=Width-2;
FTraka.BevelOuter:=bvLowered;
ftraka.Color:=FBojatrake;
InsertControl(FTraka);

FSetac := TSetac.Create(Self);
FSetac.ControlStyle:= ControlStyle - [csAcceptsControls];
FSetac.Left := ThumbFromPosition;
FSetac.top:=top+1;
FSetac.width:=Fkoliki;
fSetac.Alignment:=TaCenter;
FSetac.Height:=height-2;
FSetac.Color:=FBojaSetaca; ftraka.Color:=FBojatrake;
FSetac.ParentFont:=true;
InsertControl(FSetac);
end;

destructor TScroller.Destroy;
begin
FSetac.free;
inherited Destroy;
end;

procedure TScroller.WMSize(var Message: TWMSize);
begin
Case FKind of
sbHorizontal:
begin
FSetac.SetBounds(ThumbFromPosition,1,Fkoliki,(Height-2));
FTraka.SetBounds(1,(top+((Height div 2)-3)){-1)}{-3)},(Width-2),6);
end;
sbVertical:
begin
FSetac.SetBounds(1,ThumbFromPosition,(Width-2),Fkoliki);
FTraka.SetBounds(left+((Width div 2)-3),1,6,(Height-2));
end;
end;
Position := FPosition;
end;


procedure TScroller.SetTrk(value:TTrk);
begin
if FTrk<>value then
 FTrk:=value;
end;


procedure TScroller.SetBojaSetaca(ABojaSetaca:TColor);
begin
FBojaSetaca:=ABojaSetaca;
FSetac.Color:=FBojaSetaca;
end;

procedure TScroller.SetBojaTrake(ABojaTrake:TColor);
begin
FBojaTrake:=ABojaTrake;
ftraka.Color:=FBojatrake;

end;

procedure TScroller.CmParentFontChanged(var Message: TWMNoParams);
begin
Font.Assign(TPDJScroller(parent).Font);
  inherited;
end;



procedure TScroller.SetShowText(AShowText:boolean);
begin
FShowText:=AShowText;
if TPDJScroller(parent).enabled=false then exit;
if FShowText then Fsetac.caption:=inttostr(Fposition) else
Fsetac.caption:='';
end;

procedure TScroller.SetKoliki(value:Tkoliki);
begin
 if Fkoliki <> Value then
begin
Fkoliki := Value;

Case FKind of
sbHorizontal:
FSetac.width:=Fkoliki;
sbVertical:
FSetac.height:=Fkoliki;
end;
end;
end;




procedure TScroller.SetKind(value:TKind);
var
  i: Integer;
begin
 if FKind <> Value then
begin
FKind := Value;
if (csDesigning in ComponentState) and not (csLoading in ComponentState) then
    begin
      i := Width;
      Width := Height;
      Height := i;
    end;
end;
end;


function TScroller.ThumbFromPosition: Integer;
var
  iHW, iMin, iMax, iPosition: Integer;
begin
  iHW := 0;
  case FKind of
   sbVertical: iHW := Height - FSetac.Height;
    sbHorizontal: iHW := Width- FSetac.Width;
  end;
  iMin := FMin;
  iMax := FMax;
  iPosition := FPosition;
   if iPosition > iMin then
 Result :=Round(((iPosition-iMin) / Abs(iMax-iMin)) * iHW) else Result :=0;
end;


function TScroller.PositionFromThumb: Integer;
var
  iHW, iMin, iMax, iPosition: Integer;
begin
  iHW := 0;
 case FKind of
   sbVertical: iHW :=  Height - FSetac.Height;
   sbHorizontal: iHW :=Width - FSetac.Width;
  end;
  iMin := FMin;
  iMax := FMax;
  iPosition := 0;
 case FKind of
   sbVertical: iPosition := FSetac.Top;
    sbHorizontal: iPosition := FSetac.Left;
 end;
Result := Round(iPosition / iHW * Abs(iMax - iMin))+imin ;
end;

procedure TScroller.DoPositionChange;
begin
TPDJScroller(parent).SetFocus;
 FPosition := Position;
  DoScroll;
 if TPDJScroller(parent).enabled=false then exit;
if FShowText then Fsetac.caption:=inttostr(Fposition);


end;

procedure TScroller.DoScroll;
begin
  if Assigned(FOnScroll) then FOnScroll(Self,Position);
end;

procedure TScroller.SetPosition(Value: Integer);
begin
  FPosition := Value;
     if FPosition<0 then FPosition:=0;
     if FPosition>Fmax then FPosition:=Fmax;
     if FPosition<FMin then FPosition:=FMin;
 case FKind of
    sbVertical: FSetac.Top := ThumbFromPosition;
    sbHorizontal: FSetac.Left := ThumbFromPosition;
    end;
     if TPDJScroller(parent).enabled=false then exit;
if FShowText then Fsetac.caption:=inttostr(Fposition) else
Fsetac.caption:='';
  end;

procedure TScroller.SetMin(Value: Integer);
begin
  if Value <> FMin then
  begin
  FMin := Value;
    if FMin>FPosition then FPosition:=FMin;

    if FPosition>Fmax then FPosition:=Fmax;
    case FKind of
    sbVertical: FSetac.Top := ThumbFromPosition;
    sbHorizontal: FSetac.Left := ThumbFromPosition;
    end;
 end;
       if TPDJScroller(parent).enabled=false then exit;
if FShowText then Fsetac.caption:=inttostr(Fposition) else
Fsetac.caption:='';
  end;


procedure TScroller.SetMax(Value: Integer);
begin
 if Value <> FMax then
  begin
    FMax := Value;
    if FMax<Fposition then Fmax:=FPosition;
    case FKind of
    sbVertical: FSetac.Top := ThumbFromPosition;
    sbHorizontal: FSetac.Left := ThumbFromPosition;
    end;
  end;
       if TPDJScroller(parent).enabled=false then exit;
if FShowText then Fsetac.caption:=inttostr(Fposition) else
Fsetac.caption:='';
  end;

//*****************************************************************************

{TButtonUp}

constructor TButtonUp.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 FRepeat:=TTimer.Create(Self);
 FRepeat.Enabled:=false;
 FRepeat.Interval:=50;
 FRepeat.OnTimer:=doRepeat;
 FStart:=TTimer.Create(Self);
 FStart.Enabled:=false;
 FStart.Interval:=50;
 FStart.OnTimer:=doStart;
end;

procedure TbuttonUp.WMLButtonDblClk (var Message: TWMLButtonDown);
begin
  inherited;
end;

procedure TbuttonUp.Click;
begin
 TPDJScroller(parent).position:=TPDJScroller(parent).position-TPDJScroller(parent).SmallChange;
 TPDJScroller(parent).FScroller.DoPositionChange;
 inherited ;
end;

procedure TButtonUp.doRepeat(Sender: TObject);
begin
Click;
end;

procedure TButtonUp.doStart(Sender: TObject);
begin
 FStart.Enabled:=false;
 FRepeat.Enabled:=true;
end;


procedure TButtonUp.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin

 if Button<>mbleft then exit else begin
 FStart.Enabled:=true;
 end;
 inherited MouseDown(Button, Shift, X, Y);
end;

procedure TButtonUp.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
 if Button<>mbleft then exit else begin
 FRepeat.Enabled:=false;
 FStart.Enabled:=false; end;
 inherited MouseUp(Button, Shift, X, Y);
end;

//*****************************************************************************
{TButtonDown}

constructor TButtonDown.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 FRepeat:=TTimer.Create(Self);
 FRepeat.Enabled:=false;
 FRepeat.Interval:=50;
 FRepeat.OnTimer:=doRepeat;
 FStart:=TTimer.Create(Self);
 FStart.Enabled:=false;
 FStart.Interval:=50;
 FStart.OnTimer:=doStart;
end;


procedure TbuttonDown.WMLButtonDblClk (var Message: TWMLButtonDown);
begin
  inherited;
end;

procedure TbuttonDown.Click;
begin
 TPDJScroller(parent).position:=TPDJScroller(parent).position+TPDJScroller(parent).SmallChange;
 TPDJScroller(parent).FScroller.DoPositionChange;
 inherited ;
end;

procedure TButtonDown.doRepeat(Sender: TObject);
begin
Click;
end;

procedure TButtonDown.doStart(Sender: TObject);
begin
 FStart.Enabled:=false;
 FRepeat.Enabled:=true;
end;


procedure TButtonDown.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
 if Button<>mbleft then exit else begin
 FStart.Enabled:=true;
  end;
  inherited MouseDown(Button, Shift, X, Y);
end;

procedure TButtonDown.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
 if Button<>mbleft then exit else begin
 FRepeat.Enabled:=false;
 FStart.Enabled:=false; end;
 inherited MouseUp(Button, Shift, X, Y);
end;


destructor TButtonDown.Destroy;
begin
 FRepeat.free;
 FStart.free;
 inherited Destroy;
end;

destructor TButtonUp.Destroy;
begin
 FRepeat.free;
 FStart.free;
 inherited Destroy;
end;

//*****************************************************************************

{TTraka}

constructor TTraka.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 FRepeat:=TTimer.Create(Self);
 FRepeat.Enabled:=false;
 FRepeat.Interval:=50;
 FRepeat.OnTimer:=doRepeat;
 FStart:=TTimer.Create(Self);
 FStart.Enabled:=false;
 FStart.Interval:=50;
 FStart.OnTimer:=doStart;
end;

destructor TTraka.Destroy;
begin
 FRepeat.free;
 FStart.free;
 inherited Destroy;
end;

procedure TTraka.WMLButtonDblClk (var Message: TWMLButtonDown);
begin
  inherited;
end;

procedure TTraka.Click;
begin
if (TScroller(parent).Fkind=sbhorizontal) and (FXX<TScroller(parent).FSetac.Left) then
TScroller(parent).position:=TScroller(parent).position- TScroller(parent).Trk;
if (TScroller(parent).Fkind=sbhorizontal) and (FXX>(TScroller(parent).FSetac.Left+TScroller(parent).FSetac.width)) then
TScroller(parent).position:=TScroller(parent).position+TScroller(parent).Trk;
if (TScroller(parent).Fkind=sbvertical) and (FYY<TScroller(parent).FSetac.top) then
TScroller(parent).position:=TScroller(parent).position- TScroller(parent).Trk;
if (TScroller(parent).Fkind=sbvertical) and (FYY>(TScroller(parent).FSetac.Top+TScroller(parent).FSetac.height)) then
TScroller(parent).position:=TScroller(parent).position+TScroller(parent).Trk;
TScroller(parent).DoPositionChange;
 inherited ;
end;


procedure TTraka.doRepeat(Sender: TObject);
begin
Click;
end;

procedure TTraka.doStart(Sender: TObject);
begin
 FStart.Enabled:=false;
 FRepeat.Enabled:=true;
end;


procedure TTraka.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin

 if Button<>mbleft then exit else begin
 FStart.Enabled:=true;
 FXX:=X;
 FYY:=Y;
 end;
 inherited MouseDown(Button, Shift, X, Y);
end;

procedure TTraka.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
 if Button<>mbleft then exit else begin
 FRepeat.Enabled:=false;
 FStart.Enabled:=false; end;
 inherited MouseUp(Button, Shift, X, Y);
end;

procedure TTraka.CMMouseLeave(var AMsg: TMessage);
begin
 FRepeat.Enabled:=false;
 FStart.Enabled:=false; 
end;




end.
