unit AEXE;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,ShellApi;
  {$R AEXE.res}
type
  TAEXE = class(TComponent)

  private
    { Private declarations }
    FPath : string;
    FEXEname : string;
    FLive,FKill : boolean;
    FCop: string;
    function GetCop: string;
    function GetPath: string;
    Function KillTask(FileName:String):integer;
    function GetEXEname: string;
    procedure SetCop(const Value: string);
    procedure SetPath(APath: string);
    procedure SetEXEname(AEXEname: string);
    procedure SetLive(ALive:boolean);
    procedure SetKill(AKill:boolean);
  protected
    { Protected declarations }


  public
    { Public declarations }
    constructor Create(Aowner:Tcomponent);override;

  published
    { Published declarations }
    property EXELive:boolean
    read FLive write SetLive default False;
    property EXEKill:boolean
    read FKill write SetKill default False;
    property Path:string
    read GetPath write SetPath;
    property EXEname:string
    read GetExename write SetEXEname;
    property Copyright: string read GetCop write SetCop;
  end;

procedure Register;

implementation
Uses tlhelp32;

procedure Register;
begin
  RegisterComponents('PDJ', [TAEXE]);
end;

    constructor TAEXE.Create(AOwner:TComponent);

begin
     inherited;
     EXELive:=false;
     EXEKill:=false;
     Path:='';
     EXEname:='';
     FCop:='Copyright  2001 by Peric';
end;

Function TAEXE.KillTask(FileName:String):integer;
var
ContinueLoop:BOOL;
FSnapshotHandle:THandle;
FProcessEntry32:TProcessEntry32;
const
PROCESS_TERMINATE=$0001;
begin
FSnapshotHandle:=CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS,0);
FProcessEntry32.dwSize:=Sizeof(FProcessEntry32);
ContinueLoop:=Process32First(FSnapshotHandle,FProcessEntry32);
while integer(ContinueLoop)<>0 do
begin
if
((UpperCase(ExtractFileName(FProcessEntry32.szExeFile))=UpperCase(FileName))
or (UpperCase(FProcessEntry32.szExeFile)=UpperCase(FileName)))
then

Result:=Integer(TerminateProcess(OpenProcess(PROCESS_TERMINATE,BOOL(0),

FProcessEntry32.th32ProcessID),0));
ContinueLoop:=Process32Next(FSnapshotHandle,FProcessEntry32);
end;
CloseHandle(FSnapshotHandle);
end;


    function TAEXE.GetCop: string;
begin
     Result:=FCop;
end;


    function TAEXE.GetPath: string;
begin
     Result:=FPath;
end;



    function TAEXE.GetEXEname: string;
begin
     Result:=FEXEname;
end;



    procedure TAEXE.SetCop(const Value: string);
begin
     FCop:=FCop;
end;

    procedure TAEXE.SetLive(ALive:boolean);
    var s1:string;
begin
     FLive:=ALive;
     if csDesigning in ComponentState then
     Exit;

     if FLive = true then
     begin
     if (FPath='') and (FEXEname = '') then  S1 := Application.ExeName;
     if (FPath='') and (FEXEname >'') then  S1:= extractfilepath(application.exename)+ '\'+ FEXEname;
     if (FPath>'') and (FEXEname >'') then  S1:= FPath+ '\'+ FEXEname;
     if (FPath>'') and (FEXEname ='') then
     begin
     MessageDlg('  EXEname unknown !  ', mtInformation,[mbOk], 0);
     exit;
     end;

     ShellExecute(0, 'open', PChar(s1), '', '', SW_SHOWNORMAL);
     end ;

     end;


procedure TAEXE.SetKill(AKill:boolean);
    var k1:string;
begin
     FKill:=AKill;
     if csDesigning in ComponentState then
     Exit;

     if FKill = true then
     begin
     if (FPath='') and (FEXEname = '') then  k1 := Application.ExeName;
     if (FPath='') and (FEXEname >'') then  k1:= extractfilepath(application.exename)+ {'\'+ }FEXEname;
     if (FPath>'') and (FEXEname >'') then  k1:= FPath+ '\'+ FEXEname;
     if (FPath>'') and (FEXEname ='') then
     begin
     MessageDlg('  EXEname unknown !  ', mtInformation,[mbOk], 0);
     exit;
     end;

     KillTask(k1);
     end ;

     end;


    procedure TAEXE.SetPath(APath:string);
begin
     FPath:=APath;
end;

    procedure TAEXE.SetEXEname(AEXEname:string);
begin
     FEXEname:=AEXEname;
end;

end.
