unit Unit1;
// See also the project source (you can watch anywhere in your project
// - as long as you include 'PBWatcherUnit' in the uses clause of the unit.

//Note: This demo just shows how the PBWatcher works. It is actually a bad
//example in the sence that there are far too many watches. Only use few watches
//placed strategically in your code. That gives the best result.
//When you have found your bug, remove the watch-code to keep your code clean.
interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, ExtCtrls, ImgList, PBWatcherUnit;

type
	TTestForm = class(TForm)
		Button1: TButton;
		Memo1: TMemo;
		Button2: TButton;
		Button3: TButton;
		Timer1: TTimer;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Label1: TLabel;
    Button7: TButton;
    Images: TImageList;
    Button8: TButton;
		procedure Button1Click(Sender: TObject);
		procedure Button2Click(Sender: TObject);
		procedure Button3Click(Sender: TObject);
		procedure Timer1Timer(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	TestForm: TTestForm;

implementation

{$R *.DFM}

procedure TTestForm.Button1Click(Sender: TObject);
var
	ExtendedVar : extended;
begin
// Watching standard value types using the procedure 'Watch'.
	ExtendedVar := Random(100)/7;
PBWatcher.Watch('String', 'This is a string');
PBWatcher.Watch('BooleanVar', True);
PBWatcher.Watch('Integer', Integer(Trunc(Random(100))));
PBWatcher.Watch('Float (Random1)', Random(100)/7);
PBWatcher.Watch('|ExtendedVar', ExtendedVar); // on the same line.
PBWatcher.Watch(' TestForm.Caption', TestForm.Caption); // inserts a blank line.
PBWatcher.WatchEnum('BorderStyle', BorderStyle, TypeInfo(TFormBorderStyle));
PBWatcher.WatchSet('BorderIcons', BorderIcons, TypeInfo(TBorderIcons));
// to use the timer to measure elapsed time, first call 'ResetTimer'
// and then call 'WatchTimer' whenever you want to. The timer is NOT reset
// when you call 'WatchTimer'.
// To get the most accurate result there should be no watches between
// the reset and the measure. 
PBWatcher.ResetTimer;
	Sleep(125);
PBWatcher.WatchTimer('');
end;

procedure TTestForm.Button2Click(Sender: TObject);
begin
// Watching TStrings with 'Add To watches' set to false clears
// the watch-window so it shouldn't be combined with other watches !
	Memo1.Lines.Add('New line');
PBWatcher.WatchStrings('Memo1', Memo1.Lines);
end;

procedure TTestForm.Button3Click(Sender: TObject);
var
	CharArray : array[0..35] of Char;
	IntArray : array[1..12] of integer;
	ByteArray : array[0..2, 0..5] of Byte;
	ShortIntArray : array[1..2] of ShortInt;
	FloatArray : array[1..5] of Double;
	ExtArray : array[1..5] of Extended;
	BoolArray : array[1..5] of Boolean;
	Dummy : TObject;
	t : integer;
begin 
	CharArray := 'This is an '#0'array of Char'#20#0169;
PBWatcher.WatchCharArray('CharArray', CharArray);
PBWatcher.Watch('CharArrayAsString', string(CharArray));
	for t := 1 to 12 do IntArray[t] := Random(1001);
PBWatcher.WatchIntArray('IntArray', IntArray);
	for t := 0 to 5 do ByteArray[0, t] := Random(255);
	for t := 0 to 5 do ByteArray[1, t] := Random(10);
PBWatcher.WatchByteArray(' ByteArray[0]', ByteArray[0]); // Inserts blank line.
PBWatcher.WatchByteArray('|ByteArray[1]', ByteArray[1]); // on the same line.
	ShortIntArray[1] := -128;
	ShortIntArray[2] := 127;
PBWatcher.WatchShortIntArray('ShortIntArray', ShortIntArray);
	for t := 1 to 5 do FloatArray[t] := Random(200)/7;
PBWatcher.WatchDoubleArray(' FloatArray', FloatArray); // Inserts blank line.
	for t := 1 to 5 do ExtArray[t] := Random(200)/7;
PBWatcher.WatchExtendedArray('ExtArray', ExtArray);
	BoolArray[2] := True;
	BoolArray[4] := True;
PBWatcher.WatchBoolArray('BoolArray', BoolArray);
PBWatcher.WatchPointer('Pointer', nil, 0);
PBWatcher.WatchObject('Sender', Sender);
	Dummy := nil;
PBWatcher.WatchObject('Dummy', Dummy);
PBWatcher.WatchPoint('Point', TestForm.ClientOrigin);
PBWatcher.WatchRect('Rect', TestForm.BoundsRect);
PBWatcher.WatchColor('Color', TestForm.Color);
PBWatcher.WatchCursor('Cursor', TestForm.Cursor);
PBWatcher.WatchDateTime('Now', Now);
end;

procedure TTestForm.Timer1Timer(Sender: TObject);
var
	Tick : Cardinal;
begin
// Try to watch 'Tick' using Delphi Watch window (it won't show anything) !
	Tick := GetTickCount;
PBWatcher.Watch('Tick', Tick);
end;

procedure TTestForm.Button4Click(Sender: TObject);
begin
// Watching Components with 'Add To watches' set to false clears
// the watch-window so it shouldn't be combined with other watches !
PBWatcher.WatchComponents('Application.MainForm', Application.MainForm);
end;

procedure TTestForm.Button5Click(Sender: TObject);
begin
// shows a basic conditional watch. If you know that your bug only
// occurs under certain conditions then you can limit the watches.
if Random(5) >2 then PBWatcher.Watch('ConditionalWatch', 'Sometimes');
end;

procedure TTestForm.Button6Click(Sender: TObject);
// Watch any bitmap. (Set Transparency by menu or like here in code).
begin
PBWatcher.WatchBitmap('GetFormImage', GetFormImage);
PBWatcher.TransparentBitmap := not PBWatcher.TransparentBitmap;
PBWatcher.WatchBitmap('GetFormImage', GetFormImage);
end;

procedure TTestForm.Button7Click(Sender: TObject);
// Watch a Rectangle from a Canvas (not necessarily the entire area).
begin
PBWatcher.WatchCanvasRect('Label1', Label1.Canvas, Label1.Canvas.ClipRect);
end;

procedure TTestForm.Button8Click(Sender: TObject);
begin
PBWatcher.WatchImageList('Images', Images);
end;

end.

