//PBShareMap.
//
//Author:	Poul Bak
{Copyright  1999-2003 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft.denmark@tiscali.dk}
{NOTE: Be sure to include my name in the mail-body to get pass my filters.}
//
{Component Version: 6.20.00.00}
//
{PBShareMap is an easy-to-use component that uses file-mapping to let 2 or more
applications share a TStringList and thereby all variables that can be converted
to text (use the Name=Value approach). The applications can be instances of the
same application or different applications (each with PBShareMap component).}
{Set AutoSynchronize to true and changing the list in one application
automatically updates the other(s).}
{ExistsAlready can be used to limit your application to one instance.}
{Multiple PBShareMaps can be on one Form.}
{Default property: Values. Use it to easyly store variables - like an INI-file.}
{Version 4.00.00.00 automatically repairs the Application-List if another
application terminates abnormally.}
{Version 6.00.00.00 can be used without a form as owner (in DLLs etc).}

{Context-sensitive help is included.}

unit PBShareMap;

interface

uses
	Windows, Messages, SysUtils, Classes, Controls, ExtCtrls
	{$IFDEF VER100} , Forms {$ENDIF}
	{$IFDEF VER120} , Forms {$ENDIF}
	{$IFDEF VER130} , Forms {$ENDIF}
	;

type
{Decides when to open the map. See OpenMapWhen.}
	TOpenMapWhen = (omManual, omOnCreate, omOnShow, omOnActivate, omOnPaint);

{Author:	Poul Bak}
{Copyright  1999-2003 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft.denmark@tiscali.dk}
{NOTE: Be sure to include my name in the mail-body to get pass my filters.}
//
{Component Version: 6.20.00.00}
//
{PBShareMap is an easy-to-use component that uses file-mapping to let 2 or more applications share a TStringList and thereby all variables that can be converted to text (use the Name=Value approach). The applications can be instances of the same application or different applications (each with PBShareMap component).}
{Set 'AutoSynchronize' to true and changing the list in one application automatically updates the other(s).}
{ExistsAlready can be used to limit your application to one instance.}
{Multiple PBShareMaps can be on one Form.}
{Default property: Values. Use it to easyly store variables - like an INI-file.}
{Applist automatically holds the handles of all Owner-forms using the same map.}
{Importent: The MapName is the property that holds the common name that different
applications use to share a file-mapping object.}
{It must be unique in the system at any time.}
	TPBShareMap = class(TComponent)
	private
		{ Private declarations }
		FMapHandle, FMutexHandle, FAppListHandle : THandle;
		FMapName, FSynchMessage, FApplistMessage, FVersion : string;
		FMapStrings, FAppListStrings : TStringList;
		FMessageID, FApplistMessageID, FWindowhandle : Cardinal;
		FSize : integer;
		FMapPointer, FAppListPointer : PChar;
		FOpenMapWhen : TOpenMapWhen;
		FLocked, FIsMapOpen, FExistsAlready, FUpdating : Boolean;
		FReading, FAppListReading, FAutoSynch, HasOpened, FRepair : Boolean;
		FOnUpdate, FOnAppListChange, FOnOpenMap, FOnCloseMap : TNotifyEvent;
		FOnOpenFirst, FOnCloseLast, FOnAppListRepaired : TNotifyEvent;
		FPNewWndHandler, FPOldWndHandler: Pointer;
		FMapsOpen : integer;
		FTimer : TTimer;
		function OpenMap0(Name0, Message0 : string; var Handle0 : THandle;
			var Pointer0 : PChar; Size0 : Cardinal; var MessageID0 : Cardinal) : Boolean;
		function GetValues(Name : string) : string;
		procedure SetValues(Name : string; const Value : string);
		procedure CloseMap0(var Handle0 : THandle; var Pointer0 : PChar);
		procedure WriteMap0(const Pointer0 : PChar;
			const Strings0 : TStringList; const MessageID0, Size0 : Cardinal);
		procedure WriteAppListMap;
		procedure ReadAppListMap;
		procedure SetMapName(Value : String);
		procedure SetMapStrings(Value : TStringList);
		procedure SetSize(Value : integer);
		procedure SetAutoSynch(Value : Boolean);
		procedure EnterCriticalSection;
		procedure LeaveCriticalSection;
		procedure MapStringsChange(Sender : TObject);
		procedure AppListStringsChange(Sender : TObject);
		procedure NewWndProc(var FMessage : TMessage);
		procedure Dummy(Value : string);
		procedure TimerTimer(Sender : TObject);
	protected
		{ Protected declarations }
	public
		{ Public declarations }
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure Loaded; override;
{OpenMap is the procedure to manually open the map. If AutoOpen is true the map is automatically opened at start-up.}
{Use OpenMap and CloseMap if only a part of your program needs to have the map open.}
		procedure OpenMap;
{CloseMap is the procedure to manually close the map. The map automatically closes when the application closes.}
{Use OpenMap and CloseMap if only a part of your program needs to have the map open.}
		procedure CloseMap;
{ReadMap reads the map manually and calls OnUpdate event.}
{It is normally not necessary to call ReadMap - it is done automaticcally when another application calls WriteMap.}
		procedure ReadMap;
{WriteMap writes the map manually and sends message to all open PBShareMaps that they must update.}
{If AutoSynchronize is True, it is not necessary to call WriteMap. In that case every change in MapStrings will cause the other applications to update.}
{For small maps - or if you change the whole list at one time, that is the preferred method.}
{If you make a lot of changes 'simultaniously' it is more effective to set AutoSynchronize to False and, when you have finished changing call WriteMap;}
		procedure WriteMap;
{A TStringList that dynamically contains the handles of all the forms that contain an open PBShareMap with the same MapName as the current map.}
{Updates when an application opens or closes a map.}
{Note: It will not update when the map is closed - in this application.}
		property AppList : TStringList read FAppListStrings;
{The property can be used to determine that another application (or another instance of the same application) has already a map open - with the same MapName.}
{If you want to limit your program to one instance, simply close the application if ExistsAlready is True (set OpenMapWhen = omOnCreate). You can pass a filename to open or what you like before closing the second application.}
{Notice that if the first application closes the map and reopens it, ExistsAlready will become True.}
		property ExistsAlready : Boolean read FExistsAlready;
{When the map is open this property becomes True.}
		property IsMapOpen : Boolean read FIsMapOpen;
{The number of open PBShareMaps (with the same MapName as the current map).}
{Updates when an application (this one or another) opens or closes a map.}
{Note: It will not update when the map is closed - in this application.}
		property MapsOpen : integer read FMapsOpen;
{True when the map is beeing read - when the OnUpdate event triggers.}
{See demo for an example of use.}
		property ReadingMap : Boolean read FReading;
{The default property.}
{It is actually the same as MapStrings.Values. See TStringList.Values in Delphi help.}
//
{Use it like this:}
{Store a variable called MyVar: PBShareMap1['MyVar'] := Myvar;}
{Get the variable: MyVar := PBShareMap1['MyVar'];}
//
{if MyVar is not a string, you have to convert it to (and from) a string,
for instance an integer: PBShareMap1['MyInteger'] := IntToStr(MyInteger);}
		property Values[Name : string] : string read GetValues write SetValues; default;
	published
		{ Published declarations }
{The maximum size in Bytes that can be used to store strings.}
{Default value is 4096 Bytes - min. 32 Bytes.}
{There are no max. value to this property (well... 2 GigaBytes, I guess) but MaxSize is the amount of memory allocated for the map so you shouldn't use a value too big.}
{If the size is too large to hold in physical memory, Windows will swap the map to disk which will slow updating down.}
{When changing the MapStrings only the actual size of MapStrings will be sent - not MaxSize bytes.}
{Using very large strings might be slow - I have measured the speed to about 4 MBytes pr. second when using large strings (MBytes).}
{Note: You can't change the MaxSize when the map is open (in any application). So set the MaxSize before opening it (equal MaxSize in all applications).}
{If you change the size and another application has the map open, opening the map will not change the size.}
		property MaxSize : integer read FSize write SetSize;
{Determines if the map should update fully automatically - if True then every small change to MapStrings will result in an automatic update of the other application's maps (WriteMap auto-call).}
{If AutoSynchronize is True, it is not necessary to call 'WriteMap'. In that case every change in MapStrings will cause the other applications to update.}
{For small maps - or if you change the whole list at one time, that is the preferred method.}
{If you make a lot of changes 'simultaniously' it is more effective to set AutoSynchronize to False and, when you have finished changing call WriteMap;}
		property AutoSynchronize : Boolean read FAutoSynch write SetAutoSynch default True;
{MapName is the name of the map. The name must be unique and common: Common to the applications that ought to share the same map and unique throughout the system.}
{The map share the name-space with other file-mapping objects, mailslots and other kinds of shared memory objects.}
{MapName is the only property you must change before running.}
		property MapName : string read FMapName write SetMapName;
{The MAP - a TStringList that is 'shared' along all the maps (with the same name) that are open on the computer.}
{You can use it to share any kind of list that contains strings.}
{When a map is opened, ReadMap is automatically called, if the map already existed, otherwise WriteMap is called so the value of MapStrings is assigned to the map. If you haven't changed it at runtime, that will be the value you gave it at designtime (via Object Inspector).}
{If you want to share more than one variable you can use the 'Name=Value' approach to the TStringList - like an INI-file.}
{See the default property: Values.}
		property MapStrings : TStringList read FMapStrings write SetMapStrings;
{Triggers when the component has updated the MapStrings. Use it to put variable-values back to the variables - synchronize the variables.}
{This event only triggers when the map is changed by another application using the same map - not when this application changes the map.}
		property OnUpdate : TNotifyEvent read FOnUpdate write FOnUpdate;
{Triggers when this or another application opens or closes a map - see Applist.}
		property OnAppListChange : TNotifyEvent read FOnAppListChange	write FOnAppListChange;
{Triggers when the map is opened.}
		property OnOpenMap : TNotifyEvent read FOnOpenMap write FOnOpenMap;
{Triggers when the map is closed.}
		property OnCloseMap : TNotifyEvent read FOnCloseMap write FOnCloseMap;
{Triggers when the map is opened if and only if it's the first map.}
{Use it to initialize MapStrings in the first application.}
		property OnOpenFirst : TNotifyEvent read FOnOpenFirst write FOnOpenFirst;
{Triggers when the last map is closed - there are no maps open.}
		property OnCloseLast : TNotifyEvent read FOnCloseLast write FOnCloseLast;
{Triggers when the AppList is updated because ANOTHER application -that had
an open PBShareMap - closed abnormally (caused by an error, or 'Run-Program Reset'
in Delphi).}
		property OnAppListRepaired : TNotifyEvent read FOnAppListRepaired
			write FOnAppListRepaired;
{Decides when the map should open.}
{This determines what you can do in the OnUpdate event handler.}
{If the owner is NOT a form, only omManual is relevant.}
{omManual: The map does not open automatically - you have to call OpenMap.}
{omOnCreate: The map opens as soon as the component has loaded - using this setting
you can reference the form's own variables but not necessarily other form's variables
- they may not yet have been created.}
{omOnShow: Opens when the form is shown for the first time - meaning you can
safely call other form's variables, if that form is auto-created.}
{omOnActivate: Opens when the form is activated for the first time - meaning you
can safely call other form's variables, if that form is auto-created.}
{omOnPaint: Opens when the form is painted for the first time - meaning you can
safely call other form's variables, if that form is auto-created.}
		property OpenMapWhen : TOpenMapWhen read FOpenMapWhen write FOpenMapWhen default omOnShow;
{The version number - read only.}
		property Version : string read FVersion write Dummy stored False;
	end;

const
	FAppListSize = 4096;
	FTimerInterVal = 5000;

procedure Register;

implementation
{$IFNDEF VER100}{$IFNDEF VER120}{$IFNDEF VER130}
	{$WARN SYMBOL_DEPRECATED OFF}
{$ENDIF}{$ENDIF}{$ENDIF}

constructor TPBShareMap.Create(AOwner: TComponent);
var
	t : integer;
	TempMapName : string;
begin
	inherited Create(AOwner);
	FVersion := '6.20.00.00';
	FAutoSynch := True;
	FOpenMapWhen := omOnShow;
	HasOpened := False;
	FSize := 4096;
	FLocked := False;
	FIsMapOpen := False;
	FExistsAlready := False;
	FReading := False;
	FAppListReading := False;
	FMapStrings := TStringList.Create;
	FMapStrings.OnChange := MapStringsChange;
	FAppListStrings := TStringList.Create;
	with FAppListStrings do
	begin
		Sorted := True;
		Duplicates := dupIgnore;
		OnChange := AppListStringsChange;
	end;
	TempMapName := 'PBShareMap-';
	for t := 0 to 10 do TempMapName := TempMapName + Chr(Random(27) + 65);
	SetMapName(TempMapName);
	if AOwner is TWinControl then
	begin
		FWindowhandle := (AOwner as TWinControl).Handle;
		FPOldWndHandler := Ptr(GetWindowLong(FWindowhandle, GWL_WNDPROC));
		FPNewWndHandler :=	MakeObjectInstance(NewWndProc);
		if FPNewWndHandler = nil then Raise Exception.Create('Out of resources');
		SetWindowLong(FWindowhandle, GWL_WNDPROC, Longint(FPNewWndHandler));
	end
	else
	begin
		FOpenMapWhen := omManual;
		FWindowHandle := AllocateHWND(NewWndProc);
	end;
	FTimer := TTimer.Create(Self);
	FTimer.Enabled := False;
	FTimer.Interval := FTimerInterVal;
	FTimer.OnTimer := TimerTimer;
	FRepair := False;
end;

procedure TPBShareMap.Loaded;
begin
	inherited Loaded;
	if (not (csDesigning in ComponentState)) and (FOpenMapWhen = omOnCreate) then OpenMap;
end;

destructor TPBShareMap.Destroy;
begin
	CloseMap;
	if Owner is TWinControl then
	begin
		SetWindowLong(FWindowhandle, GWL_WNDPROC, Longint(FPOldWndHandler));
		if FPNewWndHandler <> nil then FreeObjectInstance(FPNewWndHandler);
	end
	else DeAllocateHWND(FWindowhandle);
	FAppListStrings.Free;
	FAppListStrings := nil;
	FMapStrings.Free;
	FMapStrings := nil;
	inherited destroy;
end;

function TPBShareMap.OpenMap0(Name0, Message0 : string; var Handle0 : THandle;
		var Pointer0 : PChar; Size0 : Cardinal; var MessageID0 : Cardinal) : Boolean;
var
	TempMessage : array[0..255] of Char;
begin
	Result := False;
	Handle0 := CreateFileMapping($FFFFFFFF, nil, PAGE_READWRITE or SEC_COMMIT or SEC_NOCACHE,
		0, Size0, PChar(Name0));
	if (Handle0 = INVALID_HANDLE_VALUE) or (Handle0 = 0)
		then RaiseLastWin32Error
	else
	begin
		if (Handle0 <> 0) and (GetLastError = ERROR_ALREADY_EXISTS)
			then FExistsAlready := True;
		Pointer0 := MapViewOfFile(Handle0, FILE_MAP_ALL_ACCESS, 0, 0, 0);
		if Pointer0 = nil then RaiseLastWin32Error
		else
		begin
			StrPCopy(TempMessage, Message0);
			MessageID0 := RegisterWindowMessage(TempMessage);
			if MessageID0 = 0 then RaiseLastWin32Error
			else Result := True;
		end;
	end;
end;

procedure TPBShareMap.OpenMap;
begin
	if (FMapHandle = 0) and (FMapPointer = nil) then
	begin
		FExistsAlready := False;
		if OpenMap0(FMapName, FSynchMessage, FMapHandle, FMapPointer, FSize, FMessageID) then
		begin
			FMutexHandle := Windows.CreateMutex(nil, False, PChar(FMapName + '.Mtx'));
			if FMutexHandle = 0 then RaiseLastWin32Error;
			if OpenMap0(FMapName + '-AppList', FApplistMessage, FAppListHandle,
				FAppListPointer, FAppListSize, FApplistMessageID) then
			begin
				FIsMapOpen := True;
				HasOpened := True;
				if FExistsAlready then ReadAppListMap;
				FAppListStrings.Add(IntToStr(FWindowhandle));
				if FExistsAlready then ReadMap
				else
				begin
					WriteMap;
					if Assigned(FOnOpenFirst) then FOnOpenFirst(Self);
				end;
				if Assigned(FOnOpenMap) then FOnOpenMap(Self);
				FTimer.Enabled := True;
			end;
		end;
	end;
end;

procedure TPBShareMap.CloseMap0(var Handle0 : THandle; var Pointer0 : PChar);
begin
	if Pointer0 <> nil then
	begin
		UnMapViewOfFile(Pointer0);
		Pointer0 := nil;
	end;
	if Handle0 <> 0 then
	begin
		CloseHandle(Handle0);
		Handle0 := 0;
	end;
end;

procedure TPBShareMap.CloseMap;
begin
	FTimer.Enabled := False;
	if FIsMapOpen then
	begin
		if FMutexHandle <> 0 then
		begin
			FAppListStrings.Delete(FAppListStrings.IndexOf(IntToStr(FWindowhandle)));
			if not (csDestroying in ComponentState) and (FApplistStrings.Count = 0)
				and Assigned(FOnCloseLast) then FOnCloseLast(Self);
			CloseHandle(FMutexHandle);
			FMutexHandle := 0;
		end;
		CloseMap0(FAppListHandle, FAppListPointer);
		CloseMap0(FMapHandle, FMapPointer);
		FIsMapOpen := False;
		if not (csDestroying in ComponentState) and Assigned(FOnCloseMap)
			then FOnCloseMap(Self);
	end;
end;

procedure TPBShareMap.SetMapName(Value : string);
begin
	if (FMapName <> Value) and (not FIsMapOpen) and (Length(Value) < 246) then
	begin
		FMapName := Value;
		FSynchMessage := FMapName + '-Synch-Now';
		FAppListMessage := FMapName + '-Handles';
	end;
end;

procedure TPBShareMap.SetMapStrings(Value : TStringList);
begin
	if Value.Text <> FMapStrings.Text then
	begin
		if Length(Value.Text) <= FSize then FMapStrings.Assign(Value)
		else Raise Exception.Create('Can''t write Strings. Strings are too large!');
	end;
end;

procedure TPBShareMap.MapStringsChange(Sender : TObject);
begin
	if not (csDestroying in ComponentState) then
	begin
		if FReading and (not FUpdating) then
		begin
			FUpdating := True;
			if Assigned(FOnUpdate) then FOnUpdate(Self);
			FUpdating := False;
		end
		else if ((not FReading) or FUpdating) and FIsMapOpen and FAutoSynch then WriteMap;
	end;
end;

procedure TPBShareMap.AppListStringsChange(Sender : TObject);
begin
	FMapsOpen := FAppListStrings.Count;
	if (not (csDestroying in ComponentState)) and Assigned(FOnAppListChange)
		then FOnAppListChange(Self);
	if (not FAppListReading) and FIsMapOpen then WriteAppListMap;
end;

procedure TPBShareMap.SetSize(Value : integer);
var
	StringsPointer : PChar;
begin
	if (FSize <> Value) and (FMapHandle = 0) then
	begin
		StringsPointer := FMapStrings.GetText;
		if (Value < Integer(StrLen(StringsPointer)) + 1)
			then FSize := Integer(StrLen(StringsPointer)) + 1
		else FSize := Value;
		if FSize < 32 then FSize := 32;
		StrDispose(StringsPointer);
	end;
end;

procedure TPBShareMap.SetAutoSynch(Value : Boolean);
begin
	if FAutoSynch <> Value then
	begin
		FAutoSynch := Value;
		if FAutoSynch and FIsMapOpen then WriteMap;
	end;
end;

procedure TPBShareMap.ReadMap;
begin
	FReading := True;
	EnterCriticalSection;
	if (FMapPointer <> nil) then FMapStrings.SetText(FMapPointer);
	LeaveCriticalSection;
	FReading := False;
end;

procedure TPBShareMap.ReadAppListMap;
begin
	FAppListReading := True;
	EnterCriticalSection;
	if (FApplistPointer <> nil) then FAppListStrings.SetText(FApplistPointer);
	LeaveCriticalSection;
	FAppListReading := False;
end;

procedure TPBShareMap.WriteMap0(const Pointer0 : PChar;
	const Strings0 : TStringList; const MessageID0, Size0 : Cardinal);
var
	StringsPointer : PChar;
	HandleCounter : integer;
	SendToHandle : Cardinal;
begin
	if Pointer0 <> nil then
	begin
		StringsPointer := Strings0.GetText;
		EnterCriticalSection;
		if StrLen(StringsPointer) + 1 <= Size0
			then System.Move(StringsPointer^, Pointer0^, StrLen(StringsPointer) + 1)
		else Raise Exception.Create('Can''t write Strings. Strings are too large!');
		LeaveCriticalSection;
		StrDispose(StringsPointer);
		for HandleCounter := 0 to FAppListStrings.Count - 1 do
		begin
			SendToHandle := StrToIntDef(FAppListStrings[HandleCounter], FWindowhandle);
			if SendToHandle <> FWindowhandle then PostMessage(SendToHandle,
				MessageID0,	FWindowhandle, 0);
		end;
	end;
end;

procedure TPBShareMap.WriteMap;
begin
	WriteMap0(FMapPointer, FMapStrings, FMessageID, FSize);
end;

procedure TPBShareMap.WriteAppListMap;
begin
	WriteMap0(FAppListPointer, FAppListStrings, FAppListMessageID, FAppListSize);
end;

procedure TPBShareMap.EnterCriticalSection;
begin
	if (FMutexHandle <> 0) and not FLocked then
	begin
		FLocked := (WaitForSingleObject(FMutexHandle, INFINITE) = WAIT_OBJECT_0);
	end;
end;

procedure TPBShareMap.LeaveCriticalSection;
begin
	if (FMutexHandle <> 0) and FLocked then
	begin
		ReleaseMutex(FMutexHandle);
		FLocked := False;
	end;
end;

function TPBShareMap.GetValues(Name : string) : string;
begin
	Result := FMapStrings.Values[Name];
end;

procedure TPBShareMap.SetValues(Name : string; const Value : string);
begin
	if Value <> FMapStrings.Values[Name]
		then FMapStrings.Values[Name] := Value;
end;

procedure	TPBShareMap.NewWndProc(var FMessage : TMessage);
begin
	with FMessage do
	begin
		if not (csDesigning in ComponentState) and (not HasOpened) then
		begin
			case Msg of
				WM_SHOWWINDOW: if (WParam <> 0) and (FOpenMapWhen = omOnShow)
					then OpenMap;
				WM_ACTIVATE: if (WParam <> WA_INACTIVE) and (FOpenMapWhen = omOnActivate)
					then OpenMap;
				WM_PAINT: if (FOpenMapWhen = omOnPaint) then OpenMap;
			end;
		end
		else if FIsMapOpen then
		begin
			if Msg = FMessageID then ReadMap
			else if Msg = FAppListMessageID then ReadAppListMap;
		end;
		if Owner is TWinControl then Result := CallWindowProc(FPOldWndHandler,
			FWindowhandle, Msg, wParam, lParam)
		else Result := DefWindowProc(FWindowHandle, Msg, wParam, lParam);
	end;
end;

procedure TPBShareMap.TimerTimer(Sender : TObject);
var
	t : integer;
	Repaired, TempRepair : Boolean;
begin
	FTimer.Enabled := False;
	TempRepair := FRepair;
	Repaired := False;
	t := 0;
	while t < FAppListStrings.Count do
	begin
		if (not IsWindow(StrToIntDef(FAppListStrings[t], 0))) then
		begin
			if not FRepair then FRepair := True
			else
			begin
				FAppListStrings.Delete(t);
				Repaired := True;
			end;
		end
		else Inc(t);
	end;
	if TempRepair then FRepair := False;
	if Repaired and Assigned(FOnAppListRepaired) then FOnAppListRepaired(Self);
	FTimer.Enabled := FIsMapOpen;
end;

procedure TPBShareMap.Dummy(Value : string);
begin
		//read only
end;

procedure Register;
begin
	RegisterComponents('PB', [TPBShareMap]);
end;

end.

