library DLLDemo_DLL;

uses
	SysUtils, {Forms,} PBShareMap;

type
	TDLLShareMap = class(TPBShareMap)
	private
		procedure UpdateMap(Sender : TObject);
	end;

var
	DLLShareMap : TDLLShareMap;

function InitDemoDLL(AppHandle : Cardinal) : integer; stdcall;
begin
	try
//		Application.Handle := AppHandle;
// If you have a dll with forms or dialogs - set the application.handle !
		DLLShareMap := TDLLShareMap.Create(nil);
		DLLShareMap.AutoSynchronize := False;
		DLLShareMap.MapName := 'PBShareMap-DLLDemo';
		DLLShareMap.OnUpdate := DLLShareMap.UpdateMap;
		DLLShareMap.OpenMap;
		Result := 0;
	except
		Result := -1;
	end;
end;

function FinalizeDemoDLL : integer; stdcall;
begin
	DLLShareMap.Free;
	DLLShareMap := nil;
	Result := 0;
end;

{$R *.res}

exports
	InitDemoDLL,
	FinalizeDemoDLL;

// ------------ TDLLShareMap -------------------

procedure TDLLShareMap.UpdateMap(Sender : TObject);
begin
	if Self['Request'] = 'Please send the time' then
	begin
		Self['Time'] := DateTimeToStr(Now);
		Self['Request'] := '';
		Self.WriteMap;
	end;
end;

begin
end.
