//Author: Poul Bak
//Copyright  1999 - 2004 : Bak-O-Soft (Poul Bak). All rights reserved.
//http://bak-o-soft.dk/
//Mailto:info@bak-o-soft.dk
{}
{Component Version: 1.20.00.00}
{}
{PBClipBoard is a small component that monitors the clipboard. It has only one
property, the 'Onchange' event, that triggers whenever the contents of the
clipboard changes. Use it to automatically enable/disable 'Paste'-buttons or to
view the contents of the clipboard.}

{How to use: Drop a PBClipBoard component on the form. Write an Onchange
event-handler to enable/disable the paste buttons. That's all.}

unit PBClipBoard;
{$UNDEF DEL345}
{$IFDEF VER100} {$DEFINE DEL345} {$ENDIF}
{$IFDEF VER120} {$DEFINE DEL345} {$ENDIF}
{$IFDEF VER130} {$DEFINE DEL345} {$ENDIF}
{$IFNDEF DEL345} {$WARN SYMBOL_DEPRECATED OFF} {$ENDIF}

interface

uses
	Windows, Messages, SysUtils, Classes, ClipBrd, Forms;

type
	TPBClipBoard = class(TComponent)
	private
		{ Private declarations }
		FOnChange : TNotifyEvent;
		hWndNext, HiddenWindowHandle: HWnd;
		FVersion : string;
		function GetClipBoard : TClipBoard;
		procedure Dummy(Value : string);
	protected
		{ Protected declarations }
		procedure Loaded; override;
		procedure WndProc(var Msg : TMessage);
	public
		constructor Create(AOwner : TComponent); override;
		destructor Destroy; override;
		{ Public declarations }
{Gets the global ClipBoard variable. Use it or use the global ClipBoard variable
directly. I doesn't matter.}
		property ClipBoard : TClipBoard read GetClipBoard;
	published
		{ Published declarations }
{The OnChange event triggers whenever the contents of the clipboard changes.
Use it to automatically enable/disable 'Paste'-buttons or to view the contents
of the clipboard.}
		property OnChange : TNotifyEvent read FOnChange write FOnChange;
		property Version : string read FVersion write Dummy stored False;
	end;

procedure Register;

implementation

// ---------------------  TPBClipBoard  ----------------------------
constructor TPBClipBoard.Create(AOwner : TComponent);
begin
	inherited;
	FVersion := '1.20.00.00';
end;

procedure TPBClipBoard.Loaded;
begin
	inherited;
	if not (csDesigning in ComponentState) then
	begin
		HiddenWindowHandle := AllocateHWnd(WndProc);
		hWndNext := SetClipboardViewer(HiddenWindowHandle);
	end;
end;

destructor TPBClipBoard.Destroy;
begin
	if not (csDesigning in ComponentState) then
	begin
		ChangeClipboardChain(HiddenWindowHandle, hWndNext);
		DeAllocateHWnd(HiddenWindowHandle);
	end;
	inherited;
end;

function TPBClipBoard.GetClipBoard : TClipBoard;
begin
	Result := ClipBrd.Clipboard;
end;

procedure TPBClipBoard.WndProc(var Msg : TMessage);
begin
	with Msg do
	begin
		if (Msg = WM_CHANGECBCHAIN) then
		begin
			if HWND(WParam) =hWndNext then hWndNext := LParam
			else SendMessage (hWndNext, Msg, WParam, LParam);
		end
		else if (Msg = WM_DRAWCLIPBOARD) then
		begin
			if Assigned(FOnChange) then FOnChange(Self);
			SendMessage (hWndNext, Msg, WParam, LParam);
		end
		else Result := DefWindowProc(HiddenWindowHandle, Msg, wParam, lParam);
	end;
end;

procedure TPBClipBoard.Dummy(Value : string); begin end;

// -------------------  Register  ----------------------------
procedure Register;
begin
	RegisterComponents('PB', [TPBClipBoard]);
end;

end.
