unit Mylog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,  ExtCtrls;

type
  TMylog = class(TMemo)
  private
    { Private declarations }
    Timer : TTimer;
    UseFile : boolean;
    WriteDiskNow, WriteDisk: Boolean;
    f : text;
    FMaxLines : integer;
    SavedLines : integer;
    FCheckTimeout : integer;
    FFileName : string;
    FFileAppend : boolean;
    FIncDateTime : Boolean;        // Include the Date/Time in the Log
    FLongDate : Boolean;      // day & month in the Log
    procedure SetMaxLines(ml : integer);
    procedure LogMemoOnTimer(Sender : TObject);
  protected
    { Protected declarations }

  public
    { Public declarations }
    constructor Create(AOWner : TComponent); override;
    function DateTimeToRTCLog(aDate: TDateTime): string;
    procedure Start;
    procedure Stop;
    procedure AddEvent (const S : string);
    procedure UpdateFile;
  published
    { Published declarations }
    Property  IncDateTime : Boolean read FIncDateTime write FIncDateTime;
    Property  FormatLongDate : Boolean read FLongDate write FLongDate;
    Property  FileOpened : Boolean read UseFile write UseFile;
    Property  SaveLogs : Boolean read WriteDisk write WriteDisk;
    Property  FastLogs : Boolean read WriteDiskNow write WriteDiskNow;
    //    Property  DateTimeFormatStr : String read FDateTimeFormatStr write FDateTimeFormatStr;
    property MaxLines : integer read FMaxLines write SetMaxLines;
    property CheckTimeout : integer read FCheckTimeout write FCheckTimeout;
    property FileName : string read FFileName write FFileName;
    property FileAppend : boolean read FFileAppend write FFileAppend;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PNP', [TMylog]);
end;

constructor TMylog.Create;
begin
  inherited Create(AOwner);
  Color := clInactiveBorder;
  FIncDateTime := False;
  FLongDate := False;
  ReadOnly := TRUE;
  FMaxLines := 100;
  FCheckTimeout := 200;
  FFileName := '';
  FFileAppend := TRUE;
  Timer := TTimer.Create(Self);
  Timer.Enabled := FALSE;
  Timer.OnTimer := LogMemoOnTimer;
end;

function TMylog.DateTimeToRTCLog(aDate: TDateTime): string;
const
  StrWeekDay: string = 'MonTueWedThuFriSatSun';
  StrMonth: string = 'JanFebMarAprMayJunJulAugSepOctNovDec';
var
  Year, Month, Day: Word;
  Hour, Min, Sec, MSec: Word;
  DayOfWeek: Word;
begin
  DecodeDate(aDate, Year, Month, Day);
  DecodeTime(aDate, Hour, Min, Sec, MSec);
  Msec := Msec DIV 10;
  DayOfWeek := ((Trunc(aDate) - 2) mod 7);
  if FLongDate then
  Result    := Copy(StrWeekDay, 1 + DayOfWeek * 3, 3) + ', ' +
    Format('%2.2d %s %4.4d %2.2d:%2.2d:%2.2d.%2.2d',
    [Day, Copy(StrMonth, 1 + 3 * (Month - 1), 3), Year, Hour, Min, Sec, Msec])
  else
  Result := Format('%2.2d-%2.2d-%4.4d %2.2d:%2.2d:%2.2d.%2.2d',
                   [Day, Month, Year, Hour, Min, Sec, Msec])
end;

procedure TMylog.SetMaxLines;
begin
  if ml > 0
    then FMaxLines := ml
    else FMaxLines := 100;
end;

procedure TMylog.LogMemoOnTimer;
var
  i, d : integer;
begin
  if WriteDisk then updateFile;
  begin
    UpdateFile;
    if Lines.Count > FMaxLines then
    begin
      Lines.BeginUpdate;
      d := Lines.Count - FMaxLines;
      for i := 1 to d do
      begin
        Lines.Delete(0);
        Dec(SavedLines);
      end;
     Lines.EndUpdate;
    end;
  end;
end;

procedure TMylog.Start;
begin
  if FFileName <> ''
    then begin
      UseFile := TRUE;
      AssignFile(f, FFileName);
      if FFileAppend and FileExists(FFileName)
        then Append(f)
        else Rewrite(f);
    end
    else UseFile := FALSE;
  WriteDisk := true;
  Timer.Interval := FCheckTimeout;
  Timer.Enabled := true;
end;

procedure TMylog.Stop;
begin
  Timer.Enabled := FALSE;
  if UseFile
    then CloseFile(f);
end;

procedure TMylog.updateFile;
var
  i: integer;
Begin
  for i := SavedLines to (Lines.Count -1) do
    if useFile then
    begin
      WriteLn(f, Lines[i]);
      inc(SavedLines);
   end;
end;

procedure TMylog.AddEvent;
begin
  Timer.Enabled := false;
  if FIncDateTime = true then
  begin
    if WriteDiskNow then
      WriteLn (f, DateTimeToRTCLog(Now) + ' ' + s)
    else
      Lines.Add(DateTimeToRTCLog(Now) + ' ' + S);
  end
  else
    if WriteDiskNow then
      Writeln(f, S)
    else
      Lines.Add(S);
  If WriteDisk then Timer.Enabled := true;
end;

end.
