{
--------------------------------------------------------------------------------

Component Name: TMDP
        Author: Mats Asplund
      Creation: 2000-08-08
                (MAS-CompMaker was used to generate this code.)
       Version: 1.0
   Description: Animated MDP-Logo
        Credit:
        E-mail: mats.asplund@telia.com
          Site: http://w1.545.telia.com/~u54503556/delphi/mdp.htm
  Legal issues: Copyright (C) 2000 by Mats Asplund
                This software is provided 'as-is', without any express or
                implied warranty.  In no event will the author be held liable
                for any  damages arising from the use of this software.

                Permission is granted to anyone to use this software for any
                purpose, including commercial applications, and to alter it
                and redistribute it freely, subject to the following
                restrictions:

                1. The origin of this software must not be misrepresented,
                   you must not claim that you wrote the original software.
                   If you use this software in a product, an acknowledgment
                   in the product documentation would be appreciated but is
                   not required.

                2. Altered source versions must be plainly marked as such, and
                   must not be misrepresented as being the original software.

                3. This notice may not be removed or altered from any source
                   distribution.

                4. If you decide to use this software in any of your applications.
                   Send me an EMail address and tell me about it.

Quick Reference:
                TMDP inherits from TCompoundPanel.

                Properties:

                Events:

                Methods:

--------------------------------------------------------------------------------
}
unit MDP;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, compound, StdCtrls, ExtCtrls;

type
  TCompForm = class(TForm)
    I1_9: TImage;
    I2_8: TImage;
    I3_7: TImage;
    I4_6: TImage;
    I5: TImage;
    I10_12: TImage;
    I11: TImage;
    I12: TImage;
  end;

  TMDP = class(TCompoundPanel)
  private
    FForm: TCompForm;
    Timer: TTimer;
    FINo: Integer;
    FCop: string;
    procedure Change(Sender: TObject);
    procedure SetCop(Value: string);
    function GetCop: string;
  { Private declarations }
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Start;
    procedure Stop;
    property Form: TCompForm read FForm;
  { Private declarations }
  published
    property Copyright: string read GetCop write SetCop;
  { Published declarations }
  end;

var
  CompForm: TCompForm;

procedure Register;

implementation
{$R *.DFM}

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TMDP]);
end;

procedure TMDP.Change(Sender: TObject);
begin
  case FINo of
    1: begin
        Form.I12.Hide;
        Form.I1_9.Show;
      end;
    2: begin
        Timer.Interval:= 200;
        Form.I1_9.Hide;
        Form.I2_8.Show;
      end;
    3: begin
        Form.I2_8.Hide;
        Form.I3_7.Show;
      end;
    4: begin
        Form.I3_7.Hide;
        Form.I4_6.Show;
      end;
    5: begin
        Form.I4_6.Hide;
        Form.I5.Show;
      end;
    6: begin
        Form.I5.Hide;
        Form.I4_6.Show;
      end;
    7: begin
        Form.I4_6.Hide;
        Form.I3_7.Show;
      end;
    8: begin
        Form.I3_7.Hide;
        Form.I2_8.Show;
      end;
    9: begin
        Form.I2_8.Hide;
        Form.I1_9.Show;
      end;
    10: begin
        Form.I1_9.Hide;
        Form.I10_12.Show;
      end;
    11: begin
        Timer.Interval:= 700;
        Form.I10_12.Hide;
        Form.I11.Show;
      end;
    12: begin
        Form.I11.Hide;
        Form.I10_12.Show;
      end;
    13: begin
        Form.I10_12.Hide;
        Form.I12.Show;
      end;
  end;
  if FINo = 13 then FINo:= 1 else Inc(FINo);
end;

constructor TMDP.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FForm:= MoveControls(TCompForm.Create(nil));
  Timer:= TTimer.Create(Self);
  Timer.OnTimer:= Change;
  Timer.Enabled:= false;
  Timer.Interval:= 700;
  FINo:= 1;
  Height:= 42;
  Width:= 76;
  FCop:= 'Copyright (c) 2000, MAs Prod. / Mats Asplund';
end;

destructor TMDP.Destroy;
begin
  inherited Destroy;
end;

function TMDP.GetCop: string;
begin
  Result:= FCop;
end;

procedure TMDP.SetCop(Value: string);
begin
  FCop:= FCop;
end;

procedure TMDP.Start;
begin
  Form.I12.Hide;
  Form.I2_8.Hide;
  Form.I3_7.Hide;
  Form.I4_6.Hide;
  Form.I5.Hide;
  Form.I4_6.Hide;
  Form.I3_7.Hide;
  Form.I2_8.Hide;
  Form.I10_12.Hide;
  Form.I11.Hide;
  Form.I10_12.Hide;
  Timer.Enabled:= true;
end;

procedure TMDP.Stop;
begin
  Form.I1_9.Show;
  Form.I1_9.BringToFront;
  Timer.Enabled:= false;
end;

end.

