{
----------------------------------------------------------
MAS-CompMaker was used to generate this code
MAS-CompMaker, copyright(c) 2000, Mats Asplund / MAs Prod.
----------------------------------------------------------

Component Name: TURLLabel
        Author: Mats Asplund
      Creation: 2000-08-13
       Version: 1.1
   Description: A clickable URL- or mail-Label.
        Credit:
        E-mail: mats.asplund@telia.com
          Site: http://w1.545.telia.com/~u54503556/delphi/mdp.htm
  Legal issues: Copyright (C) 2000 by Mats Asplund


         Usage: This software is provided 'as-is', without any express or
                implied warranty.  In no event will the author be held liable
                for any  damages arising from the use of this software.

                Permission is granted to anyone to use this software for any
                purpose, including commercial applications, and to alter it
                and redistribute it freely, subject to the following
                restrictions:

                1. The origin of this software must not be misrepresented,
                   you must not claim that you wrote the original software.
                   If you use this software in a product, an acknowledgment
                   in the product documentation would be appreciated but is
                   not required.

                2. Altered source versions must be plainly marked as such, and
                   must not be misrepresented as being the original software.

                3. This notice may not be removed or altered from any source
                   distribution.

                4. If you decide to use this software in any of your applications.
                   Send me an EMail address and tell me about it.

Quick Reference:
                TURLLabel inherits from TLabel.

                Key-Properties:

                MailLabel: If set to true a 'mailto:' is added to caption, in
                           order to launch mail.

                Key-Methods:

                Click-method overridden.

--------------------------------------------------------------------------------
}
unit URLLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShellApi;

type
  TURLLabel = class(TLabel)
  private
    FCopyright: string;
    FMailLabel: boolean;
    procedure SetCop(Value: string);
    procedure SetMailLabel(Value: boolean);
  protected
  public
    constructor Create(AOwner: TComponent); override;
    procedure Click; override;
  published
    property MailLabel: boolean read FMailLabel write SetMailLabel;
    property Copyright: string read FCopyright write SetCop;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TURLLabel]);
end;

procedure TURLLabel.Click;
begin
  inherited Click;
  if FMailLabel then
    ShellExecute(0, 'open', PChar('mailto:'+Caption), '', '', SW_SHOWNORMAL)
  else
    ShellExecute(0, 'open', PChar(Caption), '', '', SW_SHOWNORMAL);
end;

constructor TURLLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Font.Style:= [fsUnderline];
  Cursor:= crHandPoint;
  FCopyright:= 'Copyright (c) 2000, MAs Prod. / Mats Asplund';
end;

procedure TURLLabel.SetCop(Value: string);
begin
  Exit;
end;

procedure TURLLabel.SetMailLabel(Value: boolean);
begin
  FMailLabel := Value;
end;

end.

