{
--------------------------------------------------------------------------------

Component Name: TAppDlg
Author: Mats Asplund
Creation: Aug 10, 1999
Version: 3.2  (Aug 26, 2001)
Description:  TAppDlg is a component for displaying application info to user.              from any given source.
Credit:
EMail:        masprod@telia.com
Site:         http://go.to/masdp
Legal issues: All rights reserved 1999-2001 by Mats Asplund
              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages araising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

              4. If you decide to use this software in any of your applications.
                 Send me an EMail address and tell me about it.

Quick Reference:
              TAppDlg is a descendant from TComponent.

              Published properties:
              Productname: string
              Version: string
              Copyright: string
              Info: string
              EMail: string
              Site: string

              Method:
              Execute: Call this to run component.

--------------------------------------------------------------------------------
}
unit AppDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  PTransBuffer = ^TTransBuffer;
  TTransBuffer = array[1..4] of smallint;

  TAppDlg = class(TComponent)
  private
    fProductname: string;
    fVersion: string;
    fCopyright: string;
    fInfo: string;
    fEmail: string;
    fSite: string;
    VersionList: TStringList;
    procedure GetVersionInfo(AVersionList: TStrings);
    function GetCreationDate(FileName: string): TDateTime;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    function Execute: boolean;
    property Productname: string read fProductname write fProductname;
    property Version: string read fVersion write fVersion;
    property Copyright: string read fCopyright write fCopyright;
    property Email: string read fEmail write fEmail;
    property Site: string read fSite write fSite;
    property Info: string read fInfo write fInfo;
  end;

procedure Register;

implementation
uses AppDlgDlg;

const
  CInfoStr : array[1..4] of string =
    ('FileVersion','LegalCopyright', 'ProductName', 'ProductVersion');

// Alter these to suit your needs
  defVersion = '1.0.1.1';
  defCopyright1 = 'All rights reserved ';
  defCopyright2 = ' by Mats Asplund';
  defEmail = 'masprod@telia.com';
  defSite = 'http://go.to/masdp';

constructor TAppDlg.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  VersionList:= TStringList.Create;
end;

destructor TAppDlg.Destroy;
begin
  VersionList.Free;
  inherited Destroy;
end;

function TAppDlg.GetCreationDate(FileName: string): TDateTime;
var
  SearchRec: TSearchRec;
  DT: TFileTime;
  ST: TSystemTime;
begin
  Result:= 0;
  if not FileExists(FileName) then Exit;
  try
    SysUtils.FindFirst(FileName, faAnyFile, SearchRec);
    try
      FileTimeToLocalFileTime(SearchRec.FindData.ftCreationTime, DT);
      FileTimeToSystemTime(DT, ST);
      Result:= SystemTimeToDateTime(ST);
    finally
      SysUtils.FindClose(SearchRec);
    end;
  except
    Result:= 0;
  end;
end;

procedure TAppDlg.GetVersionInfo(AVersionList: TStrings);
var
  filename: string;
  i:        integer;
  infoSize: DWORD;
  ptrans:   PTransBuffer;
  transStr: string;
  typeStr:  string;
  value:    PChar;
  verBuf:   pointer;
  verSize:  DWORD;
  wnd:      DWORD;
begin
  AVersionList.Clear;
  filename := Application.ExeName;
  infoSize := GetFileVersioninfoSize(PChar(filename), wnd);

  if infoSize <> 0 then
  begin
    GetMem(verBuf, infoSize);
    try
      if GetFileVersionInfo(PChar(filename), wnd, infoSize, verBuf) then
      begin
        VerQueryvalue(verBuf, PChar('\VarFileInfo\Translation'),
                      Pointer(ptrans), verSize);

        transStr := IntToHex(ptrans^[1], 4) + IntToHex(ptrans^[2], 4);

        for i := Low(CInfoStr) to High(CInfoStr) do
        begin
          typeStr := 'StringFileInfo\' + transStr + '\' + CInfoStr[i];

          if VerQueryvalue(verBuf, PChar(typeStr),
                           Pointer(value), verSize) then
            AVersionList.Add(value);
        end
      end;
    finally
      FreeMem(verBuf);
    end;
  end;
end;

function TAppDlg.Execute: boolean;
var
  fYear, fYearCreate: string;
begin
  AppDlgForm:=TAppDlgForm.Create(Application);
  try
    if fProductname = '' then
      fProductname:= Application.Title;

    if fInfo = '' then
    begin
      fInfo:= Copy(DateTimeToStr(GetCreationDate(Application.ExeName)), 1, 10);
      fYearCreate:= Copy(fInfo, 1, 4);
      fYear:= Copy(DateTimeToStr(Now), 1, 4);
      if fYear <> fYearCreate then
        fYear:= fYearCreate + '-' + fYear;
    end;

    if fCopyright = '' then
    begin
      fCopyright:= defCopyright1 + fYear + defCopyright2;
    end;

    if fVersion = '' then
    begin
      GetVersionInfo(VersionList);
      fVersion:= VersionList[0];
    end;

    if fSite = '' then
      fSite:= defSite;

    if fEmail = '' then
      fEmail:= defEmail;

    AppDlgForm.Productname.Caption:= fProductname;
    AppDlgForm.Version.Caption:= fVersion;
    AppDlgForm.Copyright.Caption:= fCopyright;
    AppDlgForm.Info.Caption:= fInfo;
    AppDlgForm.Site.Caption:= fSite;
    AppDlgForm.Email.Caption:= fEmail;
    AppDlgForm.Caption:='About ' + fProductname;

    with AppDlgForm do
    begin
      ProgramIcon.Picture.Graphic:= Application.Icon;
      Result:= (ShowModal = IDOK);
    end;

  finally
    AppDlgForm.Free;
  end;
end;

procedure Register;
begin
  RegisterComponents('MAs Prod.', [TAppDlg]);
end;

end.
