// Due to changes between Delphi versions this unit hass
// been tested with Delphi 3 and Delphi 4. It will check
// for the compiler version. If you have compile errors
// with other versions of Delphi you should check the
// condidtional define $IFDEF VER100 and update it as required.


unit about;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,shellapi, LetsConnectButton;

type VS_FIXEDFILEINFO = record
        dwSignature:        DWORD;
        dwStrucVersion:     DWORD;
        dwFileVersionMS:    DWORD;
        dwFileVersionLS:    DWORD;
        dwProductVersionMS: DWORD;
        dwProductVersionLS: DWORD;
        dwFileFlagsMask:    DWORD;
        dwFileFlags:        DWORD;
        dwFileOS:           DWORD;
        dwFileType:         DWORD;
        dwFileSubtype:      DWORD;
        dwFileDateMS:       DWORD;
        dwFileDateLS:       DWORD;
     end;
type
  TAboutBox = class(TForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    Label1: TLabel;
    WebAddress: TLabel;
    Label3: TLabel;
    EmailAddress: TLabel;
    BitBtn1: TBitBtn;
    LetsConnectBtn1: TLetsConnectBtn;
    procedure FormCreate(Sender: TObject);
    procedure WebAddressClick(Sender: TObject);
  private
    { Private declarations }
  public
    function getprogramversion:string;
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

procedure DisplayAboutBox;

implementation

{$R *.DFM}

procedure DisplayAboutBox;

begin
  aboutbox:=taboutbox.create(application);
  aboutbox.showmodal;
  aboutbox.free;
end;

function TAboutBox.getprogramversion:string;

var verinfo   : array[0..1024] of char;
    buffer    : pointer;


{$IFDEF VER100}
// For Delphi 3 set len to be an integer.
    len       : integer;
{$ELSE}
// Delphi 4 changed the definition to require a cardinal
// as oposed to an integer. It is assumed that all versions
// above 3 will do likewise.
    len       : cardinal;
{$ENDIF}

    filename  : array[0..255] of char;
    versionhi : word;
    versionlo : word;

begin
  result:='';
  strpcopy(filename,paramstr(0));
  getfileversioninfo( filename,
                      0,
                      sizeof(verinfo),
                      @verinfo);
  verqueryvalue( @verinfo,
                 '\',
                 pointer(buffer),
                 len);
  versionhi:=hiword(vs_fixedfileinfo(buffer^).dwproductversionms);
  versionlo:=loword(vs_fixedfileinfo(buffer^).dwproductversionms);
  result:=inttostr(versionhi)+'.'+inttostr(versionlo);
  versionhi:=hiword(vs_fixedfileinfo(buffer^).dwproductversionls);
  versionlo:=loword(vs_fixedfileinfo(buffer^).dwproductversionls);
  result:=result+'.'+inttostr(versionhi)+'.'+inttostr(versionlo);
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
  productname.caption:=application.Title;
  version.caption:='Version '+getprogramversion;
  programicon.picture.icon:=application.icon;
end;

procedure TAboutBox.WebAddressClick(Sender: TObject);
begin
  shellexecute(0,'open',pchar(TLabel(sender).caption),nil,nil,sw_shownormal);
end;

end.

