// Let's Connect Button.
//
// This button has been created to allow programmers
// to add a Let's Connect interface to their programs.
//
// This is achieved by simply calling up a specific
// Web page with your Let's Connect "button" number
// and default country code.
//
// Instructions : -
//
// Simply add the button onto your form and enter in
// your Let's Connect button number and your
// country's telephone code (ie Australia = 61)
// You can also change the Glyph to replace the
// default image.
//
//
//
// Let's Connect is a service that allows your clients to
// click a button, enter in their phone number and then
// immediately establish a phone call between you and them.
//
// Unlike Internet telephony connections this service
// established a real phone link so that neither you
// nor your client requires any special hardware or
// software.
//
// This service is ideal for programmers that offer
// priority support contracts to their clients as it
// effectively provides an international free call
// service at a very cost effective rate.  It is also
// very useful if you distribute trial software as it
// will allow a potential client to get in contact with
// you very easily.
//
// For more information go to the LetsConnect web site
// at http://www.letsconnect.com
//
// Dealer and reseller enquires are welcome.
//


unit LetsConnectButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons,shellapi;

type
  TLetsConnectBtn = class(TSpeedButton)
  private
    FButtonNumber   : string;
    FCountryCode    : string;
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor create(AOwner: TComponent); override;
  published
    property ButtonNumber : string read FButtonNumber write FButtonNumber;
    property CountryCode  : string read FCountryCode write FCountryCode;
    procedure click; override;
    { Published declarations }
  end;

procedure Register;

implementation

procedure TLetsConnectBtn.click;

begin
  inherited;
  shellexecute(0,'open',pchar('http://www.letsconnect.com/letsconnect/letsconnect.asp?ID='+FButtonNumber+'&CountryCode='+FCountryCode),nil,nil,sw_shownormal);
end;

constructor TLetsConnectBtn.create(AOwner: TComponent);

begin
  inherited;
  if csDesigning in ComponentState then
  begin
    caption:='';
    width:=132;
    height:=34;
    if fileexists('LetsConnect1.bmp') then
    begin
      buttonNumber:='48';
      CountryCode:='31';
      glyph.LoadFromFile('LetsConnect1.bmp');
      width:=glyph.Width+4;
      height:=glyph.height+4;
    end;
  end;
end;

procedure Register;
begin
  RegisterComponents('LetsConnect', [TLetsConnectBtn]);
end;

end.
