unit kbmMemTableReg;

interface

{$I kbmMemTable.inc}

uses Classes, DsgnIntf
{$ifdef LEVEL5}
,FldLinks, DB
{$endif};

procedure Register;
// =========================================================================
// Registration for kbmMemTable extended by Chris G. Royle to support
// Delphi 5 Categories.
//
// Between versions 1.37 and the current version, many new features / properties have
// been added. Categorisation helps newbies & upgraders make the transition.
//
// Note that the Advanced, and File Categories default to being non-visible after a build.
// =========================================================================
implementation

uses
  kbmMemTable
{$ifdef LEVEL5}
 ,kbmMemTableDesigner
{$endif};

{$ifdef LEVEL5}
type

  TkbmMemTableBasicCategory = class(TPropertyCategory)
  public
    class function Name: string; override;
    class function Description: string; override;
  end;
  TkbmMemTableAdvancedCategory = class(TPropertyCategory)
  public
    class function Name: string; override;
    class function Description: string; override;
    procedure AfterConstruction; override;
  end;
  TkbmMemTableIndexCategory = class(TPropertyCategory)
  public
    class function Name: string; override;
    class function Description: string; override;
  end;
  TkbmMemTableFileCategory = class(TPropertyCategory)
  public
    class function Name: string; override;
    class function Description: string; override;
    procedure AfterConstruction; override;
  end;

{ TkbmMemTableFieldLinkProperty }
  TkbmMemTableFieldLinkProperty = class(TFieldLinkProperty)
  private
    FTable: TkbmMemTable;
  protected
    procedure GetFieldNamesForIndex(List: TStrings); override;
    function GetIndexBased: Boolean; override;
    function GetIndexDefs: TIndexDefs; override;
    function GetIndexFieldNames: string; override;
    function GetIndexName: string; override;
    function GetMasterFields: string; override;
    procedure SetIndexFieldNames(const Value: string); override;
    procedure SetIndexName(const Value: string); override;
    procedure SetMasterFields(const Value: string); override;
  public
    property IndexBased: Boolean read GetIndexBased;
    property IndexDefs: TIndexDefs read GetIndexDefs;
    property IndexFieldNames: string read GetIndexFieldNames write SetIndexFieldNames;
    property IndexName: string read GetIndexName write SetIndexName;
    property MasterFields: string read GetMasterFields write SetMasterFields;

    procedure Edit; override;
  end;

const
  CBasicName    = 'Basic';
  CBasicDesc    = 'TkbmMemTable Basic';
  CFileName     = 'File Access';
  CFileDesc     = 'TkbmMemTable File Access';
  CIndexName    = 'Indexing';
  CIndexDesc    = 'TkbmMemTable Indexing';
  CAdvancedName = 'Advanced';
  CAdvancedDesc = 'TkbmMemTable Advanced';
{$endif}


procedure Register;
begin
  RegisterComponents('Data Access', [TkbmMemTable,TkbmThreadDataSet]);
{$ifdef LEVEL5}
  RegisterComponentEditor(TkbmMemTable, TkbmMemTableDesigner);
  RegisterPropertyEditor(TypeInfo(string), TkbmMemTable, 'MasterFields', TkbmMemTableFieldLinkProperty);

  RegisterPropertiesInCategory(TkbmMemTableBasicCategory, TkbmMemTable,
    ['Active',
     'FieldDefs',
     'EnableIndexes', 'IndexDefs', 'IndexFieldNames', 'IndexName', 'AutoReposition',
     'Filter', 'Filtered', 'FilterOptions',
     'Persistent', 'PersistentFile',
     'ProgressFlags',
     'MasterFields', 'MasterSource', 'Name',
     'ReadOnly', 'SortFields', 'SortOptions',
     'Tag', 'Version',
     'OnFilterRecord', 'OnCalcFields', 'OnProgress']);
  RegisterPropertiesInCategory(TkbmMemTableFileCategory, TkbmMemTable,
    ['CSVFieldDelimiter', 'CSVQuote', 'CSVRecordDelimiter', 'CommaTextOptions',
     'Persistent', 'PersistentFile', 'PersistentSaveFormat', 'PersistentSaveOptions', 'PersistentBackup', 'PersistentBackupExt',
     'OnLoad', 'OnLoadRecord', 'OnSave', 'OnSaveRecord']);
  RegisterPropertiesInCategory(TkbmMemTableIndexCategory, TkbmMemTable,
    ['EnableIndexes', 'IndexDefs', 'IndexFieldNames', 'IndexName']);
  RegisterPropertiesInCategory(TkbmMemTableAdvancedCategory, TkbmMemTable,
    ['AllDataOptions',
     'AttachedAutoRefresh', 'AttachedTo',
     'AutoIncMinValue', 'EnableJournal',
     'EnableVersioning',
     'DeltaHandler',
     'LoadLimit',
     'RecalcOnFetch', 'RecalcOnIndex', 'StoreDataOnForm',
     'Performance',
     'VersioningMode',
     'OnLoadField', 'OnSaveField', 'OnCompareFields',
     'OnCompressBlobStream', 'OnCompressSave', 'OnDecompressBlobStream', 'OnDecompressLoad',
     'OnCompressField','OnDecompressField','OnSetupField']);
{$endif}
end;

{$ifdef LEVEL5}
class function TkbmMemTableBasicCategory.Name: string;
begin
  Result := CBasicName;
end;

class function TkbmMemTableBasicCategory.Description: string;
begin
  Result := CBasicDesc;
end;

class function TkbmMemTableFileCategory.Name: string;
begin
  Result := CFileName;
end;

class function TkbmMemTableFileCategory.Description: string;
begin
  Result := CFileDesc;
end;

procedure TkbmMemTableFileCategory.AfterConstruction;
begin
  inherited;
  Visible:= False;
end;

class function TkbmMemTableIndexCategory.Name: string;
begin
  Result := CIndexName;
end;

class function TkbmMemTableIndexCategory.Description: string;
begin
  Result := CIndexDesc;
end;


class function TkbmMemTableAdvancedCategory.Name: string;
begin
  Result := CAdvancedName;
end;

procedure TkbmMemTableAdvancedCategory.AfterConstruction;
begin
  inherited;
  Visible:= False;
end;

class function TkbmMemTableAdvancedCategory.Description: string;
begin
  Result := CAdvancedDesc;
end;

{ TkbmMemTableFieldLinkProperty }

procedure TkbmMemTableFieldLinkProperty.Edit;
var
  Table: TkbmMemTable;
begin
  Table := DataSet as TkbmMemTable;
  FTable := TkbmMemTable.Create(nil);
  FTable.Name:='__PROXY_MT';
  try
     FTable.CreateTableAs(Table,[]);
     FTable.IndexDefs.assign(Table.IndexDefs);
     FTable.MasterFields := Table.MasterFields;

     if Table.IndexFieldNames <> '' then
        FTable.IndexFieldNames := Table.IndexFieldNames
     else
         FTable.IndexName := Table.IndexName;

     FTable.Open;
     inherited Edit;
     if Changed then
     begin
          Table.MasterFields := FTable.MasterFields;
          if FTable.IndexFieldNames <> '' then
             Table.IndexFieldNames := FTable.IndexFieldNames
          else
              Table.IndexName := FTable.IndexName;
     end;
  finally
     FTable.Free;
  end;
end;

procedure TkbmMemTableFieldLinkProperty.GetFieldNamesForIndex(List: TStrings);
var
  i: Integer;
begin
  for i := 0 to FTable.IndexFieldCount - 1 do
      List.Add(FTable.IndexFields[i].FieldName);
end;

function TkbmMemTableFieldLinkProperty.GetIndexBased: Boolean;
begin
  Result := not IProviderSupport(FTable).PSIsSQLBased;
end;

function TkbmMemTableFieldLinkProperty.GetIndexDefs: TIndexDefs;
begin
  Result := FTable.IndexDefs;
end;

function TkbmMemTableFieldLinkProperty.GetIndexFieldNames: string;
begin
  Result := FTable.IndexFieldNames;
end;

function TkbmMemTableFieldLinkProperty.GetIndexName: string;
begin
  Result := FTable.IndexName;
end;

function TkbmMemTableFieldLinkProperty.GetMasterFields: string;
begin
  Result := FTable.MasterFields;
end;

procedure TkbmMemTableFieldLinkProperty.SetIndexFieldNames(const Value: string);
begin
  FTable.IndexFieldNames := Value;
end;

procedure TkbmMemTableFieldLinkProperty.SetIndexName(const Value: string);
begin
     FTable.IndexName := Value;
end;

procedure TkbmMemTableFieldLinkProperty.SetMasterFields(const Value: string);
begin
  FTable.MasterFields := Value;
end;
{$endif}

end.


