unit kbmMemTableDesigner;

interface

{$I kbmMemTable.inc}

uses
    Dsgnintf,db;
type
    TkbmMemTableDesigner = class(TComponentEditor)
    private
    public
    	procedure ExecuteVerb(Index: Integer); override;
    	function GetVerb(Index: Integer): string; override;
    	function GetVerbCount: Integer; override;
    	procedure TableDesigner;
    	procedure LoadPersistentFileBinary;
    	procedure LoadPersistentFileNormal;
    	procedure EmptyTable;
    end;

implementation

uses
    DSDesign,kbmMemTable,kbmMemTableDesForm;

procedure TkbmMemTableDesigner.EmptyTable;
begin
     TkbmMemTable(Component).Active := True;
     TkbmMemTable(Component).EmptyTable;
end;

procedure TkbmMemTableDesigner.ExecuteVerb(Index: Integer);
begin
{$ifdef LEVEL5}
     case Index of
      	0: DSDesign.ShowFieldsEditor(Designer, TDataSet(Component),TDSDesigner);
	1: TableDesigner;
	2: LoadPersistentFileBinary;
	3: LoadPersistentFileNormal;
	4: EmptyTable;
     end;
{$else}
     case Index of
	0: TableDesigner;
	1: LoadPersistentFileBinary;
	2: LoadPersistentFileNormal;
	3: EmptyTable;
     end;
{$endif}
end;

function TkbmMemTableDesigner.GetVerb(Index: Integer): String;
begin
{$ifdef LEVEL5}
     case Index of
     	0: Result:= '&Fields Editor';
     	1: Result:= '&Table Designer';
     	2: Result:= '&Load Persistent File (Binary)';
     	3: Result:= '&Load Persistent File (Normal)';
     	4: Result:= '&Empty Table';
     end;
{$else}
     case Index of
     	0: Result:= '&Table Designer';
     	1: Result:= '&Load Persistent File (Binary)';
     	2: Result:= '&Load Persistent File (Normal)';
     	3: Result:= '&Empty Table';
     end;
{$endif}
end;

function TkbmMemTableDesigner.GetVerbCount: Integer;
begin
{$ifdef LEVEL5}
     Result:=5;
{$else}
     Result:=4;
{$endif}
end;

procedure TkbmMemTableDesigner.LoadPersistentFileBinary;
var
   DummyTable:TkbmMemTable;
begin
     DummyTable:=TkbmMemTable.Create(nil);
     try
        DummyTable.LoadFromBinaryFile(TkbmMemTable(Component).PersistentFile);
        DummyTable.Active:=True;
	TkbmMemTable(Component).Active:=True;
	TkbmMemTable(Component).EmptyTable;
	frmKbmMemTableDesigner.CopyDataSet(DummyTable,TDataSet(Component),False);
	DummyTable.Active:=False;
     finally
	DummyTable.Free;
     end;
end;

procedure TkbmMemTableDesigner.LoadPersistentFileNormal;
var
   DummyTable:TkbmMemTable;
begin
     DummyTable:=TkbmMemTable.Create(nil);
     try
        DummyTable.LoadFromFile(TkbmMemTable(Component).PersistentFile);
        DummyTable.Active := True;
        TkbmMemTable(Component).Active:=True;
        TkbmMemTable(Component).EmptyTable;
        frmKbmMemTableDesigner.CopyDataSet(DummyTable,TDataSet(Component),False);
        DummyTable.Active := False;
     finally
        DummyTable.Free;
     end;
end;

procedure TkbmMemTableDesigner.TableDesigner;
var
   frmKbmMemTableDesigner:TfrmKbmMemTableDesigner;
begin
     frmKbmMemTableDesigner:=TfrmKbmMemTableDesigner.Create(nil);
     try
        frmkbmMemTableDesigner.Designer := Designer;
        frmKbmMemTableDesigner.MemTable:=TkbmMemTable(Component);
        frmKbmMemTableDesigner.ShowModal;
     finally
        frmKbmMemTableDesigner.Free;
     end;
end;

end.
