unit kbmMemTable;

interface

uses SysUtils,Classes,Db,DbCommon,Windows;

// TKbmMemTable v. 2.50d Beta
const COMPONENT_VERSION = '2.50d Beta';
// =========================================================================
// An inmemory temporary table.
// Can be used as a demonstration of how to create descendents of TDataSet,
// or as in my case, to allow a program to generate temporary data that can
// be used directly by all data aware controls.
//
// Copyright 1999,2000 Kim Bo Madsen/Optical Services - Scandinavia
// All rights reserved.
//
// LICENSE AGREEMENT
// PLEASE NOTE THAT THE LICENSE AGREEMENT HAS CHANGED!!! 16. Feb. 2000
//
// You are allowed to use this component in any project for free.
// You are NOT allowed to claim that you have created this component or to
// copy its code into your own component and claim that it was your idea.
//
// -----------------------------------------------------------------------------------
// PLEASE NOTE THE FOLLOWING ADDITION TO THE LICENSE AGREEMENT:
// If you choose to use this component for generating middleware libraries (with similar
// functionality as dbOvernet, Midas, Asta etc.), those libraries MUST be released as
// Open Source and Freeware!
// -----------------------------------------------------------------------------------
//
// Im offering this for free for your convinience, and the only thing I REQUIRE
// is to get an e-mail about what project this component (or derived versions)
// is used for.
//
// You dont need to state my name in your software, although it would be
// appreciated if you do.
//
// If you find bugs or alter the component (f.ex. see suggested enhancements
// further down), please DONT just send the corrected/new code out on the internet,
// but instead send it to me, so I can put it into the official version. You will
// be acredited if you do so.
//
//
// DISCLAIMER
// By using this component or parts theirof you are accepting the full
// responsibility of the use. You are understanding that the author cant be
// made responsible in any way for any problems occuring using this component.
// You also recognize the author as the creator of this component and agrees
// not to claim otherwize!
//
// Please forward corrected versions (source code ONLY!), comments,
// and emails saying you are using it for this or that project to:
//            kbm@optical.dk
//
// Suggestions for future enhancements:
//
//      - IDE designer for adding static data to the memtable.
//      - Optimized sorting. Combosort, many way mergesort or the like for large datasets.

//
// History:
//
//1.00:	The first release. Was created due to a need for a component like this.
//                                                                    (15. Jan. 99)
//1.01:	The first update. Release 1.00 contained some bugs related to the ordering
//	of records inserted and to bookmarks. Problems fixed.         (21. Jan. 99)

//1.02:	Fixed handling of NULL values. Added SaveToStream, SaveToFile,
//	LoadFromStream and LoadFromFile. SaveToStream and SaveToFile is controlled
//	by a flag telling if to save data, contents of calculated fields,
//	contents of lookupfields and contents of non visible fields.
//	Added an example application with Delphi 3 source code.       (26. Jan. 99)
//
//1.03: Claude Rieth from Computer Team sarl (clrieth@team.lu) came up with an
//      implementation of CommaText and made a validation check in _InternalInsert.
//      Because I allready have implemented the saveto.... functions, I decided
//      to implement Claude's idea using my own saveto.... functions. (27. Jan. 99)
//      I have decided to rename the component, because Claude let me know that
//      the RX library have a component with the same name as this.
//      Thus in the future the component will be named TkbmMemTable.
//      SaveToStream and LoadFromStream now set up date and decimal separator
//      temporary to make sure that the data saved can be loaded on another
//      installation with different date and decimal separator setups.
//      Added EmptyTable method to clear the contents of the memory table.
//
//1.04: Wagner ADP (wagner@cads-informatica.com.br) found a bug in the _internalinsert
//      procedure which he came up with a fix for.                     (4. Feb. 99)
//      Added support for the TDataset protected function findrecord.
//      Added support for CreateTable, DeleteTable.
//
//1.05: Charlie McKeegan from Task Software Limited (charlie@task.co.uk) found
//      a minor bug (and came up with a fix) in SetRecNo which mostly is
//      noticeable in a grid where the grid wont refresh when the record slider
//      is moved to the end of the recordset.                          (5. Feb. 99)
//      Changed SaveToStream to use the displayname of the field as the header
//      instead of the fieldname.
//
//1.06: Introduced a persistence switch and a reference to a file. If the
//      persistence switch is set, the file will be read aut. on table open,
//      and the contents of the table will be saved in the table on table close.
//
//1.07: Changed calculation of fieldofsets in InternalOpen to follow the fielddefs
//      instead of fields. It has importance when rearranging fields.
//      Because of this change the calculation of fieldoffsets into the buffer
//      has been changed too. These corrections was found to be needed to
//      support the new components tkbmPooledQuery and tkbmPooledStoredProc
//      (found in the package tkbmPooledConn)
//      which in turn handles pooled connections to a database. Very usefull
//      in f.ex a WWW application as they also makes the BDE function threadsafe,
//      and limits the concurrent connections to a database.
//
//1.08: Changed buffer algorithm in GetLine since the old one was faulty.
//      Problem was pointed out by: Markus Roessler@gmx.de
//
//1.09: Added LoadFromDataset, SaveToDataset, CreateTableAs,
//      BCD and BLOB support by me.
//      James Baile (James@orchiddata.demon.co.uk) pointed out a bug in GetRecNo
//      which could lead to an endless loop in cases with filtering. He also
//      provided code for sorting, which I have been rearranging a bit and
//      implemented.
//      Travis Diamond (tdiamond@airmail.net) pointed out a bug in GetWord where
//      null fields would be skipped.
//      Claudio Driussi (c.driussi@popmail.iol.it) send me version including
//      a sort routine, and Ive used some of he's ideas to implement a sorting
//      mechanism. Further he's code contained MoveRecords and MoveCurRec which
//      I decided to include in a modified form for Drag and Drop record
//      rearrangements.
//
//1.10: Support for Locate.                                             (17. May. 99)
//      Claudio Driussi (c.driussi@popmail.iol.it) came up with a fix for
//      GetRecNo. MoveRecord is now public.
//      Andrius Adamonis (andrius@prototechnika.lt) came up with fix for
//      call to validation routines in SetFieldData and support for
//      OldValue and NewValue in GetActiveRecordBuffer.
//
//1.11: Pascalis Bochoridis from SATO S.A Greece (pbohor@sato.gr)
//      Corrected bookmark behavior (substituted RecordNo from TRecInfo with unused Bookmark)
//      Corrected GetRecNo & SetRecNo  (Scrollbars now work ok at First and Last record)
//      Added LocateRecord, Locate, Lookup (I decided to use his Locate instead of my own).
//
//1.12: Added CloseBlob. Corrected destructor.                          (26. May. 99)
//      Corrected GetFieldData and SetFieldData. Could result in overwritten
//      memory elsewhere because of use of DataSize instead of Size.
//      Pascalis Bochoridis from SATO S.A Greece (phohor@sato.gr) send me a corrected
//      LocateRecord which solves problems regarding multiple keyfields.
//      Thomas Bogenrieder (tbogenrieder@wuerzburg.netsurf.de) have suggested a faster
//      LoadFromStream version which is much faster, but loads the full stream contents into
//      memory before processing. I fixed a few bugs in it, rearranged it and decided
//      to leave it up to you what you want to use.
//      I suggest that if you need speed for smaller streams, use his method, else use mine.
//      You can activate his method by uncommenting the define statement FAST_LOADFROMSTREAM
//      a few lines down.
//
//1.13  Corrected SetRecNo and MoveRecord.                               (31. May. 99)
//      By Pascalis Bochoridis from SATO S.A Greece (phohor@sato.gr)
//
//1.14  Respecting DefaultFields differently.                            (3. Jun. 99)
//      LoadFromDataset now includes a CopyStructure flag.
//      Supporting Master/Detail relations.
//      Now the Sort uses a new property for determining the fields to sort on,
//      which means its possible to sort on other fields than is used for
//      master/detail. Added SortOn(FieldNames:string) which is used for quick
//      addhoc sorting by just supplying the fieldnames as parameters to the
//      SortOn command.
//      Fixed memory leak in LoadFromDataset (forgot to free bookmark).
//      Added CopyFieldProperties parameter to LoadFromDataset and CreateTableAs which
//      if set to TRUE will copy f.ex. DisplayName, DisplayFormat, EditMask etc. from
//      the source.
//      Corrected OnValidate in SetFieldData. Was placed to late to have any impact.
//      Now checking for read only fields in SetFieldData.
//
//1.15  Totally rearranged LocateRecord to handle binary search when     (23. Jun. 99)
//      the data searched is sorted.
//      I was inspired by Paulo Conzon (paolo.conzon@smc.it) who send me a version with the Locate method
//      hacked for binary search. New methods PopulateRecord and PopulateField is used to create
//      a key record to search for.
//      Changed Sort and SortOn to accept sortoptions by a parameter instead of having a property.
//      The following sort options exists: mtsoCaseInsensitive and mtsoDescending.
//      mtsoPartialKey is used internally from LocateRecord where the TLocateOptions are remapped to
//      TkbmMemTableCompareOptions.
//
//1.16  Bug fixed in SaveToDataset. Close called where it shouldnt.      (19. Jul. 99)
//      Bug reported by Reinhard Kalinke (R_Kalinke@compuserve.com)
//      Fixed a few bugs + introduced Blob saving/loading in LoadFromStream/SaveToStream and thus
//      also LoadFromFile/SaveToFile. To save blob fields specify mtfSaveBlobs in save flags.
//      Full AutoInc implementation (max. 1 autoinc field/table).
//      These fixes and enhancements was contributed by Arsne von Wys (arsene@vonwyss.ch)
//      SetFieldData triggered the OnChange event to often. This is now fixed. Bug discovered by
//      Andrius Adamonis (andrius@prototechnika.lt).
//      Added mtfSkipRest save flag which if set will ONLY write out the fields specified by the rest of
//      the flags, while default operation is to put a marker to indicate a field skipped.
//      Usually mtfSkipRest shouldnt be specified if the stream should be reloaded by LoadFromStream later on.
//      But for generating Excel CSV files or other stuff which doesnt need to be reloaded,
//      mtfSkipRest can be valuable.
//      Greatly speeded up LoadFromStream (GetLine and GetWord).
//
//1.17  Supporting fieldtypes ftFixedChar,ftWideString.
//      Added runtime fieldtype checking for catching unsupported fields.
//      Raymond J. Schappe (rschappe@isthmus-ts.com) found a bug in CompareFields which he send a fix for.
//      Added a read only Version property.
//      The faster LoadFromStream added in 1.12 has now been removed due to the optimization of
//      the original LoadFromStream in 1.16. Tests shows no noticably performance difference anymore.
//      Inspired by Bruno Depero (bdepero@usa.net) which send me some methods for saving and
//      loading table definitions, I added mtfSaveDef to TkbmMemTableSaveFlag. If used the table
//      definition will be saved in a file. To copy another datasets definition, first do a CreateTableAs,
//      then SaveToFile/SaveToStream with mtfSaveDef.
//      Renamed TkbmSupportedFieldTypes to kbmSupportedFieldTypes and TkbmBlobTypes to kbmBlobTypes.
//      Generalized Delphi/BCB definitions.
//      Denis Tsyplakov (den@vrn.sterling.ru) suggested two new events: OnLoadField and OnLoadRecord
//      which have been implemented.
//      Added OnCompressSave and OnDecompressLoad for user defined (de)compression of SaveToStream,
//      LoadFromStream, SaveToFile and LoadFromFile.
//      Bruno Depero (bdepero@usa.net) inspired me to do this, since he send me a version including
//      Zip compression. But I like to generalize things and not to depend on any other specific
//      3. part library. Now its up to you which compression to use.
//      Added OnCompressBlobStream and OnDecompressBlobStream for (de)compression of inmemory blobs.
//      Added LZH compression to the Demo project by Bruno Depero (bdepero@usa.net).
//
//1.18  Changed SaveToStream and LoadFromStream to code special characters in string fields
//      (ftString,ftWideString,ftFixedChar,ftMemo,ftFmtMemo).
//      You may change this behaviour to the old way by setting kbmStringTypes to an empty set.
//      Fixed severe blob null bug. Blobs fields was sometimes reported IsNull=true even if
//      they had data in them.
//      Fixed a few minor bugs.
//
//1.19  Fixed a bug in CodedStringToString where SetLength was to long.             (10. Aug. 1999)
//      Bug reported by Del Piero (tomli@mail.tycoon.com.tw).
//      Fixed bug in LoadFromStream where DuringTableDef was wrongly initialized
//      to true. Should be false. Showed when a CSV file without definition was loaded.
//      Bug reported by Mr. Schmidt (ISAT.Schmidt@t-online.de)
//
//1.20  Marcelo Roberto Jimenez (mroberto@jaca.cetuc.puc-rio.br) reported a few bugs(23. Aug. 1999)
//      to do with empty dataset, which he also corrected (GetRecNo, FilterMasterDetail).
//      Furthermore he suggested and provided code for a Capacity property, which
//      can be used to preallocate room in the internal recordlist for a specific
//      minimum number of records.
//      Explicitly typecasted @ to PChar in several places to avoid problem about
//      people checking 'Typed @' in compile options.
//
//1.21  Corrected Locate on filtered recordssets.                                   (24. Aug. 1999)
//      Problem observed by Keith Blows (keithblo@woollyware.com)
//
//1.22  Corrected GetActiveRecord and added overridden SetBlockReadSize to be       (30. Aug. 1999)
//      compatible with D4/BCB4's TProvider functionality. The information and
//      code has been generously supplied by Jason Wharton (jwharton@ibobjects.com).
//      Paul Moorcroft (pmoor@netspace.net.au) added SaveToBinaryFile, LoadFromBinaryFile,
//      SaveToBinaryStream and LoadFromBinaryStream. They save/load the contents incl.
//      structure to/from the stream/file in a binary form which saves space and is
//      faster.
//      Added support for ftLargeInt (D4/D5/BCB4).
//
//1.23  Forgot to add defines regarding Delphi 5. I havnt got D5 yet, and thus      (12. Sep. 1999)
//      not tested this myself, but have relied on another person telling me that it
//      do work in D5. Let me know if it doesnt.
//      Added save flag mtfSaveFiltered to allow saving all records regardless if they are
//      filtered or not. Suggestion posed by Jose Mauro Teixeira Marinho (marinho@aquarius.ime.eb.br)
//      Added automatic resort when records are inserted/edited into a sorted table by
//      Jir Hostinsk (tes@pce.cz). The autosort is controlled by AutoSort flag which is
//      disabled by default. Furthermore at least one SortField must be defined for the auto
//      sort to be active.
//
//1.24  The D5 story is continuing. Removed the override keyword on BCDToCurr        (7. Oct. 1999)
//      and CurrToBCD for D5 only. Changed type of PersistentFile from String to TFileName.
//      Support for SetKey, GotoKey, FindKey inspired by sourcecode from Azuer (blue@nexmil.net) for
//      TkbmMemTable v. 1.09, but now utilizing the new internal search features.
//      Fixed bug with master/detail introduced in 1.21 or so.
//      Fixed old bug in GetRecNo which didnt know how to end a count on a filtered recordset.
//      Support for SetRange, SetRangeStart, SetRangeEnd, ApplyRange, CancelRange,
//      EditRangeStart, EditRangeEnd, FindNearest, EditKey.
//      Fixed several bugs to do with date, time and datetime fields. Now the internal
//      storage format is a TDateTimeRec.
//      Fixed problems when saving a CSV file on one machine and loading it on another
//      with different national setup. Now the following layout is allways used on
//      save and load (unless the flag mtfSaveInLocalFormat is specified on the SaveToStream/SaveToFile method,
//      in which case the local national setup is used for save. Beware that the fileformat will not be
//      portable between machines, but can be used for simply creating a Comma separated report for other
//      use):  DateSeparator:='/'  TimeSeparator:=':'  ThousandSeparator:=','  DecimalSeparator:='.'
//      ShortDateFormat:='dd/mm/yyyy' CurrencyString:='' CurrencyFormat:=0 NegCurrFormat:=1
//      Date problems reported by Craig Murphy (craig@isleofjura.demon.co.uk).
//      We are getting close to have a very complete component now !!!
//
//1.25  Added CompareBookmarks, BookmarkValid, InternalBookmarkValid by             (11. Oct. 1999)
//      Lars Sndergaard (ls@lunatronic.dk)
//
//1.26  In 1.24 I introduced a new keybuffer principle for performance and easyness.(14. Oct. 1999)
//      Unfortunately I forgot a few things to do with Master/Detail. They have now
//      been fixed. Problem reported by Dirk Carstensen (D.Carstensen@FH-Wolfenbuettel.DE)
//      He also translated all string ressources to German.
//      Simply define the localization type wanted further down and recompile TkbmMemTable.
//      Fixed AutoSort problem when AutoSort=true on first record insert.
//      Further more setting AutoSort=true on a nonsorted dataset will result in an
//      automatic full sort on table open.
//      Problem reported by Carl (petrolia@inforamp.net)
//      Added events OnSave and OnLoad which are called by SaveToDataSet,
//      SaveToStream, SaveToBinaryStream, SaveToFile, SaveToBinaryFile,
//      LoadFromDataSet, LoadFromStream, LoadFromBinaryStream,
//      LoadFromFile, LoadFromBinaryFile. StorageType defines what type of save/load
//      is going on: mtstDataSet, mtstStream, mtstBinaryStream, mtstFile and mtstBinaryFile.
//      Stream specifies the stream used to save/load. Will be nil if StorageType is mtstDataSet.
//
//1.27  In 1.26 I unfortunately made 2 errors... Forgot to rename the german ressource file's (19. Oct. 1999)
//      unitname and made another autosort problem. Things are going a bit fast at the moment,
//      thus it is up to you all to test my changes :)
//      Well..well... the german ressourcefile's unitname is now correct.
//      AutoSort is now working as it should. Been checking it :)
//      And its pretty fast too. Tried with 100.000 records, almost immediately
//      on a PII 500Mhz.
//      Added autosort facilities to the demo project and posibility to change
//      number of records in sample data. Tried with 1 million records... and it works :)
//      although quicksort is not the optimal algorithm to use on a very unbalanced
//      large recordset. It seems to be fast enough for around 10.000 records.
//      (almost immediately on a PII 500Mhz.)
//      Published SortOptions, and added SortDefault to do a sort using the published
//      sortfields and options. Mind you that Sort(...) sets up new sortoptions.
//
//1.28  Added PersistentSaveOptions.                                                 (21. Oct. 1999)
//      Added PersistentSaveFormat either mtsfBinary or mtsfCSV.
//      Fixed some flaws regarding persistense in designmode which could lead to loss of
//      data in the persistent file and loss of field definitions.
//
//1.29  I. M. M. VATOPEDIOU (monh@vatopedi.thessal.singular.gr) found a bug in GetRecNo (22. Oct. 1999)
//      which he send a fix for.
//
//1.30  Fernando (tolentino@atalaia.com.br) send OldValue enhancements and thus introduced
//      InternalInsert, InternalEdit, InternalCancel procedures.
//      Furthermore he suggested to rename TkbmMemTable to TkbmCustomMemTable and descend TkbmMemTable from it.
//      I decided to follow his suggestion as to make it easier to design own memory table children.
//      Kanca (kanca@ibm.net) send me example on runtime creation of TkbmMemTable. The example
//      has been put in the demo project as a comment.
//      Holger Dors (dors@kittelberger.de) suggested a version of CompareBookmarks which guarantiees
//      values -1, 0 or 1 as result. This has now been implemented.
//      Furthermore he retranslated an incorrect German translation for FindNearest.
//
//1.31  SetRecNo and GetRecNo has been analyzed carefully and rewritten to      (26. Oct. 1999)
//      reflect normal behaviour. Locate was broken in 1.29 because of the prev.
//      GetRecNo fix. Reported by Carl (petrolia@inforamp.net).
//      There have been significant speedups in insert record and delete record.
//      Now TkbmMemTable contains a componenteditor for D5. Source has been donated by
//      Albert Research (albertrs@redestb.es) and partly changed by me.
//      Ressourcestrings has been translated to French by John Knipper (knipjo@altavista.net)
//      Removed InternalInsert for D3. Problem reported by John Knipper.
//
//1.32  Fernando (tolentino@atalaia.com.br) sent Portuguese/Brasillian translation. (5. Nov. 1999)
//      Vasil (vasils@ru.ru) sent Russian translation.
//      Javier Tari Agullo (jtari@cyber.es) sent Spanish translation.
//      Tero Tilus (terotil@cc.jyu.fi) suggested to save the visibility flag of a field too
//      along with all the other fielddefinitions in the SaveToStream/LoadFromStream etc. methods.
//      I changed CreateTableAs format to:
//        procedure CreateTableAs(Source:TDataSet; CopyOptions:TkbmMemTableCopyTableOptions);
//      where copyoptions can be:
//        mtcpoStructure         - Copy structure from the source datasource.
//        mtcpoOnlyActiveFields  - Only copy structure of active fields in the source datasource.
//        mtcpoProperties        - Also copy field info like DisplayName etc. from the source datasource.
//        mtcpoLookup            - Also copy lookup definitions from the source datasource.
//        mtcpoCalculated        - Also copy calculated fielddefinitions from the source datasource.
//      or a combination of those values in square brackets [...].
//      Further LoadFromDataSet is now following the same syntax.
//      A new method CreateFieldAs has been appended used by CreateTableAs.
//      Lookup fields defined in the memorytable now works as expected.
//      Now the designer will show all types of database tables, not only STANDARD.
//      Changed CopyRecords to allow copying of calculated data, and not clearing out
//      lookup fields on destination.
//      Fixed autosort error reported by Walter Yu (walteryu@21cn.com).
//
//1.33  Fixed error in CopyRecords which would lead to wrongly clearing calculated fields  (23. Nov. 1999)
//      after they have correcly been set.
//      Fixed problem with autosort when inserting record before first.
//      Fixed exception problem with masterfields property during load. Problem
//      reported by Jose Luis Tirado (jltirado@jazzfree.com).
//      Fixed a few errors in the demo application.
//      Added Italian translation by Bruno Depero (bdepero@usa.net).
//
//1.34  Fixed Resort problem not setting FSorted=true. Problem reported by     (3. Dec. 1999)
//      Tim_Daborn@Compuserve.com.
//      Added Slovakian translation by Roman Olexa (systech@ba.telecom.sk)
//      Added Romanian translation by Sorin Pohontu (spohontu@assist.cccis.ro)
//      Fixed problem about FSortFieldList not being updated when new sortfields are defined.
//      The fix solves the AutoSort problem reported by Sorin Pohontu (spohontu@assist.cccis.ro)
//      Javier Tari Agullo (jtari@cyber.es) send a fix for Spanish translation.
//      Added threaded dataset controller (TkbmThreadDataSet).
//      Put it on a form, link the dataset property to a dataset.
//      When you need to use a dataset, do:
//
//      ds:=ThreadDataset.Lock;
//      try
//         ...
//      finally
//         ThreadDataset.Unlock;
//      end;
//
//1.35  LargeInt type handling changed. Now it will be read and saved          21. Dec. 1999
//      as a float, not as an integer. General fixes to do with LargeInt field
//      types. Bug reported by Fernando P. Njera Cano (j.najera@cgac.es).
//      Fixed bug reported by Urs Wagner (Urs_Wagner%NEUE_BANKENSOFTWARE_AG@raiffeisen.ch)
//      where a field could be edited even if no Edit or Insert statement has been issued.
//      Jozef Bielik (jozef@gates96.com) suggested to reset FRecNo and FSorted when
//      last record is deleted in _InternalDelete. This has been implemented.
//
//1.36  Edison Mera Menndez (edmera@yahoo.com) send fix for bug in autoupdate. 23. Dec. 1999
//      Further he send code for a faster resort based on binary search for
//      insertionpoint instead of the rather sequential one in the previous version.
//      In case of problems, the old code can be activated by defining ORIGINAL_RESORT
//      He also suggested and send code for an unified _InternalSearch which does the
//      job of selecting either sequential or binary search.
//      Brad - RightClick (brade@rightclick.com.au) suggested that autosort should be
//      disengaged during load operations. I agree and thus have implemented it.
//      Implemented that EmptyTable implecitely does a cancel in case the table
//      was in Edit mode. Suggested by Albert Research (albertrs@redestb.es).
//
//1.37  Claude Rieth from Computer Team sarl (clrieth@team.lu) suggested to be able to 3. Jan. 2000
//      specify save options for CommaText. Thus CommaTextOptions has been added.
//      Several people have been having trouble installing in BCB4. The reason is
//      that some unused 3.rd party libraries sneeked into the TkbmMemTable
//      BCB4 project file. It has been fixed.
//      Bookmark handling has been corrected. Problem reported by Dick Boogaers (d.boogaers@css.nl).
//      InternalLoadFromBinaryStream has been fixed with regards to loading a NULL date.
//      A date is considered NULL when the value of the date is 0.0 (1/1/1899).
//      Problem reported by Paul Moorcroft (pmoor@netspace.net.au)
//      Ohh.. and HAPPY NEWYEAR everybody! The world didnt vanish because of 2 digits.
//      Isnt that NICE !! :)
//
//2.00a BETA First beta release.
//      CompareBookmark corrected to handle nil bookmark pointers by             5. Jan. 2000
//      jozef bielik (jozef@gates96.com)
//      Indexes introduced. AddIndex,DeleteIndex,IndexDefs supported.
//      AutoSort removed, Resort removed, Sort and SortOn now emulated via an internal index
//      named __MT__DEFSORT__.
//      Indexes introduced as a way into the internal indexes. Not really needed by most.
//      EnableIndexes can be set to false to avoid updating the indexes during a heavy load
//      operation f.ex. The indexes will be invalid until next UpdateIndexes is issued.
//      mtfSaveIndexDef added to possible save flags.
//      Save formats changed for both CSV files and binary files. For reading v.1.xx
//      files, either use CSV format or for binary files, set the compatibility
//      definition further down. V. 1.xx will NOT be compatible with files written
//      in v.2.xx format unless no table definitions are written.
//      _InternalSearch, _InternalBinarySearch and _InternalSequentialSearch removed.
//      ftBytes fieldtype corrected. Usage is shown in the demo project.
//
//2.00b BETA Fixed D4 installation problem reported by Edison Mera Menndez (edmera@yahoo.com).
//      Published IndexDefs.
//      Added support for ixUnique.
//      Thomas Everth (everth@wave.co.nz) fixed two minor issues in LoadFromDataSet and
//      SaveToDataSet. Further he provided the protected method UpdateRecords, and the
//      public method UpdateToDataset which can be used to sync. another dataset with
//      the contents of the memorytable.
//      Fixed lookup to correcly handle null or empty keyvalues.
//
//2.00c BETA Renamed IndexFields to IndexFieldNames. Supporting IndexName.
//      Fixed designtime indexdefinitions wouldnt be activated at runtime.
//      Fixed Sort/SortOn would generate exception. Fixed Sort/SortOn on blob
//      would generate exception.
//
//2.00d BETA Fixed Master/Detail.
//      Changed the internal FRecords TList to a double linked list to make
//      deletes alot easier from the list. FRecords have been superseeded by
//      FFirstRecord and FFLastRecord. Changed the recordstructure. Introduced
//      TkbmRecord and PkbmRecord which is the definition of a record item.
//      Fixed SwitchToIndex to maintain current record the same after a switch.
//      Added notification handling to reflect removal of other components.
//      Added support for borrowing structures from another TDataset in the
//      table designer.
//
//2.00e BETA Changed bookmark functionality.
//      Fixed D4 installation.
//      Fixed index updating.
//      Optimized indexing and bookmark performance.
//      Added record validity check.
//      Still some bookmark problems.
//
//2.00f BETA Removed the double linked list idea from 2.00d. Back to a TList.
//      Reason is the bookmark handling is not easy to get to work with pointers,
//      plus its needed to be able to delete a record without actually removing
//      it from the 'physical' database. Thus PackTable has been introduced.
//      Deleting a record actually frees the recordcontents, but the spot in
//      the TList will not be deleted, just marked as deleted (nil). PackTable removes
//      all those empty spots, but at the same time invalidates bookmarks.
//      EmptyTable does what the name says, empty it including empty spots and
//      records as allways. Result should be that bookmarks are working as they
//      should, and GotoBookmark is very fast now.
//      Empty spots will automatically be reused when inserting new records
//      by the use of a list of deleted recordID's, FDeletedRecords.
//      Protected function LocateRecord changed.
//      Locate changed, Lookup behaviour improved.
//      CancelRange behaviour improved.
//
//2.00g BETA Fixed edit error when only 1 record was left and indexes defined.
//      Problem reported by Dick Boogaers (d.boogaers@css.nl).
//      Fixed error occuring when inserting records in an empty memtable with
//      a unique index defined.
//      Fixed error when altering a field which is indexed to a value bigger than
//      biggest value for that field in the table.
//
//2.00h BETA Added IndexFields property as suggested by Dick Boogaers (d.boogaers@css.nl).
//
//2.00i BETA Added AttachedTo property for having two or more views on the
//      physical same data. Updating one table will show immediately in the others.
//      Fielddefinitions will be inherited from the primary table holding the data.
//      There can only be one level of attachments. Eg. t2 can be attached to t1,
//      but then t3 can't be attached at t2, but must be directly attached to t1.
//      Its possible to have different indexes on the tables sharing same data.
//      Fixed SearchRecordID problem which sometimes didnt find the record even
//      if it definitely existed. The reason and solution is explained in the
//      SearchRecordID method.
//      Made TkbmCustomMemTable threadsafe.
//      ftArray and ftADT support added by Stas Antonov (hcat@hypersoft.ru).
//
//2.00j BETA Changed to not check for disabled controls on DisableControls/EnableControls
//      pairs. Fixed wrong call to _InternalEmpty in InternalClose when an attached
//      table close. Thread locking changed and fixed.
//      New property AttachedAutoRefresh. Set to false to disallow the cascading refreshes
//      on dataaware controls connected to all the attached memorytables.
//
//2.00k BETA Made public properties on TkbmIndex:
//      IsOrdered:boolead It can be used to determine if the index is up to date.
//      Or it can be set to true to force that the index must be percieved as up to date,
//      even if it hasnt been fully resorted since creation. Usefull f.ex. when loading
//      data from a presorted file. Eg.:
//      mt.EnableIndexes:=false;
//      mt.LoadFromFile(...);
//      mt.EnableIndexes:=true;
//
//      // Since the data was saved using the index named 'iSomeIndex' and thus loaded
//      // in the right sortorder, dont reupdate the iSomeIndex index.
//      mt.Indexes.Get('iSomeIndex').IsOrdered:=true;
//
//      // At some point, update all nonordered indexes.
//      mt.UpdateIndexes;
//
//      IndexType:TkbmIndexType Should only be used to determine the indextype. Dont set.
//      CompareOptions:TkbmMemTableCompareOptions Should only be used to determine the compare options.
//      Dont set.
//      IndexOptions:TIndexOptions Should only be used to determine the indexoptions. Dont set.
//      IndexFields:string Should only be used to determine the fields in the index. Dont set.
//      IndexFieldList:TList Should only be used to gain access to a list of TField objects
//      of fields participating in the index. Dont alter or set.
//      Dataset:TkbmCustomMemTable Should only be used to determine the dataset on which the
//      index is created. Dont set.
//      Name:string Should only be used to determine the name used during creation of the index.
//      Dont set.
//      References:TList References to the records. The references are sorted in the way the index defines.
//      IsRowOrder:boolean Used to determine if this index is a row order index. (the order the records
//      are inserted).
//      IsInternal:boolean Used to determine if this index is an internal index (used by SortOn f.ex.)
//      IndexOfs:integer Used to determine what position this index have in the TkbmIndexes list.
//      Fixed ftBytes bug reported by Gianluca Bonfatti (gbonfatti@libero.it).
//
//2.01  FINAL Cosmin (monh@vatopedi.thessal.singular.gr) reported some problems
//      and came up with some fixes. I have loosely followed them to solve the problems.
//      a) Fixed loading data into readonly fields using LoadFrom...
//      Developers can use new 'IgnoreReadOnly' public property if they want to
//      update fields which are actually defined as readonly. Remember to
//      set it to false again to avoid users updating readonly fields.
//      b) Fixed readonly on table level.
//      c) New read only property: RangeActive:boolean. True if a range is set.
//      d) Fixed autoinc. fields.
//      Fixed bogus warning about undefined return from SearchRecordID.
//
//2.01a Fixed wrong use of FBufferSize in PrepareKeyRecord. Should be FRecordSize;
//
//2.10  Now complete support for Filter property!
//
//2.11  The filter property is only supported for D5. IFDEF's inserted to maintain
//      backwards compatibility.
//      Support for a UniqueRecordID which allways will increase on each insert
//      in contrast to RecordID which is not unique through the lifetime of
//      a memorytable (eg. reusing deleted record spots).
//      Support for RecordTag (longint) which can be used by any application to fill
//      extra info into the record for own use without having to create a real
//      field for that information. Remember that the application is responsible
//      for freeing memory pointed to by this tag (if thats the way its used).
//      Added mtfSaveIgnoreRange and mtfSaveIgnoreMasterDetail to solve problem reported
//      by monh@vatopedi.thessal.singular.gr that saving data during master/detail
//      or ranges will only save 'visible' records.
//
//2.20  NOTE!!!!!   !!!!   !!!!!  NEW LICENSE AGREEMENT  !!!! PLEASE READ !!!!!
//      Fixed quite serious bug in PrepareKeyRecord which would overwrite    16. Feb. 2000
//      memory. Problem occured after using one of the SetKey, EditKey, FindKey,
//      GotoKey, FindNearest methods.
//      Enhanced record validation scheme. Can now check for memory overruns.
//      Changed the inner workings of FindKey and FindNearest a little bit.
//      Fixed that if an IndexDef was specified without any fields, an exception will
//      be raised.
//      Added CopyBlob boolean flag to _InternalCopyRecord which if set, also
//      duplicates all blobs in the copy. Remember to _InternalFreeRecord with
//      the FreeBlob boolean flag set for these copies.
//      Added journaling functionality through the new properties
//      Journal:TkbmJournal, EnableJournal:boolean, IsJournaling:boolean and
//      IsJournalAvailable:boolean. The journaling features are inspired by
//      CARIOTOGLOU MIKE (Mike@singular.gr).
//
//2.21  Fixed backward compatibility with Delphi 3.
//
//2.22  Fixed Sort and SortOn problem with CancelRange.
//      Fixed compile problem when defining BINARY_FILE_1_COMPATIBILITY.
//
//2.23  Fixed several bugs in TkbmCustomMemTable.UpdateIndexes which would
//      lead to duplicate indexdefinitions on every update, which again would
//      lead to the infamous idelete<0 bug.
//      Inserted several checks for table being active in situations where
//      indexes are modified.
//
//2.24  Fixed bug reported by Jean-Pierre LIENARD (jplienard@compuserve.com)
//      where Sort/SortOn called 2 times around a close/open pair would lead
//      to AV. InternalClose now deletes a sortindex if one where created.
//      Thus Sort/SortOn are only temporary (as they were supposed to be in
//      the first place anyway :)
//      Fixed small filtering bug.
//
//2.30a ALPHA Fixed bug in BinarySearch. Before it correctly found a matching record
//      but it was not guranteed the first available record matching. Now it
//      backtracks to make sure its the first one in the sortorder which matchs.
//      Fixed old problem when persistent tables are not written on destruction
//      of the component.
//      Fixed GetByFieldNames (use to find an index based on fieldnames) to be
//      case insensitive.
//      Journal is now freed on close of table, not destruction.
//      Fixed bug in _InternalCompareRecords which would compare with one field
//      to little if maxfields were specified (noticed in some cases in M/D
//      setups).
//      Changed internals of _InternalSaveToStream and _InternalSaveToBinaryStream.
//      Support for versioning implemented. Support for saving deltas using
//      SaveToBinary... supported using flag mtfSaveDeltas.
//      Resolver class (TkbmCustomDeltaHandler) for descending from to
//      make delta resolvers.
//      Added StartTransaction, Commit, Rollback as virtual methods for local
//      transaction handling. Override these to handle middleware transactions.
//      Added readonly TransactionLevel which shows the level of the current
//      transaction.
//      CARIOTOGLOU MIKE (Mike@singular.gr) came up with a big part of the versioning code
//      and had several suggestions to how to handle deltas and versioning.
//
//2.30b BETA Added checking for empty record in list of records in several places (lst.items[n]=nil)
//      Added new save flag mtfSaveDontFilterDeltas which if not specified, filters out
//      all records which has been inserted and then deleted again within the same session.
//      (A session understood like from load of records to save of them).
//      Added new property AllData which can be read to get a variant containing all data
//      and be set from a variant to load all data from.
//      Added new property AllDataOptions which defines which data will be saved using the
//      AllData property. Suggested by CARIOTOGLOU MIKE (Mike@singular.gr).
//      Added designtime persistense of data on form by the new property StoreDataOnForm.
//      If a designtime memtable contains data and thus is active, setting StoreDataOnForm:=true
//      and saving the form will save the data on the form. Thus the data will be available
//      when the form is loaded next time aslong the memtable is active (opened).
//      Added Czech translation by Roman Krejci (info@rksolution.cz)
//      Added property IsFieldModified(i:integer):boolean for checking if a field has been modified.
//      The status is only available until Cancel or Post. Suggested by Alexandre DANVY (alex-dan@ebp.fr)
//      Tabledesigner layout fixed.
//
//2.30c BETA Added two generaly available procedures:                        3. Mar. 2000
//      StreamToVariant and VariantToStream which handles putting a stream into
//      a variant and extracting it again. Means its possible to store f.ex a complete
//      file in a variant by opening the file with a TFileStream and pass the stream
//      through StreamToVariant.
//      Added example of transactioning to the demo project.
//      Added support for TField.DefaultExpression (default value for each field).
//      Define DO_CHECKRECORD to call _InternalCheckRecord. Was default before.
//      Normally only to be used in debug situations.
//      Applied some performance optimizations.
//
//2.30  FINAL Fixed before close bug which would clear a persistent file
//      if the programmer called close before destroy. Problem reported by
//      Frans Bouwmans (fbouwmans@spiditel.nl)
//      Fixed clear index bug not resetting FSortIndex. Problem reported by
//      Ronald Eckersberger (TeamDM) (ron@input.at)
//      Published AutoCalcFields.
//      Added property: RecalcOnFetch (default true) which regulates if
//      calculated fields should be recalced on each fetch of a record or not.
//      Fixed resetting AttachedTo when parent table is destroyed.
//
//2.31  Fixed D3 compatibility.
//      Fixed Resolver. OrigValues as record at checkpoint, Values as
//      record in current version.
//      Fixed missing resync in FindNearest reported by
//      Alexander V. Miloserdov (tatco@cherkiz.spb.su).
//
//2.32  Fixed TkbmCustomMemTable.DeleteIndex A/V bug in D4. Problem reported
//      by Alexander V. Miloserdov (tatco@cherkiz.spb.su).
//
//2.33  Refixed again FindNearest. This time it works ;)
//
//2.34  Fixed missing filter in SaveTo.... Problem reported by Alexei Smirnov (alexeisu@kupol.ru)
//      Fixed missing use of binary search. Problem reported by Tim Daborn (Tim_Daborn@Compuserve.com)
//      Data persistency on destruction of component fixed. Fix by Cosmin (monh@vatopedi.thessal.singular.gr)
//      UpdateRecord fixed with regards to only one key field specified.
//      Fix by Marcello Tavares (TAVARES@emicol.com.br)
//      Brazilian ressource file changed by Marcello Tavares (TAVARES@emicol.com.br).
//      Added KBM_MAX_FIELDS which can be changed to set max. number of fields
//      to handle in a table. Default 256.
//      Fixed bug in error message when unsupported field added to fielddef.
//      Problem reported by Alexandre Danvy (alex-dan@ebp.fr)
//      Fixed some bugs regarding SetRangeStart/End EditRangeStart/End and ApplyRange.
//      Remember to set IndexFieldNames to an index to use including the fields used for the range.
//      Better is to use a filter or similar.
//
//2.35  Fixed bug not clearing out indexes on table close.
//
//2.36  Fixed bug in DeleteIndex which would not reset FCurIndex correctly.   30. mar. 2000
//      Problem seen when SortOn or Sort would be called many times.
//      Problem reported by Michail Haralampos (Space Systems) (spacesys@otenet.gr)
//      Changed CreateTableAs to not to update fielddefs while source table is allready
//      active for compatibility with a bug in Direct Oracle Access. Problem
//      reported by Holger Dors (dors@kittelberger.de)
//      Changed handling of oldrecord and current record during an edit of a record to
//      correctly cancel changes to a blob. Problem reported by Ludek Horcicka (ludek.horcicka@bcbrno.cz)
//
//2.37  Fixed A/V bug versioning blobfields. Problem reported by Jerzy Labocha (jurekl@geocities.com).
//      Optimized indexing when record edited which does not affect index.
//      Suggested by Lou Fernandez (lfernandez@horizongt.com).
//      Fixed bug in InternalLoadFromBinary where check for ixNonMaintained was in wrong order
//      compared to savetobinary.
//      Fixed bug in InternalLoadFromBinary where indexes was created and marked
//      as updated prematurely. Problem reported by Jerzy Labocha (jurekl@geocities.com).
//      Changed LoadFromDataSet to allow copy of properties from default fields.
//      Problem reported by Tim Evans (time@cix.compulink.co.uk).
//
//2.38  Fixed bug not correctly determining autoinc value on loading binary file.
//      Problem and fix reported by Jerzy Labocha (jurekl@geocities.com).
//      Fixed small bug in SaveToStream where nil records would risc being saved.
//      Fixed bug in SetRecNo reported by Mike Cariotoglou (Mike@singular.gr).
//      Added RespectFilter on TkbmIndex.Search and TkbmIndexes.Search for Locate etc. to
//      respect filters set. Problem reported by Andrew Leiper (Andy@ietgroup.com).
//      Added to index search routines to make them threadsafe.
//      Fixed bug updating indexes of attached tables on edit of master table.
//      Problem reported by Lou Fernandez (lfernandez@horizongt.com).
//      Added CSV delimiter properties: CSVQuote, CSVFieldDelimiter, CSVRecordDelimiter
//      which are all char to define how CSV output or input should be handled.
//      CSVRecordDelimiter can be #0 to not insert a recorddelimiter. Note that
//      #13+#10 will be inserted at all times anyway to seperate records.
//      Fixed bug in _InternalClearRecord and added new protected method
//      UnmodifiedRecord in TkbmCustomDeltaHandler.
//      Changed algorithm of dsOldRecord to return first version of record.
//      Added 3 new public medium level functions:
//        function GetVersionFieldData(Field:TField; Version:integer):variant;
//        function GetVersionStatus(Version:integer):TUpdateStatus;
//        function GetVersionCount:integer;
//      which can be used to obtain info about previous versions of current record.
//      GetVersionCount get number of versions of current record. Min 1.
//      GetVersionFieldData gets a variant of data of a specific version. Current
//      record version (newest) is 0.
//      GetVersionStatus returns the TUpdateStatus info of a specific version. Current
//      record version (newest) is 0.
//      Inspiration and fixes by Mike Cariotoglou (Mike@singular.gr).
//
//2.39  Fixed bug setting Filtered while Filter is empty.
//      Fixed autoinc bug on attached tables reported by Jerzy Labocha (jurekl@geocities.com).
//      Added GetRows function for getting a specified number of rows at a starting point
//      and return them as a variant. Code contributed by Reinhard Kalinke (R_Kalinke@compuserve.com)
//      Added integer property LoadLimit which will limit the number of records loaded using LoadFrom....
//      methods. Suggested by Roman Olexa (systech@ba.telecom.sk). if LoadLimit<=0 then
//      no limit is imposed.
//      Added read only integer property LoadCount which specifies how many records
//      was affected in last load operation.
//      Added read only boolean property LoadedCompletely which is true if all data was loaded,
//      false if the load was interrupted because of LoadLimit.
//      Fixed LoadFrom.... to not load into non data fields. Fix by cosmin@lycosmail.com.
//      Fixed persistency on destruction of component.
//      Added partial Dutch ressourcefile by M.H. Avegaart (avegaart@mccomm.nl).
//      Added method Reset to clear out data, fields, indexes and more by kanca@ibm.net.
//      LoadFromBinaryStream/File now tries to guess approx. how many records will be loaded
//      and thus adjust capacity accordingly.
//      Improved persistent save to not delete original file before finished writing new.
//      Suggested by Paul Bailey (paul@cirrlus.co.za).
//      Fixed minor bug in GetRecordCount when table not active by Csehi Andras (acsehi@qsoft.hu)
//
//2.40  Fixed problem with SetRange specifying fewer fields than number of index fields, giving   12. May. 2000
//      wrong number of resulting records. Problem reported by Jay Herrmann (Jayh@adamsbusinessforms.com)
//      Added new AddIndex2 method to TkbmCustomMemTable which allows to define some additional indexsetups:
//        mtcoIgnoreLocale   which use standard CompareStr instead of AnsiCompareStr.
//        mtcoIgnoreNullKey  which specifies that a null key field value will be ignored in record comparison.
//      Except for the ExtraOptions parameter its equal in functionality to AddIndex.
//      Added new property: OnCompareFields which can be used to handle specialized sortings and searches.
//      Made the following functions publicly available:
//           function CompareFields(KeyField,AField:pointer; FieldType: TFieldType; Partial, CaseInsensitive,IgnoreLocale:boolean):Integer;
//           function StringToCodedString(const Source:string):string;
//           function CodedStringToString(const Source:string):string;
//           function StringToBase64(const Source:string):string;
//           function Base64ToString(const Source:string):string;
//      Added new property: AutoIncMinValue which can be used to set startvalue for autoinc. field.
//      Added new property: AutoIncValue which can be used to obtain current next value for an autoinc field.
//
//2.41  Fixed problem regarding calculated fields on attached table not updating. Problem
//      reported by aZaZel (azazel@planningsrl.it).
//
//2.42  Added PersistentBackup:boolean and PersistentBackupExt:string which controls if to make  25. May. 2000
//      a backup of the previous persistent file and which extension the file should have.
//      Code provided by cosmin@lycosmail.com.
//      Made ResetAutoInc public. Suggested by cosmin@lycosmail.com.
//      Fixed missing copy of RecordTag in InternalCopyR*. Reported by Alexey Trizno (xpg@mail.spbnit.ru).
//      Added property groups by Chris G. Royle (cgr@dialabed.co.za).
//      Fixed missing reset of UpdateStatus in _InternalClearRecord. Reported by CARIOTOGLOU MIKE (Mike@singular.gr)
//      Fixed Search bug on empty table. Problem seen inserting into empty table with ixunique index defined.
//      Problem reported by George Tasker (gtasker@informedsources.com.au)
//      Published BeforeRefresh and AfterRefresh.
//      Fixed deactivation of designed active table during runtime. Reason was missing inherited
//      in Loaded method. Problem reported by John McLaine (johnmclaine@hotmail.com)
//
//2.43  Added OnProgress event which will fire on long operations notifying how
//      many percent has been accomplished. The operation performed can be
//      found in the Code parameter.
//      Added new FastQuickSort procedure to TkbmIndex. Enhances searchspeed by
//      somewhere around 50-75%. Sorting 100.000 records on a field on a PII 450Mhz
//      now takes approx 5 secs. FastQuickSort (combination of a modified Quicksort and
//      Insertion sort) is now the default sorting mechanism.
//      To reenable the previous standard Quicksort mechanism, put a comment on the
//      USE_FASTQUICKSORT definition further down.
//      Danish translation of ressource strings added.
//      Added public low level function GetDeletedRecordsCount:integer.
//      Changed master/detail behaviour to allow more indexfields than masterfields.
//      Change proposed seperately by Thomas Everth (everth@wave.co.nz) and
//      IMB Tameio (vatt@internet.gr)
//      Updated Brasilian translation by Eduardo Costa e Silva (SoftAplic) (eduardo@softaplic.com.br)
//      Added protected procedure PopulateBlob by Fernando (tolentino@atalaia.com.br)
//      Fixed issues compiling in D3 and BCB4.
//      Commented out not copying nondatafields in LoadFromDataset as implemented in v.2.39
//      Problem reported by Roman Olexa (systech@ba.telecom.sk).
//
//2.44  Removed stupid bug I implemented in 2.43. Forgot to remove some code.
//      Fixed the demo project handling range. The demo of the SetRange function
//      forgot that no index named 'Period' was defined, thus the range was set
//      on the currently active index instead.
//      Added support for using SortOn('',....) for selecting the roworder index.
//      Defined some consts for internal indexnames and internal journal field names.
//        kbmRowOrderIndex = '__MT__ROWORDER'
//        kbmDefSortIndex  = '__MT__DEFSORT'
//        kbmJournalOperationField  = '__MT__Journal_Operation'
//        kbmJournalRecordTypeField = '__MT__Journal_RecordType'
//
//2.45  Fixed Master/detail problem setting masterfields while table not active.
//      Problem reported by CARIOTOGLOU MIKE (Mike@singular.gr).
//      Fixed Filter expression problem when reordering fields in runtime.
//      Problem reported by houyuguo@21cn.com.
//      Added several more progress functions.
//      Added TableState which can be polled to decide whats going on in the table at
//      the moment.
//      Added AutoReposition property (default false) which determines if automatically
//      to reposition to new place for record on record post, or to stay at current pos.
//      Fixed dupplicate fieldname problem with attached tables as reported by
//      Roman Olexa (systech@ba.telecom.sk). If fieldnames conflict between the
//      current table and the table attached to, the original current table field
//      is removed from the table, and the attached to table field used instead.
//
//2.45b Fixed missing FOrdered:=true on FastQuicksort. Problem reported
//      by Tim  Daborn (Tim_Daborn@Compuserve.com)
//
//2.46  Fixed SetFilterText bug. Problem reported by Anders Thomsen (thomsenjunk@hotmail.com)
//      Added BCB 5 support by Lester Caine (lester@lsces.globalnet.co.uk)
//
//2.47  Added copy flag mtcpoAppend for appending data using LoadFromDataset.
//      Added Master/Detail designer. Corrected master/detail functionality.
//      Added Hungarian translation by Csehi Andras (acsehi@qsoft.hu)
//
//2.48  Fixed InternalSaveToStream to save in current indexorder. Problem reported
//      by Cosmin (vatt@internet.gr) and Christoph Ansermot (info@illuminati.ch)
//      Fixed InternalAddRecord to respect the Append flag. Problem reported by
//      Milleder Markus (QI/LSR-Wi) (Markus.Milleder@tenovis.com)
//      Fixed filter bug < which was considered the same as <=. Bug reported by
//      Milleder Markus (QI/LSR-Wi) (Markus.Milleder@tenovis.com)
//
//2.49  Fixed TkbmIndexes.Clear leaving an invalid FSortIndex.      16. July 2000
//      Problem fixed by Jason Mills (jmills@sync-link.com).
//      Fixed D3 bugs which wouldnt allow to compile. Problem fixed by
//      Speets, RCJ (ramon.speets@corusgroup.com)
//      Changed ftVarBytes to work similar to ftBytes. Problem reported by
//      mike cariotoglou (Mike@singular.gr)
//      Fixed filtering of strings through the Filter property. Problem reported
//      by several.
//      Modified demoproject with FindKey functionality and string field.
//      For the time being, removed support for the WideString fieldtype.
//      Changed SaveToBinaryxxxxx to save in the order of the current index.
//      Beware that if the current index is not up to date, it could mean
//      saving less records than there actually is in the table.
//      Changed binary file format to include null value info. LoadFromBinaryxxx
//      is backwards compatible, but files saved with SaveToBinaryxxxx can only
//      be read by software incoorporating TkbmMemTable v. 2.49 or newer.
//      If needed, one of the BINARY_FILE_XXX_COMPATIBILITY defines can be
//      specified for saving in a format compatible with older versions of
//      TkbmMemTable.
//
//2.50  Fixed bug on SortOn after UpdateIndexes. Problem reported by Gate (x_gate@hotmail.com)
//      Added IndexByName(IndexName:string) property to obtain a TkbmIndex object for
//      the specified indexname.
//      Added Enabled property to TkbmIndex which can be set to false to disable
//      updating that index or true to allow updating again. An automatic rebuild
//      is issued if needed.
//      Fixed incorrect definition of properties EnableVersioning and VersioningMode
//      in TkbmMemTable. Problem reported by U. Classen (uc@dsa-ac.de)
//      Made CopyRecords public and changed it to copy from current pos in source.
//      Fixed counter bug in CopyRecords which would copy one record more than limit.
//      Fix suggested by Wilfried Mestdagh (wilfried_sonal@compuserve.com).
//      Added saveflag mtfSaveAppend which will append the current dataset to
//      the data previously saved in the file or stream. Suggested
//      by Denis Tsyplakov (den@icsv.ru)
//      Fixed AutoInc problem using InsertRecord/AppendRecord as reported by
//      Jerzy Labocha (jurekl@ramzes.szczecin.pl)
//      Fixed D3 inst. by replacing TField.FullName for TField.FieldName for
//      level 3 installations only. Problem reported by Marcel Langr (mlangr@ivar.cz)
//      Fixed cancel/Blob bug. Pretty tuff to fix. Several routines heavily
//      rewritten to solve problem. Those changes also allows for better strings
//      optimization.
//      Fixed bug reported by jacky@acroprise.com.tw in SwitchToIndex on empty table.
//      Fixed autoreposition bug by CARIOTOGLOU MIKE (Mike@singular.gr).
//      Fixed attachedto bug during destroy by Vladimir Piven (grumbler@ekonomik.com.ua).
//      Optimized per record memory usage by compiling out the debug values startident and endident
//      + made record allocation one call to getmem instead of two. Suggested by
//      Llus Oll (mailto:llob@menta.net)
//      Added Performance property which can hold mtpfFast, mtpfBalanced or mtpfSmall.
//      Meaning:
//        mtpfFast=One GetMem/Rec. No recordcompression.
//        mtpfBalanced=One or more GetMem/Rec. Null varlength fields are compressed.
//        mtpfSmall=Like mtpfBalanced except varlength field level compression is made.
//      Use mtpfFast if all string values will have a value which are close to the
//      max size of the string fields or raw speed is important.
//      Use mtpfBalanced if most string fields will be null.
//      Use mtpfSmall in other cases.
//      Added OnCompressField and OnDecompressField which can be used to
//      create ones own field level compression and decompression for all nonblob
//      varlength fields. For blobfields checkout OnCompressBlob and OnDecompressBlob.
//      Added OnSetupField which can be used to overwrite indirection of
//      specific fields when Performance is mtpfBalanced or mtpfSmall.
//      Fixed locate on date or time fields giving variant conversion error.
//      Problem reported by Tim Daborn (Tim_Daborn@Compuserve.com).
//      Updated Russian ressources and added Ukrainian ressources by
//      Vladimir (grumbler@ekonomik.com.ua)
//=============================================================================

// TODO -cPERFORMANCE -oKBM: Less locking on readonly searches on non calc fields.

//=============================================================================
// Define the localization you need here by uncommenting the appropriate line.
{$define KBMMEM_RES_ENGLISH}
//{$define KBMMEM_RES_GERMAN}
//{$define KBMMEM_RES_FRENCH}
//{$define KBMMEM_RES_BRASIL}
//{$define KBMMEM_RES_RUSSIAN}
//{$define KBMMEM_RES_SPANISH}
//{$define KBMMEM_RES_ITALIAN}
//{$define KBMMEM_RES_ROMANIAN}
//{$define KBMMEM_RES_SLOVAKIAN}
//{$define KBMMEM_RES_CZECH}
//{$define KBMMEM_RES_DUTCH}
//{$define KBMMEM_RES_DANISH}
//{$define KBMMEM_RES_HUNGARIAN}
//{$define KBMMEM_RES_UKRAINIAN}
//=============================================================================

//=============================================================================
// Remove the remark on the next line if all records should be checked before use.
//{$define DO_CHECKRECORD}
//=============================================================================

//=============================================================================
// Remove the remark on the next lines if to keep binary or CSV file compatibility
// between different versions of TkbmMemTable.
//{$define BINARY_FILE_230_COMPATIBILITY}
//{$define BINARY_FILE_200_COMPATIBILITY}
//{$define BINARY_FILE_1XX_COMPATIBILITY}
//{$define CSV_FILE_1XX_COMPATIBILITY}
//=============================================================================

//=============================================================================
// Comment the next line to use the standard Quicksort algorithm.
{$define USE_FASTQUICKSORT}
//=============================================================================

//=============================================================================
// Change this if you need more than 256 fields in a table.
const
     KBM_MAX_FIELDS=256;
//=============================================================================

{$include kbmMemTable.inc}

//***********************************************************************

{$ifdef BCB}
{$ObjExportAll On}
{$ASSERTIONS ON}
{$endif}

const
     // Key buffer types.
     kbmkbMin=0;
     kbmkbKey=0;
     kbmkbRangeStart=1;
     kbmkbRangeEnd=2;
     kbmkbMasterDetail=3;
     kbmkbMax=3;

     // Record identifier.
     kbmRecordIdent=$6A1B2C3E;

     // Consts for GetRows
     kbmBookmarkCurrent = $00000000;
     kbmBookmarkFirst = $00000001;
     kbmBookmarkLast = $00000002;
     kbmGetRowsRest = $FFFFFFFF;

     // Internal index names.
     kbmRowOrderIndex = '__MT__ROWORDER';
     kbmDefSortIndex  = '__MT__DEFSORT';

     // Internal field names.
     kbmJournalOperationField  = '__MT__Journal_Operation';
     kbmJournalRecordTypeField = '__MT__Journal_RecordType';

type
  EMemTableError = class(EDataBaseError);

  TkbmCustomMemTable = class;
  TkbmCustomDeltaHandler = class;

  PkbmRecord=^TkbmRecord;
  TkbmRecord=record
{$IFDEF DO_CHECKRECORD}
      StartIdent:longint;
{$ENDIF}

      RecordNo: integer;
      BookmarkData: integer;
      BookmarkFlag: TBookmarkFlag;
      RecordID: integer;
      UniqueRecordID: integer;

      TransactionLevel:integer;
      Tag:longint;
      Data:PChar;

      UpdateStatus:TUpdateStatus;
      PrevRecordVersion:PkbmRecord;

{$IFDEF DO_CHECKRECORD}
      EndIdent:longint;
{$ENDIF}
  end;

{
  Internal Data layout:
+------------------------+---------------------------+-----------------------+
| FIXED LENGTH DATA      |   CALCULATED FIELDS       | VARIABLE LENGTH PTRS  |
| FRecordSize bytes      |   FRecordCalcSize bytes   | FRecordVarLengthSize  |
+------------------------+---------------------------+-----------------------+
                         ^                           ^
                         StartCalculated             StartVarLength

Blobsfields in the internal buffer are pointers to the blob data.
}

  PDateTimeRec=^TDateTimeRec;
  PWordBool=^WordBool;

  TkbmMemTableStorageType = (mtstDataSet,mtstStream,mtstBinaryStream,mtstFile,mtstBinaryFile);

  TkbmMemTableSaveFlag = (mtfSaveData, mtfSaveCalculated,mtfSaveLookup,mtfSaveNonVisible,
                          mtfSaveBlobs,mtfSaveDef,mtfSaveIndexDef,mtfSkipRest,mtfSaveFiltered,
                          mtfSaveInLocalFormat,mtfSaveIgnoreRange,mtfSaveIgnoreMasterDetail,mtfSaveDeltas,
                          mtfSaveDontFilterDeltas, mtfSaveAppend);
  TkbmMemTableSaveFlags = set of TkbmMemTableSaveFlag;

  TkbmFieldTypes = set of TFieldType;

  TkbmMemTablePersistentSaveFormat = (mtsfBinary,mtsfCSV);

  TkbmMemTableCompareOption = (mtcoDescending,mtcoCaseInsensitive,mtcoPartialKey,mtcoIgnoreNullKey,mtcoIgnoreLocale);
  TkbmMemTableCompareOptions = set of TkbmMemTableCompareOption;

  TkbmMemTableCopyTableOption = (mtcpoStructure,mtcpoOnlyActiveFields,mtcpoProperties,mtcpoLookup,mtcpoCalculated,mtcpoAppend);
  TkbmMemTableCopyTableOptions = set of TkbmMemTableCopyTableOption;

  TkbmMemTableJournalSaveOption = (mtjsSaveStructure);
  TkbmMemTableJournalSaveOptions = set of TkbmMemTableJournalSaveOption;

  TkbmMemTableJournalLoadOption = (mtjlLoadStructure,mtjlIgnoreUnknownFields);
  TkbmMemTableJournalLoadOptions = set of TkbmMemTableJournalLoadOption;

  PkbmVarLength=PChar;
  PPkbmVarLength=^PkbmVarLength;

  TkbmIndexType = (mtitNonSorted,mtitSorted);

  TkbmIndex = class
  private
     FName:           string;
     FReferences:     TList;
     FDataSet:        TkbmCustomMemTable;
     FIndexFields:    string;
     FIndexFieldList: TList;
     FIndexOptions:   TIndexOptions;
     FOptions:        TkbmMemTableCompareOptions;
     FOrdered:        boolean;
     FType:           TkbmIndexType;
     FRowOrder:       boolean;
     FInternal:       boolean;
     FIndexOfs:       integer;
     FIsView:         boolean;

     procedure InternalInsertionSort(Lo,Hi:integer);
     procedure InternalSwap(I,J:integer);
     procedure InternalFastQuickSort(L,R:Integer);
     function  GetEnabled:boolean;
     procedure SetEnabled(Enabled:boolean);
  protected
     function CompareRecords(AFieldList:TList;KeyRecord,ARecord:PkbmRecord;SortCompare:boolean;Options:TkbmMemTableCompareOptions): Integer;
     procedure QuickSort(L,R:Integer);
     procedure FastQuickSort(L,R:Integer);
     function BinarySearch(FirstNo,LastNo:integer; KeyRecord:PkbmRecord; Nearest,RespectFilter:boolean; var Index:integer; Options:TkbmMemTableCompareOptions):integer;
     function BinarySearchRecordID(FirstNo,LastNo:integer; RecordID:integer; var Index:integer):integer;
     function SequentialSearch(FirstNo,LastNo:integer; KeyRecord:PkbmRecord; Nearest,RespectFilter:boolean; var Index:integer; Options:TkbmMemTableCompareOptions):integer;
     function SequentialSearchRecordID(FirstNo,LastNo:integer; RecordID:integer; var Index:integer):integer;
     function FindRecordNumber(RecordBuffer:PChar):integer;

  public
     constructor Create(Name:string;DataSet:TkbmCustomMemtable; Fields:string; Options:TIndexOptions; IndexType:TkbmIndexType; Internal:boolean);
     destructor Destroy; override;

     function Search(KeyRecord:PkbmRecord; Nearest,RespectFilter:boolean; var Index:integer; Options:TkbmMemTableCompareOptions):integer;
     function SearchRecord(KeyRecord:PkbmRecord; var Index:integer; RespectFilter:boolean; Options:TkbmMemTableCompareOptions):integer;
     function SearchRecordID(RecordID:integer; var Index:integer):integer;
     procedure Clear;
     procedure LoadAll;
     procedure ReSort;
     procedure Rebuild;

     property Enabled:boolean read GetEnabled write SetEnabled;
     property IsView:boolean read FIsView write FIsView;
     property IsOrdered:boolean read FOrdered write FOrdered;
     property IndexType:TkbmIndexType read FType write FType;
     property CompareOptions:TkbmMemTableCompareOptions read FOptions write FOptions;
     property IndexOptions:TIndexOptions read FIndexOptions write FIndexOptions;
     property IndexFields:string read FIndexFields write FIndexFields;
     property IndexFieldList:TList read FIndexFieldList write FIndexFieldList;
     property Dataset:TkbmCustomMemTable read FDataSet write FDataSet;
     property Name:string read FName write FName;
     property References:TList read FReferences write FReferences;
     property IsRowOrder:boolean read FRowOrder write FRowOrder;
     property IsInternal:boolean read FInternal write FInternal;
     property IndexOfs:integer read FIndexOfs write FIndexOfs;
  end;

  TkbmIndexUpdateHow = (mtiuhInsert,mtiuhEdit,mtiuhDelete);

  TkbmIndexes = class
  private
     FRowOrderIndex:  TkbmIndex;
     FIndexes:        TStringList;
     FDataSet:        TkbmCustomMemTable;

  public
     constructor Create(DataSet:TkbmCustomMemTable);
     destructor Destroy; override;

     procedure Clear;
     procedure Add(IndexDef:TIndexDef);

     procedure AddIndex(Index:TkbmIndex);
     procedure DeleteIndex(Index:TkbmIndex);

     procedure ReBuild(IndexName:string);
     procedure Delete(IndexName:string);
     function Get(IndexName:string):TkbmIndex;
     procedure Empty(IndexName:string);

     function GetByFieldNames(FieldNames:string):TkbmIndex;

     procedure EmptyAll;
     procedure ReBuildAll;

     procedure CheckRecordUniqueness(ARecord,ActualRecord:PkbmRecord);
     procedure UpdateIndexes(How:TkbmIndexUpdateHow;OldRecord,NewRecord:PkbmRecord; RecordPos:integer);
     function Search(FieldList:TList; KeyRecord:PkbmRecord; Nearest,RespectFilter:boolean; var Index:integer;
                     Options:TkbmMemTableCompareOptions):integer;
     function  Count:integer;
  end;

  TkbmJournalOperation = (mtjoInsert,mtjoEdit,mtjoDelete);

  TkbmVersioningMode = (mtvm1SinceCheckPoint,mtvmAllSinceCheckPoint);

  TkbmJournalRecord = record
     Operation:TkbmJournalOperation;
     Rec:PkbmRecord;
     OrigRec:PkbmRecord;
     Stamp:TDateTime;
  end;
  PkbmJournalRecord = ^TkbmJournalRecord;

  TkbmJournal = class
  private
     FDataset: TkbmCustomMemTable;
     FJournal: TkbmCustomMemTable;

     procedure CreateJournalFields;
  public
     constructor Create(AMemTable:TkbmCustomMemTable);
     destructor Destroy; override;

     procedure Add(AOperation:TkbmJournalOperation;ARec:PkbmRecord;AOrigRec:PkbmRecord);
     procedure Empty;
     property  Table:TkbmCustomMemTable read FJournal write FJournal;
  end;

  TkbmProgressCode = (mtpcLoad,mtpcSave,mtpcEmpty,mtpcPack,mtpcCheckPoint,mtpcSearch,mtpcCopy,mtpcUpdate,mtpcSort);
  TkbmProgressCodes = set of TkbmProgressCode;

  TkbmState = (mtstBrowse,mtstLoad,mtstSave,mtstEmpty,mtstPack,mtstCheckPoint,mtstSearch,mtstUpdate,mtstSort);

  TkbmPerformance = (mtpfFast,mtpfBalanced,mtpfSmall);
  TkbmFieldFlag = (mtffIndirect,mtffCompress,mtffModified);
  TkbmFieldFlags = set of TkbmFieldFlag;

  TkbmOnProgress = procedure(DataSet:TDataSet; Percentage:integer; Code:TkbmProgressCode) of object;
  TkbmOnLoadRecord = procedure(DataSet:TDataSet; var Accept:boolean) of object;
  TkbmOnLoadField = procedure(DataSet:TDataSet; FieldNo:integer; Field:TField) of object;
  TkbmOnSaveRecord = procedure(DataSet:TDataSet; var Accept:boolean) of object;
  TkbmOnSaveField = procedure(DataSet:TDataSet; FieldNo:integer; Field:TField) of object;
  TkbmOnCompress = procedure(UnCompressedStream,CompressedStream:TStream) of object;
  TkbmOnDeCompress = procedure(CompressedStream,DeCompressedStream:TStream) of object;
  TkbmOnCompressField = procedure(DataSet:TDataSet; Field:TField; const Buffer:PChar; var Size:longint; var ResultBuffer:PChar) of object;
  TkbmOnDecompressField = procedure(DataSet:TDataSet; Field:TField; const Buffer:PChar; var Size:longint; var ResultBuffer:PChar) of object;
  TkbmOnSave = procedure(DataSet:TDataSet; StorageType:TkbmMemTableStorageType; Stream:TStream) of object;
  TkbmOnLoad = procedure(DataSet:TDataSet; StorageType:TkbmMemTableStorageType; Stream:TStream) of object;
  TkbmOnCompareFields = procedure(DataSet:TDataSet; KeyField,AField:pointer; FieldType:TFieldType; Partial,CaseInsensitive,IgnoreLocale:boolean; var Result:integer) of object;
  TkbmOnSetupField = procedure(DataSet:TDataSet; Field:TField; var FieldFlags:TkbmFieldFlags) of object;

{$IFDEF LEVEL3}
  TUpdateStatusSet = set of TUpdateStatus;
{$ENDIF}

  TkbmCustomMemTable = class(TDataSet)
  private
        FRecords:                               TThreadList;
        FDeletedRecords:                        TList;
        FJournal:                               TkbmJournal;

        FFilterRecord:                          PkbmRecord;
        FKeyRecord:                             PkbmRecord;
        FKeyBuffers:                            array [kbmkbMin..kbmkbMax] of PkbmRecord;
        FIgnoreReadOnly:                        boolean;

        FIndexDefs:                             TIndexDefs;
        FIndexes:                               TkbmIndexes;
        FCurIndex:                              TkbmIndex;
        FSortIndex:                             TkbmIndex;
        FEnableIndexes:                         boolean;

        FState:                                 TkbmState;

{$IFDEF LEVEL5}
        FFilterParser:                          TExprParser;
{$ENDIF}
        FFilterOptions:                         TFilterOptions;

        FMasterLink:                            TMasterDataLink;
        FIsOpen:                                Boolean;
        FRecNo:                                 longint;
        FReposRecNo:                            longint;

        FBeforeCloseCalled:                     boolean;
        FDuringAfterOpen:                       boolean;

        FLoadLimit:                             longint;
        FLoadCount:                             longint;
        FLoadedCompletely:                      boolean;

        FPerformance:                           TkbmPerformance;

        FDeltaHandler:                          TkbmCustomDeltaHandler;

        FOverrideActiveRecordBuffer:            PkbmRecord;
        FEnableJournal:                         boolean;
        FEnableVersioning:                      boolean;
        FVersioningMode:                        TkbmVersioningMode;
        FStatusFilter:                          TUpdateStatusSet;
        FDeleteCount:                           longint;

        FCSVQuote:char;
        FCSVFieldDelimiter:char;
        FCSVRecordDelimiter:char;

        FAttachedChildren:                      TThreadList;
        FAttachedTo:                            TkbmCustomMemTable;
        FAttachedAutoRefresh:                   boolean;

        FAutoIncField:                          TField;
        FAutoIncMax,
        FAutoIncMin,

        FVarLengthCount:                        integer;

        FRecordDataSize,
        FRecordCalcSize,
        FRecordVarLengthSize,
        FStartCalculated,
        FStartVarLength:                        longint;

        FRecalcOnFetch:                         boolean;

        FRecordSize:                            longint;
        FFieldOfs:                              array [0..KBM_MAX_FIELDS-1] of integer;
        FFieldFlag:                             array [0..KBM_MAX_FIELDS-1] of TkbmFieldFlags;
        FReadOnly:                              boolean;
        FRecordID:                              longint;
        FUniqueRecordID:                        longint;

        FPersistent:                            boolean;
        FPersistentFile:                        TFileName;
        FPersistentSaveOptions:                 TkbmMemTableSaveFlags;
        FPersistentSaveFormat:                  TkbmMemTablePersistentSaveFormat;
        FPersistentSaved:                       boolean;
        FPersistentBackup:                      boolean;
        FPersistentBackupExt:                   string;
        FCommaTextOptions:                      TkbmMemTableSaveFlags;
        FAllDataOptions:                        TkbmMemTableSaveFlags;

        FStoreDataOnForm:                       boolean;
        FTempDataStorage:                       TMemoryStream;

        FDummyStr:                              string;

        FMasterIndexList:                       TList;
        FIndexList:                             TList;
        FRecalcOnIndex:                         boolean;
        FIndexFieldNames:                       string;
        FIndexName:                             string;
        FSortFieldNames:                        string;
        FAutoReposition:                        boolean;

        FRangeActive:                           boolean;

        FSortedOn:                              string;
        FSortOptions:                           TkbmMemTableCompareOptions;
        FKeyOptions:                            TkbmMemTableCompareOptions;

        FOnCompareFields:                       TkbmOnCompareFields;

        FOnSave:                                TkbmOnSave;
        FOnLoad:                                TkbmOnLoad;

        FProgressFlags:                         TkbmProgressCodes;
        FOnProgress:                            TkbmOnProgress;

        FOnLoadRecord:                          TkbmOnLoadRecord;
        FOnSaveRecord:                          TkbmOnSaveRecord;
        FOnLoadField:                           TkbmOnLoadField;
        FOnSaveField:                           TkbmOnSaveField;

        FOnCompressSave:                        TkbmOnCompress;
        FOnDecompressLoad:                      TkbmOnDecompress;

        FOnCompressBlobStream:                  TkbmOnCompress;
        FOnDecompressBlobStream:                TkbmOnDecompress;

        FOnSetupField:                          TkbmOnSetupField;
        FOnCompressField:                       TkbmOnCompressField;
        FOnDecompressField:                     TkbmOnDecompressField;

{$IFDEF DO_CHECKRECORD}
        procedure _InternalCheckRecord(ARecord:PkbmRecord);
{$ENDIF}
        function _InternalAllocRecord:PkbmRecord;
        function _InternalCopyRecord(SourceRecord:PkbmRecord; CopyVarLengths:boolean):PkbmRecord;
        procedure _InternalCopyVarLength(SourceRecord,DestRecord:PkbmRecord; Field:TField);
        procedure _InternalCopyVarLengths(SourceRec,DestRec:PkbmRecord);
        procedure _InternalMoveRecord(SourceRecord,DestRecord:PkbmRecord; MoveVarLength:boolean);
{$IFDEF KBM}
        procedure _InternalMoveVarLengths(SourceRecord,DestRecord:PkbmRecord);
{$ENDIF}
        procedure _InternalFreeRecordVarLengths(ARecord:PkbmRecord);
        procedure _InternalFreeRecord(ARecord:PkbmRecord; FreeVarLengths, FreeVersions:boolean);
        procedure _InternalClearRecord(ARecord:PkbmRecord);
        procedure _InternalAppendRecord(ARecord:PkbmRecord);
        procedure _InternalDeleteRecord(ARecord:PkbmRecord);
        procedure _InternalPackRecords;

        function GetActiveRecord:               PkbmRecord;

        function FilterRecord(ARecord:PkbmRecord):Boolean;
        procedure _InternalEmpty(DoJournal:boolean);
        procedure _InternalFirst;
        procedure _InternalLast;
        function  _InternalNext:boolean;
        function  _InternalPrior:boolean;

        function  _InternalCompareRecords(FieldList:TList; MaxFields:integer; KeyRecord,ARecord:PkbmRecord; Options:TkbmMemTableCompareOptions): Integer;

        procedure SetMasterFields(const Value: string);
        function GetMasterFields: string;
        procedure SetDataSource(Value: TDataSource);

        function  IsFiltered:boolean;
{$IFDEF LEVEL5}
        procedure BuildFilter(Filter:string);
        function ParseFilter(FilterExpr:TExprParser):variant;
        procedure FreeFilter;
{$ENDIF}

        function GetVersion:string;
        procedure SetIndexFieldNames(FieldNames:string);
        procedure SetIndexName(IndexName:string);
        procedure SetIndexDefs(Value:TIndexDefs);
        procedure SetCommaText(AString: String);
        function GetCommaText: String;
        function GetIndexByName(IndexName:string):TkbmIndex;
        function GetIndexField(Index:integer):TField;
        procedure SetIndexField(Index:integer; Value:TField);
        procedure SetAttachedTo(Value:TkbmCustomMemTable);
        procedure SetRecordTag(Value:longint);
        function GetRecordTag:longint;
        function GetJournal:TkbmJournal;
        function GetIsJournaling:boolean;
        function GetIsJournalAvailable:boolean;
        function GetIsVersioning:boolean;
        procedure SetStatusFilter(const Value:TUpdateStatusSet);
        procedure SetEnableJournal(Value:boolean);
        procedure SetDeltaHandler(AHandler:TkbmCustomDeltaHandler);
        procedure SetAllData(AVariant:variant);
        function GetAllData:variant;
        procedure SetAutoIncMinValue(AValue:integer);
        procedure SetPerformance(AValue:TkbmPerformance);

        procedure SwitchToIndex(Index:TkbmIndex);
        procedure ClearModifiedFlags;
        function GetModifiedFlags(i:integer):boolean;
        function GetFieldIsVarLength(FieldType:TFieldType; Size:longint):boolean;
  protected
        FTransactionLevel:                      integer;

        // Protected stuff which needs to be supported in the TDataset ancestor to make things work.
        procedure InternalOpen; override;
        procedure InternalClose; override;
        procedure InternalFirst;override;
        procedure InternalLast;override;
        procedure InternalAddRecord(Buffer: Pointer; Append: Boolean); override;
        procedure InternalDelete; override;
        procedure InternalInitRecord(Buffer: PChar); override;
        procedure InternalPost; override;
        procedure InternalCancel; override;
        procedure InternalEdit; override;
        {$ifndef LEVEL3}
        procedure InternalInsert; override;
        {$endif}
        procedure InternalInitFieldDefs; override;
        procedure InternalSetToRecord(Buffer: PChar); override;
        procedure DoBeforeClose; override;
        procedure DoBeforeOpen; override;
        procedure DoAfterOpen; override;
        procedure DoAfterPost; override;
        procedure DoAfterDelete; override;
        procedure DoOnNewRecord; override;
        procedure DoBeforePost; override;
        function IsCursorOpen: Boolean; override;
        function GetCanModify: Boolean; override;
        function GetRecordSize: Word;override;
        function GetRecordCount: integer;override;
        function AllocRecordBuffer: PChar; override;
        procedure FreeRecordBuffer(var Buffer: PChar); override;
        procedure CloseBlob(Field: TField); override;
        procedure SetFieldData(Field: TField; Buffer: Pointer);override;
{$IFDEF LEVEL3}
        function GetFieldData(Field: TField; Buffer: Pointer): Boolean; override;
{$ENDIF}
        function GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
        function FindRecord(Restart, GoForward: Boolean): Boolean; override;
        function GetRecNo: integer;override;
        procedure SetRecNo(Value: integer);override;
        function GetIsIndexField(Field: TField): Boolean; override;
        function GetBookmarkFlag(Buffer: PChar): TBookmarkFlag; override;
        procedure SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag); override;
        procedure GetBookmarkData(Buffer: PChar; Data: Pointer); override;
        procedure SetBookmarkData(Buffer: PChar; Data: Pointer); override;
        procedure InternalGotoBookmark(Bookmark: Pointer); override;
        function BCDToCurr(BCD: Pointer; var Curr: Currency): Boolean; {$IFNDEF LEVEL5}override;{$ENDIF}
        function CurrToBCD(const Curr: Currency; BCD: Pointer; Precision, Decimals: Integer): Boolean; {$IFNDEF LEVEL5}override;{$ENDIF}
        procedure InternalHandleException; override;
        function GetDataSource: TDataSource; override;
        procedure Notification(AComponent: TComponent; Operation: TOperation); override;
        procedure SetFiltered(Value:boolean); override;
        procedure SetFilterText(const Value:string); override;

{$IFDEF LEVEL5}
        procedure DataEvent(Event: TDataEvent; Info: Longint); override;
{$ENDIF}
        procedure Loaded; override;

        // Internal lowlevel routines.
        procedure DefineProperties(Filer: TFiler); override;
        procedure ReadData(Stream:TStream);
        procedure WriteData(Stream:TStream);

        procedure BuildFieldList(Dataset:TDataset; List:TList; const FieldNames: string);
        function FindFieldInList(List:TList; FieldName:String):TField;
        function IsFieldListsEqual(List1,List2:TList):boolean;

        function GetFieldSize(FieldType:TFieldType; Size:longint):longint;
        function GetFieldPointer(ARecord:PkbmRecord; Field:TField):PChar;
        procedure PopulateField(ARecord:PkbmRecord;Field:TField;AValue:Variant);
        procedure PopulateRecord(ARecord:PkbmRecord;Fields:string;Values:variant);
        procedure PopulateVarLength(ARecord:PkbmRecord;Field:TField;const Buffer; Size:Integer);
        function InternalBookmarkValid(Bookmark: Pointer):boolean;
        procedure PrepareKeyRecord(KeyRecordType:integer; Clear:boolean);
        function FilterRange(ARecord:PkbmRecord): Boolean;
        function FilterMasterDetail(ARecord:PkbmRecord):boolean;
{$IFDEF LEVEL5}
        function FilterExpression(ARecord:PkbmRecord):boolean;
{$ENDIF}
        procedure MasterChanged(Sender: TObject);
        procedure MasterDisabled(Sender: TObject);
        procedure CopyFieldsProperties(Source,Destination:TDataSet);

        // Internal attached children handling.
        procedure DeAttachChild(Value:TkbmCustomMemTable);
        procedure AttachChild(Value:TkbmCustomMemTable);
        procedure AttachedChildrenNotify;
        procedure AttachedChildrenRefresh(Caller:TkbmCustomMemTable);
        procedure AttachedChildrenUpdateIndexes(How:TkbmIndexUpdateHow;OldRecord,NewRecord:PkbmRecord);
        procedure AttachedChildrenCheckRecordUniqueness(ARecord,ActualRecord:PkbmRecord);
        procedure DoCascadeUpdateIndexes(How:TkbmIndexUpdateHow;OldRecord,NewRecord:PkbmRecord; RecordPos:integer);

        // Internal medium level routines.
        procedure InternalSaveToStream(Stream: TStream; flags:TkbmMemTableSaveFlags);
        procedure InternalSaveToBinaryStream(Stream: TStream; flags:TkbmMemTableSaveFlags);
        procedure InternalLoadFromStream(Stream: TStream);
        procedure InternalLoadFromBinaryStream(Stream: TStream);
        function UpdateRecords(Source,Destination:TDataSet; KeyFields:string; Count:longint):longint;
        function LocateRecord(const KeyFields:string; const KeyValues:Variant; Options:TLocateOptions):integer;
        procedure DestroyIndexes;
        procedure CreateIndexes;
        procedure SavePersistent;
        procedure LoadPersistent;

        function CheckAutoInc:boolean;
  public
        // Public stuff which needs to be supported in the TDataset ancestor to make things work.
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        function BookmarkValid(Bookmark: TBookmark): boolean; override;
        function CompareBookmarks(Bookmark1, Bookmark2: TBookmark):Integer; override;
{$IFDEF LEVEL4}
        function GetFieldData(Field: TField; Buffer: Pointer): Boolean; override;
        procedure SetBlockReadSize(Value: Integer); override;
        function UpdateStatus: TUpdateStatus; override;
{$ENDIF}

        function CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;
        function IsSequenced:Boolean; override;

        // Public low level routines.
        function GetDeletedRecordsCount:integer;
        function CompressFieldBuffer(Field:TField; const Buffer:pointer; var Size:longint):pointer;
        function DecompressFieldBuffer(Field:TField; const Buffer:pointer; var Size:longint):pointer;

        // Public medium level routines.
        function CreateFieldAs(Field:TField):TField;
        function MoveRecord(Source, Destination: Integer): Boolean;
        function MoveCurRecord(Destination:Longint):Boolean;
        function GetVersionFieldData(Field:TField; Version:integer):variant;
        function GetVersionStatus(Version:integer):TUpdateStatus;
        function GetVersionCount:integer;
        procedure ResetAutoInc;
        procedure Progress(Pct:integer; Code:TkbmProgressCode);
        function CopyRecords(Source,Destination:TDataSet; Count:longint):longint;

        // Public high level routines.
        procedure CreateTable;
        procedure EmptyTable;
        procedure CreateTableAs(Source:TDataSet; CopyOptions:TkbmMemTableCopyTableOptions);
        procedure DeleteTable;
        procedure PackTable;
        procedure AddIndex(const Name, Fields: string; Options: TIndexOptions{$IFDEF LEVEL5}; const DescFields: string = ''{$ENDIF});
        procedure AddIndex2(const Name, Fields: string; Options: TIndexOptions; ExtraOptions: TkbmMemTableCompareOptions{$IFDEF LEVEL5}; const DescFields: string = ''{$ENDIF});
        procedure DeleteIndex(const Name: string);
        procedure UpdateIndexes;
        function IndexFieldCount:Integer;
        procedure StartTransaction; virtual;
        procedure Commit; virtual;
        procedure Rollback; virtual;
        procedure LoadFromFile(const FileName: string);
        procedure LoadFromStream(Stream:TStream);
        procedure LoadFromBinaryFile(const FileName: string);
        procedure LoadFromBinaryStream(Stream: TStream);
        procedure LoadFromDataSet(Source:TDataSet; CopyOptions:TkbmMemTableCopyTableOptions);
        procedure SaveToFile(const FileName: string; flags:TkbmMemTableSaveFlags);
        procedure SaveToBinaryFile(const FileName: string; flags:TkbmMemTableSaveFlags);
        procedure SaveToStream(Stream: TStream; flags:TkbmMemTableSaveFlags);
        procedure SaveToBinaryStream(Stream: TStream; flags:TkbmMemTableSaveFlags);
        procedure SaveToDataSet(Destination:TDataSet);
        procedure UpdateToDataSet(Destination:TDataSet; KeyFields:String);
        procedure SortDefault;
        procedure Sort(Options:TkbmMemTableCompareOptions);
        procedure SortOn(const FieldNames:string; Options:TkbmMemTableCompareOptions);
        function Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant; override;
        function Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean; override;
        procedure SetKey;
        procedure EditKey;
        function GotoKey:boolean;
        function FindKey(const KeyValues:array of const): Boolean;
        function FindNearest(const KeyValues:array of const): Boolean;
        procedure ApplyRange;
        procedure CancelRange;
        procedure SetRange(const StartValues, EndValues:array of const);
        procedure SetRangeStart;
        procedure SetRangeEnd;
        procedure EditRangeStart;
        procedure EditRangeEnd;
        procedure CheckPoint;

{$IFNDEF LEVEL3}
        function GetRows(Rows:Integer; Start:Variant; Fields:Variant):Variant;
        procedure Reset;
{$ENDIF}

        property Active;
        property Filtered;
        property Filter;
        property AutoIncValue:integer read FAutoIncMax;
        property AutoIncMinValue:integer read FAutoIncMin write SetAutoIncMinValue;
        property AllData:variant read GetAllData write SetAllData;
        property AllDataOptions:TkbmMemTableSaveFlags read FAllDataOptions write FAllDataOptions;
        property StoreDataOnForm:boolean read FStoreDataOnForm write FStoreDataOnForm;
        property AttachedTo:TkbmCustomMemTable read FAttachedTo write SetAttachedTo;
        property AttachedAutoRefresh:boolean read FAttachedAutoRefresh write FAttachedAutoRefresh;
        property CommaText:string read GetCommaText write SetCommaText;
        property CommaTextOptions:TkbmMemTableSaveFlags read FCommaTextOptions write FCommaTextOptions;
        property CSVQuote:char read FCSVQuote write FCSVQuote;
        property CSVFieldDelimiter:char read FCSVFieldDelimiter write FCSVFieldDelimiter;
        property CSVRecordDelimiter:char read FCSVRecordDelimiter write FCSVRecordDelimiter;
        property IndexFieldNames:string read FIndexFieldNames write SetIndexFieldNames;
        property IndexName:string read FIndexName write SetIndexName;
        property EnableIndexes:boolean read FEnableIndexes write FEnableIndexes;
        property AutoReposition:boolean read FAutoReposition write FAutoReposition;
        property SortFields:string read FSortFieldNames write FSortFieldNames;
        property SortOptions:TkbmMemTableCompareOptions read FSortOptions write FSortOptions;
        property ReadOnly:boolean read FReadOnly write FReadOnly default false;
        property Performance:TkbmPerformance read FPerformance write SetPerformance;
        property IgnoreReadOnly:boolean read FIgnoreReadOnly write FIgnoreReadOnly default false;
        property RangeActive:boolean read FRangeActive;
        property PersistentFile:TFileName read FPersistentFile write FPersistentFile;
        property Persistent:boolean read FPersistent write FPersistent default false;
        property PersistentSaveOptions:TkbmMemTableSaveFlags read FPersistentSaveOptions write FPersistentSaveOptions;
        property PersistentSaveFormat:TkbmMemTablePersistentSaveFormat read FPersistentSaveFormat write FPersistentSaveFormat;
        property PersistentBackup:boolean read FPersistentBackup write FPersistentBackup;
        property PersistentBackupExt:string read FPersistentBackupExt write FPersistentBackupExt;
        property ProgressFlags:TkbmProgressCodes read FProgressFlags write FProgressFlags;
        property LoadLimit:integer read FLoadLimit write FLoadLimit;
        property LoadCount:integer read FLoadCount;
        property LoadedCompletely:boolean read FLoadedCompletely;
        property RecalcOnFetch:boolean read FRecalcOnFetch write FRecalcOnFetch;
        property IsFieldModified[i:integer]:boolean read GetModifiedFlags;
        property EnableJournal:boolean read FEnableJournal write SetEnableJournal;
        property EnableVersioning:boolean read FEnableVersioning write FEnableVersioning;
        property VersioningMode:TkbmVersioningMode read FVersioningMode write FVersioningMode;
        property IsJournalAvailable:boolean read GetIsJournalAvailable;
        property IsJournaling:boolean read GetIsJournaling;
        property IsVersioning:boolean read GetIsVersioning;
        property StatusFilter:TUpdateStatusSet read FStatusFilter write SetStatusFilter;
        property Journal:TkbmJournal read GetJournal;
        property DeltaHandler:TkbmCustomDeltaHandler read FDeltaHandler write SetDeltaHandler;
        property Indexes:TkbmIndexes read FIndexes;
        property IndexByName[IndexName:string]:TkbmIndex read GetIndexByName;
        property IndexDefs:TIndexDefs read FIndexDefs write SetIndexDefs;
        property IndexFields[Index:Integer]:TField read GetIndexField write SetIndexField;
        property RecalcOnIndex:boolean read FRecalcOnIndex write FRecalcOnIndex;
        property FilterOptions:TFilterOptions read FFilterOptions write FFilterOptions;
        property MasterFields: string read GetMasterFields write SetMasterFields;
        property MasterSource: TDataSource read GetDataSource write SetDataSource;
        property RecordTag: longint read GetRecordTag write SetRecordTag;
        property Version:string read GetVersion write FDummyStr;
        property TransactionLevel:integer read FTransactionLevel;
        property TableState:TkbmState read FState;
        property OnLoadRecord:TkbmOnLoadRecord read FOnLoadRecord write FOnLoadRecord;
        property OnLoadField:TkbmOnLoadField read FOnLoadField write FOnLoadField;
        property OnSaveRecord:TkbmOnSaveRecord read FOnSaveRecord write FOnSaveRecord;
        property OnSaveField:TkbmOnSaveField read FOnSaveField write FOnSaveField;
        property OnCompressSave:TkbmOnCompress read FOnCompressSave write FOnCompressSave;
        property OnDecompressLoad:TkbmOnDecompress read FOnDecompressLoad write FOnDecompressLoad;
        property OnCompressBlobStream:TkbmOnCompress read FOnCompressBlobStream write FOnCompressBlobStream;
        property OnDecompressBlobStream:TkbmOnDecompress read FOnDecompressBlobStream write FOnDecompressBlobStream;
        property OnSetupField:TkbmOnSetupField read FOnSetupField write FOnSetupField;
        property OnCompressField:TkbmOnCompressField read FOnCompressField write FOnCompressField;
        property OnDecompressField:TkbmOnDecompressField read FOnDecompressField write FOnDecompressField;
        property OnSave:TkbmOnSave read FOnSave write FOnSave;
        property OnLoad:TkbmOnLoad read FOnLoad write FOnLoad;
        property OnProgress:TkbmOnProgress read FOnProgress write FOnProgress;
        property OnCompareFields:TkbmOnCompareFields read FOnCompareFields write FOnCompareFields;
        property BeforeOpen;
        property AfterOpen;
        property BeforeClose;
        property AfterClose;
        property BeforeInsert;
        property AfterInsert;
        property BeforeEdit;
        property AfterEdit;
        property BeforePost;
        property AfterPost;
        property BeforeCancel;
        property AfterCancel;
        property BeforeDelete;
        property AfterDelete;
        property BeforeScroll;
        property AfterScroll;
        property OnCalcFields;
        property OnDeleteError;
        property OnEditError;
        property OnFilterRecord;
        property OnNewRecord;
        property OnPostError;
  end;

  TkbmMemTable = class(TkbmCustomMemTable)
  published
        property Active;
        property AttachedTo;
        property AttachedAutoRefresh;
        property AutoIncMinValue;
        property AutoCalcFields;
        property FieldDefs;
        property Filtered;
        property DeltaHandler;
        property EnableIndexes;
        property AutoReposition;
        property IndexFieldNames;
        property IndexName;
        property IndexDefs;
        property RecalcOnIndex;
        property RecalcOnFetch;
        property SortFields;
        property SortOptions;
        property ReadOnly;
        property Performance;
        property PersistentFile;
        property AllDataOptions;
        property StoreDataOnForm;
        property CommaTextOptions;
        property CSVQuote;
        property CSVFieldDelimiter;
        property CSVRecordDelimiter;
        property Persistent;
        property PersistentSaveOptions;
        property PersistentSaveFormat;
        property PersistentBackup;
        property PersistentBackupExt;
        property ProgressFlags;
        property LoadLimit;
        property LoadedCompletely;
        property EnableJournal;
        property EnableVersioning;
        property VersioningMode;
        property Filter;
        property FilterOptions;
        property MasterFields;
        property MasterSource;
        property Version;
        property OnProgress;
        property OnLoadRecord;
        property OnLoadField;
        property OnSaveRecord;
        property OnSaveField;
        property OnCompressSave;
        property OnDecompressLoad;
        property OnCompressBlobStream;
        property OnDecompressBlobStream;
        property OnSetupField;
        property OnCompressField;
        property OnDecompressField;
        property OnSave;
        property OnLoad;
        property OnCompareFields;
        property BeforeOpen;
        property AfterOpen;
        property BeforeClose;
        property AfterClose;
        property BeforeInsert;
        property AfterInsert;
        property BeforeEdit;
        property AfterEdit;
        property BeforePost;
        property AfterPost;
        property BeforeCancel;
        property AfterCancel;
        property BeforeDelete;
        property AfterDelete;
        property BeforeScroll;
        property AfterScroll;
{$IFDEF LEVEL5}
        property BeforeRefresh;
        property AfterRefresh;
{$ENDIF}
        property OnCalcFields;
        property OnDeleteError;
        property OnEditError;
        property OnFilterRecord;
        property OnNewRecord;
        property OnPostError;
  end;

  TkbmBlobStream = class(TMemoryStream)
  private
    FField: TBlobField;
    FDataSet: TkbmCustomMemTable;
    FMode:TBlobStreamMode;
    FPBlob: PPkbmVarLength;
    FPField: PChar;
    FFieldNo: Integer;
    FModified: Boolean;
    procedure ReadBlobData;
    procedure WriteBlobData;
  public
    constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
    destructor Destroy; override;
    function Write(const Buffer; Count: Longint): Longint; override;
    procedure Truncate;
  end;

  TkbmThreadDataSet = class(TComponent)
  private
    FDataset:TDataset;
    FLockCount:integer;
    FSemaphore:THandle;
    function GetIsLocked:boolean;
    procedure SetDataset(ds:TDataset);
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner:TComponent); override;
    destructor Destroy; override;
    function TryLock(TimeOut:DWORD):TDataset;
    function Lock:TDataset;
    procedure Unlock;
    property IsLocked:boolean read GetIsLocked;
  published
    property Dataset:TDataset read FDataset write SetDataset;
  end;

  // Handler which user must override to provide functionality when trying to update deltas on an external database.
  TkbmCustomDeltaHandler = class(TComponent)
  private
     FDataSet:TkbmCustomMemTable;
     FPRecord,FPOrigRecord:PkbmRecord;
     procedure CheckDataSet;
     function GetValues(Index:integer):Variant;
     function GetOrigValues(Index:integer):Variant;
     function GetFieldCount:integer;
     function GetFieldNames(Index:integer):string;
     function GetFields(Index:integer):TField;
     function GetOrigValuesByName(Name:string):Variant;
     function GetValuesByName(Name:string):Variant;
  protected
     procedure InsertRecord; virtual;
     procedure DeleteRecord; virtual;
     procedure ModifyRecord; virtual;
     procedure UnmodifiedRecord; virtual;
  public
     procedure Resolve; virtual;
     property DataSet:TkbmCustomMemTable read FDataSet;
     property FieldCount:integer read GetFieldCount;
     property OrigValues[i:integer]:Variant read GetOrigValues;
     property Values[i:integer]:Variant read GetValues;
     property OrigValuesByName[Name:string]:Variant read GetOrigValuesByName;
     property ValuesByName[Name:string]:Variant read GetValuesByName;
     property FieldNames[i:integer]:string read GetFieldNames;
     property Fields[i:integer]:TField read GetFields;
  end;

  function StreamToVariant(stream:TStream):variant;
  procedure VariantToStream(AVariant:variant; stream:TStream);
  function CompareFields(KeyField,AField:pointer; FieldType: TFieldType; Partial, CaseInsensitive,IgnoreLocale:boolean):Integer;
  function StringToCodedString(const Source:string):string;
  function CodedStringToString(const Source:string):string;
  function StringToBase64(const Source:string):string;
  function Base64ToString(const Source:string):string;

const
  // Some standard save sets to simplify things.
  kbmSaveAllDeltas:TkbmMemTableSaveFlags = [mtfSaveNonVisible,mtfSaveBlobs,mtfSaveDef,mtfSaveFiltered,mtfSaveIgnoreRange,mtfSaveIgnoreMasterDetail,mtfSaveDeltas];
  kbmSaveAllData:TkbmMemTableSaveFlags = [mtfSaveNonVisible,mtfSaveBlobs,mtfSaveDef,mtfSaveFiltered,mtfSaveIgnoreRange,mtfSaveIgnoreMasterDetail,mtfSaveData];
  kbmSaveAllDataAndDelta:TkbmMemTableSaveFlags = [mtfSaveNonVisible,mtfSaveBlobs,mtfSaveDef,mtfSaveFiltered,mtfSaveIgnoreRange,mtfSaveIgnoreMasterDetail,mtfSaveData,mtfSaveDeltas];


  // All supported field types.
  kbmSupportedFieldTypes:TkbmFieldTypes=[ftString,ftSmallint,ftInteger,ftWord,ftBoolean,ftFloat,ftCurrency,
                                         ftDate,ftTime,ftDateTime,ftAutoInc,ftBCD,ftBlob,ftMemo,ftGraphic,ftFmtMemo,
                                         ftParadoxOle,ftDBaseOle,ftTypedBinary,ftBytes, ftVarBytes
{$ifndef LEVEL3}
                                         ,ftFixedChar,{ftWideString,}ftLargeInt,ftADT,ftArray
{$endif}
                                        ];

  // All field types which should be treated as strings during save and load.
  kbmStringTypes:TkbmFieldTypes=[ftString,ftMemo,ftFmtMemo
{$ifndef LEVEL3}
                                 ,ftFixedChar,ftWideString
{$endif}
                                ];
  // All field types which should be treated as binary types during save and load.
  kbmBinaryTypes:TkbmFieldTypes=[ftBlob,ftMemo,ftGraphic,ftFmtMemo,ftParadoxOle,ftDBaseOle,ftTypedBinary,ftVarBytes,ftBytes];

  // All field types which should be treated as blobs.
  kbmBlobTypes:TkbmFieldTypes=[ftBlob,ftMemo,ftGraphic,ftFmtMemo,ftParadoxOle,ftDBaseOle,ftTypedBinary];

  // All non blob field types.
  kbmNonBlobTypes:TkbmFieldTypes=[ftString,ftSmallint,ftInteger,ftWord,ftBoolean,ftFloat,ftCurrency,
                                  ftDate,ftTime,ftDateTime,ftAutoInc,ftBCD,ftBytes,ftVarBytes
{$ifndef LEVEL3}
                                  ,ftFixedChar,{ftWideString,}ftLargeInt,ftADT,ftArray
{$endif}                         ];

  // Field types which should be stored as a variable chunk of memory.
  // Blobs are automatically treated as variable length datatypes.
  kbmVarLengthNonBlobTypes:TkbmFieldTypes=[ftString,ftBytes,ftVarBytes
{$ifndef LEVEL3}
                                    ,ftFixedChar{,ftWideString}];
{$endif}

  NullVarLength=PkbmVarLength(0);
  
{$ifdef LEVEL3}
procedure Register;
{$endif}

implementation

uses
  TypInfo, Dialogs, Forms, Controls, IniFiles, DBConsts,
{$ifdef KBMMEM_RES_ENGLISH}
  kbmMemResEng
{$else}
 {$ifdef KBMMEM_RES_GERMAN}
  kbmMemResGer
 {$else}
  {$ifdef KBMMEM_RES_FRENCH}
   kbmMemResFra
  {$else}
   {$ifdef KBMMEM_RES_BRASIL}
    kbmMemResBra
   {$else}
    {$ifdef KBMMEM_RES_RUSSIAN}
     kbmMemResRus
    {$else}
     {$ifdef KBMMEM_RES_SPANISH}
      kbmMemResSpa
     {$else}
      {$ifdef KBMMEM_RES_ITALIAN}
       kbmMemResIta
      {$else}
       {$ifdef KBMMEM_RES_ROMANIAN}
        kbmMemResRom
       {$else}
        {$ifdef KBMMEM_RES_SLOVAKIAN}
         kbmMemResSky
        {$else}
         {$ifdef KBMMEM_RES_CZECH}
          kbmMemResCsy
         {$else}
          {$ifdef KBMMEM_RES_DUTCH}
           kbmMemResDut
          {$else}
           {$ifdef KBMMEM_RES_DANISH}
            kbmMemResDan
           {$else}
            {$ifdef KBMMEM_RES_HUNGARIAN}
             kbmMemResHun
            {$else}
             {$ifdef KBMMEM_RES_UKRAINIAN}
              kbmMemResUkr
             {$endif}
            {$endif}
           {$endif}
          {$endif}
         {$endif}
        {$endif}
       {$endif}
      {$endif}
     {$endif}
    {$endif}
   {$endif}
  {$endif}
 {$endif}
{$endif};

const

{$ifdef LEVEL3}
  FieldTypeNames: array[TFieldType] of string = (
    'Unknown', 'String', 'SmallInt', 'Integer', 'Word', 'Boolean', 'Float',
    'Currency', 'BCD', 'Date', 'Time', 'DateTime', 'Bytes', 'VarBytes',
    'AutoInc', 'Blob', 'Memo', 'Graphic', 'FmtMemo', 'ParadoxOle',
    'dBaseOle', 'TypedBinary', 'Cursor');
{$endif}

  // Field mappings needed for filtering. (What field type should be compared with what internal type).
{$ifdef LEVEL5}
  FldTypeMap: TFieldMap = (
    ord(ftUnknown), ord(ftString), ord(ftSmallInt), ord(ftInteger), ord(ftWord), ord(ftBoolean),
    ord(ftFloat), ord(ftFloat), ord(ftBCD), ord(ftDate), ord(ftTime), ord(ftDateTime), ord(ftBytes),
    ord(ftVarBytes), ord(ftInteger), ord(ftBlob), ord(ftBlob), ord(ftBlob), ord(ftBlob), ord(ftBlob),
    ord(ftBlob), ord(ftBlob), ord(ftUnknown), ord(ftString), ord(ftString), ord(ftLargeInt), ord(ftADT),
    ord(ftArray), ord(ftUnknown), ord(ftUnknown), ord(ftUnknown), ord(ftUnknown), ord(ftUnknown), ord(ftUnknown),
    ord(ftUnknown), ord(ftUnknown) );
{$endif}

  // Table definition magic words.
  kbmTableDefMagicStart = '@@TABLEDEF START@@';
  kbmTableDefMagicEnd = '@@TABLEDEF END@@';

  // Index definition magic words.
  kbmIndexDefMagicStart = '@@INDEXDEF START@@';
  kbmIndexDefMagicEnd = '@@INDEXDEF END@@';

  // Binary file magic word.
  kbmBinaryMagic = '@@BINARY@@';

  // File version magic word.
  kbmFileVersionMagic = '@@FILE VERSION@@';

  // Current file versions. V. 1.xx file versions are considered 100, 2.xx are considered 2xx etc.
  kbmBinaryFileVersion = 249;
  kbmCSVFileVersion = 200;
  kbmJournalVersion = 200;
  kbmDeltaVersion = 200;

// -----------------------------------------------------------------------------------
// General procedures.
// -----------------------------------------------------------------------------------

// Allocate a varlength.
function AllocVarLength(Size:longint):PkbmVarLength;
begin
     GetMem(Result,Size+4);
     FillChar(Result^,Size+4,0);
     Result[0]:=Char(Size and $FF);
     Result[1]:=Char((Size shr 8) and $FF);
     Result[2]:=Char((Size shr 16) and $FF);
     Result[3]:=Char((Size shr 24) and $FF);
end;

// Get pointer to varlength data.
function GetVarLengthData(AVarLength:PkbmVarLength):PChar;
begin
     Result:=AVarLength+4;
end;

// Get size of varlength data.
function GetVarLengthSize(AVarLength:PkbmVarLength):longint;
begin
     Result:=byte(AVarLength[0])+
             (byte(AVarLength[1]) shl 8)+
             (byte(AVarLength[2]) shl 16)+
             (byte(AVarLength[3]) shl 24);
end;

// Allocate a varlength and populate it.
function AllocVarLengthAs(const Source:PChar; Size:longint):PkbmVarLength;
begin
     Result:=AllocVarLength(Size);
     move(Source^,GetVarLengthData(Result)^,Size);
end;

// Duplicate varlength.
function CopyVarLength(AVarLength:PkbmVarLength):PkbmVarLength;
var
   sz:longint;
begin
     sz:=GetVarLengthSize(AVarLength);
     Result:=AllocVarLength(sz);
     Move(GetVarLengthData(AVarLength)^,GetVarLengthData(Result)^,sz);
end;

{$IFDEF DEBUG}
// Dump varlength.
procedure DumpVarLength(AVarLength:PkbmVarLength);
var
   s:string;
   i:integer;
   sz:integer;
   p:PChar;
begin
     s:='VarLength '+inttohex(longint(AVarLength),8);
     OutputDebugString(PChar(s));
     s:=inttostr(byte(AVarLength[0]))+inttostr(byte(AVarLength[1]))+
        inttostr(byte(AVarLength[2]))+inttostr(byte(AVarLength[3]));
     s:='Size data='+s;
     OutputDebugString(PChar(s));
     sz:=GetVarLengthSize(AVarLength);
     s:=' Size='+inttostr(sz);
     OutputDebugString(PChar(s));
     p:=GetVarLengthData(AVarLength);
     s:='';
     for i:=0 to sz-1 do
     begin
          s:=s+p[i];
     end;
     s:=' Data='+s;
     OutputDebugString(PChar(s));
end;
{$ENDIF}

// Free a varlength.
procedure FreeVarLength(AVarLength:PkbmVarLength);
begin
     if (AVarLength <> nil) then FreeMem(AVarLength);
end;

// Put contents of a stream into a variant.
function StreamToVariant(stream:TStream):variant;
var
   p:PChar;
begin
     stream.Seek(0,0);
     Result:=VarArrayCreate([0,stream.Size - 1],VarByte);
     try
        p:=VarArrayLock(Result);
        try
           stream.ReadBuffer(p^,stream.Size);
        finally
           VarArrayUnlock(Result);
        end;
     except
        Result:=Unassigned;
     end;
end;

// Get contents of a variant and put it in a stream.
procedure VariantToStream(AVariant:variant; stream:TStream);
var
   p:PChar;
   sz:integer;
begin
     // Check if variant contains data and is an array.
     if VarIsEmpty(AVariant) or VarIsNull(AVariant) or (not VarIsArray(AVariant)) then exit;

     sz:=VarArrayHighBound(AVariant,1);
     p:=VarArrayLock(AVariant);
     try
        stream.WriteBuffer(p^,sz+1);
     finally
        VarArrayUnlock(AVariant);
     end;
end;

// Compare two fields.
function CompareFields(KeyField,AField:pointer; FieldType: TFieldType; Partial, CaseInsensitive,IgnoreLocale:boolean):Integer;
var
   p:PChar;
   l:integer;
   ts1,ts2:TDateTimeRec;
   d:Double;
//s:string;
begin
     Result := 0;
     case FieldType of
{$ifndef LEVEL3}
       ftFixedChar{,ftWideString},
{$endif}
       ftString:
          begin
               p:=nil;
               try
                  // If partial, cut to reference length. p1=reference field value, p2=tried field value.
                  if Partial then
                  begin
                       l:=StrLen(PChar(KeyField));
                       p:=StrAlloc(l+1);
                       StrLCopy(p,AField,l);
                  end
                  else p:=AField;

                  if IgnoreLocale then
                  begin
                       if CaseInsensitive then
                          Result:=CompareText(PChar(KeyField), p)
                       else
                          Result:=CompareStr(PChar(KeyField), p);
                  end
                  else
                  begin
                       if CaseInsensitive then
                          Result:=AnsiCompareText(PChar(KeyField), p)
                       else
                          Result:=AnsiCompareStr(PChar(KeyField), p);
                  end;
               finally
                  if p<>AField then StrDispose(p);
               end;
          end;

       ftSmallint:
          Result:=PSmallInt(KeyField)^-PSmallInt(AField)^;

       ftInteger,
       ftAutoInc:
          begin
             Result:=PLongint(KeyField)^-PLongint(AField)^;
          end;

{$ifndef LEVEL3}
       ftLargeInt:
          begin
             Result:=PInt64(KeyField)^-PInt64(AField)^;
          end;
{$endif}

       ftDate:
          begin
             ts1:=PDateTimeRec(KeyField)^;
             ts2:=PDateTimeRec(AField)^;
             Result:=ts1.Date-ts2.Date;
          end;

       ftTime:
          begin
             ts1:=PDateTimeRec(KeyField)^;
             ts2:=PDateTimeRec(AField)^;
             Result:=ts1.Date-ts2.Date;
          end;

       ftDateTime:
          begin
             ts1:=PDateTimeRec(KeyField)^;
             ts2:=PDateTimeRec(AField)^;
             d:=ts1.DateTime-ts2.DateTime;
             if d<0.0 then Result:=-1
             else if d>0.0 then Result:=1
             else Result:=0;
          end;

       ftWord:
          Result:=PWord(KeyField)^-PWord(AField)^;

       ftBoolean:
          if PWordBool(KeyField)^>PWordBool(AField)^ then Result:=1
          else if PWordBool(KeyField)^<PWordBool(AField)^ then Result:=-1;

       ftFloat,
       ftCurrency:
          if PDouble(KeyField)^>PDouble(AField)^ then Result:=1
          else if PDouble(KeyField)^<PDouble(AField)^ then Result:=-1;
     end;
end;

// Code special characters (LF,CR,%,#0)
// CR (#13) -> %c
// LF (#10) -> %n
// #0 -> %0
// % -> %%
function StringToCodedString(const Source:string):string;
var
   i,j:integer;
   l:integer;
begin
     // Count CR/LF.
     l:=0;
     for i:=1 to length(Source) do
         if Source[i] in [#13,#10,'%',#0] then inc(l);

     // If no special characters, return the original string.
     if l=0 then
     begin
          Result:=Source;
          exit;
     end;

     // If any special characters, make room for them.
     SetLength(Result,length(Source)+l);

     // Code special characters.
     j:=1;
     for i:=1 to length(Source) do
         case Source[i] of
              #13: begin
                        Result[j]:='%'; inc(j);
                        Result[j]:='c'; inc(j);
                   end;
              #10: begin
                        Result[j]:='%'; inc(j);
                        Result[j]:='n'; inc(j);
                   end;
              #0:  begin
                        Result[j]:='%'; inc(j);
                        Result[j]:='0'; inc(j);
                   end;
              '%': begin
                        Result[j]:='%'; inc(j);
                        Result[j]:='%'; inc(j);
                   end;
              else
                   begin
                        Result[j]:=Source[i];
                        inc(j);
                   end;
         end;
end;

// Decode special characters (LF,CR,%,#0)
// %c -> CR (#13)
// %n -> LF (#10)
// %% -> %
// %0 -> #0
function CodedStringToString(const Source:string):string;
var
   i,j:integer;
begin
     SetLength(Result,length(Source));

     // Code special characters.
     i:=1;
     j:=1;
     while true do
     begin
          if i>length(Source) then break;
          if Source[i]='%' then
          begin
               inc(i);
               case Source[i] of
                    'c': Result[j]:=#13;
                    'n': Result[j]:=#10;
                    '%': Result[j]:='%';
                    '0': Result[j]:=#0;
               end;
               inc(j);
          end
          else
          begin
               Result[j]:=Source[i];
               inc(j);
          end;
          inc(i);
     end;

     // Cut result string to right length.
     if i<>j then SetLength(Result,j-1);
end;

// Code a string as BASE 64.
function StringToBase64(const Source:string):string;
var
   Act: Word;
   Bits,I,P,Len: Integer;
begin
     Bits:=0;
     Len:=(Length(Source)*4+2) div 3;
     if Len>0 then
     begin
          SetLength(Result,Len);
	  P:=1;
	  Act:=0;
	  for I:=1 to Pred(Len) do
          begin
	       if Bits<6 then
               begin
	            Act:=(Act shr 6) or (Ord(Source[P]) shl Bits);
		    Inc(P);
		    Inc(Bits,2);
               end
               else
               begin
	            Dec(Bits,6);
		    Act:=Act shr 6;
               end;
	       Result[I]:=Char(Act and 63+32);
          end;
	  Result[Len]:=Char(Act shr 6+32);
     end;
end;

// Decode BASE64 string.
function Base64ToString(const Source:string): string;
var
   Act: Word;
   Bits,I,P,Len: Integer;
begin
     Len:=(Length(Source)*3) div 4;
     SetLength(Result,Len);
     Bits:=0;
     Act:=0;
     P:=1;
     for I:=1 to system.Length(Source) do
     begin
          Act:=Act or (Ord(Source[I])-32) shl Bits;
	  if Bits>=2 then
          begin
	       Result[P]:=Char(Act and $FF);
	       Inc(P);
	       Act:=Act shr 8;
	       Dec(Bits,2);
          end
          else
	      Inc(Bits,6);
     end;
end;

// -----------------------------------------------------------------------------------
// TkbmIndexes
// -----------------------------------------------------------------------------------
constructor TkbmIndex.Create(Name:string;DataSet:TkbmCustomMemtable; Fields:string; Options:TIndexOptions; IndexType:TkbmIndexType; Internal:boolean);
var
   lst:TList;
begin
     inherited Create;

     FName:=Name;
     FIndexFields:=Fields;
     FDataSet:=DataSet;
     FType:=IndexType;
     FInternal:=Internal;
     FRowOrder:=false;
     FIsView:=false;

     lst:=DataSet.FRecords.LockList;
     try
        FOrdered:=(lst.Count=0);
     finally
        DataSet.FRecords.UnlockList;
     end;

     FIndexOptions:=Options;
     FOptions:=[];
     if (ixDescending in Options) then FOptions:=FOptions+[mtcoDescending];
     if (ixCaseInsensitive in Options) then FOptions:=FOptions+[mtcoCaseInsensitive];

     FReferences:=TList.create;

     // Build list of fields in index, and check them for validity.
     FIndexFieldList:=TList.create;
     FDataSet.BuildFieldList(FDataSet,FIndexFieldList,FIndexFields);
end;

destructor TkbmIndex.Destroy;
begin
     Clear;
     FReferences.free;
     FIndexFieldList.free;
     inherited;
end;

procedure TkbmIndex.SetEnabled(Enabled:boolean);
begin
     if (not Enabled) then
        FIndexOptions:=FIndexOptions+[ixNonMaintained]
     else
     begin
          FIndexOptions:=FIndexOptions-[ixNonMaintained];
          if not FOrdered then Rebuild;
     end;
end;

function TkbmIndex.GetEnabled:boolean;
begin
     Result:=not (ixNonMaintained in FIndexOptions);
end;

// Compare two arbitrary records for sort.
function TkbmIndex.CompareRecords(AFieldList:TList;KeyRecord,ARecord:PkbmRecord;SortCompare:boolean;Options:TkbmMemTableCompareOptions): Integer;
begin
     with FDataSet do
     begin
          // Compare record contents.
          Result:=_InternalCompareRecords(AFieldList,-1,KeyRecord,ARecord,Options);

          // Couldnt compare them according to fieldcontents, will now compare according to recnum.
          if (Result=0) and SortCompare then
             Result:=KeyRecord.RecordNo - ARecord.RecordNo;

          // If descending sort, invert result.
          if (mtcoDescending in FOptions) then Result:=-Result;
     end;
end;

// Binary search routine on Record ID index.
// Recursive function.
function TkbmIndex.BinarySearchRecordID(FirstNo,LastNo:integer; RecordID:integer; var Index:integer):integer;
var
   Mid:integer;
   pRec:PkbmRecord;
begin
     // Look in the center of the interval.
     Mid:=(LastNo+FirstNo+1) div 2;
     pRec:=PkbmRecord(FReferences.Items[Mid]);

     // Compare records.
     Result:=RecordID - pRec^.RecordID;

     // If found exactly.
     if Result=0 then
     begin
          Index:=Mid;
          exit;
     end;

     // Not matching, dig deeper.

     // If the key is smaller than the middle record, look in the lower half segment.
     if Result<0 then
        LastNo:=Mid-1
     else
         FirstNo:=Mid+1;

     // Check if usefull to search.
     if FirstNo>LastNo then
     begin
          // Else complete match.
          Result:=0;
          exit;
     end;

     Result:=BinarySearchRecordID(FirstNo,LastNo,RecordID,Index)
end;

// Binary search routine.
// Recursive function.
function TkbmIndex.BinarySearch(FirstNo,LastNo:integer; KeyRecord:PkbmRecord; Nearest,RespectFilter:boolean; var Index:integer; Options:TkbmMemTableCompareOptions):integer;
var
   Mid:integer;
   pRec:PkbmRecord;

   procedure DoRespectFilter;
   var
      r:integer;
      b:boolean;
   begin
        if (not RespectFilter) or (not FDataset.IsFiltered) or (FDataset.FilterRecord(FReferences.Items[Index])) then exit;

        // Loop sequentially to find valid nonfiltered record.
        inc(Index);
        while (Index<FReferences.Count) do
        begin
             r:=CompareRecords(FIndexFieldList,KeyRecord,PkbmRecord(FReferences.Items[Index]),false,Options);
             b:=FDataset.FilterRecord(PkbmRecord(FReferences.Items[Index]));

             // Check if acceptable record.
             if (b) and ((r=0) or ((Nearest) and (r<0))) then exit;

             // Look at next record.
             inc(Index);
        end;

        // Didnt find anything valid, nonfiltered.
        Index:=-1;
   end;
begin
     // Look in the center of the interval.
     Mid:=(LastNo+FirstNo+1) div 2;
     pRec:=PkbmRecord(FReferences.Items[Mid]);

     // Call progress function.
     FDataSet.Progress(trunc((Mid-FirstNo)/(LastNo-FirstNo+1)*100),mtpcSearch);

     // Check if to recalc before compare.
     with FDataSet do
     begin
          if FRecalcOnIndex then
          begin
               //fill calc fields part of buffer
               ClearCalcFields(PChar(pRec));
               GetCalcFields(PChar(pRec));
          end;
     end;

     // Compare records.
     Result:=CompareRecords(FIndexFieldList,KeyRecord,pRec,false,Options);

     // If found exactly.
     if Result=0 then
     begin
          // Backstep to make sure we found the first available record matching.
          dec(Mid);
          while (Mid>=0) do
          begin
               pRec:=PkbmRecord(FReferences.Items[Mid]);
               if CompareRecords(FIndexFieldList,KeyRecord,pRec,false,Options)<>0 then break;
               dec(Mid);
          end;
          Index:=Mid+1;

          DoRespectFilter;
          exit;
     end;

     // Not matching, dig deeper.

     // If the key is smaller than the middle record, look in the lower half segment.
     if Result<0 then
        LastNo:=Mid-1
     else
         FirstNo:=Mid+1;

     // Check if usefull to search.
     if FirstNo>LastNo then
     begin
          // Check if nearest.
          if (Index<0) and (Nearest) then
          begin
               Index:=Mid;
               if (Result>0) then inc(Index);

               DoRespectFilter;
               exit;
          end;

          // Else complete match.
          Result:=0;
          exit;
     end;

     Result:=BinarySearch(FirstNo,LastNo,KeyRecord,Nearest,RespectFilter,Index,Options)
end;

// Sequential search.
function TkbmIndex.SequentialSearch(FirstNo,LastNo:integer; KeyRecord:PkbmRecord; Nearest,RespectFilter:boolean; var Index:integer; Options:TkbmMemTableCompareOptions):integer;
var
   i:integer;
   pRec:PkbmRecord;
begin
     // Loop for all records.
     Result:=0;
     Index:=-1;
     for i:=FirstNo to LastNo do
     begin
          // Check if to recalc before compare.
          pRec:=PkbmRecord(FReferences.Items[i]);
          with FDataSet do
          begin
               // Call progress function.
               if (i mod 100) = 0 then
                 FDataSet.Progress(trunc((i-FirstNo)/(LastNo-FirstNo+1)*100),mtpcSearch);

               if FRecalcOnIndex then
               begin
                    //fill calc fields part of buffer
                    ClearCalcFields(PChar(pRec));
                    GetCalcFields(PChar(pRec));
               end;
          end;

          // Check key record equal to record.
          Result:=CompareRecords(FIndexFieldList,KeyRecord,pRec,false,Options);
          if ((not RespectFilter) or FDataset.FilterRecord(pRec)) and (Result=0) or (Nearest and (Result<0)) then
          begin
               Index:=i;
               exit;
          end;
     end;
end;

// Sequential search for record ID.
function TkbmIndex.SequentialSearchRecordID(FirstNo,LastNo:integer; RecordID:integer; var Index:integer):integer;
var
   i:integer;
   pRec:PkbmRecord;
begin
     // Loop for all records.
     Result:=0;
     Index:=-1;
     for i:=FirstNo to LastNo do
     begin
          // Call progress function.
          if (i mod 100) = 0 then
            FDataSet.Progress(trunc((i-FirstNo)/(LastNo-FirstNo+1)*100),mtpcSearch);

          pRec:=PkbmRecord(FReferences.Items[i]);
          Result:=RecordID - pRec^.RecordID;

          if (Result=0) then
          begin
               Index:=i;
               exit;
          end;
     end;
end;

// Search.
// Aut. choose between indexed seq. search and indexed binary search.
function TkbmIndex.Search(KeyRecord:PkbmRecord; Nearest,RespectFilter:boolean; var Index:integer; Options:TkbmMemTableCompareOptions):integer;
begin
     Index:=-1;

     // Lock the record list for our use, to make sure nobody alters it.
     FDataSet.Progress(0,mtpcSearch);
     FDataSet.FState:=mtstSearch;
     FDataSet.FRecords.LockList;
     try
        // Utilize best search method depending of size.
        if FOrdered and (not FRowOrder) and (FReferences.Count>20) then
            Result:=BinarySearch(0,FReferences.Count-1,KeyRecord,Nearest,RespectFilter,Index,Options)
        else if (FReferences.Count>0) then
           Result:=SequentialSearch(0,FReferences.Count-1,KeyRecord,Nearest,RespectFilter,Index,Options)
        else
            Result:=0;
     finally
        FDataSet.FRecords.UnlockList;
        FDataSet.Progress(100,mtpcSearch);
        FDataSet.FState:=mtstBrowse;
     end;
end;

// Search for specific record in index.
function TkbmIndex.SearchRecord(KeyRecord:PkbmRecord; var Index:integer; RespectFilter:boolean; Options:TkbmMemTableCompareOptions):integer;
var
   First,Last:integer;
   i:integer;
begin
     Index:=-1;
     Result:=0;

     // Lock the record list for our use, to make sure nobody alters it.
     FDataSet.FRecords.LockList;
     FDataSet.Progress(0,mtpcSearch);
     try
        // Check if anything to search.
        if (FReferences.count>0) then
        begin
             // Assume whole range.
             First:=0;
             Last:=FReferences.count-1;

             // Try to minimize the sequential scan for record.
             if FOrdered and (not FRowOrder) and (FReferences.Count>20) then
             begin
                  i:=-1;
                  BinarySearch(0,FReferences.Count-1,KeyRecord,false,RespectFilter,i,Options);
                  if i>=0 then First:=i;
             end;

             // Sequential scan for correct record id from that point.
             SequentialSearchRecordID(First,Last,KeyRecord^.RecordID,Index);
        end;
     finally
        FDataSet.FRecords.UnlockList;
     end;
end;

// Search for specific record ID in row order index only.
function TkbmIndex.SearchRecordID(RecordID:integer; var Index:integer):integer;
begin
     // Try to look for it by binary search.
     // If records are inserted here and there in the index, they will not be sorted
     // as the roworderindex indicates the order the user has put the records in
     // using append and insert. But as a good guess, there should be a good chance
     // of finding a record by a binary search. If it wasnt found, we will try again
     // using a sequential search to be on the safe side.
     Index:=-1;
     Result:=0; // To fix bogus warning from compiler.

     // Lock the record list for our use, to make sure nobody alters it.
     FDataSet.FRecords.LockList;
     try
        if FOrdered and FRowOrder then
           Result:=BinarySearchRecordID(0,FReferences.Count-1,RecordID,Index);
        if Index<0 then
            Result:=SequentialSearchRecordID(0,FReferences.Count-1,RecordID,Index);
     finally
        FDataSet.FRecords.UnlockList;
     end;
end;

// Routines used by FastQuicksort.
procedure TkbmIndex.InternalSwap(I,J:integer);
var
   t:PChar;
begin
     t:=FReferences.Items[I];
     FReferences.Items[I]:=FReferences.Items[J];
     FReferences.Items[J]:=t;
end;

procedure TkbmIndex.InternalFastQuickSort(L,R:Integer);
var
   I,J:integer;
   P:PkbmRecord;
begin
     if ((R-L)>4) then
     begin
          I:=(R+L) div 2;
          if CompareRecords(FIndexFieldList,PkbmRecord(FReferences.Items[L]),PkbmRecord(FReferences.Items[I]),true,FOptions)>0 then
           InternalSwap(L,I);
          if CompareRecords(FIndexFieldList,PkbmRecord(FReferences.Items[L]),PkbmRecord(FReferences.Items[R]),true,FOptions)>0 then
           InternalSwap(L,R);
          if CompareRecords(FIndexFieldList,PkbmRecord(FReferences.Items[I]),PkbmRecord(FReferences.Items[R]),true,FOptions)>0 then
           InternalSwap(I,R);

          J:=R-1;
          InternalSwap(I,J);
          I:=L;
          P:=PkbmRecord(FReferences.Items[J]);
          while true do
          begin
               Inc(I);
               Dec(J);
               while CompareRecords(FIndexFieldList,PkbmRecord(FReferences.Items[I]),P,true,FOptions) < 0 do Inc(I);
               while CompareRecords(FIndexFieldList,PkbmRecord(FReferences.Items[J]),P,true,FOptions) > 0 do Dec(J);
               if (J<I) then break;
               InternalSwap(I,J);
          end;
          InternalSwap(I,R-1);
          InternalFastQuickSort(L,J);
          InternalFastQuickSort(I+1,R);
     end;
end;

procedure TkbmIndex.InternalInsertionSort(Lo,Hi:integer);
var
   I,J:integer;
   P:PkbmRecord;
begin
     for I:=Lo+1 to Hi do
     begin
          P:=PkbmRecord(FReferences.Items[I]);
          J:=I;
          while ((J>Lo) and (CompareRecords(FIndexFieldList,PkbmRecord(FReferences.Items[J-1]),P,true,FOptions)>0)) do
          begin
               FReferences.Items[J]:=FReferences.Items[J-1];
               dec(J);
          end;
          FReferences.Items[J]:=P;
     end;
end;

// Sort the record refences using the Fast Quicksort algorithm.
procedure TkbmIndex.FastQuickSort(L,R:Integer);
begin
     InternalFastQuickSort(L,R);
     InternalInsertionSort(L,R);
     FOrdered:=true;
end;

// Sort the record refences using the Quicksort algorithm.
procedure TkbmIndex.QuickSort(L,R:Integer);
var
   I,J:Integer;
   P:PKbmRecord;
begin
     repeat
           I:=L;
           J:=R;
           P:=PkbmRecord(FReferences.Items[(L + R) shr 1]);
           repeat
                 while CompareRecords(FIndexFieldList,PkbmRecord(FReferences.Items[I]),P,true,FOptions) < 0 do Inc(I);
                 while CompareRecords(FIndexFieldList,PkbmRecord(FReferences.Items[J]),P,true,FOptions) > 0 do Dec(J);
                 if I <= J then
                 begin
                      InternalSwap(I,J);
                      Inc(I);
                      Dec(J);
                 end;
           until I>J;
           if L<J then QuickSort(L,J);
           L:=I;
    until I>=R;
    FOrdered:=true;
end;

procedure TkbmIndex.Clear;
begin
     FReferences.Clear;
     FOrdered:=false;
end;

function TkbmIndex.FindRecordNumber(RecordBuffer:PChar):integer;
var
   i:integer;
begin
     for i:=0 to FReferences.Count-1 do
         if FReferences.Items[i]=RecordBuffer then
         begin
              Result:=i;
              exit;
         end;
     Result:=-1;
end;

procedure TkbmIndex.LoadAll;
var
   i:integer;
   lst:TList;
begin
     Clear;
     FOrdered:=false;

     lst:=FDataSet.FRecords.LockList;
     try
        FReferences.Capacity:=lst.Count;
        with FDataSet do
        begin
             // Add the records.
             for i:=0 to lst.Count-1 do
                 if lst.Items[i]<>nil then FReferences.Add(lst.Items[i]);
        end;
     finally
        FDataSet.FRecords.UnlockList;
     end;
end;

procedure TkbmIndex.ReSort;
var
   i:integer;
begin
     // If not sorted, dont bother to sort the index.
     if FType=mtitNonSorted then exit;

     // Lock the record list for our use, to make sure nobody alters it.
     FDataSet.Progress(0,mtpcSort);
     FDataSet.FState:=mtstSort;
     FDataSet.FRecords.LockList;
     try
        // Sort the index.
{$IFDEF USE_FASTQUICKSORT}
        FastQuickSort(0,FReferences.Count-1);
{$ELSE}
        QuickSort(0,FReferences.Count-1);
{$ENDIF}

        // If unique index, look for duplicates.
        if ixUnique in FIndexOptions then
           for i:=1 to FReferences.Count-1 do
               if CompareRecords(FIndexFieldList,FReferences.Items[i-1],FReferences.Items[i],false,FOptions)=0 then
                  raise EMemTableError.Create(kbmDupIndex);
     finally
        FDataSet.FRecords.UnlockList;
        FDataSet.Progress(100,mtpcSort);
        FDataSet.FState:=mtstBrowse;
     end;
end;

procedure TkbmIndex.Rebuild;
begin
     if FDataset.Active then
     begin
          if not FIsView then LoadAll;
          if FReferences.Count>0 then ReSort;
     end
     else
         FOrdered:=true;
end;

// -----------------------------------------------------------------------------------
// TkbmIndexes
// -----------------------------------------------------------------------------------
constructor TkbmIndexes.Create(DataSet:TkbmCustomMemTable);
begin
     inherited Create;
     FIndexes:=TStringList.Create;
     FRowOrderIndex:=TkbmIndex.Create(kbmRowOrderIndex,DataSet,'',[],mtitNonSorted,true);
     FRowOrderIndex.FRowOrder:=true;
     AddIndex(FRowOrderIndex);
     FDataSet:=DataSet;
end;

destructor TkbmIndexes.Destroy;
var
   i:integer;
begin
     for i:=0 to FIndexes.count-1 do
         TList(FIndexes.Objects[i]).free;
     FIndexes.free;
     inherited;
end;

procedure TkbmIndexes.Clear;
var
   i:integer;
   lIndex:TkbmIndex;
begin
     for i:=FIndexes.Count-1 downto 0 do
     begin
          lIndex:=TkbmIndex(FIndexes.Objects[i]);
          lIndex.Clear;
          if lIndex = FRowOrderIndex then continue;
          if lIndex = FDataSet.FCurIndex then FDataSet.FCurIndex:=FRowOrderIndex;
          if lIndex = FDataSet.FSortIndex then FDataSet.FSortIndex := nil;
          lIndex.free;
          FIndexes.delete(i);
     end;
end;

function TkbmIndexes.Count:integer;
begin
     Result:=FIndexes.Count;
end;

function TkbmIndexes.Get(IndexName:string):TkbmIndex;
var
   iIndex:integer;
begin
     iIndex:=FIndexes.IndexOf(IndexName);
     if iIndex<0 then raise EMemTableError.CreateFmt(kbmIndexNotExist,[IndexName]);
     Result:=TkbmIndex(FIndexes.Objects[iIndex]);
end;

// Lookup first index on specified fieldnames.
function TkbmIndexes.GetByFieldNames(FieldNames:string):TkbmIndex;
var
   iIndex:integer;
begin
     Result:=nil;
     FieldNames:=UpperCase(FieldNames);
     for iIndex:=0 to FIndexes.count-1 do
         if UpperCase(TkbmIndex(FIndexes.Objects[iIndex]).FIndexFields) = FieldNames then
         begin
              Result:=TkbmIndex(FIndexes.Objects[iIndex]);
              break;
         end;
end;

procedure TkbmIndexes.AddIndex(Index:TkbmIndex);
begin
     Index.FIndexOfs:=FIndexes.count;
     FIndexes.AddObject(Index.FName,Index);
end;

procedure TkbmIndexes.Add(IndexDef:TIndexDef);
var
   lIndex:TkbmIndex;
begin
     if (IndexDef.Name='') or (IndexDef.Fields='') then
        raise EMemTableError.Create(kbmMissingNames);

     lIndex:=TkbmIndex.Create(IndexDef.Name,FDataSet,IndexDef.Fields,IndexDef.Options,mtitSorted,false);
     AddIndex(lIndex);
end;

procedure TkbmIndexes.DeleteIndex(Index:TkbmIndex);
var
   iIndex:integer;
   lIndex:TkbmIndex;
begin
     // Dont allow deletion of roworder index.
     if Index=FRowOrderIndex then exit;
     if Index=FDataSet.FCurIndex then FDataSet.FCurIndex:=FRowOrderIndex;

     for iIndex:=0 to FIndexes.count-1 do
     begin
          lIndex:=TkbmIndex(FIndexes.Objects[iIndex]);
          if lIndex=Index then
          begin
               FIndexes.delete(iIndex);
               break;
          end;
     end;

     // Renumber rest indexes.
     while (iIndex<FIndexes.count-1) do
     begin
          lIndex:=TkbmIndex(FIndexes.Objects[iIndex]);
          dec(lIndex.FIndexOfs);
     end;
end;

procedure TkbmIndexes.Delete(IndexName:string);
var
   iIndex:integer;
   lIndex:TkbmIndex;
begin
     iIndex:=FIndexes.IndexOf(IndexName);
     if iIndex<0 then raise EMemTableError.CreateFmt(kbmIndexNotExist,[IndexName]);
     lIndex:=TkbmIndex(FIndexes.Objects[iIndex]);

     // Dont allow deletion of roworder index.
     if lIndex=FRowOrderIndex then exit;
     if lIndex=FDataSet.FCurIndex then FDataSet.FCurIndex:=FRowOrderIndex;
     DeleteIndex(lIndex);
end;

procedure TkbmIndexes.Empty(IndexName:string);
var
   lIndex:TkbmIndex;
begin
     // Get reference to index reference list.
     lIndex:=Get(IndexName);
     lIndex.Clear;
end;

procedure TkbmIndexes.EmptyAll;
var
   iIndex:integer;
   lIndex:TkbmIndex;
begin
     for iIndex:=0 to FIndexes.Count-1 do
     begin
          lIndex:=TkbmIndex(FIndexes.Objects[iIndex]);
          lIndex.Clear;
     end;
end;

procedure TkbmIndexes.ReBuild(IndexName:string);
var
   lIndex:TkbmIndex;
begin
     // Get reference to index reference list.
     if not FDataSet.Active then exit;
     lIndex:=Get(IndexName);
     lIndex.Rebuild;
     if lIndex=FDataSet.FCurIndex then
     begin
          if FDataSet.FRecNo>=lIndex.FReferences.Count then FDataSet.FRecNo:=lIndex.FReferences.Count-1;
          FDataSet.Resync([]);
     end;
end;

procedure TkbmIndexes.ReBuildAll;
var
   iIndex:integer;
   lIndex:TkbmIndex;
begin
     for iIndex:=0 to FIndexes.Count-1 do
     begin
          lIndex:=TkbmIndex(FIndexes.Objects[iIndex]);
          lIndex.Rebuild;
          if (lIndex=FDataSet.FCurIndex) and FDataSet.Active then FDataSet.Resync([]);
     end;
end;

// Search for keyrecord on specified fields.
// Aut. selects the optimal search method depending if an index is available.
// CurIndex is a reference to the current index, that is the one the Index value will refer
// to as a result.
function TkbmIndexes.Search(FieldList:TList; KeyRecord:PkbmRecord; Nearest,RespectFilter:boolean; var Index:integer;
                            Options:TkbmMemTableCompareOptions):integer;
var
   i:integer;
   pRec:PkbmRecord;
begin
     // Check if searching on current index, do fast search.
     Index:=-1;
     Result:=0;
     if FDataSet.IsFieldListsEqual(FDataSet.FCurIndex.FIndexFieldList,FieldList) then
     begin
          Result:=FDataSet.FCurIndex.Search(KeyRecord,Nearest,RespectFilter,Index,Options);
          exit;
     end;

     // No compatible indexes found, do a sequential search on current index.
     with FDataSet.FCurIndex do
     begin
          for i:=0 to FReferences.Count-1 do
          begin
               // Check if to recalc before compare.
               pRec:=PkbmRecord(FReferences.Items[i]);
               with FDataSet do
               begin
                    if FRecalcOnIndex then
                    begin
                         //fill calc fields part of buffer
                         ClearCalcFields(PChar(pRec));
                         GetCalcFields(PChar(pRec));
                    end;
               end;

               // Check key record equal to record.
               Result:=CompareRecords(FieldList,KeyRecord,pRec,false,Options);
               if ((not RespectFilter) or FDataset.FilterRecord(pRec)) and (Result=0) or (Nearest and (Result<0)) then
               begin
                    Index:=i;
                    exit;
               end;
          end;
     end;
end;

// Check a record for acceptance regarding indexdefinitions.
procedure TkbmIndexes.CheckRecordUniqueness(ARecord:PkbmRecord; ActualRecord:PkbmRecord);
var
   i:integer;
   iResult:integer;
   lIndex:TkbmIndex;
begin
     // If indexes not enabled, dont make uniqueness test.
     if not FDataSet.FEnableIndexes then exit;

     // Check all indexes for uniqueness.
     for i:=0 to FIndexes.Count-1 do
     begin
          lIndex:=TkbmIndex(FIndexes.Objects[i]);
          with lIndex do
          begin
{$IFNDEF LEVEL3}
               if (ixNonMaintained in FIndexOptions) then continue;
{$ENDIF}

               // Check if unique index and duplicate key, complain.
               if (ixUnique in FIndexOptions)
                  and ((Search(ARecord,false,false,iResult,FOptions)=0) and (iResult>=0))
                  and (lIndex.FReferences.Items[iResult] <> ActualRecord) then
                  raise EMemTableError.Create(kbmDupIndex);
          end;
     end;
end;

// Call this during insert, append, edit or delete of record to update the index lists.
// OldRecord contains a reference to the actual 'physical' record.
// NewRecord points to a buffer which contains the new value soon to be copied into OldRecord. (Edit)
// NewRecord is nil on append or insert since OldRecord allready will contain values.
// RecordPos specifies current FRecNo.
// Returns pos in current index for operation.
procedure TkbmIndexes.UpdateIndexes(How:TkbmIndexUpdateHow;OldRecord,NewRecord:PkbmRecord; RecordPos:integer);
var
   i:integer;
   lIndex:TkbmIndex;
   IsRowOrderIndex,IsCurIndex:boolean;
   iInsert,iDelete:integer;
begin
     // Loop through all indexes.
     for i:=0 to FIndexes.count-1 do
     begin
          lIndex:=TkbmIndex(FIndexes.Objects[i]);

          IsRowOrderIndex:=(lIndex = FRowOrderIndex);
          IsCurIndex:=(lIndex = FDataSet.FCurIndex);

          with lIndex do
          begin
               // Check if to skip updating this index.
               if {$IFNDEF LEVEL3}(ixNonMaintained in FIndexOptions) or {$ENDIF}(not FDataSet.FEnableIndexes) then
               begin
                    FOrdered:=false;
                    continue;
               end;
               FOrdered:=true;

               // Check how to update index.
               case How of
                    mtiuhEdit:
                       begin
                            // Is it the roworder index? Dont do anything since it wont change anything.
                            if IsRowOrderIndex then continue;

                            // Do not update indexes if key has not changed.
                            if lIndex.CompareRecords(lIndex.FIndexFieldList,OldRecord,NewRecord,false,lIndex.FOptions)=0 then continue;

                            // Search the original position.
                            // Is it the current index, then use FRecNo, otherwise look for it.
                            if IsCurIndex and (RecordPos>=0) then
                               iDelete:=RecordPos
                            else
                            begin
                                 iDelete:=-1;
                                 SearchRecord(OldRecord,iDelete,false,FOptions);
                            end;
                            if iDelete<0 then raise EMemTableError.Create(kbmKeyFieldsChanged);

                            // Delete from old place in index.
                            FReferences.Delete(iDelete);

                            // If any references left, look for nearest insertion place.
                            iInsert:=-1;
                            Search(NewRecord,true,false,iInsert,FOptions);

                            // If found insertion place, insert.
                            if iInsert>=0 then
                               // Insert the reference at new place.
                               FReferences.Insert(iInsert,OldRecord)
                            else
                               // Add reference to list.
                               iInsert:=FReferences.Add(OldRecord);

                            if IsCurIndex then FDataset.FReposRecNo:=iInsert;
                       end;

                    mtiuhInsert:
                       begin
                            // Is it the roworder index? Is it the same as the one we are looking at?
                            if IsRowOrderIndex then
                            begin
                                 if IsCurIndex then
                                    iInsert:=RecordPos
                                 else
                                     iInsert:=-1;
                            end
                            else if FReferences.Count>0 then
                            begin
                                 iInsert:=-1;
                                 Search(NewRecord,true,false,iInsert,FOptions);
                            end
                            else
                                iInsert:=-1;

                            // Figure out if to append or to insert to index.
                            if (iInsert<0) or (iInsert>=FReferences.Count) then
                            begin
                                 // Append reference to index.
                                 iInsert:=FReferences.Add(NewRecord);
                            end
                            else
                               // Insert reference.
                               FReferences.Insert(iInsert,NewRecord);

                            if IsCurIndex then FDataset.FReposRecNo:=iInsert;
                       end;

                    mtiuhDelete:
                       begin
                            if FReferences.Count>0 then
                            begin
                                 iDelete:=-1;

                                 // Is it the roworder index?
                                 if IsRowOrderIndex then
                                    SearchRecordID(OldRecord^.RecordID,iDelete)
                                 else
                                     SearchRecord(OldRecord,iDelete,false,FOptions);
                                 if iDelete>=0 then FReferences.Delete(iDelete);

                                 if IsCurIndex then FDataset.FReposRecNo:=iDelete;
                            end;
                       end;
               end;
          end;
     end;
end;

// -----------------------------------------------------------------------------------
// TkbmJournal
// -----------------------------------------------------------------------------------
constructor TkbmJournal.Create(AMemTable:TkbmCustomMemTable);
begin
     inherited Create;
     FJournal:=TkbmCustomMemTable.Create(nil);
     FDataset:=AMemTable;

     // Generate journalfields.
     CreateJournalFields;
     FJournal.Open;
end;

destructor TkbmJournal.Destroy;
begin
     FJournal.Close;
     FJournal.Free;
     FJournal:=nil;
     inherited;
end;

procedure TkbmJournal.CreateJournalFields;
begin
     FJournal.Close;
     FJournal.DestroyFields;
     FJournal.FieldDefs.Assign(FDataSet.FieldDefs);
     FJournal.FieldDefs.Add(kbmJournalOperationField,ftInteger{$IFNDEF LEVEL5},0,true{$ENDIF});
     FJournal.FieldDefs.Add(kbmJournalRecordTypeField,ftInteger{$IFNDEF LEVEL5},0,true{$ENDIF});
     FJournal.CreateFields;
end;

procedure TkbmJournal.Add(AOperation:TkbmJournalOperation;ARec:PkbmRecord;AOrigRec:PkbmRecord);
   procedure AddRecord(AOperation:TkbmJournalOperation; ARecordType:integer; ARec:PkbmRecord);
   var
      i:integer;
   begin
        FDataset.FRecords.LockList;
        try
           FJournal.Append;
           FJournal.FieldByName(kbmJournalOperationField).asinteger:=ord(AOperation);
           FJournal.FieldByName(kbmJournalRecordTypeField).asinteger:=ARecordType;

           FDataset.FOverrideActiveRecordBuffer:=ARec;
           try
              for i:=0 to FDataSet.FieldCount-1 do
                  FJournal.Fields[i].AsVariant:=FDataSet.Fields[i].AsVariant;
           finally
              FDataset.FOverrideActiveRecordBuffer:=nil;
           end;

           FJournal.Post;

        finally
           FDataset.FRecords.UnlockList;
        end;
   end;
begin
     if not FJournal.Active then exit;

     case AOperation of
          mtjoInsert: AddRecord(AOperation,1,ARec);
          mtjoEdit:
                 begin
                      AddRecord(AOperation,2,AOrigRec);
                      AddRecord(AOperation,1,ARec);
                 end;
          mtjoDelete: AddRecord(AOperation,2,AOrigRec);
     end;
end;

procedure TkbmJournal.Empty;
begin
     if FJournal.Active then FJournal.EmptyTable;
end;

// -----------------------------------------------------------------------------------
// TkbmCustomMemTable
// -----------------------------------------------------------------------------------

// Lowlevel record handling routines.

// Allocate space for a record structure.
function TkbmCustomMemTable._InternalAllocRecord:PkbmRecord;
begin
     GetMem(Result,SizeOf(TkbmRecord)+FRecordDataSize);
     Result^.Data:=PChar(Result)+SizeOf(TkbmRecord);
     _InternalClearRecord(Result);
end;

{$IFDEF DO_CHECKRECORD}
// Check record validity.
procedure TkbmCustomMemTable._InternalCheckRecord(ARecord:PkbmRecord);
begin
     // Check record identifier.
     if (ARecord^.StartIdent<>kbmRecordIdent) or (ARecord^.EndIdent<>kbmRecordIdent) then
        raise EMemTableError.Create(kbmInvalidRecord+inttostr(integer(ARecord)));
end;
{$ENDIF}

// Free var lengths in record.
procedure TkbmCustomMemTable._InternalFreeRecordVarLengths(ARecord:PkbmRecord);
var
   i:integer;
   pVarLength:PPkbmVarLength;
   pField:PChar;
begin
     // Delete varlengths if any defined.
     if FVarLengthCount>0 then
     begin
          // Browse fields to delete varlengths.
          for i:=0 to FieldCount-1 do
          begin
               if mtffIndirect in FFieldFlag[i] then
               begin
                    pField:=GetFieldPointer(ARecord,Fields[i]);
                    pVarLength:=PPkbmVarLength(pField+1);
                    if (pVarLength^<>nil) then
                    begin
                         FreeVarLength(pVarLength^);
                         pVarLength^:=nil;
                         pField[0]:=#0;
                    end;
               end;
          end;
     end;
end;

// Deallocate space for a record.
procedure TkbmCustomMemTable._InternalFreeRecord(ARecord:PkbmRecord; FreeVarLengths,FreeVersions:boolean);
begin
     if ARecord=nil then exit;

{$IFDEF DO_CHECKRECORD}
     _InternalCheckRecord(ARecord);
{$ENDIF}
     if FreeVarLengths then _InternalFreeRecordVarLengths(ARecord);

     // Free record data, incl. previous versioning records if any.
     with ARecord^ do
     begin
           if FreeVersions and (PrevRecordVersion<>nil) then
           begin
                _InternalFreeRecord(PrevRecordVersion,FreeVarLengths,true);
                PrevRecordVersion:=nil;
           end;
           Data:=nil;
     end;

     // Free record.
     FreeMem(ARecord);
end;

// Clear record buffer.
procedure TkbmCustomMemTable._InternalClearRecord(ARecord:PkbmRecord);
begin
{$IFDEF DO_CHECKRECORD}
     _InternalCheckRecord(ARecord);
     ARecord^.StartIdent:=kbmRecordIdent;
     ARecord^.EndIdent:=kbmRecordIdent;
{$ENDIF}
     ARecord^.RecordNo:=-1;
     ARecord^.RecordID:=-1;
     ARecord^.UniqueRecordID:=-1;
     ARecord^.BookmarkData:=-1;
     ARecord^.Tag:=0;
     ARecord^.UpdateStatus:=usUnModified;
     ARecord^.PrevRecordVersion:=nil;
     ARecord^.TransactionLevel:=-1;
     FillChar(ARecord^.Data^,FRecordDataSize,0);
end;

// Allocate space for a duplicate record, and copy the info to it.
function TkbmCustomMemTable._InternalCopyRecord(SourceRecord:PkbmRecord;CopyVarLengths:boolean):PkbmRecord;
begin
{$IFDEF DO_CHECKRECORD}
     _InternalCheckRecord(SourceRecord);
{$ENDIF}

     Result:=_InternalAllocRecord;
     with Result^ do
     begin
          _InternalMoveRecord(SourceRecord,Result,false);
          if CopyVarLengths then _InternalCopyVarLengths(SourceRecord,Result);
     end;
end;

// Copy a var length from one record to another.
// If destination has a var length allready, it will be deleted.
procedure TkbmCustomMemTable._InternalCopyVarLength(SourceRecord,DestRecord:PkbmRecord; Field:TField);
var
   pFldSrc,pFldDest:PChar;
   pVarLenSrc,pVarLenDest:PPkbmVarLength;
   pVarLenClone:PkbmVarLength;
begin
     pFldSrc:=GetFieldPointer(SourceRecord,Field);
     pFldDest:=GetFieldPointer(DestRecord,Field);

     pVarLenSrc:=PPkbmVarLength(pFldSrc+1);
     pVarLenDest:=PPkbmVarLength(pFldDest+1);

     // Check if varlength in destination, then delete.
     if (pVarLenDest^ <> nil) then
     begin
          FreeVarLength(pVarLenDest^);
          pVarLenDest^:=nil;
          pFldDest[0]:=#0;  // Set field value to NULL.
     end;

     // Copy varlength from source to destination.
     if (pVarLenSrc^ <> nil) then
     begin
          pVarLenClone:=CopyVarLength(pVarLenSrc^);
          pVarLenDest^:=pVarLenClone;
          pFldDest[0]:=#1;  // Set field value to NOT NULL.
     end;
end;

// Copy var lengths from one record to another.
procedure TkbmCustomMemTable._InternalCopyVarLengths(SourceRec,DestRec:PkbmRecord);
var
   i:integer;
begin
     // Copy varlengths if any defined.
     if FVarLengthCount>0 then
     begin
          // Browse fields to copy varlengths.
          for i:=0 to FieldCount-1 do
              if mtffIndirect in FFieldFlag[i] then
                 _InternalCopyVarLength(SourceRec,DestRec,Fields[i]);
     end;
end;

// Compression of a field buffer.
function TkbmCustomMemTable.CompressFieldBuffer(Field:TField; const Buffer:pointer; var Size:longint):pointer;
begin
     case Field.DataType of
        ftString,ftFixedChar:
          begin
               // Store the 0 even if its taking up one extra byte in all cases.
               // Simplyfies decompression.
               Size:=strlen(PChar(Buffer))+1;
               Result:=Buffer;
          end;
        else
          begin
               Result:=Buffer;
          end;
     end;
end;

// Decompression of a field buffer.
// Since we at the time only handles strings truncated at the 0 char,
// simply return the buffer and allready known size.
function TkbmCustomMemTable.DecompressFieldBuffer(Field:TField; const Buffer:pointer; var Size:longint):pointer;
begin
     Result:=Buffer;
end;

// Move contents of one record to another.
// If not to move varlength fields, copies field contents by fieldcontents.
procedure TkbmCustomMemTable._InternalMoveRecord(SourceRecord,DestRecord:PkbmRecord; MoveVarLength:boolean);
begin
{$IFDEF DO_CHECKRECORD}
     _InternalCheckRecord(SourceRecord);
     DestRecord^.StartIdent:=kbmRecordIdent;
     DestRecord^.EndIdent:=kbmRecordIdent;
{$ENDIF}
     DestRecord^.RecordNo:=SourceRecord^.RecordNo;
     DestRecord^.BookmarkFlag:=SourceRecord^.BookmarkFlag;
     DestRecord^.BookmarkData:=SourceRecord^.BookmarkData;
     DestRecord^.UpdateStatus:=SourceRecord^.UpdateStatus;
     DestRecord^.PrevRecordVersion:=SourceRecord^.PrevRecordVersion;
     DestRecord^.Tag:=SourceRecord^.Tag;

     // Check if to move all data including blob data.
     if (MoveVarLength) then
        Move(SourceRecord^.Data^,DestRecord^.Data^,FRecordSize+FRecordCalcSize+FRecordVarLengthSize)
     else
         Move(SourceRecord^.Data^,DestRecord^.Data^,FRecordSize+FRecordCalcSize);
end;

{$IFDEF KBM}
// Move blob contents from one record to another.
procedure TkbmCustomMemTable._InternalMoveBlobs(SourceRecord,DestRecord:PkbmRecord);
var
   i:integer;
   pNullBlobSrc,pNullBlobDest:PChar;
   pBlobSrc,pBlobDest:PkbmBlob;
   BlobSrc,BlobDest:TkbmBlob;
begin
{$IFDEF DO_CHECKRECORD}
     _InternalCheckRecord(SourceRecord);
     _InternalCheckRecord(DestRecord);
{$ENDIF}

     // Move blobs if any defined.
     if FVarLengthCount>0 then
     begin
          // Browse fields to move blobs.
          for i:=0 to FieldCount-1 do
          begin
               if Fields[i].DataType in kbmBlobTypes then
               begin
                    pNullBlobSrc:=GetFieldPointer(SourceRecord,Fields[i]);
                    pNullBlobDest:=GetFieldPointer(DestRecord,Fields[i]);
                    pBlobSrc:=PkbmBlob(pNullBlobSrc+1);
                    pBlobDest:=PkbmBlob(pNullBlobDest+1);

                    // Copy null flag from source to dest.
                    pNullBlobDest^:=pNullBlobSrc^;

                    // Check if something in dest, but nothing in source. Deallocate dest and set it to null.
                    if (pBlobSrc^ = nil) or (pNullBlobSrc^=#0) then
                    begin
                         if (pBlobDest^ <> nil) then
                         begin
                              pBlobDest^.free;
                              pBlobDest^:=nil;
                         end;
                         continue;
                    end;

                    // Move contents of blob to dest.
                    BlobSrc:=pBlobSrc^;
                    BlobDest:=pBlobDest^;
                    FreeMem(BlobDest.FBuffer);
                    BlobDest.FLength:=BlobSrc.FLength;
                    BlobDest.FBuffer:=Allocmem(BlobSrc.FLength);
                    Move(BlobSrc.FBuffer^,BlobDest.FBuffer^,BlobDest.FLength);
               end;
          end;
     end;
end;
{$ENDIF}

// Compare two records.
function TkbmCustomMemTable._InternalCompareRecords(FieldList:TList; MaxFields:integer; KeyRecord,ARecord:PkbmRecord; Options:TkbmMemTableCompareOptions): Integer;
var
   i:integer;
   p1,p2:PChar;
   sz1,sz2:longint;
   pv1,pv2:PkbmVarLength;
   fld:TField;
   n:integer;
   igncase,partial,ignnullkey,ignlocale:boolean;
   flags:TkbmFieldFlags;
begin
     Result:=0;
     if (KeyRecord=nil) or (ARecord=nil) then exit;

{$IFDEF DO_CHECKRECORD}
     _InternalCheckRecord(KeyRecord);
     _InternalCheckRecord(ARecord);
{$ENDIF}

     n:=FieldList.Count;
     if (MaxFields>0) and (MaxFields<n) then n:=MaxFields;

     ignnullkey:=(mtcoIgnoreNullKey in Options);
     igncase:=(mtcoCaseInsensitive in Options);
     partial:=(mtcoPartialKey in Options);
     ignLocale:=(mtcoIgnoreLocale in Options);

     // Loop through all indexfields, left to right.
     for i:=0 to n-1 do
     begin
          fld:=TField(FieldList[i]);

          // Get data for specified field for the two records.
          p1:=GetFieldPointer(KeyRecord,fld);
          p2:=GetFieldPointer(ARecord,fld);

          // Check if to ignore null field in key record.
          if (ignnullkey) and (p1[0]=#0) then continue;

          // Check if both not null.
          if (p1[0]<>#0) and (p2[0]<>#0) then
          begin
               // Skip null flag.
               inc(p1);
               inc(p2);

               // Check if indirect fields.
               if (fld.FieldNo>=0) then
               begin
                    flags:=FFieldFlag[fld.FieldNo-1];
                    if (mtffIndirect in flags) then
                    begin
                         pv1:=PPkbmVarLength(p1)^;
                         p1:=GetVarLengthData(pv1);

                         pv2:=PPkbmVarLength(p2)^;
                         p2:=GetVarLengthData(pv2);

                         if (mtffCompress in flags) then
                         begin
                              sz1:=GetVarLengthSize(pv1);
                              sz2:=GetVarLengthSize(pv2);
                              if (Assigned(FOnDecompressField)) then
                              begin
                                   FOnDecompressField(self,fld,p1,sz1,p1);
                                   FOnDecompressField(self,fld,p2,sz2,p2);
                              end
                              else
                              begin
                                   p1:=DecompressFieldBuffer(fld,p1,sz1);
                                   p2:=DecompressFieldBuffer(fld,p2,sz2);
                              end;
                         end;
                    end;
               end;

               // Compare the fields.
               if (Assigned(FOnCompareFields)) then
               begin
                    Result:=0;
                    FOnCompareFields(self,p1,p2,fld.DataType,partial,igncase,ignLocale,Result);
               end
               else
                   Result:=CompareFields(p1,p2,fld.DataType,partial,igncase,ignLocale);
          end
          else if Boolean(p1[0]) then Result:=1
          else if Boolean(p2[0]) then Result:=-1;
          if Result<>0 then break;
     end;
end;

// Append record to chain of records.
procedure TkbmCustomMemTable._InternalAppendRecord(ARecord:PkbmRecord);
var
   d,r:integer;
   lst:TList;
begin
{$IFDEF DO_CHECKRECORD}
     _InternalCheckRecord(ARecord);
{$ENDIF}

     lst:=FRecords.LockList;
     try
        // Check if to reuse a deleted spot.
        if FDeletedRecords.Count>0 then
        begin
             d:=FDeletedRecords.Count-1;
             r:=Integer(FDeletedRecords.Items[d]);

             // Put 'physical' record number into record.
             ARecord^.RecordID:=r;
             FDeletedRecords.Delete(d);

             // Put unique record number into record.
             ARecord^.UniqueRecordID:=FUniqueRecordID;
             inc(FUniqueRecordID);

             lst.Items[r]:=ARecord;
        end
        else
        begin
             // Put 'physical' record number into record.
             ARecord^.RecordID:=FRecordID;
             inc(FRecordID);

             // Put unique record number into record.
             ARecord^.UniqueRecordID:=FUniqueRecordID;
             inc(FUniqueRecordID);

             lst.Add(ARecord);

             // Check if running out of valid bookmark ID's.
             // Very unlikely (needs inserting 2 billion records), but possible.
             if FRecordID>=2147483600 then
                raise EMemTableError.Create(kbmOutOfBookmarks);
        end;

        if IsVersioning then ARecord^.UpdateStatus:=usInserted;
     finally
        FRecords.UnlockList;
     end;
end;

// Delete record from chain.
procedure TkbmCustomMemTable._InternalDeleteRecord(ARecord:PkbmRecord);
var
   lst:TList;
begin
     if ARecord=nil then exit;

{$IFDEF DO_CHECKRECORD}
     _InternalCheckRecord(ARecord);
{$ENDIF}

     lst:=FRecords.LockList;
     try
        FDeletedRecords.Add(pointer(ARecord.RecordID));
        lst.Items[ARecord.RecordID]:=nil;
     finally
        FRecords.UnlockList;
     end;

     _InternalFreeRecord(ARecord,true,true);
end;

// Pack records.
procedure TkbmCustomMemTable._InternalPackRecords;
var
   i:integer;
   lst:TList;
begin
     lst:=FRecords.LockList;
     try
        lst.Pack;
        for i:=0 to lst.Count-1 do
            if lst.Items[i]<>nil then PkbmRecord(lst.Items[i])^.RecordID:=i;
     finally
        FRecords.UnlockList;
     end;
end;

constructor TkbmCustomMemTable.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     FRecordID:=0;
     FUniqueRecordID:=0;

     FTransactionLevel:=0;

     // Default all load operations should load all records.
     FLoadLimit:=-1;
     FLoadCount:=-1;
     FLoadedCompletely:=false;

     // Suppose standalone table.
     // If FAttachedTo points to another memtable, FRecords and FDeletedRecords will point
     // to the other tables FRecords and FDeletedRecords.
     FAttachedChildren:=TThreadList.Create;
     FAttachedTo:=nil;
     FAttachedAutoRefresh:=true;
     FRecords:=TThreadList.Create;
     FDeletedRecords:=TList.Create;

     FJournal:=nil;
     FEnableJournal:=false;

     FEnableVersioning:=false;
     FVersioningMode:=mtvm1SinceCheckPoint;
     FAutoReposition:=false;

     FPerformance:=mtpfFast;

     FRecNo:=-1;

     FAutoIncMin:=0;

     FPersistent:=false;
     FRecalcOnIndex:=false;
     FRecalcOnFetch:=true;

     FProgressFlags:=[mtpcSave,mtpcLoad,mtpcCopy];
     FState:=mtstBrowse;

{$IFDEF LEVEL5}
     FFilterParser:=nil;
{$ENDIF}

     FIndexList:=TList.Create;
     FMasterIndexList:=TList.Create;
     FIndexDefs:=TIndexDefs.Create(Self);
     FIndexes:=TkbmIndexes.Create(Self);
     FSortIndex:=nil;
     FEnableIndexes:=true;

     FPersistentSaveOptions:=[mtfSaveData,mtfSaveNonVisible,mtfSaveIgnoreRange,mtfSaveIgnoreMasterDetail];
     FPersistentSaveFormat:=mtsfBinary;
     FCommaTextOptions:=[mtfSaveData];
     FAllDataOptions:=[mtfSaveNonVisible,mtfSaveBlobs,mtfSaveFiltered,mtfSaveIgnoreRange,mtfSaveIgnoreMasterDetail,mtfSaveData,mtfSaveDeltas];

     FCSVQuote:='"';
     FCSVFieldDelimiter:=',';
     FCSVRecordDelimiter:=',';

     FStoreDataOnForm:=false;
     FTempDataStorage:=nil;

     FMasterLink:=TMasterDataLink.Create(Self);
     FMasterLink.OnMasterChange:=MasterChanged;
     FMasterLink.OnMasterDisable:=MasterDisabled;
end;

destructor TkbmCustomMemTable.Destroy;
begin
     // Close table.
     if Active then SavePersistent;
     Close;

     // Check if temporary data storage left over.
     if FTempDataStorage<>nil then FTempDataStorage.free;
     FTempDataStorage:=nil;

{$IFDEF LEVEL5}
     // Delete filterbuffers if assigned.
     FreeFilter;
{$ENDIF}

     // Must be before deletion of records, otherwise it fails.
     inherited Destroy;

     // Delete allocated memory.
     FMasterLink.free;     FMasterLink:=nil;
     FIndexList.free;      FIndexList:=nil;
     FMasterIndexList.Free;FMasterIndexList:=nil;
     FIndexes.free;        FIndexes:=nil;

     // Dont delete if attached to.
     if FAttachedTo=nil then
     begin
          FRecords.free;        FRecords:=nil;
          FDeletedRecords.free; FDeletedRecords:=nil;
     end
     else
         FAttachedTo.DeAttachChild(Self);
     FAttachedChildren.free;

     // Free index definitions.
     FIndexDefs.free;      FIndexDefs:=nil;
end;

procedure TkbmCustomMemTable.Loaded;
begin
     inherited;
end;

{$IFDEF LEVEL5}
procedure TkbmCustomMemTable.DataEvent(Event: TDataEvent; Info: Longint);
begin
     inherited;
end;
{$ENDIF}

procedure TkbmCustomMemTable.Progress(Pct:integer; Code:TkbmProgressCode);
begin
     if Assigned(FOnProgress) and (Code in FProgressFlags) then FOnProgress(self,Pct,Code);
end;

function TkbmCustomMemTable.GetDeletedRecordsCount:integer;
begin
     Result:=FDeletedRecords.count;
end;

// Get current component version.
function TkbmCustomMemTable.GetVersion:string;
begin
     Result:=COMPONENT_VERSION;
end;

// Handle saving and loading static data from the form.
procedure TkbmCustomMemTable.DefineProperties(Filer:TFiler);
begin
     inherited;
     Filer.DefineBinaryProperty('Data', ReadData, WriteData, FStoreDataOnForm);
end;

procedure TkbmCustomMemTable.ReadData(Stream:TStream);
begin
     if FTempDataStorage<>nil then
     begin
          FTempDataStorage.free;
          FTempDataStorage:=nil;
     end;
     FTempDataStorage:=TMemoryStream.Create;
     FTempDataStorage.LoadFromStream(Stream);
end;

procedure TkbmCustomMemTable.WriteData(Stream:TStream);
begin
     if Active then
        InternalSaveToBinaryStream(Stream,[mtfSaveNonVisible,mtfSaveBlobs,mtfSaveDef,mtfSaveFiltered,mtfSaveIgnoreRange,mtfSaveIgnoreMasterDetail,mtfSaveData]);
end;

// Update the properties if some component we are dependent on is removed.
procedure TkbmCustomMemTable.Notification(AComponent: TComponent; Operation: TOperation);
begin
     inherited Notification(AComponent, Operation);
     if Operation=opRemove then
     begin
          if AComponent=FMasterLink.DataSource then FMasterLink.DataSource:=nil
          else if AComponent=FDeltaHandler then
          begin
               (AComponent as TkbmCustomDeltaHandler).FDataSet:=nil;
               FDeltaHandler:=nil;
          end
          else if AComponent=FAttachedTo then FAttachedTo:=nil;
     end;
end;

// Set minimum autoinc value.
procedure TkbmCustomMemTable.SetAutoIncMinValue(AValue:integer);
begin
     FAutoIncMin:=AValue;
     if FAutoIncMax<FAutoIncMin then FAutoIncMax:=FAutoIncMin-1;
end;

// Set performance.
procedure TkbmCustomMemTable.SetPerformance(AValue:TkbmPerformance);
begin
     if Active then
        raise EMemTableError.Create(kbmTableMustBeClosed);
     FPerformance:=AValue;
end;

// Set transaction level.
procedure TkbmCustomMemTable.StartTransaction;
begin
     if not active then exit;
     if (not IsVersioning) or (VersioningMode <> mtvmAllSinceCheckPoint) then
        raise EMemTableError.Create(kbmTransactionVersioning);

     inc(FTransactionLevel);
end;

// Rollback transaction.
procedure TkbmCustomMemTable.Rollback;
var
   lst:TList;
   i:integer;
   pRec:PkbmRecord;
begin
     // Check if transaction started.
     if not active or (FTransactionLevel<=0) then exit;

     // Loop through all records and discard newest current transactions.
     lst:=FRecords.LockList;
     try
        for i:=0 to lst.count-1 do
        begin
             pRec:=PkbmRecord(lst.Items[i]);
             if pRec=nil then continue;

             // While same transaction level.
             while pRec^.TransactionLevel=FTransactionLevel do
             begin
                  // Check what happened with this version.
                  case pRec^.UpdateStatus of

                       // Inserted, delete it again.
                       usInserted:
                         begin
                              _InternalFreeRecord(pRec,true,true);
                              lst.Items[i]:=nil;
                              break;
                         end;

                       // Marked for deletion or modified, change to older version.
                       usDeleted,
                       usModified:
                         begin
                              lst.Items[i]:=pRec^.PrevRecordVersion;
                              _InternalFreeRecord(pRec,true,false);
                         end;

                       // Done nothing. Skip.
                       usUnmodified: break;
                  end;
                  pRec:=lst.Items[i];
             end;
        end;
     finally
        dec(FTransactionLevel);
        FIndexes.ReBuildAll;
        FRecords.UnlockList;
        Resync([]);
     end;
end;

// Commit transaction.
procedure TkbmCustomMemTable.Commit;
var
   lst:TList;
   i:integer;
   pRec,pRec1:PkbmRecord;
begin
     // Check if transaction started.
     if not active or (FTransactionLevel<=0) then exit;

     // Loop through all records and discard older transactions.
     lst:=FRecords.LockList;
     try
        for i:=0 to lst.count-1 do
        begin
             pRec:=PkbmRecord(lst.Items[i]);
             if pRec=nil then continue;

             // While same transaction level, use newest, discard rest.
             pRec1:=pRec^.PrevRecordVersion;

             while (pRec1<>nil) and (pRec1^.TransactionLevel=FTransactionLevel) do
             begin
                  _InternalFreeRecord(pRec1,true,true);
                  pRec1:=pRec1^.PrevRecordVersion;
             end;
             pRec^.PrevRecordVersion:=pRec1;
        end;
     finally
        dec(FTransactionLevel);
        FIndexes.ReBuildAll;
        FRecords.UnlockList;
        Resync([]);
     end;
end;

// Get number of versions of the current record.
function TkbmCustomMemTable.GetVersionCount:integer;
var
   pRec:PkbmRecord;
begin
     Result:=1;

     if not Active then raise EMemTableError.Create(kbmNoCurrentRecord);
     pRec:=GetActiveRecord;
     if pRec=nil then raise EMemTableError.Create(kbmNoCurrentRecord);

     while pRec^.PrevRecordVersion<>nil do
     begin
          inc(Result);
          pRec:=pRec^.PrevRecordVersion;
     end;
end;

// Get data of a specific version of a record.
function TkbmCustomMemTable.GetVersionFieldData(Field:TField; Version:integer):variant;
var
   pRec:PkbmRecord;
begin
     if not Active then raise EMemTableError.Create(kbmNoCurrentRecord);
     pRec:=GetActiveRecord;
     if pRec=nil then raise EMemTableError.Create(kbmNoCurrentRecord);

     while (Version>0) and (pRec^.PrevRecordVersion<>nil) do
     begin
          dec(Version);
          pRec:=pRec^.PrevRecordVersion;
     end;

     FOverrideActiveRecordBuffer:=pRec;
     try
        Result:=Field.AsVariant;
     finally
        FOverrideActiveRecordBuffer:=nil;
     end;
end;

// Get TUpdateStatus of a specific version of a record.
function TkbmCustomMemTable.GetVersionStatus(Version:integer):TUpdateStatus;
var
   pRec:PkbmRecord;
begin
     if not Active then raise EMemTableError.Create(kbmNoCurrentRecord);
     pRec:=GetActiveRecord;
     if pRec=nil then raise EMemTableError.Create(kbmNoCurrentRecord);

     while (Version>0) and (pRec^.PrevRecordVersion<>nil) do
     begin
          dec(Version);
          pRec:=pRec^.PrevRecordVersion;
     end;

     Result:=pRec^.UpdateStatus;
end;

// Called by attaching child.
procedure TkbmCustomMemTable.DeAttachChild(Value:TkbmCustomMemTable);
var
   lst:TList;
   i:integer;
begin
     lst:=FAttachedChildren.LockList;
     try
        i:=lst.IndexOf(Value);
        if i>=0 then lst.Delete(i);
     finally
        FAttachedChildren.UnlockList;
     end;
end;

// Called by deattaching child.
procedure TkbmCustomMemTable.AttachChild(Value:TkbmCustomMemTable);
var
   lst:TList;
begin
     lst:=FAttachedChildren.LockList;
     try
        lst.Add(Value);
     finally
        FAttachedChildren.UnlockList;
     end;
end;

// Called to notify attached children of updates/changes to the records.
procedure TkbmCustomMemTable.AttachedChildrenNotify;
begin
end;

// Called to get attached children to refresh themselfs.
procedure TkbmCustomMemTable.AttachedChildrenRefresh(Caller:TkbmCustomMemTable);
var
   lst:TList;
   i:integer;
begin
     lst:=FAttachedChildren.LockList;
     try
        for i:=0 to lst.count-1 do
            if TkbmCustomMemTable(lst.Items[i])<>Caller then
               with TkbmCustomMemTable(lst.Items[i]) do
                    if Active and (State in [dsBrowse]) then Refresh;
     finally
            FAttachedChildren.UnlockList;
     end;
end;

// Update indexes of all attached children.
procedure TkbmCustomMemTable.AttachedChildrenUpdateIndexes(How:TkbmIndexUpdateHow;OldRecord,NewRecord:PkbmRecord);
var
   lst:TList;
   i:integer;
begin
     lst:=FAttachedChildren.LockList;
     try
        for i:=0 to lst.count-1 do
            with TkbmCustomMemTable(lst.Items[i]) do
            begin
                 if Active then
                    FIndexes.UpdateIndexes(How,OldRecord,NewRecord,-1);
            end;
     finally
        FAttachedChildren.UnlockList;
     end;
end;

procedure TkbmCustomMemTable.AttachedChildrenCheckRecordUniqueness(ARecord,ActualRecord:PkbmRecord);
var
   lst:TList;
   i:integer;
begin
     lst:=FAttachedChildren.LockList;
     try
        for i:=0 to lst.count-1 do
            with TkbmCustomMemTable(lst.Items[i]) do
            begin
                 if Active then
                    FIndexes.CheckRecordUniqueness(ARecord,ActualRecord);
            end;
     finally
        FAttachedChildren.UnlockList;
     end;
end;

procedure TkbmCustomMemTable.DoCascadeUpdateIndexes(How:TkbmIndexUpdateHow;OldRecord,NewRecord:PkbmRecord; RecordPos:integer);
begin
     FIndexes.UpdateIndexes(How,OldRecord,NewRecord,RecordPos);
     AttachedChildrenUpdateIndexes(How,OldRecord,NewRecord);
end;

procedure TkbmCustomMemTable.AddIndex(const Name, Fields: string; Options: TIndexOptions{$IFDEF LEVEL5}; const DescFields:string{$ENDIF});
begin
     FIndexDefs.Add(Name,Fields,Options);
     FIndexDefs.Updated:=true;
     try
        UpdateIndexes;
     except
        DeleteIndex(Name);
        UpdateIndexes;
        raise;
     end;
end;

procedure TkbmCustomMemTable.AddIndex2(const Name, Fields: string; Options: TIndexOptions; ExtraOptions: TkbmMemTableCompareOptions{$IFDEF LEVEL5}; const DescFields:string{$ENDIF});
var
   Index:TkbmIndex;
begin
     FIndexDefs.Add(Name,Fields,Options);
     FIndexDefs.Updated:=true;
     try
        Index:=TkbmIndex.Create(Name,self,Fields,Options,mtitSorted,false);
        Index.FOptions:=Index.FOptions + ExtraOptions;
        FIndexes.AddIndex(Index);
        UpdateIndexes;
     except
        DeleteIndex(Name);
        UpdateIndexes;
        raise;
     end;
end;

procedure TkbmCustomMemTable.DeleteIndex(const Name: string);
var
   i:integer;
{$IFNDEF LEVEL5}
   id:TIndexDefs;
{$ENDIF}
begin
{$IFDEF LEVEL5}
     i:=FIndexDefs.IndexOf(Name);
     if i>=0 then
     begin
          FIndexDefs.Delete(i);
          UpdateIndexes;
     end;
{$ELSE}
{$IFDEF LEVEL3}
     // D3 missing delete method. Need to rebuild indexdefs.
     id:=TIndexDefs.Create(self);
     try
        id.Assign(FIndexDefs);
        FIndexDefs.Clear;
        for i:=0 to id.Count-1 do
            if id.Items[i].Name<>Name then
               FIndexDefs.Add(id.Items[i].Name,id.Items[i].Fields,id.Items[i].Options);
     finally
        id.free;
     end;
{$ELSE}
     // D4 missing delete method. Need to rebuild indexdefs.
     id:=TIndexDefs.Create(self);
     try
        id.Assign(FIndexDefs);
        FIndexDefs.Clear;
        for i:=0 to id.Count-1 do
            if id.Items[i].Name<>Name then
               FIndexDefs.AddIndexDef.Assign(id.Items[i]);
     finally
        id.free;
     end;
{$ENDIF}
{$ENDIF}
     FIndexDefs.Updated:=true;
end;

procedure TkbmCustomMemTable.SwitchToIndex(Index:TkbmIndex);
var
   id:integer;
begin
     if Index=FCurIndex then exit;

     id:=-1;
     if Active then
     begin
          CheckBrowseMode;
          id:=PkbmRecord(ActiveBuffer)^.RecordID;
     end;

     CancelRange;
     UpdateCursorPos;

     if Index=nil then Index:=FIndexes.FRowOrderIndex;

     if (Index<>FCurIndex) then
     begin
          if Index.FInternal then
          begin
               FIndexFieldNames:='';
               FIndexName:='';
          end
          else
          begin
               FIndexFieldNames:=Index.FIndexFields;
               FIndexName:=Index.FName;
          end;
          FCurIndex:=Index;
     end;

     BuildFieldList(self,FIndexList,FIndexFieldNames);

     try
        // Repos recordno.
        if FRecNo>=FCurIndex.FReferences.Count then FRecNo:=FCurIndex.FReferences.Count-1;
        if Active and (FRecNo>=0) then
        begin
             FCurIndex.SearchRecordID(id,FRecNo);
             Resync([]);
        end;
     except
        SetState(dsInactive);
        CloseCursor;
        raise;
     end;
end;

procedure TkbmCustomMemTable.SetIndexFieldNames(FieldNames:string);
var
   lIndex:TkbmIndex;
begin
     if Active then
     begin
          if FieldNames='' then
             SwitchToIndex(nil)
          else
          begin
               lIndex:=FIndexes.GetByFieldNames(FieldNames);
               if lIndex<>nil then SwitchToIndex(lIndex);
          end;
     end
     else
         FIndexFieldNames:=FieldNames;
end;

procedure TkbmCustomMemTable.SetIndexName(IndexName:string);
var
   lIndex:TkbmIndex;
begin
     if Active then
     begin
          if IndexName='' then
             SwitchToIndex(nil)
          else
          begin
               lIndex:=FIndexes.Get(IndexName);
               if lIndex<>nil then SwitchToIndex(lIndex);
          end;
     end
     else
         FIndexName:=IndexName;
end;

procedure TkbmCustomMemTable.SetIndexDefs(Value:TIndexDefs);
begin
     FIndexDefs.assign(Value);
end;

procedure TkbmCustomMemTable.SetRecordTag(Value:longint);
var
   p:PChar;
begin
     FRecords.LockList;
     try
        p:=ActiveBuffer;
        if p=nil then raise Exception.Create(kbmNoCurrentRecord);
        PkbmRecord(p).Tag:=Value;
     finally
        FRecords.UnlockList;
     end;
end;

function TkbmCustomMemTable.GetRecordTag:longint;
var
   p:PChar;
begin
     Result:=0;
     FRecords.LockList;
     try
        p:=ActiveBuffer;
        if p=nil then raise Exception.Create(kbmNoCurrentRecord);
        Result:=PkbmRecord(p).Tag;
     finally
        FRecords.UnlockList;
     end;
end;

function TkbmCustomMemTable.GetIsJournalAvailable:boolean;
begin
     Result:=(FJournal<>nil);
end;

function TkbmCustomMemTable.GetIsJournaling:boolean;
begin
     Result:=(EnableJournal and IsJournalAvailable);
end;

function TkbmCustomMemTable.GetJournal:TkbmJournal;
begin
     Result:=FJournal;
end;

function TkbmCustomMemTable.GetIsVersioning:boolean;
begin
     Result:=FEnableVersioning;
end;

procedure TkbmCustomMemTable.SetStatusFilter(const Value:TUpdateStatusSet);
begin
     CheckBrowseMode;
     UpdateCursorPos;
     if FStatusFilter<>value then
     begin
          FStatusFilter:=Value;
          Resync([]);
     end;
end;

{$IFNDEF LEVEL3}
function TkbmCustomMemTable.UpdateStatus:TUpdateStatus;
var
   p:PkbmRecord;
begin
     p:=GetActiveRecord;
     if assigned(p) then
        result:=p^.updateStatus
     else
         result:=inherited UpdateStatus;
end;
{$ENDIF}

procedure TkbmCustomMemTable.SetAttachedTo(Value:TkbmCustomMemTable);
var
   i:integer;
   fld:TField;
begin
     if Value=FAttachedTo then exit;
     if Value=self then
        raise EMemTableError.Create(kbmCantAttachToSelf);

     Close;

     // Check if attached to something, break the attachment.
     if FAttachedTo<>nil then
     begin
          FAttachedTo.DeAttachChild(self);
          FAttachedTo:=nil;

          // Prepare local memorytable.
          FRecords:=TThreadList.Create;
          FDeletedRecords:=TList.Create;
     end;

     // Make the new attachment.
     if Value<>nil then
     begin
          // Check if trying to make 3 level attachment. Disallow.
          if Value.FAttachedTo<>nil then
             raise EMemTableError.Create(kbmCantAttachToSelf2);

          FAttachedTo:=Value;
          FAttachedTo.AttachChild(self);

          // Prepare attached to memorytable.
          FRecords.Free;
          FRecords:=FAttachedTo.FRecords;

          FDeletedRecords.Free;
          FDeletedRecords:=FAttachedTo.FDeletedRecords;

          if not Value.Active then Value.InternalInitFieldDefs;
          FieldDefs.Assign(Value.FieldDefs);

          // Copy fielddefinitions.
          if not (csDesigning in ComponentState) then
          begin
               for i:=0 to FAttachedTo.FieldCount-1 do
               begin
{$IFDEF LEVEL3}
                    fld:=FindField(FAttachedTo.Fields[i].FieldName);
{$ELSE}
                    fld:=FindField(FAttachedTo.Fields[i].FullName);
{$ENDIF}
                    if fld<>nil then fld.dataset:=nil;
                    CreateFieldAs(FAttachedTo.Fields[i]);
               end;

               // Copy fieldproperties from source.
               CopyFieldsProperties(FAttachedTo,self);
          end;
     end;
end;

// Set filtered property.
procedure TkbmCustomMemTable.SetFiltered(Value:boolean);
begin
     inherited;
     if Active then
     begin
{$IFDEF LEVEL5}
          if Value and (FFilterParser=nil) and (Filter<>'') then SetFilterText(Filter)
          else
{$ENDIF}
              Refresh;
     end;
end;

// Parse a filterstring and build filter structure.
procedure TkbmCustomMemTable.SetFilterText(const Value:string);
begin
     inherited;

{$IFDEF LEVEL5}
     // Remove old filter.
     FreeFilter;
{$ENDIF}

     // If active, build filter.
     if Active then
     begin
{$IFDEF LEVEL5}
          BuildFilter(Value);
{$ENDIF}
          Refresh;
     end;
end;

// Enable/Disable journaling.
// Disable will not remove the journal, only disable putting entries in it.
procedure TkbmCustomMemTable.SetEnableJournal(Value:boolean);
begin
     FEnableJournal:=Value;

     // Prepare journal.
     if FEnableJournal and (not IsJournalAvailable) then
        FJournal:=TkbmJournal.Create(self);
end;

// Set delta handler.
procedure TkbmCustomMemTable.SetDeltaHandler(AHandler:TkbmCustomDeltaHandler);
begin
     if FDeltaHandler<>nil then FDeltaHandler.FDataSet:=nil;
     AHandler.FDataSet:=self;
     FDeltaHandler:=AHandler;
end;

// Set the contents of a memtable from a variant.
procedure TkbmCustomMemTable.SetAllData(AVariant:variant);
var
   ms:TMemoryStream;
begin
     // Check if variant contains data.
     if VarIsEmpty(AVariant) or VarIsNull(AVariant) or (not VarIsArray(AVariant)) then exit;

     ms:=TMemoryStream.Create;
     try
        VariantToStream(AVariant,ms);

        _InternalEmpty(false);
        ms.Seek(0,0);
        InternalLoadFromBinaryStream(ms);
     finally
        ms.Free;
     end;
end;

function TkbmCustomMemTable.GetAllData:variant;
var
   ms:TMemoryStream;
begin
     Result:=Unassigned;
     if not Active then exit;

     ms:=TMemoryStream.Create;
     try
        InternalSaveToBinaryStream(ms,FAllDataOptions);
        Result:=StreamToVariant(ms);
     finally
        ms.Free;
     end;
end;

function TkbmCustomMemTable.GetMasterFields: string;
begin
     Result:=FMasterLink.FieldNames;
end;

procedure TkbmCustomMemTable.SetMasterFields(const Value: string);
begin
     FMasterLink.FieldNames:=Value;

     // Build master field list.
     if Active and (FMasterLink.DataSource<>nil) and (FMasterLink.DataSource.DataSet<>nil) then
        BuildFieldList(FMasterLink.DataSource.DataSet,FMasterIndexList,FMasterLink.FieldNames);
end;

function TkbmCustomMemTable.GetDataSource: TDataSource;
begin
     Result:=FMasterLink.DataSource;
end;

procedure TkbmCustomMemTable.SetDataSource(Value: TDataSource);
begin
     if IsLinkedTo(Value) then DatabaseError(kbmSelfRef);

     // Build master field list.
     if Active and (Value<>nil) and (Value.DataSet<>nil) then
        BuildFieldList(Value.DataSet,FMasterIndexList,FMasterLink.FieldNames);

     FMasterLink.DataSource:=Value;
end;

procedure TkbmCustomMemTable.MasterChanged(Sender: TObject);
var
   i:integer;
begin
     // Check if no fields defined for master/detail. Do nothing.
     if FMasterLink.Fields.Count = 0 then exit;

     // Check if not allocated master keybuffer.
     if FKeyBuffers[kbmkbMasterDetail]=nil then FKeyBuffers[kbmkbMasterDetail]:=_InternalAllocRecord;

     // Fill masterrecord with masterfield values.
     for i:=0 to FMasterLink.Fields.Count-1 do
         PopulateField(FKeyBuffers[kbmkbMasterDetail],TField(FIndexList.List^[i]),TField(FMasterLink.Fields.Items[i]).Value);

     // Reposition.
     CheckBrowseMode;
     First;
end;

procedure TkbmCustomMemTable.MasterDisabled(Sender: TObject);
begin
     First;
end;

// SetKey, EditKey, FindKey, FindNearest, GotoKey, Ranges.

procedure TkbmCustomMemTable.PrepareKeyRecord(KeyRecordType:integer; Clear:boolean);
begin
     // If keybuffer not assigned, allocate for it.
     if not assigned(FKeyBuffers[KeyRecordType]) then FKeyBuffers[KeyRecordType]:=_InternalAllocRecord;

     // Switch keybuffer.
     FKeyRecord:=FKeyBuffers[KeyRecordType];
     if Clear then _InternalClearRecord(FKeyRecord);
end;

procedure TkbmCustomMemTable.SetKey;
begin
     PrepareKeyRecord(kbmkbKey,true);
     SetState(dsSetKey);
     DataEvent(deDataSetChange, 0);
end;

procedure TkbmCustomMemTable.EditKey;
begin
     PrepareKeyRecord(kbmkbKey,false);
     SetState(dsSetKey);
     DataEvent(deDataSetChange, 0);
end;

function TkbmCustomMemTable.GotoKey:boolean;
var
   Index:integer;
begin
     CheckBrowseMode;
     if not Assigned(FKeyBuffers[kbmkbKey]) then
     begin
          Result:=false;
          exit;
     end;

     SetState(dsBrowse);
     CursorPosChanged;

     // Prepare list of fields representing the keys to search for.
     BuildFieldList(self,FIndexList,IndexFieldNames);

     PrepareKeyRecord(kbmkbKey,false);

     DisableControls;
     try
        // Locate record.
        Index:=-1;
        FCurIndex.Search(FKeyRecord,false,true,Index,FCurIndex.FOptions);
        if Index>=0 then
        begin
             FRecNo:=Index;
             Resync([]);
        end;
     finally
        EnableControls;
        Result:=Index>=0;
        SetFound(Result);
     end;
end;

function TkbmCustomMemTable.FindKey(const KeyValues:array of const):boolean;
var
   i,j,k:integer;
   fld:TField;
   SaveState:TDataSetState;
begin
     CheckBrowseMode;

     PrepareKeyRecord(kbmkbKey,true);

     SaveState:=SetTempState(dsSetKey);
     try
        // Fill values into keyrecord.
        BuildFieldList(self,FIndexList, FIndexFieldNames);
        j:=FIndexList.Count-1;
        k:=High(KeyValues);
        if k>=j then k:=j;
        for i:=0 to k do
        begin
             fld:=TField(FIndexList.List^[i]);
             fld.AssignValue(KeyValues[i]);
        end;
     finally
        RestoreState(SaveState);
     end;

     // Goto key.
     Result:=GotoKey;
end;

function TkbmCustomMemTable.FindNearest(const KeyValues:array of const):boolean;
var
   i,j,k:integer;
   fld:TField;
   Index:integer;
   SaveState:TDataSetState;
begin
     CheckBrowseMode;

     // Fill values into keyrecord.
     PrepareKeyRecord(kbmkbKey,true);

     SaveState:=SetTempState(dsSetKey);
     try
        BuildFieldList(self,FIndexList, FIndexFieldNames);
        j:=FIndexList.Count-1;
        k:=High(KeyValues);
        if k>=j then k:=j;
        for i:=0 to k do
        begin
             fld:=TField(FIndexList.List^[i]);
             fld.AssignValue(KeyValues[i]);
        end;
        SetState(dsBrowse);
        CheckBrowseMode;
        CursorPosChanged;

        DisableControls;
        try
           // Look for record.
           Index:=-1;
           FCurIndex.Search(FKeyRecord,true,true,Index,FCurIndex.FOptions);
           if Index>=0 then FRecNo:=Index;
        finally
           EnableControls;
           Result:=Index>=0;
           SetFound(Result);
        end;
     finally
        RestoreState(SaveState);
        Resync([]);
     end;
end;

procedure TkbmCustomMemTable.SetRangeStart;
begin
     // Prepare setting key values in key records.
     BuildFieldList(self,FIndexList, FIndexFieldNames);

     SetState(dsSetKey);
     PrepareKeyRecord(kbmkbRangeStart,true);
     DataEvent(deDataSetChange, 0);
end;

procedure TkbmCustomMemTable.SetRangeEnd;
begin
     // Prepare setting key values in key records.
     BuildFieldList(self,FIndexList, FIndexFieldNames);

     SetState(dsSetKey);
     PrepareKeyRecord(kbmkbRangeEnd,true);
     DataEvent(deDataSetChange, 0);
end;

procedure TkbmCustomMemTable.EditRangeStart;
begin
     // Prepare setting key values in key records.
     BuildFieldList(self,FIndexList, FIndexFieldNames);

     SetState(dsSetKey);
     PrepareKeyRecord(kbmkbRangeStart,false);
     DataEvent(deDataSetChange, 0);
end;

procedure TkbmCustomMemTable.EditRangeEnd;
begin
     // Prepare setting key values in key records.
     BuildFieldList(self,FIndexList, FIndexFieldNames);

     SetState(dsSetKey);
     PrepareKeyRecord(kbmkbRangeEnd,false);
     DataEvent(deDataSetChange, 0);
end;

procedure TkbmCustomMemTable.ApplyRange;
begin
     SetState(dsBrowse);
     FRangeActive:=(FKeyBuffers[kbmkbRangeStart]<>nil) and (FKeyBuffers[kbmkbRangeEnd]<>nil);
     if not IsEmpty then first;
end;

procedure TkbmCustomMemTable.CancelRange;
var
   n:integer;
begin
     if not FRangeActive then exit;

     if ActiveBuffer<>nil then
        n:=PkbmRecord(ActiveBuffer)^.RecordID
     else
         n:=-1;

     FRangeActive:=false;

     if Active then
     begin
          if n<0 then First
          else FCurIndex.SearchRecordID(n,FRecNo);
          Resync([]);
     end;
end;

procedure TkbmCustomMemTable.SetRange(const StartValues, EndValues:array of const);
var
   i,j,k:integer;
   fld:TField;
begin
     CheckBrowseMode;

     // Prepare setting key values in key records.
     BuildFieldList(self,FIndexList, FIndexFieldNames);
     j:=FIndexList.Count-1;

     // Setup start key values.
     SetRangeStart;
     k:=High(StartValues);
     if k>=j then k:=j;
     for i:=0 to k do
     begin
          fld:=TField(FIndexList.List^[i]);
          fld.AssignValue(StartValues[i]);
     end;

     // Setup end key values.
     SetRangeEnd;
     k:=High(EndValues);
     if k>=j then k:=j;
     for i:=0 to k do
     begin
          fld:=TField(FIndexList.List^[i]);
          fld.AssignValue(EndValues[i]);
     end;

     ApplyRange;
end;

// Copy masterfields to detail table if a master/detail relation.
procedure TkbmCustomMemTable.DoOnNewRecord;
var
   i:integer;
begin
     // Copy link values from master to detail.
     if FMasterLink.Active and (FMasterLink.Fields.Count > 0) then
        for i:=0 to FMasterLink.Fields.Count-1 do
            TField(FIndexList[i]).Value := TField(FMasterLink.Fields[i]).Value;

{$IFDEF LEVEL4}
     // If a DefaultExpression exists, fill data with default
     for i:=0 to Fields.Count-1 do
         if Fields[i].DefaultExpression<>'' then
            TField(Fields[i]).Value:=TField(Fields[i]).DefaultExpression;
{$ENDIF}

     inherited DoOnNewRecord;

     // Update autoinc if such a field is defined.
     if Assigned(FAutoIncField) then
        PopulateField(GetActiveRecord,FAutoIncField,FAutoIncMax+1);
end;

// Update max. autoinc. value.
procedure TkbmCustomMemTable.DoBeforePost;
type
    TAutoInc=packed record
       Used:Byte;
       Int:Integer;
    end;
var
   pAutoInc:^TAutoInc;
begin
     // If an autoinc field is specified, allways keep track of highest used number.
     if Assigned(FAutoIncField) then
     begin
          pAutoInc:=Pointer(GetFieldPointer(PkbmRecord(ActiveBuffer),FAutoIncField));
          if FAutoIncMax<pAutoInc^.Int then FAutoIncMax:=pAutoInc^.Int;
     end;
     inherited;
end;

function TkbmCustomMemTable.GetFieldSize(FieldType:TFieldType; Size:longint):longint;
begin
     case FieldType of
{$ifndef LEVEL3}
          {ftWideString:         Result:=Size*2+1;}
          ftFixedChar,
{$endif}
          ftString:             Result:=Size+1;
          ftBytes:              Result:=Size;
          ftVarBytes:           Result:=Size+SizeOf(Word);
          ftSmallInt:           Result:=SizeOf(SmallInt);
          ftInteger:            Result:=SizeOf(Integer);
{$ifndef LEVEL3}
          ftLargeInt:           Result:=SizeOf(Int64);
          ftADT,ftArray:        Result:=0;
{$endif}
          ftWord:               Result:=SizeOf(Word);
          ftBoolean:            Result:=SizeOf(WordBool);
          ftFloat:              Result:=SizeOf(Double);
          ftCurrency:           Result:=SizeOf(Double);
          ftDate:               Result:=SizeOf(TDateTimeRec);
          ftTime:               Result:=SizeOf(TDateTimeRec);
          ftDateTime:           Result:=SizeOf(TDateTimeRec);
          ftAutoInc:            Result:=SizeOf(Integer);
          ftBlob:               Result:=0;
          ftMemo:               Result:=0;
          ftGraphic:            Result:=0;
          ftFmtMemo:            Result:=0;
          ftParadoxOle:         Result:=0;
          ftDBaseOle:           Result:=0;
          ftTypedBinary:        Result:=0;
          ftBCD:                Result:=34;
     else
          Result:=0;
     end;
end;

// Return false if the field should be included as fixed size in the record.
function TkbmCustomMemTable.GetFieldIsVarLength(FieldType:TFieldType; Size:longint):boolean;
begin
     Result:=false;

     // No need to store small amounts of data or fixed length data indirectly.
     if (FieldType in kbmVarLengthNonBlobTypes) and (Size>10) then
     begin
          // If should be as fast as possible, dont go indirectly, else ok.
          if (FPerformance <> mtpfFast) then Result:=true;
     end
     else if (FieldType in kbmBlobTypes) then Result:=true;
end;

procedure TkbmCustomMemTable.DestroyIndexes;
begin
     FIndexes.Clear;
end;

procedure TkbmCustomMemTable.CreateIndexes;
var
   i:integer;
begin
     FIndexes.Clear;

     for i:=0 to FIndexDefs.Count-1 do
         FIndexes.Add(FIndexDefs.Items[i]);
end;

function TkbmCustomMemTable.GetIndexByName(IndexName:string):TkbmIndex;
begin
     Result:=FIndexes.Get(IndexName);
end;

function TkbmCustomMemTable.IndexFieldCount:Integer;
begin
     Result:=FCurIndex.FIndexFieldList.Count;
end;

function TkbmCustomMemTable.GetIndexField(Index: Integer): TField;
begin
     if (Index<0) or (Index>=IndexFieldCount) then
        Result:=nil
     else
         Result:=TField(FCurIndex.FIndexFieldList[Index]);
end;

procedure TkbmCustomMemTable.SetIndexField(Index:Integer; Value:TField);
var
   s,a:string;
   i:integer;
   lIndex:TkbmIndex;
begin
     // Try to find a predefined index matching this and other specified fields.
     s:='';
     a:='';
     for i:=0 to FCurIndex.FIndexFieldList.count-1 do
         s:=s+a+TField(FCurIndex.FIndexFieldList[i]).FieldName;

     lIndex:=FIndexes.GetByFieldNames(s);
     if lIndex<>nil then SwitchToIndex(lIndex);
end;

procedure TkbmCustomMemTable.UpdateIndexes;
var
   i,j:integer;
   lIndex:TkbmIndex;
begin
     // Check if to delete any indexes.
     for i:=FIndexes.Count-1 downto 0 do
     begin
          j:=FIndexDefs.IndexOf(FIndexes.FIndexes.Strings[i]);
          if j<0 then
          begin
               lIndex:=TkbmIndex(FIndexes.FIndexes.Objects[i]);
               if (lIndex = FIndexes.FRowOrderIndex) or (lIndex = FSortIndex) then continue;
               FIndexes.FIndexes.Delete(i);
               if lIndex = FCurIndex then
               begin
                    FCurIndex:=FIndexes.FRowOrderIndex;
                    Resync([]);
                    FIndexFieldNames:='';
               end;
               lIndex.free;
          end;
     end;

     // Check if to add any indexes.
     for i:=0 to FIndexDefs.Count-1 do
     begin
          with FIndexDefs.Items[i] do
          begin
               j:=FIndexes.FIndexes.IndexOf(FIndexDefs.Items[i].Name);
               if j<0 then
               begin
                    lIndex:=TkbmIndex.Create(Name,self,Fields,Options,mtitSorted,false);
                    FIndexes.AddIndex(lIndex);
               end;
          end;
     end;

     // Check if to rebuild any indexes.
     for i:=0 to FIndexes.Count-1 do
     begin
          lIndex:=TkbmIndex(FIndexes.FIndexes.Objects[i]);
          if not lIndex.FOrdered then
          begin
               lIndex.Rebuild;
               if (lIndex = FCurIndex) and (Active) then Resync([]);
          end;
     end;
end;

function TkbmCustomMemTable.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
begin
     Result:=TkbmBlobStream.Create(Field as TBlobField, Mode);
end;

procedure TkbmCustomMemTable.CreateTable;
var
   i:Integer;
begin
     CheckInactive;

     // If no fielddefs existing, use the previously defined fields.
     if FieldDefs.Count = 0 then
        for i:=0 to FieldCount-1 do
            with Fields[i] do
                 if FieldKind = fkData then
                    FieldDefs.Add(FieldName, DataType, Size, Required);

     // Remove previously defined fields and indexes.
     DestroyIndexes;
     DestroyFields;

     // Create fields and indexes.
     CreateFields;
     CreateIndexes;

     ResetAutoInc;
end;

// Create field as another field.
function TkbmCustomMemTable.CreateFieldAs(Field:TField):TField;
var
   cl:TFieldClass;
begin
     Result:=nil;
     if not (Field.DataType in kbmSupportedFieldTypes) then exit;

     cl:=TFieldClass(Field.ClassType);
     Result:=cl.Create(owner);
     Result.Size:=Field.Size;
     Result.FieldKind:=Field.FieldKind;
     Result.FieldName:=Field.FieldName;
     Result.Lookup:=Field.Lookup;
     Result.KeyFields:=Field.KeyFields;
     Result.LookupDataSet:=Field.LookupDataSet;
     Result.LookupResultField:=Field.LookupResultField;
     Result.LookupKeyFields:=Field.LookupKeyFields;
     Result.DataSet:=self;
end;

// Create memory table as another dataset.
procedure TkbmCustomMemTable.CreateTableAs(Source:TDataSet; CopyOptions:TkbmMemTableCopyTableOptions);
var
   i:integer;
begin
     CheckInactive;

     if Source=nil then exit;

     // Add fields as they are defined in the other dataset.
     if not Source.Active then Source.FieldDefs.Update;
     FieldDefs.Assign(Source.FieldDefs);

     // Check which fielddefs we wont keep.
     for i:=FieldDefs.Count-1 downto 0 do
     begin
          // Remove non supported fieldsdefs.
          if not (FieldDefs.Items[i].DataType in kbmSupportedFieldTypes) then
             FieldDefs.Items[i].free

          // Remove nonactive fields.
          else if (mtcpoOnlyActiveFields in CopyOptions) and
                  (Source.FindField(FieldDefs.Items[i].Name)=nil) then
                      FieldDefs.Items[i].free;
     end;

     // Destroy existing fields.
     DestroyFields;
     if not Source.DefaultFields then CreateFields;

     // Copy lookup and calculated fields if specified.
     for i:=0 to Source.FieldCount-1 do
         if ((Source.Fields[i].FieldKind=fkLookup) and (mtcpoLookup in CopyOptions))
            or ((Source.Fields[i].FieldKind=fkCalculated) and (mtcpoCalculated in CopyOptions)) then
            CreateFieldAs(Source.Fields[i]);

     // Copy fieldproperties from source.
     if mtcpoProperties in CopyOptions then CopyFieldsProperties(Source,self);

     ResetAutoInc;
end;

// Delete table.
procedure TkbmCustomMemTable.DeleteTable;
begin
     CheckInactive;
     DestroyFields;
end;

// Purge all records.
procedure TkbmCustomMemTable._InternalEmpty(DoJournal:boolean);
var
   i:integer;
   lst:TList;
begin
     FIndexes.EmptyAll;

     lst:=FRecords.LockList;
     try
        // Check if to add to journal.
        if DoJournal and IsJournaling then
           for i:=0 to lst.Count-1 do
           begin
                if lst.Items[i]<>nil then
                   FJournal.Add(mtjoDelete,nil,PkbmRecord(lst.Items[i]));
           end;

        // Remove the records.
        for i:=0 to lst.Count-1 do
            _InternalFreeRecord(lst.Items[i],true,true);

        lst.Clear;
        FDeletedRecords.Clear;
     finally
        FRecords.UnlockList;
     end;
     FRecNo:=-1;
     FRecordID:=0;
     FUniqueRecordID:=0;
     FDeleteCount:=0;
end;

procedure TkbmCustomMemTable.ClearModifiedFlags;
var
   i:integer;
begin
     // Set KBM_MAX_FIELDS booleans of size byte equal false.
     for i:=0 to FieldCount-1 do
         FFieldFlag[i]:=FFieldFlag[i] - [mtffModified];
end;

function TkbmCustomMemTable.GetModifiedFlags(i:integer):boolean;
begin
     if (i<0) or (i>=FieldCount) then raise ERangeError.CreateFmt(kbmOutOfRange,[i]);
     Result:=mtffModified in FFieldFlag[i];
end;

procedure TkbmCustomMemTable.InternalOpen;
  procedure EnumerateFieldDefs(SomeFieldDefs:TFieldDefs; var NbrFields:integer);
  var
     i:integer;
{$IFNDEF LEVEL3}
     j:integer;
{$ENDIF}
     sz:integer;
  begin
       for i:=0 to SomeFieldDefs.Count - 1 do
           with SomeFieldDefs[i] do
           begin
                // Check if field type supported.
                if not (DataType in kbmSupportedFieldTypes) then
                   raise EMemTableError.Create(kbminternalOpen1Err+
                         Name
                         {$ifndef LEVEL3}
                         +' ('+DisplayName+')'
                         {$endif}
                         +Format(kbminternalOpen2Err,[integer(DataType)]));

                // Determine if field is subject to being an indirect field.
                if (Fields[FieldNo-1].FieldKind=fkData) and GetFieldIsVarLength(DataType,Size) then
                begin
                     FFieldFlag[NbrFields]:=FFieldFlag[NbrFields]+[mtffIndirect];

                     // Call user app. to allow override of default unless a blobtype.
                     if (Assigned(FOnSetupField)) and (not (Fields[FieldNo-1].DataType in kbmBlobTypes)) then
                        FOnSetupField(self,Fields[FieldNo-1],FFieldFlag[NbrFields]);
                end;

                // If an indirect field (a varlength), dont set fieldofs at this time.
                if (mtffIndirect in FFieldFlag[NbrFields]) then
                   FFieldOfs[NbrFields]:=-1
                else
                begin
                     // Else normal fixed size field embedded in the record.
                     FFieldOfs[NbrFields]:=FRecordSize;

{$IFNDEF LEVEL3}
                     // Check if arraytype field.
                     if ChildDefs.Count > 0 then
                     begin
                          if DataType = ftArray then
                             for j:=1 to Size do EnumerateFieldDefs(ChildDefs,NbrFields)
                          else
                              EnumerateFieldDefs(ChildDefs,NbrFields);
                     end
                     else
                     begin
                          // Look for fieldsize.
                          sz:=GetFieldSize(DataType,Size);
                          inc(sz);   // 1.st byte is boolean flag for Null or not.
                          inc(FRecordSize,sz);
                     end;
{$ELSE}
                     // Look for fieldsize.
                     sz:=GetFieldSize(DataType,Size);
                     inc(sz);   // 1.st byte is boolean flag for Null or not.
                     inc(FRecordSize,sz);
{$ENDIF}
                end;
                inc(NbrFields);
           end;
  end;

  procedure EnumerateVarLengthFieldDefs(SomeFieldDefs:TFieldDefs; var NbrFields:integer);
  var
     i:integer;
{$IFNDEF LEVEL3}
     j:integer;
{$ENDIF}
  begin
       for i:=0 to SomeFieldDefs.Count - 1 do
           with SomeFieldDefs[i] do
           begin
                // Check if a varlength field (blobs and long strings f.ex.).
                if mtffIndirect in FFieldFlag[NbrFields] then
                begin
                     // Check if to compress it.
                     if FPerformance=mtpfSmall then
                        FFieldFlag[NbrFields]:=FFieldFlag[NbrFields]+[mtffCompress];
                     FFieldOfs[NbrFields]:=FStartVarLength+FVarLengthCount*(SizeOf(PkbmVarLength)+1);
                     inc(FVarLengthCount);
                end;
                inc(NbrFields);

{$IFNDEF LEVEL3}
                // Check if arraytype field. Adjust field counter.
                if ChildDefs.Count > 0 then
                begin
                     if DataType = ftArray then
                        for j:=1 to Size do EnumerateVarLengthFieldDefs(ChildDefs,NbrFields)
                     else
                         EnumerateVarLengthFieldDefs(ChildDefs,NbrFields);
                end;
{$ENDIF}
           end;
  end;

var
   NbrFields:integer;
   Temp:integer;
begin
     InternalInitFieldDefs;
     if DefaultFields then CreateFields;

     // Calculate non blob field offsets into the record.
     FRecordSize:=0;
     FVarLengthCount:=0;                  // Know of no var length fields in the definition yet.
     NbrFields:=0;
     EnumerateFieldDefs(FieldDefs,NbrFields);
     BindFields(True);

     FRecNo:=-1;
     BookmarkSize := sizeof(Integer);

     FStartCalculated:=FRecordSize;
     FRecordCalcSize:=CalcFieldsSize;
     FStartVarLength:=FStartCalculated+FRecordCalcSize;

     // Calculate number of var length fields and their place in the record.
     Temp:=0;
     EnumerateVarLengthFieldDefs(FieldDefs,Temp);

     FRecordVarLengthSize:=FVarLengthCount * (SizeOf(Pointer) + 1);
     FRecordDataSize:=FRecordSize+FRecordCalcSize+FRecordVarLengthSize;


     FIsOpen:=True;
     ClearModifiedFlags;

     // Prepare index.
     CreateIndexes;

     // Select roworder index. Designtime selected alternative index will be selected in AfterOpen.
     FCurIndex:=FIndexes.FRowOrderIndex;

     // Build master field list.
     if (FMasterLink.FieldNames<>'') and (FMasterLink.DataSource<>nil) and (FMasterLink.DataSource.DataSet<>nil) then
        BuildFieldList(FMasterLink.DataSource.DataSet,FMasterIndexList,FMasterLink.FieldNames);

     // Prepare journal.
     if EnableJournal and (not IsJournalAvailable) then
        FJournal:=TkbmJournal.Create(self);

     // Set flag that before close has not yet been called (used by destructor).
     FBeforeCloseCalled:=false;
end;

procedure TkbmCustomMemTable.InternalClose;
var
   i:integer;
begin
     // Check if to call before close.
     if not FBeforeCloseCalled then DoBeforeClose;

     // Remove all indexes (except roworderindex).
     DestroyIndexes;
     FCurIndex:=FIndexes.FRowOrderIndex;

     if FAttachedTo=nil then _InternalEmpty(false);
     FIsOpen:=False;
     BindFields(False);

     // Delete keybuffers if assigned.
     FKeyRecord:=nil;
     for i:=kbmkbMin to kbmkbMax do
         if Assigned(FKeyBuffers[i]) then
         begin
              _InternalFreeRecord(FKeyBuffers[i],true,false);
              FKeyBuffers[i]:=nil;
         end;

     if DefaultFields then DestroyFields;

     // Remove journal.
     if FJournal<>nil then
     begin
          FJournal.Free;
          FJournal:=nil;
     end;
end;

procedure TkbmCustomMemTable.ResetAutoInc;
begin
     FAutoIncField:=nil;
     FAutoIncMax:=FAutoIncMin-1;
     CheckAutoInc;
end;

function TkbmCustomMemTable.CheckAutoInc:boolean;
var
   i:integer;
begin
     Result:=False;
     for i:=0 to FieldCount-1 do
         if Fields[i].DataType=ftAutoInc then
         begin
              FAutoIncField:=Fields[i];
              Result:=True;
              break;
         end;
end;

procedure TkbmCustomMemTable.InternalInitFieldDefs;
var
   i:integer;
begin
     // Check if attached to another table, use that tables definitions.
     if FAttachedTo<>nil then
     begin
          FAutoIncField:=FAttachedTo.FAutoIncField;
          FAutoIncMax:=FAttachedTo.FAutoIncMax;

          FieldDefs.Assign(FAttachedTo.FieldDefs);
          exit;
     end;

     // If using predefined fields, generate fielddefs according to fields.
     if not DefaultFields then
     begin
          FieldDefs.clear;
          for i:=0 to Fieldcount-1 do
          begin
               // Add fielddef.
               FieldDefs.Add(Fields[i].FieldName,Fields[i].DataType,Fields[i].Size,Fields[i].Required);
          end;
     end;

     // Look for autoinc field if any.
     ResetAutoInc;
end;

function TkbmCustomMemTable.GetActiveRecord:PkbmRecord;
var
   RecNo:integer;
begin
     // Check if to return a pointer to a specific buffer.
     if FOverrideActiveRecordBuffer<>nil then
     begin
          Result:=FOverrideActiveRecordBuffer;
          exit;
     end;

     // Else return depending on dataset state.
     case State of
          dsBrowse:              if IsEmpty then
                                    Result := nil
                                 else
                                    Result := PkbmRecord(ActiveBuffer);

          dsCalcFields:          Result := PkbmRecord(CalcBuffer);

          dsFilter:              Result:=FFilterRecord;

          dsEdit:                Result:=PkbmRecord(ActiveBuffer);

          dsInsert:              Result:=PkbmRecord(ActiveBuffer);

          dsNewValue,dsCurValue: Result:=PkbmRecord(ActiveBuffer);

          dsOldValue:            begin
                                      // Return database record as result.
                                      RecNo:=PkbmRecord(ActiveBuffer)^.RecordNo;
                                      if (RecNo>0) then
                                         Result:=PkbmRecord(FCurIndex.FReferences.Items[RecNo-1])
                                      else
                                      begin
                                           Result:=PkbmRecord(ActiveBuffer);
                                           while Result^.PrevRecordVersion<>nil do
                                                 Result:=Result^.PrevRecordVersion;
                                      end;
                                 end;

          dsSetKey:              Result:=FKeyRecord;
{$IFDEF LEVEL4}
          dsBlockRead:           Result := PkbmRecord(ActiveBuffer);
{$ENDIF}
     else
          Result:=nil;
     end;
end;

function TkbmCustomMemTable.GetFieldPointer(ARecord:PkbmRecord; Field:TField):PChar;
begin
     Result:=nil;
     if ARecord=nil then exit;

     Result:=ARecord^.Data;
     if Field.FieldNo<=0 then
        inc(Result,FStartCalculated+Field.Offset)
     else
        inc(Result,FFieldOfs[Field.FieldNo-1]);
end;

// Result is data in the buffer and a boolean return (true=not null, false=is null).
function TkbmCustomMemTable.GetFieldData(Field: TField; Buffer: Pointer): Boolean;
var
   SourceBuffer:PChar;
   ActRec,CurRec:PkbmRecord;
   flags:TkbmFieldFlags;
   pVarLength:PkbmVarLength;
   RecNo:longint;
   cBuffer:PChar;
   cSz:longint;
begin
     Result:=False;
     if not FIsOpen then exit;
     ActRec:=GetActiveRecord;
     SourceBuffer:=GetFieldPointer(ActRec,Field);
     if SourceBuffer=nil then Exit;

     // Check if varlength field, get the data indirectly. If no data avail. get the data from the db.
     flags:=FFieldFlag[Field.FieldNo-1];
     if mtffIndirect in flags then
     begin
          pVarLength:=PPkbmVarLength(SourceBuffer+1)^;

          // If varlength field not populated, check if database original populated.
          if (pVarLength = nil) then
          begin
               RecNo:=ActRec^.RecordNo;
               if (RecNo>0) then
               begin
                    CurRec:=PkbmRecord(FCurIndex.FReferences.Items[RecNo-1]);
                    SourceBuffer:=GetFieldPointer(CurRec,Field);
                    pVarLength:=PPkbmVarLength(SourceBuffer+1)^;
               end;
          end;

          // Check if to get data or not. Blobfields dont return data.
          if (not (Field.DataType in kbmBlobTypes))
             and Assigned(Buffer) and (pVarLength<>nil) then
          begin
               cBuffer:=GetVarLengthData(pVarLength);
               cSz:=GetVarLengthSize(pVarLength);

               // Check if compressed field, decompress buffer.
               if mtffCompress in flags then
               begin
                    if Assigned(FOnDeCompressField) then
                       FOnDecompressField(self,Field,CBuffer,cSz,CBuffer)
                    else
                        CBuffer:=DecompressFieldBuffer(Field,CBuffer,CSz);
               end;

               Move(cBuffer^,Buffer^,cSz);
          end;
     end
     else
     begin
          if Assigned(Buffer) then
             Move(SourceBuffer[1], Buffer^, GetFieldSize(Field.DataType,Field.Size));
     end;

     // Return null status.
     Result:=SourceBuffer[0]<>#0;
end;

procedure TkbmCustomMemTable.SetFieldData(Field: TField; Buffer: Pointer);
var
   DestinationBuffer: PChar;
   ppVarLength:PPkbmVarLength;
   sz:longint;
   n:integer;
   flags:TkbmFieldFlags;
   cBuffer:PChar;
   cSz:longint;
begin
     if not FIsOpen then exit;

     if not (State in dsWriteModes) then DatabaseError(kbmEditModeErr{$IFNDEF LEVEL3}, Self{$ENDIF});
     DestinationBuffer:=GetFieldPointer(GetActiveRecord,Field);
     if DestinationBuffer=nil then Exit;

     if (not FIgnoreReadOnly) and (FReadOnly or Field.ReadOnly) then
        DatabaseErrorFmt(kbmReadOnlyErr,[Field.DisplayName]);

     if Field.FieldKind in [fkData, fkInternalCalc] then Field.Validate(Buffer);
     sz:=GetFieldSize(Field.DataType,Field.Size);

     // Set the null value from the buffer.
     if LongBool(Buffer) then DestinationBuffer^:=#1
     else DestinationBuffer^:=#0;
     inc(DestinationBuffer);

     // Check if varlength field, set the data indirectly.
     flags:=FFieldFlag[Field.FieldNo-1];
     if mtffIndirect in flags then
     begin
          ppVarLength:=PPkbmVarLength(DestinationBuffer);

          // If varlength field populated, clear it out.
          if (ppVarLength^ <> nil) then
          begin
               FreeVarLength(ppVarLength^);
               ppVarLength^:=nil;
          end;

          // Check if to populate the varlength field.
          if Assigned(Buffer) and longbool(Buffer) then
          begin
               cBuffer:=Buffer;
               cSz:=sz;

               // Check if to compress the data.
               if mtffCompress in flags then
               begin
                    if Assigned(FOnCompressField) then
                       FOnCompressField(self,Field,Buffer,cSz,CBuffer)
                    else
                        CBuffer:=CompressFieldBuffer(Field,Buffer,CSz);
               end;

               ppVarLength^:=AllocVarLengthAs(CBuffer,CSz);
          end;
     end
     else
     begin
          if Assigned(Buffer) then
          begin
               if longbool(Buffer) then
                  Move(Buffer^,DestinationBuffer^,sz)
               else
                   FillChar(DestinationBuffer^,sz, 0);
          end;
     end;

     // Set modified flag.
     n:=Field.FieldNo-1;
     if (n>=0) then FFieldFlag[n]:=FFieldFlag[n]+[mtffModified];

     if not (State in [dsCalcFields, dsFilter, dsNewValue]) then
        DataEvent(deFieldChange, Longint(Field));
end;

function TkbmCustomMemTable.BCDToCurr(BCD: Pointer; var Curr: Currency): Boolean;
begin
     Move(BCD^, Curr, SizeOf(Currency));
     Result := True;
end;

function TkbmCustomMemTable.CurrToBCD(const Curr: Currency; BCD: Pointer; Precision, Decimals: Integer): Boolean;
begin
     Move(Curr, BCD^, SizeOf(Currency));
     Result := True;
end;

function TkbmCustomMemTable.IsCursorOpen: Boolean;
begin
     Result:=FIsOpen;
end;

function TkbmCustomMemTable.GetCanModify: Boolean;
begin
     Result:=not FReadOnly;
end;

function TkbmCustomMemTable.GetRecordSize: Word;
begin
     Result:=FRecordSize;
end;

function TkbmCustomMemTable.AllocRecordBuffer: PChar;
begin
     Result:=PChar(_InternalAllocRecord);
end;

procedure TkbmCustomMemTable.FreeRecordBuffer(var Buffer: PChar);
begin
     _InternalFreeRecord(PkbmRecord(Buffer),true,true);
     Buffer:=nil;
end;

{$IFDEF LEVEL4}
procedure TkbmCustomMemTable.SetBlockReadSize(Value: Integer);
var
   DoNext: Boolean;
begin
     if Value <> BlockReadSize then
     begin
          if (Value > 0) or (Value < -1) then
          begin
               inherited;
               BlockReadNext;
          end
          else
          begin
               DoNext:=Value=-1;
               Value:=0;
               inherited;

               if DoNext then
                  Next
               else
               begin
                    CursorPosChanged;
                    Resync([]);
               end;
          end;
     end;
end;
{$ENDIF}

// Fill one field with contents of a variant.
procedure TkbmCustomMemTable.PopulateField(ARecord:PkbmRecord; Field:TField; AValue:Variant);
var
   p:PChar;
   pValue:PChar;

   s:array[0..dsMaxStringSize] of Char;
   si:smallint;
{$ifndef LEVEL3}
   li:Int64;
{$endif}
   i:integer;
   w:word;
   d:double;
   dt:TDateTime;
   ts:TTimeStamp;
   dtr:TDateTimeRec;
//   astr:AnsiString;
   flags:TkbmFieldFlags;
   sz:longint;
   CSz:longint;
   CBuffer:PChar;
   ppVarLength:PPkbmVarLength;
begin
     p:=GetFieldPointer(ARecord,Field);
     sz:=GetFieldSize(Field.DataType, Field.Size);

     // Populate with null?
     if VarIsNull(AValue) or VarIsEmpty(AValue) then
     begin
          Boolean(p[0]):=false;
          FillChar(p[1],sz, 0);
          exit;
     end;

     // Populate with value.
     Boolean(p[0]):=true;
     with Field do
     begin
          pValue:=nil;
          case DataType of
{$ifndef LEVEL3}
               {ftWideString:
                   begin
                        astr:=AValue;
                        pValue:=@astr;
                   end;}

               ftFixedChar,
{$endif}
               ftString:
                   begin
                        StrLCopy(s,PChar(VarToStr(AValue)),DataSize);
                        if TStringField(Field).Transliterate then
                           DataSet.Translate(s,s,True);
                        pValue:=s;
                   end;

               ftSmallint:
                   begin
                        si:=AValue;
                        pValue:=PChar(@si);
                   end;
{$ifndef LEVEL3}
               ftLargeInt:
                   begin
                        li:=trunc(double(AValue));
                        pValue:=PChar(@li);
                   end;
{$endif}
               ftInteger,
               ftAutoInc:
                   begin
                        i:=AValue;
                        pValue:=PChar(@i);
                   end;

               ftDate:
                   begin
                        dt:=StrToDateTime(AValue);
                        ts:=DateTimeToTimeStamp(dt);
                        dtr.Date:=ts.Date;
                        pValue:=PChar(@dtr);
                   end;

               ftTime:
                   begin
                        dt:=StrToDateTime(AValue);
                        ts:=DateTimeToTimeStamp(dt);
                        dtr.Time:=ts.Time;
                        pValue:=PChar(@dtr);
                   end;

               ftDateTime:
                   begin
                        dt:=StrToDateTime(AValue);
                        ts:=DateTimeToTimeStamp(dt);
                        dtr.DateTime:=TimeStampToMSecs(ts);
                        pValue:=PChar(@dtr);
                   end;
//                   begin
//                        dt:=AValue;
//                        pValue:=PChar(@dt);
//                   end;

               ftWord:
                   begin
                        w:=AValue;
                        pValue:=PChar(@w);
                   end;

               ftBoolean: ;

               ftFloat,
               ftCurrency:
                   begin
                        d:=AValue;
                        pValue:=PChar(@d);
                   end;
          end;

          // If anything to store.
          if (pValue<>nil) then
          begin
               // Check if varlength field, set the data indirectly.
               inc(p);
               flags:=FFieldFlag[Field.FieldNo-1];
               if mtffIndirect in flags then
               begin
                    ppVarLength:=PPkbmVarLength(p);

                    // If varlength field populated, clear it out.
                    if (ppVarLength^ <> nil) then
                    begin
                         FreeVarLength(ppVarLength^);
                         ppVarLength^:=nil;
                    end;

                    // Check if to populate the varlength field.
                    cBuffer:=pValue;
                    cSz:=sz;

                    // Check if to compress the data.
                    if mtffCompress in flags then
                    begin
                         if Assigned(FOnCompressField) then
                            FOnCompressField(self,Field,pValue,cSz,CBuffer)
                         else
                             CBuffer:=CompressFieldBuffer(Field,pValue,CSz);
                    end;

                    ppVarLength^:=AllocVarLengthAs(CBuffer,CSz);
               end
               else
                   Move(pValue^,p^,sz);

               // Set modified flag.
               i:=Field.FieldNo-1;
               if (i>=0) then FFieldFlag[i]:=FFieldFlag[i]+[mtffModified];
          end;
     end;
end;

// Populate a varlength field with a value.
procedure TkbmCustomMemTable.PopulateVarLength(ARecord:PkbmRecord;Field:TField;const Buffer;Size:integer);
var
   pField:PChar;
   pVarLength:PPkbmVarLength;
begin
     pField:=GetFieldPointer(ARecord,Field);
     if pField=nil then exit;

     pVarLength:=PPKbmVarLength(pField+1);
     if pVarLength^<>nil then
     begin
          FreeVarLength(pVarLength^);
          pVarLength^:=nil;
     end;

     pVarLength^:=AllocVarLength(Size);

     if Size<>0 then
     begin
          pField[0]:=#1;
          move(Buffer, GetVarLengthData(pVarLength^)^, Size );
     end
     else
         pField[0]:=#0;
end;

// Fill record with values for specified fields.
procedure TkbmCustomMemTable.PopulateRecord(ARecord:PkbmRecord; Fields:string; Values:variant);
var
   FieldList:Tlist;
   i:integer;
   n:integer;
begin
     FieldList := TList.Create;
     try
        BuildFieldList(self,FieldList,Fields);

        n:=VarArrayDimCount(Values);
        if n>1 then raise EMemTableError.Create(kbmVarArrayErr);
        if (n=0) and (FieldList.count>1) then raise EMemTableError.Create(kbmVarReason1Err);
        if FieldList.Count<1 then raise EMemTableError.Create(kbmVarReason2Err);

        // Single value.
        if n=0 then
        begin
             PopulateField(ARecord,TField(FieldList.Items[0]),Values);
             exit;
        end;

        // Several values.
        for i:=0 to FieldList.Count-1 do
        begin
             PopulateField(ARecord,TField(FieldList.Items[i]),Values[i]);
        end;
     finally
        FieldList.free;
     end;
end;

procedure TkbmCustomMemTable.InternalFirst;
begin
     _InternalFirst;
end;

procedure TkbmCustomMemTable.InternalLast;
begin
     _InternalLast;
end;

procedure TkbmCustomMemTable._InternalFirst;
begin
     FRecNo:=-1;
end;

procedure TkbmCustomMemTable._InternalLast;
begin
     FRecNo:=FCurIndex.FReferences.Count;
end;

function TkbmCustomMemTable._InternalNext:boolean;
begin
     if FRecNo<FCurIndex.FReferences.Count-1 then
     begin
          Inc(FRecNo);
          Result:=true;
     end
     else Result:=false;
end;

function TkbmCustomMemTable._InternalPrior:boolean;
begin
     if FRecNo>0 then
     begin
          Dec(FRecNo);
          Result:=true;
     end
     else Result:=false;
end;

function TkbmCustomMemTable.GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult;
var
   Acceptable: Boolean;
   pRec:PkbmRecord;
begin
     Result:=grOK;
     Acceptable:=False;
     repeat
         begin
              case GetMode of
                   gmCurrent: begin
                                   if FRecNo>=FCurIndex.FReferences.Count then Result:=grEOF
                                   else if FRecNo<0 then Result:=grBOF
                                   else Result:=grOk;
                              end;
                   gmNext:    begin
                                   if _InternalNext then Result:=grOK
                                   else Result:=grEOF;
                              end;
                   gmPrior:   begin
                                   if _InternalPrior then Result:=grOK
                                   else Result:=grBOF;
                              end;
              end;
              if Result=grOk then
              begin
                   // Check if record is acceptable according to filtering, master/detail and ranges.
                   pRec:=PkbmRecord(FCurIndex.FReferences.Items[FRecNo]);
                   Acceptable:=FilterRecord(pRec);
                   if (Acceptable) then
                   begin
                        // Fill record part of buffer
                        _InternalFreeRecordVarLengths(PkbmRecord(Buffer));
                        _InternalClearRecord(PkbmRecord(Buffer));
                        _InternalMoveRecord(pRec,PkbmRecord(Buffer),false);

                        //fill information part of buffer
                        with PkbmRecord(Buffer)^ do
                        begin
                             RecordNo:=FRecNo+1;
                             RecordID:=pRec^.RecordID;
                             UniqueRecordID:=pRec^.UniqueRecordID;
                             BookmarkFlag:=bfCurrent;
                             BookmarkData:=RecordNo;
                        end;
                        if FRecalcOnFetch then GetCalcFields(Buffer);
                   end
                   else
                       if (GetMode=gmCurrent) then Result:=grError;
              end;
         end;
     until (Result<>grOk) or Acceptable;
end;

function TkbmCustomMemTable.FindRecord(Restart, GoForward: Boolean): Boolean;
var
   Status:boolean;
begin
     CheckBrowseMode;
     DoBeforeScroll;
     SetFound(False);
     UpdateCursorPos;
     CursorPosChanged;

     if GoForward then
     begin
          if Restart then _InternalFirst;
          Status := _InternalNext;
     end else
     begin
          if Restart then _InternalLast;
          Status := _InternalPrior;
     end;

     if Status then
     begin
          Resync([rmExact, rmCenter]);
          SetFound(True);
     end;
     Result := Found;
     if Result then DoAfterScroll;
end;

{$ifdef LEVEL5}
// Free filter buffers.
procedure TkbmCustomMemTable.FreeFilter;
begin
     if Assigned(FFilterParser) then
     begin
          FFilterParser.free;
          FFilterParser:=nil;
     end;
end;

// Parse filterstring and build new filter.
// Filter operators supported:
// = < > <> <= >= AND OR NULL
// Field Operator Constant Eg: Field1>32 and Field2='ABC'
procedure TkbmCustomMemTable.BuildFilter(Filter:string);
begin
     Filter:=Trim(Filter);
     if Filter='' then exit;

     if FFilterParser<>nil then
     begin
          FFilterParser.free;
          FFilterParser:=nil;
     end;

     FFilterParser:=TExprParser.Create(self,Filter,FFilterOptions,[poExtSyntax],'',nil,FldTypeMap);
end;

// Parse build filter.
function TkbmCustomMemTable.ParseFilter(FilterExpr:TExprParser):variant;
var
   //iVersion,iTotalSize,iNodes,iNodeStart:Word;
   iLiteralStart:Word;

   function ParseNode(pfdStart,pfd:PChar):variant;
   var
      b:WordBool;

      iClass:NODEClass;
      iOperator:TCANOperator;

      pArg1,pArg2:PChar;
      Arg1:variant;

      //     FieldNo:integer;
      FieldName:String;
      DataType:TFieldType;
      DataOfs:integer;
      //     DataSize:integer;

      ts:TTimeStamp;
      dt:TDateTime;
      cdt:Comp;
      bcd:TBCD;
   type
      PDouble=^Double;
      PTimeStamp=^TTimeStamp;
      PComp=^Comp;
      PWordBool=^WordBool;
      PBCD=^TBCD;
   begin
        // Get node class.
        iClass:=NODEClass(PInteger(@pfd[0])^);
        iOperator:=TCANOperator(PInteger(@pfd[4])^);
        inc(pfd,CANHDRSIZE);

//        ShowMessage(Format('Class=%d, Operator=%d',[ord(iClass),ord(iOperator)]));

        // Check class.
        case iClass of
            nodeFIELD:
               begin
                    case iOperator of
                         coFIELD2:
                           begin
//                                FieldNo:=PWord(@pfd[0])^ - 1;
                                DataOfs:=iLiteralStart+PWord(@pfd[2])^;
                                pArg1:=pfdStart;
                                inc(pArg1,DataOfs);
                                FieldName:=StrPas(pArg1);
                                Result:=FieldByName(FieldName).Value;
                           end;
                         else
                             raise EMemTableError.CreateFmt(kbmUnknownOperator,[ord(iOperator)]);
                    end;
               end;

            nodeCONST:
               begin
                    case iOperator of
                         coCONST2:
                           begin
                                DataType:=TFieldType(PWord(@pfd[0])^);
                                // DataSize:=PWord(@pfd[2])^;
                                DataOfs:=iLiteralStart+PWord(@pfd[4])^;

                                pArg1:=pfdStart;
                                inc(pArg1,DataOfs);

                                // Check type.
                                Case DataType of
                                     ftSmallInt, ftWord: Result:=PWord(pArg1)^;
                                     ftInteger, ftAutoInc: Result:=PInteger(pArg1)^;
                                     ftFloat, ftCurrency: Result:=PDouble(pArg1)^;
                                     ftString, ftFixedChar, ftGuid: Result:=StrPas(pArg1);
                                     ftDate:
                                       begin
                                            ts.Date:=PInteger(pArg1)^;
                                            ts.Time:=0;
                                            dt:=TimeStampToDateTime(ts);
                                            Result:=dt;
                                       end;
                                     ftTime:
                                       begin
                                            ts.Date:=0;
                                            ts.Time:=PInteger(pArg1)^;;
                                            dt:=TimeStampToDateTime(ts);
                                            Result:=dt;
                                       end;
                                     ftDateTime:
                                       begin
                                            cdt:=PComp(pArg1)^;
                                            ts:=MSecsToTimeStamp(cdt);
                                            dt:=TimeStampToDateTime(ts);
                                            Result:=dt;
                                       end;
                                     ftBoolean: Result:=PWordBool(pArg1)^;
                                     ftBCD:
                                       begin
                                            bcd:=PBCD(pArg1)^;
//                                            BCDToCurr(bcd,Cur);
//                                            Result:=Cur;
                                            Result:=0;
                                       end;
                                     else
                                         raise EMemTableError.CreateFmt(kbmUnknownFieldType,[ord(DataType)]);
                                end;
                           end;
                    end;
               end;
            nodeUNARY:
               begin
                    pArg1:=pfdStart;
                    inc(pArg1,CANEXPRSIZE+PWord(@pfd[0])^);

                    case iOperator of
                         coISBLANK,coNOTBLANK:
                           begin
                                Arg1:=ParseNode(pfdStart,pArg1);
                                b:=(VarIsEmpty(Arg1) or VarIsNull(Arg1));
                                if iOperator=coNOTBLANK then b:=not b;
                                Result:=Variant(b);
                           end;

                         coNOT:
                           begin
                                b:=not WordBool(ParseNode(pfdStart,pArg1));
                                Result:=Variant(b);
                           end;

                         coMINUS: Result:=-ParseNode(pfdStart,pArg1);
                         coUPPER: Result:=UpperCase(VarToStr(ParseNode(pfdStart,pArg1)));
                         coLOWER: Result:=LowerCase(VarToStr(ParseNode(pfdStart,pArg1)));
                    end;
               end;
            nodeBINARY:
               begin
                    // Get Loper and Roper pointers to buffer.
                    pArg1:=pfdStart;
                    inc(pArg1,CANEXPRSIZE+PWord(@pfd[0])^);
                    pArg2:=pfdStart;
                    inc(pArg2,CANEXPRSIZE+PWord(@pfd[2])^);

                    // Check operator for what to do.
                    case iOperator of
                         coEQ:
                           begin
                                b:=(ParseNode(pfdStart,pArg1) = ParseNode(pfdStart,pArg2));
                                Result:=Variant(b);
                                exit;
                           end;

                         coNE:
                           begin
                                b:=(ParseNode(pfdStart,pArg1) <> ParseNode(pfdStart,pArg2));
                                Result:=Variant(b);
                                exit;
                           end;

                         coGT:
                           begin
                                b:=(ParseNode(pfdStart,pArg1) > ParseNode(pfdStart,pArg2));
                                Result:=Variant(b);
                                exit;
                           end;

                         coGE:
                           begin
                                b:=(ParseNode(pfdStart,pArg1) >= ParseNode(pfdStart,pArg2));
                                Result:=Variant(b);
                                exit;
                           end;

                         coLT:
                           begin
                                b:=(ParseNode(pfdStart,pArg1) < ParseNode(pfdStart,pArg2));
                                Result:=Variant(b);
                                exit;
                           end;

                         coLE:
                           begin
                                b:=(ParseNode(pfdStart,pArg1) <= ParseNode(pfdStart,pArg2));
                                Result:=Variant(b);
                                exit;
                           end;

                         coOR:
                           begin
                                b:=(WordBool(ParseNode(pfdStart,pArg1)) or WordBool(ParseNode(pfdStart,pArg2)));
                                Result:=Variant(b);
                                exit;
                           end;

                         coAND:
                           begin
                                b:=(WordBool(ParseNode(pfdStart,pArg1)) and WordBool(ParseNode(pfdStart,pArg2)));
                                Result:=Variant(b);
                                exit;
                           end;

                         coADD:
                           begin
                                Result:=(ParseNode(pfdStart,pArg1) + ParseNode(pfdStart,pArg2));
                                exit;
                           end;

                         coSUB:
                           begin
                                Result:=(ParseNode(pfdStart,pArg1) - ParseNode(pfdStart,pArg2));
                                exit;
                           end;

                         coMUL:
                           begin
                                Result:=(ParseNode(pfdStart,pArg1) * ParseNode(pfdStart,pArg2));
                                exit;
                           end;

                         coDIV:
                           begin
                                Result:=(ParseNode(pfdStart,pArg1) / ParseNode(pfdStart,pArg2));
                                exit;
                           end;

                         coMOD,coREM:
                           begin
                                Result:=(ParseNode(pfdStart,pArg1) mod ParseNode(pfdStart,pArg2));
                                exit;
                           end;
                         else
                           begin
                                raise EMemTableError.CreateFmt(kbmOperatorNotSupported,[ord(iOperator)]);
                           end;
                    end;
               end;
        end;
   end;

var
   pfdStart,pfd:PChar;
begin
     pfdStart:=@FilterExpr.FilterData[0];
     pfd:=pfdStart;

     // Get header.
     //     iVersion:=PWord(@pfd[0])^;
     //     iTotalSize:=PWord(@pfd[2])^;
     //     iNodes:=PWord(@pfd[4])^;
     //     iNodeStart:=PWord(@pfd[6])^;
     iLiteralStart:=PWord(@pfd[8])^;
     inc(pfd,10);

     // Show header.
{
     ShowMessage(Format('Version=%d, TotalSize=%d, Nodes=%d, NodeStart=%d, LiteralStart=%d',
        [iVersion,iTotalSize,iNodes,iNodeStart,iLiteralStart]));

     s:='';
     for i:=0 to FFilterParser.DataSize-1 do
     begin
          b:=FFilterParser.FilterData[i];
          if (b>=32) and (b<=127) then s1:=chr(b)
          else s1:=' ';
          s:=s+Format('%d=%0.2x%s ',[i,FFilterParser.FilterData[i],s1]);
     end;
     ShowMessage(s);
}
     Result:=ParseNode(pfdStart,pfd);
end;

// Filter record according to filterexpression.
function TkbmCustomMemTable.FilterExpression(ARecord:PkbmRecord):boolean;
var
   noderes:variant;
begin
     noderes:=ParseFilter(FFilterParser);
     Result:=(WordBool(noderes)=true);
//     ShowMessage(Format('noderes=%d Result=%d',[integer(noderes),ord(Result)]));
end;
{$endif}

// Is any record filtering applied.
// Could be master/detail or userdefined filter.
function TkbmCustomMemTable.IsFiltered:boolean;
begin
     Result:=(FStatusFilter<>[]) or
             (FDeleteCount<>0) and not (UsDeleted in FStatusFilter) or
             (Filtered and ({$IFDEF LEVEL5}Assigned(FFilterParser) or {$ENDIF}Assigned(OnFilterRecord)))
             or ((FMasterLink <> nil) and Assigned(FMasterLink.DataSource) and (FMasterLink.FieldNames<>'') and (FIndexList.Count>0))
             or (FRangeActive);
end;

// Filter record according to master table.
function TkbmCustomMemTable.FilterMasterDetail(ARecord:PkbmRecord):boolean;
begin
     Result:=_InternalCompareRecords(FIndexList,FMasterLink.Fields.Count,FKeyBuffers[kbmkbMasterDetail],ARecord,[])=0;
end;

// Filter record according to range.
function TkbmCustomMemTable.FilterRange(ARecord:PkbmRecord): Boolean;
begin
     // Compare buffer with start and end values.
     Result:=(_InternalCompareRecords(FIndexList,-1,FKeyBuffers[kbmkbRangeStart],ARecord,[mtcoIgnoreNullKey])<=0)
             and (_InternalCompareRecords(FIndexList,-1,FKeyBuffers[kbmkbRangeEnd],ARecord,[mtcoIgnoreNullKey])>=0);
end;

// Filter records in general for
// master/detail, range and userdefined filter.
function TkbmCustomMemTable.FilterRecord(ARecord:PkbmRecord): Boolean;
var
   SaveState: TDatasetState;
label
   L_Exit;
begin
     Result:=True;
     if not IsFiltered then Exit;

     // Check if record is deleted, but versioning.
     if (FStatusFilter<>[]) and not (ARecord^.UpdateStatus in FStatusFilter) or
        (FStatusFilter=[]) and (ARecord^.UpdateStatus=usDeleted) then
     begin
          Result:=False;
          exit;
     end;

     // Now we will apply the filters on the record.
     SaveState:=SetTempState(dsFilter);
     FFilterRecord:=ARecord;

     // Check if to recalc before compare.
     if FRecalcOnIndex then
     begin
          ClearCalcFields(PChar(ARecord));
          GetCalcFields(PChar(ARecord));
     end;

     // Check if range filtering.
     if FRangeActive then
     begin
          Result:=FilterRange(ARecord);
          if not Result then goto L_exit;
     end;

     // Check if master/detail filtering.
     if Assigned(FMasterLink.DataSource) and (FMasterLink.FieldNames<>'') then
     begin
          Result:=FilterMasterDetail(ARecord);
          if not Result then goto L_Exit;
     end;

     // Call users own filtering if specified.
     if Filtered and Assigned(OnFilterRecord) then
     begin
          OnFilterRecord(self,Result);
          if not Result then goto L_Exit;
     end;

{$IFDEF LEVEL5}
     // Check if filterstring active.
     if Assigned(FFilterParser) then
     begin
          Result:=FilterExpression(ARecord);
          if not Result then goto L_exit;
     end;
{$ENDIF}

L_Exit:
     // Finished filtering.
     RestoreState(SaveState);
end;

procedure TkbmCustomMemTable.InternalSetToRecord(Buffer: PChar);
begin
     if Buffer=nil then exit;
     InternalGotoBookmark(@PkbmRecord(Buffer)^.BookmarkData);
end;

function TkbmCustomMemTable.GetRecordCount: integer;
var
   SaveState: TDataSetState;
   SavePosition: integer;
   TempBuffer: PChar;
begin
     if not Active then DatabaseError(SDatasetClosed, Self);
     
     if not IsFiltered then Result:=FCurIndex.FReferences.Count
     else
     begin
          Result:=0;
          SaveState:=SetTempState(dsBrowse);
          SavePosition:=FRecNo;
          TempBuffer:=PChar(_InternalAllocRecord);
          try
             InternalFirst;
             while GetRecord(TempBuffer,gmNext,True)=grOk do Inc(Result);
          finally
             RestoreState(SaveState);
             FRecNo:=SavePosition;
             _InternalFreeRecord(PkbmRecord(TempBuffer),false,false);
          end;
     end;
end;

function TkbmCustomMemTable.GetRecNo: integer;
begin
     if (ActiveBuffer = nil) then Result:=-1
     else Result:=PkbmRecord(ActiveBuffer)^.RecordNo;
end;

procedure TkbmCustomMemTable.SetRecNo(Value: Integer);
begin
     if (Value>0) and (Value<=FCurIndex.FReferences.Count) and (Pred(Value)<>FRecNo) then
     begin
          FRecNo:=Value-1;
          CursorPosChanged;
          Resync([rmExact,rmCenter]);
     end;
end;

procedure TkbmCustomMemTable.InternalAddRecord(Buffer: Pointer; Append: Boolean);
var
   pRec,pCopyRec:PkbmRecord;
   where:integer;
begin
     pRec:=PkbmRecord(Buffer);

     // Check record acceptance.
//     FIndexes.CheckRecord(Buffer,nil);

     // Copy the reference record.
     pCopyRec:=_InternalCopyRecord(pRec,false);

     // Update indexes and add physical record.
     where:=FRecNo;
     if Append then where:=-1;
     if FAttachedTo<>nil then
        FAttachedTo.DoCascadeUpdateIndexes(mtiuhInsert,nil,pCopyRec,where)
     else
        DoCascadeUpdateIndexes(mtiuhInsert,nil,pCopyRec,where);

     if IsJournaling then FJournal.Add(mtjoInsert,pCopyRec,nil);

     // Append the reference record.
     pCopyRec^.TransactionLevel:=FTransactionLevel;
     _InternalAppendRecord(pCopyRec);
end;

procedure TkbmCustomMemTable.InternalDelete;
var
   pRec,pDelRec:PkbmRecord;
   lst:TList;
begin
     pRec:=PkbmRecord(FCurIndex.FReferences.Items[FRecNo]);

     // Check if journaling.
     if IsJournaling then FJournal.Add(mtjoDelete,nil,pRec);

     // Check if versioning. Dont delete the record. Only mark it as so.
     if IsVersioning then
     begin
          pDelRec:=_InternalCopyRecord(pRec,true);
          pRec^.PrevRecordVersion:=pDelRec;
          pRec^.UpdateStatus:=usDeleted;
          pRec^.TransactionLevel:=FTransactionLevel;
          inc(FDeleteCount);
          exit;
     end;

     // Update indexes.
     if FAttachedTo<>nil then
        FAttachedTo.DoCascadeUpdateIndexes(mtiuhDelete,pRec,nil,FRecNo)
     else
         DoCascadeUpdateIndexes(mtiuhDelete,pRec,nil,FRecNo);

     _InternalDeleteRecord(pRec);

     // After deleted last record, reset state of the table to empty.
     lst:=FRecords.LockList;
     try
        if (lst.Count=0) then _InternalEmpty(false);
     finally
        FRecords.UnlockList;
     end;
end;

procedure TkbmCustomMemTable.InternalInitRecord(Buffer: PChar);
begin
     // Clearout record contents.
     _InternalClearRecord(PkbmRecord(Buffer));
end;

procedure TkbmCustomMemTable.InternalPost;
var
   pActRec,pNewRec,pRec:PkbmRecord;
begin
     pActRec:=PkbmRecord(ActiveBuffer);

     if State = dsEdit then
     begin
          // Get reference to record to modify.
          pRec:=FCurIndex.FReferences.Items[FRecNo];

          // Check that record does not violate index.
          FIndexes.CheckRecordUniqueness(pActRec,pRec);
          AttachedChildrenCheckRecordUniqueness(pActRec,pRec);

          // Check if to update journal.
          if IsJournaling then FJournal.Add(mtjoEdit,pActRec,pRec);

          // Check if to update version.
          if IsVersioning and Modified then
          begin
               // Check if only to keep original record since checkpoint.
               if (FVersioningMode=mtvmAllSinceCheckPoint) or
                  ((FVersioningMode=mtvm1SinceCheckPoint) and (pActRec^.UpdateStatus=usUnModified)) then
               begin
                    pActRec^.UpdateStatus:=UsModified;
                    pActRec^.PrevRecordVersion:=_InternalCopyRecord(pRec,True);
               end;
          end;

          // Update index.
          if FAttachedTo<>nil then
             FAttachedTo.DoCascadeUpdateIndexes(mtiuhEdit,pRec,pActRec,FRecNo)
          else
              DoCascadeUpdateIndexes(mtiuhEdit,pRec,pActRec,FRecNo);

          // Alter the physical record.
          _InternalFreeRecordVarLengths(pRec);
          _InternalCopyVarLengths(pActRec,pRec);
          _InternalMoveRecord(pActRec,pRec,false);
          _InternalFreeRecordVarLengths(pActRec);
          pRec^.TransactionLevel:=FTransactionLevel;
     end
     else
     begin
          // Check record acceptance.
          FIndexes.CheckRecordUniqueness(pActRec,nil);

          // New record. Allocate room for it and copy the reference record.
          pNewRec:=_InternalCopyRecord(pActRec,true);
          _InternalFreeRecordVarLengths(pActRec);
          pActRec^.RecordNo:=FRecNo-1;

          if IsJournaling then FJournal.Add(mtjoInsert,pNewRec,nil);

          // Add the physical record.
          _InternalAppendRecord(pNewRec);
          pNewRec^.TransactionLevel:=FTransactionLevel;

          // Add to index.
          if FAttachedTo<>nil then
             FAttachedTo.DoCascadeUpdateIndexes(mtiuhInsert,nil,pNewRec,FRecNo)
          else
              DoCascadeUpdateIndexes(mtiuhInsert,nil,pNewRec,FRecNo);
     end;
     ClearModifiedFlags;
end;

procedure TkbmCustomMemTable.InternalEdit;
begin
     inherited InternalEdit;
end;

{$ifndef LEVEL3}
procedure TkbmCustomMemTable.InternalInsert;
begin
     inherited InternalInsert;
end;
{$endif}

procedure TkbmCustomMemTable.InternalCancel;
begin
     inherited InternalCancel;
     ClearModifiedFlags;
end;

// Bookmark handling.

procedure TkbmCustomMemTable.SetBookmarkFlag(Buffer:PChar; Value:TBookmarkFlag);
begin
     PkbmRecord(Buffer).BookmarkFlag:=Value;
end;

function TkbmCustomMemTable.GetBookmarkFlag(Buffer:PChar): TBookmarkFlag;
begin
     Result:=PkbmRecord(Buffer).BookmarkFlag;
end;

procedure TkbmCustomMemTable.GetBookmarkData(Buffer:PChar; Data:Pointer);
begin
     PInteger(Data)^:=PkbmRecord(Buffer)^.BookmarkData;
end;

procedure TkbmCustomMemTable.SetBookmarkData(Buffer:PChar; Data:Pointer);
begin
     PkbmRecord(Buffer)^.BookmarkData:=PInteger(Data)^;
end;

// Check if a bookmarkpointer is actually valid.
function TkbmCustomMemTable.InternalBookmarkValid(Bookmark:Pointer):boolean;
var
   b:integer;
   lst:TList;
begin
     CursorPosChanged;
     b:=PInteger(Bookmark)^;

     lst:=FRecords.LockList;
     try
        Result:=((b>0) and (b<=lst.Count));
     finally
        FRecords.UnlockList;
     end;
end;

function TkbmCustomMemTable.BookmarkValid(Bookmark:TBookmark): boolean;
begin
     result:=InternalBookmarkValid(Bookmark);
end;

function TkbmCustomMemTable.CompareBookmarks(Bookmark1,Bookmark2:TBookmark): Integer;
const
     RetCodes: array[Boolean, Boolean] of ShortInt = ((2,-1),(1,0));
var
   b1,b2:integer;
begin
     // Check for uninitialized bookmarks
     Result := RetCodes[Bookmark1 = nil, Bookmark2 = nil];
     if (Result = 2) then
     begin
          b1:=PInteger(Bookmark1)^;
          b2:=PInteger(Bookmark2)^;
          if b1<b2 then Result:=-1
          else if b1>b2 then Result:=1
          else Result:=0;
     end;
end;

procedure TkbmCustomMemTable.InternalGotoBookmark(Bookmark:Pointer);
var
   b:integer;
   lst:TList;
begin
     if (Bookmark=nil) then
        raise EMemTableError.CreateFmt(kbmBookmErr,[-200]);
     b:=PInteger(Bookmark)^;

     lst:=FRecords.LockList;
     try
        if (b<1) or (b>lst.Count) then
           raise EMemTableError.CreateFmt(kbmBookmErr,[PInteger(Bookmark)^]);
     finally
        FRecords.UnlockList;
     end;

     FRecNo:=b-1;
end;

procedure TkbmCustomMemTable.InternalHandleException;
begin
     Application.HandleException(Self);
end;

procedure TkbmCustomMemTable.SaveToFile(const FileName:string; flags:TkbmMemTableSaveFlags);
var
   Stream: TStream;
begin
     if (mtfSaveAppend in flags) then
     begin
          Stream := TFileStream.Create(FileName,fmOpenReadWrite + fmShareDenyWrite);
          Stream.Seek(0,soFromEnd);
     end
     else
         Stream := TFileStream.Create(FileName,fmCreate);
     try
        if (assigned(FOnSave)) then FOnSave(self,mtstFile,Stream);
        InternalSaveToStream(Stream,flags);
     finally
        Stream.Free;
     end;
end;

procedure TkbmCustomMemTable.SaveToBinaryFile(const FileName:string; flags:TkbmMemTableSaveFlags);
var
   Stream: TStream;
begin
     if (mtfSaveAppend in flags) then
     begin
          Stream := TFileStream.Create(FileName,fmOpenReadWrite + fmShareDenyWrite);
          Stream.Seek(0,soFromEnd);
     end
     else
         Stream := TFileStream.Create(FileName,fmCreate);
     try
        if (assigned(FOnSave)) then FOnSave(self,mtstBinaryFile,Stream);
        InternalSaveToBinaryStream(Stream,flags);
     finally
        Stream.Free;
     end;
end;

procedure TkbmCustomMemTable.SaveToStream(Stream:TStream; flags:TkbmMemTableSaveFlags);
begin
     if (mtfSaveAppend in flags) then Stream.Seek(0,soFromEnd);
     if (assigned(FOnSave)) then FOnSave(self,mtstStream,Stream);
     InternalSaveToStream(Stream,flags);
end;

procedure TkbmCustomMemTable.SaveToBinaryStream(Stream:TStream; flags:TkbmMemTableSaveFlags);
begin
     if (mtfSaveAppend in flags) then Stream.Seek(0,soFromEnd);
     if (assigned(FOnSave)) then FOnSave(self,mtstBinaryStream,Stream);
     InternalSaveToBinaryStream(Stream,flags);
end;

procedure TkbmCustomMemTable.CloseBlob(Field:TField);
var
   pField:PChar;
   pBlob:PPkbmVarLength;
begin
     if (FRecNo<0) or (FRecNo>=FCurIndex.FReferences.Count) or (not (State in [dsEdit,dsInactive])) then
     begin
          if Field.DataType in kbmBlobTypes then
          begin
               pField:=GetFieldPointer(PkbmRecord(ActiveBuffer),Field);
               pBlob:=PPkbmVarLength(pField+1);
               pField[0]:=#0;
               pBlob^:=nil;
          end;
     end;
end;

procedure TkbmCustomMemTable.InternalSaveToStream(Stream:TStream; flags:TkbmMemTableSaveFlags);
var
   i,j:integer;
   nf:integer;
   s,a:string;
   l:integer;
   fset,f:^Boolean;
   Ods,Oms,Ots,Oths:char;
   Ocf,Onf:Byte;
   Osdf,Ocs:string;
   oStream:TStream;
   filt,range:boolean;
   md:TMasterDataLink;
   Accept:boolean;
   SaveData:boolean;
   SaveDeltas:boolean;
begin
     // Setup standard layout for data.
     Ods:=DateSeparator;
     Oms:=DecimalSeparator;
     Ots:=TimeSeparator;
     Oths:=ThousandSeparator;
     Ocf:=CurrencyFormat;
     Onf:=NegCurrFormat;
     Osdf:=ShortDateFormat;
     Ocs:=CurrencyString;

     if not (mtfSaveInLocalFormat in flags) then
     begin
          DateSeparator:='/';
          TimeSeparator:=':';
          ThousandSeparator:=',';
          DecimalSeparator:='.';
          ShortDateFormat:='dd/mm/yyyy';
          CurrencyString:='';
          CurrencyFormat:=0;
          NegCurrFormat:=1;
     end;

     // Check if to save filtered data.
     filt:=Filtered;
     md:=FMasterLink;
     range:=FRangeActive;
     if Filtered and (mtfSaveFiltered in flags) then Filtered:=false;
     if (md<>nil) and (mtfSaveIgnoreMasterDetail in flags) then FMasterLink:=nil;
     if range and (mtfSaveIgnoreRange in flags) then FRangeActive:=false;

     SaveData:=mtfSaveData in flags;
     SaveDeltas:=mtfSaveDeltas in flags;
     if SaveDeltas then
        raise EMemTableError.Create(kbmSavingDeltasBinary);

     fset:=nil;
     oStream:=nil;
     FRecords.LockList;
     FState:=mtstSave;
     Progress(0,mtpcSave);
     try
        DisableControls;

        // If to compress stream, create memory stream to save to instead.
        if Assigned(FOnCompressSave) then
        begin
             oStream:=Stream;
             Stream:=TMemoryStream.Create;
        end;

        // Setup flags for fields to save.
        nf:=Fieldcount;
        GetMem(fset,nf * sizeof(boolean));
        f:=fset;
        for i:=0 to nf-1 do
        begin
             // Default dont save this field.
             f^:=false;

             // If a blob field, only save if specified.
             if (Fields[i].DataType in kbmBlobTypes) then
             begin
                  if not (mtfSaveBlobs in flags) then continue;
                  f^:=true;
             end;

             // Only save fields of specific types.
             case Fields[i].FieldKind of
                  fkData: if SaveData then f^:=true;
                  fkCalculated: if mtfSaveCalculated in flags then f^:=true;
                  fkLookup: if mtfSaveLookup in flags then f^:=true;
                  else f^:=true;
             end;

             // If not to save invisible fields, dont.
             if not (Fields[i].Visible or (mtfSaveNonVisible in flags)) then f^:=false;
             inc(f);
        end;

        // Write definition in CSV format.
        if mtfSaveDef in flags then
        begin
{$IFNDEF CSV_FILE_1XX_COMPATIBILITY}
             // Write file version.
             s:=AnsiQuotedStr(PChar(kbmFileVersionMagic),FCSVQuote)+',"'+IntToStr(kbmCSVFileVersion)+'"'+#13+#10;
             l:=length(s);
             Stream.WriteBuffer(Pointer(s)^, l);
{$ENDIF}

             // Write header.
             s:=AnsiQuotedStr(PChar(kbmTableDefMagicStart),FCSVQuote)+#13+#10;
             l:=length(s);
             Stream.WriteBuffer(Pointer(s)^, l);

             // Write fielddefinitions.
             f:=fset;
             for i:=0 to nf-1 do
             begin
                  if f^ or (not (mtfSkipRest in flags)) then
                  begin
                       s:=Fields[i].FieldName+'='+
                           FieldTypeNames[Fields[i].DataType]+','+
                           inttostr(Fields[i].Size)+','+
                           AnsiQuotedStr(Fields[i].DisplayName,'"')+','+
                           AnsiQuotedStr(Fields[i].EditMask,'"')+','+
                           inttostr(Fields[i].DisplayWidth);
                       if Fields[i].Required then s:=s+',REQ';
                       if Fields[i].ReadOnly then s:=s+',RO';
                       s:=AnsiQuotedStr(PChar(s),FCSVQuote)+#13+#10;
                       l:=length(s);
                       Stream.WriteBuffer(Pointer(s)^, l);
                  end;

                  inc(f);
             end;

{$IFNDEF CSV_FILE_1XX_COMPATIBILITY}
             // Check if to write index definitions.
             if mtfSaveIndexDef in flags then
             begin
                  // Write header.
                  s:=AnsiQuotedStr(PChar(kbmIndexDefMagicStart),FCSVQuote)+#13+#10;
                  l:=length(s);
                  Stream.WriteBuffer(Pointer(s)^, l);

                  // Write indexdefinitions.
                  for i:=0 to FIndexDefs.count-1 do
                      with FIndexDefs.Items[i] do
                      begin
                           s:=Name+'='+
                              AnsiQuotedStr(Fields,FCSVQuote)+','+
{$IFDEF LEVEL3}
                              Name;
{$ELSE}
                              AnsiQuotedStr(DisplayName,FCSVQuote);
{$ENDIF}
                           if ixDescending in Options then s:=s+',DESC';
                           if ixCaseInsensitive in Options then s:=s+',CASE';
{$IFNDEF LEVEL3}
                           if ixNonMaintained in Options then s:=s+',NONMT';
{$ENDIF}
                           if ixUnique in Options then s:=s+',UNIQ';
                           s:=AnsiQuotedStr(PChar(s),FCSVQuote)+#13+#10;
                           l:=length(s);
                           Stream.WriteBuffer(Pointer(s)^, l);
                      end;

                  // Write footer.
                  s:=AnsiQuotedStr(PChar(kbmIndexDefMagicEnd),FCSVQuote)+#13+#10;
                  l:=length(s);
                  Stream.WriteBuffer(Pointer(s)^, l);
             end;
{$ENDIF}

             // Write footer.
             s:=AnsiQuotedStr(PChar(kbmTableDefMagicEnd),FCSVQuote)+#13+#10;
             l:=length(s);
             Stream.WriteBuffer(Pointer(s)^, l);
        end;

        // Write all field display names in CSV format.
        s:='';
        f:=fset;
        for i:=0 to nf-1 do
        begin
             if f^ or (not (mtfSkipRest in flags)) then
             begin
                  s:=s+AnsiQuotedStr(PChar(Fields[i].DisplayName),FCSVQuote);
                  if (i<nf-1) then s:=s+FCSVFieldDelimiter;
             end;
             inc(f);
        end;
        if FCSVRecordDelimiter <> #0 then s:=s+FCSVRecordDelimiter;
        s:=s+#13+#10;
        l:=length(s);
        Stream.Write(Pointer(s)^, l);

        // Write all records in CSV format ordered by current index.
        for j:=0 to FCurIndex.FReferences.count-1 do
        begin
             if (j mod 100)=0 then Progress(trunc((j/FCurIndex.FReferences.count)*100),mtpcSave);

             // Setup which record to work on.
             FOverrideActiveRecordBuffer:=PkbmRecord(FCurIndex.FReferences.Items[j]);
             if FOverrideActiveRecordBuffer=nil then continue;

             // Check filter of record.
             Accept:=FilterRecord(FOverrideActiveRecordBuffer);
             if not Accept then continue;

             // Check if to accept that record for save.
             Accept:=true;
             if Assigned(FOnSaveRecord) then FOnSaveRecord(self,Accept);
             if not Accept then continue;

             // Write current record.
             s:='';
             a:='';
             f:=fset;
             for i:=0 to nf-1 do
             begin
                  if f^ then
                  begin
                       if Assigned(FOnSaveField) then FOnSaveField(self,i,Fields[i]);
                       if (Fields[i].IsNull) then s:=s+a
                       else if Fields[i].DataType in kbmStringTypes then
                           s:=s+a+AnsiQuotedStr(StringToCodedString(Fields[i].AsString),FCSVQuote)
                       else if Fields[i].DataType in kbmBinaryTypes then
                           s:=s+a+AnsiQuotedStr(StringToBase64(Fields[i].AsString),FCSVQuote)
                       else
                           s:=s+a+AnsiQuotedStr(PChar(Fields[i].AsString),FCSVQuote);
                       a:=FCSVFieldDelimiter;
                  end
                  else if not (mtfSkipRest in flags) then
                  begin
                       s:=s+a;
                       a:=FCSVFieldDelimiter;
                  end;
                  inc(f);
             end;

             // Add record delimiter.
             if FCSVRecordDelimiter <> #0 then s:=s+FCSVRecordDelimiter;
             s:=s+#13+#10;
             l:=length(s);

             // Write line.
             Stream.WriteBuffer(Pointer(s)^, l);
        end;

        // If to compress stream, send saved memorystream through event and save to original stream.
        if Assigned(FOnCompressSave) then FOnCompressSave(Stream,oStream);

     finally
        FOverrideActiveRecordBuffer:=nil;

        // Restore locale setup.
        DateSeparator:=Ods;
        DecimalSeparator:=Oms;
        TimeSeparator:=Ots;
        ThousandSeparator:=Oths;
        CurrencyFormat:=Ocf;
        NegCurrFormat:=Onf;
        ShortDateFormat:=Osdf;
        CurrencyString:=Ocs;

        if fset<>nil then FreeMem(fset);
        if oStream<>nil then Stream.free;

        FMasterLink:=md;
        FRangeActive:=range;
        Filtered:=filt;

        FOverrideActiveRecordBuffer:=nil;
        FRecords.UnlockList;
        EnableControls;
        Progress(100,mtpcSave);
        FState:=mtstBrowse;
     end;
end;

procedure TkbmCustomMemTable.InternalSaveToBinaryStream(Stream: TStream; flags:TkbmMemTableSaveFlags);
var
   i,j:integer;
   nf:integer;
   fset,f:^Boolean;
   oStream:TStream;
   Writer:TWriter;
   filt,range:boolean;
   md:TMasterDataLink;
   Accept:boolean;
   SaveData:boolean;
   SaveDeltas:boolean;
   SaveDontFilterDeltas:boolean;
   NewestVersion:boolean;
   pRec:PkbmRecord;
begin
     fset:=nil;
     oStream:=nil;

     filt:=Filtered;
     md:=FMasterLink;
     range:=FRangeActive;
     if Filtered and (mtfSaveFiltered in flags) then Filtered:=false;
     if (md<>nil) and (mtfSaveIgnoreMasterDetail in flags) then FMasterLink:=nil;
     if range and (mtfSaveIgnoreRange in flags) then FRangeActive:=false;

     SaveData:=(mtfSaveData in flags) or (mtfSaveLookup in flags) or (mtfSaveCalculated in flags);
     SaveDeltas:=mtfSaveDeltas in flags;
     SaveDontFilterDeltas:=mtfSaveDontFilterDeltas in flags;

     FState:=mtstSave;
     Progress(0,mtpcSave);

     FRecords.LockList;

     try
        DisableControls;

        // If to compress stream, create memory stream to save to instead.
        if Assigned(FOnCompressSave) then
        begin
             oStream:=Stream;
             Stream:=TMemoryStream.Create;
        end;

        Writer := TWriter.Create(Stream, 16384);
        Writer.WriteSignature;

{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
        Writer.WriteInteger(kbmBinaryFileVersion);
{$ENDIF}

        try

           // Setup flags for fields to save.
           nf:=Fieldcount;
           GetMem(fset,nf * sizeof(boolean));
           f:=fset;
           for i:=0 to nf-1 do
           begin
                // Default dont save this field.
                f^:=false;

                // If a blob field, only save if specified.
                if (Fields[i].DataType in kbmBlobTypes) then
                begin
                     if not (mtfSaveBlobs in flags) then continue;
                     f^:=true;
                end;

                // Only save fields of specific types.
                case Fields[i].FieldKind of
                     fkData: if (mtfSaveData in flags) or SaveDeltas then f^:=true;
                     fkCalculated: if mtfSaveCalculated in flags then f^:=true;
                     fkLookup: if mtfSaveLookup in flags then f^:=true;
                     else f^:=true;
                end;

                // If not to save invisible fields, dont.
                if not (Fields[i].Visible or (mtfSaveNonVisible in flags)) then f^:=false;
                inc(f);
           end;

           // Write field definitions
           Writer.WriteListBegin;

           // Write fielddefinitions.
           f:=fset;
           if (mtfSaveDef in flags) then
           begin
                for i:=0 to nf-1 do
                begin
                     if f^ then
                     begin
                          Writer.WriteString(Fields[i].FieldName);
                          Writer.WriteString(FieldTypeNames[Fields[i].DataType]);
                          Writer.WriteInteger(Fields[i].Size);
                          Writer.WriteString(Fields[i].DisplayName);
                          Writer.WriteString(Fields[i].EditMask);
                          Writer.WriteInteger(Fields[i].DisplayWidth);
                          Writer.WriteBoolean(Fields[i].Required);
                          Writer.WriteBoolean(Fields[i].ReadOnly);
                     end;

                     inc(f);
                end;
           end;
           Writer.WriteListEnd;


{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
           // Save index definitions.
           Writer.WriteListBegin;
           if mtfSaveIndexDef in flags then
           begin
                for i:=0 to FIndexDefs.Count-1 do
                    with FIndexDefs.Items[i] do
                    begin
                         Writer.WriteString(Name);
                         Writer.WriteString(Fields);
{$IFNDEF LEVEL3}
                         Writer.WriteString(DisplayName);
{$ELSE}
                         Writer.WriteString(Name);
{$ENDIF}
                         Writer.WriteBoolean(ixDescending in Options);
                         Writer.WriteBoolean(ixCaseInSensitive in Options);
{$IFNDEF LEVEL3}
                         Writer.WriteBoolean(ixNonMaintained in Options);
{$ELSE}
                         Writer.WriteBoolean(false);
{$ENDIF}
                         Writer.WriteBoolean(ixUnique in Options);
                    end;
           end;
           Writer.WriteListEnd;
{$ENDIF}

           // Write all records
           Writer.WriteListBegin;
           for j:=0 to FCurIndex.FReferences.count-1 do
           begin
                if (j mod 100)=0 then Progress(trunc((j/FCurIndex.FReferences.count)*100),mtpcSave);

                // Setup which record to look at.
                FOverrideActiveRecordBuffer:=PkbmRecord(FCurIndex.FReferences.Items[j]);
                if (FOverrideActiveRecordBuffer=nil) then continue;

                // Check filter of record.
                Accept:=FilterRecord(FOverrideActiveRecordBuffer);
                if not Accept then continue;

                // Check accept of saving this record.
                Accept:=true;
                if Assigned(FOnSaveRecord) then FOnSaveRecord(self,Accept);
                if not Accept then continue;

                // Write current record.
                NewestVersion:=true;
{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
 {$IFNDEF BINARY_FILE_200_COMPATIBILITY}
                // New for v. 2.24.
                if not SaveData and (FOverrideActiveRecordBuffer^.UpdateStatus=usUnmodified) then continue;

                // New for v. 2.30b
                if not SaveDontFilterDeltas and (FOverrideActiveRecordBuffer^.UpdateStatus=usDeleted) then
                begin
                     // Make sure record has not been inserted and deleted again.
                     pRec:=FOverrideActiveRecordBuffer^.PrevRecordVersion;
                     while pRec^.PrevRecordVersion<>nil do pRec:=pRec^.PrevRecordVersion;
                     if pRec^.UpdateStatus=usInserted then continue;
                end;

                // Write record versions in a list starting with Updatestatus.
                Writer.WriteListBegin;
                while FOverrideActiveRecordBuffer<>nil do
                begin
                     Writer.WriteInteger(ord(FOverrideActiveRecordBuffer^.UpdateStatus));
 {$ENDIF}
{$ENDIF}
                     f:=fset;
                     for i:=0 to nf-1 do
                     begin
                          if f^ then
                          begin
                               if NewestVersion and Assigned(FOnSaveField) then FOnSaveField(self,i,Fields[i]);

{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
 {$IFNDEF BINARY_FILE_200_COMPATIBILITY}
  {$IFNDEF BINARY_FILE_230_COMPATIBILITY}
                               Writer.WriteBoolean(Fields[i].IsNull);
                               if not Fields[i].IsNull then
                               begin
  {$ENDIF}
 {$ENDIF}
{$ENDIF}
                                    case Fields[i].DataType of
                                         ftBoolean : Writer.WriteBoolean(Fields[i].AsBoolean);

{$IFNDEF LEVEL3}
                                         ftLargeInt: Writer.WriteFloat(Fields[i].AsFloat);
{$ENDIF}

                                         ftSmallInt,
                                         ftInteger,
                                         ftWord,
                                         ftAutoInc : Writer.WriteInteger(Fields[i].AsInteger);

                                         ftFloat : Writer.WriteFloat(Fields[i].AsFloat);

                                         ftBCD,
                                         ftCurrency : Writer.WriteFloat(Fields[i].AsCurrency);

                                         ftDate,
                                         ftTime,ftDateTime: Writer.WriteFloat(Fields[i].AsFloat);
                                    else
                                        Writer.WriteString(Fields[i].AsString);
                                    end;
{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
 {$IFNDEF BINARY_FILE_200_COMPATIBILITY}
  {$IFNDEF BINARY_FILE_230_COMPATIBILITY}
                               end;
  {$ENDIF}
 {$ENDIF}
{$ENDIF}
                          end;

                          inc(f);
                     end;
{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
 {$IFNDEF BINARY_FILE_200_COMPATIBILITY}                         // New for v. 2.24.

                     // Only write newest version (current data).
                     if not SaveDeltas then break;

                     // Prepare writing next older version of record.
                     FOverrideActiveRecordBuffer:=FOverrideActiveRecordBuffer^.PrevRecordVersion;
                     NewestVersion:=false;
                end;
                Writer.WriteListEnd;
 {$ENDIF}
{$ENDIF}
           end;
           Writer.WriteListEnd;

        finally
           Writer.FlushBuffer;
           Writer.Free;

           // If to compress stream, send saved memorystream through event and save to original stream.
           if Assigned(FOnCompressSave) then FOnCompressSave(Stream,oStream);
        end;

     finally
        FOverrideActiveRecordBuffer:=nil;
        FMasterLink:=md;
        FRangeActive:=range;
        Filtered:=filt;
        if oStream<>nil then Stream.free;
        if fset<>nil then FreeMem(fset);
        FRecords.UnlockList;
        EnableControls;
        Progress(100,mtpcSave);
        FState:=mtstBrowse;
     end;
end;

procedure TkbmCustomMemTable.LoadFromFile(const FileName: string);
var
   Stream: TStream;
begin
     Stream := TFileStream.Create(FileName, fmOpenRead);
     try
        if assigned(FOnLoad) then FOnLoad(self,mtstFile,Stream);
        InternalLoadFromStream(Stream);
     finally
        Stream.Free;
     end;
end;

procedure TkbmCustomMemTable.LoadFromBinaryFile(const FileName: string);
var
   Stream: TStream;
begin
     Stream := TFileStream.Create(FileName, fmOpenRead);
     try
        if assigned(FOnLoad) then FOnLoad(self,mtstBinaryFile,Stream);
        InternalLoadFromBinaryStream(Stream)
     finally
        Stream.Free;
     end;
end;

procedure TkbmCustomMemTable.LoadFromStream(Stream:TStream);
begin
     if assigned(FOnLoad) then FOnLoad(self,mtstStream,Stream);
     InternalLoadFromStream(Stream);
end;

procedure TkbmCustomMemTable.LoadFromBinaryStream(Stream:TStream);
begin
     if assigned(FOnLoad) then FOnLoad(self,mtstBinaryStream,Stream);
     InternalLoadFromBinaryStream(Stream);
end;

procedure TkbmCustomMemTable.InternalLoadFromStream(Stream: TStream);
const
   BUFSIZE=8192;
var
//   FileVersion:integer;
   i:integer;
   bm:TBookmark;
   nf:integer;
   s:string;
   buf,bufptr:PChar;
   remaining_in_buf:integer;
   Line,Word:string;
   lptr,elptr:PChar;
   null:boolean;
   Ods,Oms,Ots,Oths:char;
   Ocf,Onf:Byte;
   Osdf,Ocs:string;
   DuringTableDef,DuringIndexDef:boolean;
   slist:TStringList;
   FName,TName,DName,EMask:string;
   FSize,DSize:integer;
   REQ,RO,INV,CASEIN,{$IFNDEF LEVEL3}NONMT,{$ENDIF}DESC,UNIQ:boolean;
   FT:TFieldType;
   FFields:string;
   Accept:boolean;
   oStream:TStream;
   oPersistence,oEnableIndexes:boolean;
   ioptions:TIndexOptions;

   function GetChunk:boolean;
   begin
        remaining_in_buf:=Stream.Read(pointer(buf)^,BUFSIZE);
        bufptr:=buf;
        Result:=remaining_in_buf>0;
   end;

   function GetLine:boolean;
   var
     EOL,EOF:boolean;
     ep,sp:PChar;
     TmpStr:string;
   begin
        // Cut out a line.
        EOL:=false;
        EOF:=false;
        Line:='';
        sp:=bufptr;
        ep:=bufptr;
        while true do
        begin
             // Check if need another chunk.
             if remaining_in_buf=0 then
             begin
                  // Add to line.
                  SetString(TmpStr,sp,bufptr-sp);
                  Line:=Line+TmpStr;

                  // Show progress.
                  Progress(trunc((Stream.Position / Stream.Size) * 100),mtpcLoad);

                  // Check if EOF.
                  if not GetChunk then
                  begin
                       EOF:=true;
                       break;
                  end;
                  sp:=bufptr;
             end;

             // Check if we got EOL character, skip them and finally break.
             if (bufptr^) in [#0, #10, #13] then
             begin
                  if not EOL then ep:=bufptr-1;
                  EOL:=true
             end
             else if EOL then
             begin
                  SetString(TmpStr,sp,ep-sp+1);
                  Line:=Line+TmpStr;
                  break;
             end;

             // Prepare to look at next char.
             Inc(bufptr);
             dec(remaining_in_buf);
        end;

        lptr:=PChar(Line);
        elptr:=PChar(Line)+Length(Line)-1;
        Result:=(not EOF);
   end;

   function GetWord(var null:boolean):string;
   label
     L_exit;
   var
     sptr:PChar;
     TmpStr:string;
   begin

     // Cut out next word.
     Result:='';

     // Look for starting " or ,.
     while (lptr^ <> FCSVQuote) and (lptr^ <> FCSVFieldDelimiter) and (lptr^ <> FCSVRecordDelimiter) and (lptr<elptr) do inc(lptr);
     if (lptr>=elptr) then exit;
     if (lptr^ = FCSVFieldDelimiter) or (lptr^ = FCSVRecordDelimiter) then
     begin
          null:=true;
          inc(lptr);
          exit;
     end
     else null:=false;
     inc(lptr);

     while true do
     begin
          // Look for ending ".
          sptr:=lptr;
          while not (lptr^ = FCSVQuote) do
          begin
               if (lptr>=elptr) then goto L_exit;
               inc(lptr);
          end;
          SetString(TmpStr,sptr,lptr-sptr);
          Result:=Result+TmpStr;
          inc(lptr);

          // Is it a double "" or end of word ?.
          if (lptr^ = FCSVQuote) then
          begin
               Result:=Result+FCSVQuote;
               inc(lptr);
               continue;
          end;

L_exit:
          inc(lptr);
          break;
     end;
   end;

begin
  // Dont let persistence react on internal open/close statements.
  oPersistence:=FPersistent;
  FPersistent:=false;
  oEnableIndexes:=FEnableIndexes;
  FEnableIndexes:=false;

  // Setup standard layout for data.
  Ods:=DateSeparator;
  Oms:=DecimalSeparator;
  Ots:=TimeSeparator;
  Oths:=ThousandSeparator;
  Ocf:=CurrencyFormat;
  Onf:=NegCurrFormat;
  Osdf:=ShortDateFormat;
  Ocs:=CurrencyString;

  DateSeparator:='/';
  TimeSeparator:=':';
  ThousandSeparator:=',';
  DecimalSeparator:='.';
  ShortDateFormat:='dd/mm/yyyy';
  CurrencyString:='';
  CurrencyFormat:=0;
  NegCurrFormat:=1;

  bm:=GetBookmark;

  Progress(0,mtpcLoad);

  oStream:=nil;
  FIgnoreReadOnly:=true;
  FState:=mtstLoad;
  try
     // Allocate space for a buffer.
     GetMem(buf,BUFSIZE);

     // Still nothing in the buffer to handle.
     remaining_in_buf:=0;

     DisableControls;

     // If to decompress stream, create memory stream to load from instead.
     if Assigned(FOnDeCompressLoad) then
     begin
          oStream:=Stream;
          Stream:=TMemoryStream.Create;
          FOnDecompressLoad(oStream,Stream);
          Stream.Position:=0;
     end;

     // Read all definition lines in CSV format.
     slist:=TStringList.Create;
     DuringTableDef:=false;
     DuringIndexDef:=false;
     try
        while true do
        begin
             GetLine;
             if Line='' then break;

             // Read magic words if any.
             Word:=GetWord(null);

{$IFNDEF CSV_FILE_1XX_COMPATIBILITY}
             if Word=kbmFileVersionMagic then
             begin
                  Word:=GetWord(null);
//                  FileVersion:=StrToInt(Word);  Ignore fileversion in the current release since its the first one understanding the fileversion value.
                  continue;
             end
             else
{$ENDIF}

             if Word=kbmTableDefMagicStart then
             begin
                  DuringTableDef:=true;
                  Close;
                  FieldDefs.clear;
                  DeleteTable;
                  continue;
             end

             // End of table definition?
             else if Word=kbmTableDefMagicEnd then
             begin
                  DuringTableDef:=false;
                  Open;
                  continue;
             end

             // Start of index definitions?
             else if Word=kbmIndexDefMagicStart then
             begin
                  DestroyIndexes;
                  FIndexDefs.Clear;
                  DuringIndexDef:=true;
                  continue;
             end

             // End of index definitions?
             else if Word=kbmIndexDefMagicEnd then
             begin
                  DuringIndexDef:=false;
                  CreateIndexes;
                  continue;
             end;

             // If not during table definitions then its the header. Break.
             if not DuringTableDef then break;

             // If its an index definition.
             if DuringIndexDef then
             begin
                  i:=pos('=',Word);
                  slist.CommaText:=copy(Word,i+1,length(Line));
                  FName:=copy(Word,1,i-1);
                  FFields:=slist.Strings[0];
                  DName:=slist.Strings[1];
                  CASEIN:=pos(',CASE',Word)<>0;
{$IFNDEF LEVEL3}
                  NONMT:=pos(',NONMT',Word)<>0;
{$ENDIF}
                  DESC:=pos(',DESC',Word)<>0;
                  UNIQ:=pos(',UNIQ',Word)<>0;

                  // Add field definition.
                  ioptions:=[];
                  if CASEIN then ioptions:=ioptions+[ixCaseInSensitive];
                  if DESC then ioptions:=ioptions+[ixDescending];
                  if UNIQ then ioptions:=ioptions+[ixUnique];
{$IFNDEF LEVEL3}
                  if NONMT then ioptions:=ioptions+[ixNonMaintained];
                  with IndexDefs.AddIndexDef do
                  begin
                       Name:=FName;
                       Fields:=FFields;
                       Options:=ioptions;
                       DisplayName:=DName;
                  end;
{$ELSE}
                  IndexDefs.Add(FName,FFields,ioptions);
{$ENDIF}
                  continue;
             end;

             // Otherwise its a field definition. Break the line apart.
             i:=pos('=',Word);
             slist.CommaText:=copy(Word,i+1,length(Line));
             FName:=copy(Word,1,i-1);
             TName:=slist.Strings[0];
             FSize:=strtoint(slist.Strings[1]);
             DName:=slist.Strings[2];
             EMask:=slist.Strings[3];
             DSize:=strtoint(slist.Strings[4]);
             REQ:=pos(',REQ',Word)<>0;
             RO:=pos(',RO',Word)<>0;
             INV:=pos(',INV',Word)<>0;

             // Find fieldtype from fieldtypename.
             for i:=0 to ord(High(FieldTypeNames)) do
                 if FieldTypeNames[TFieldType(i)]=TName then break;
             FT:=TFieldType(i);
             if not (FT in kbmSupportedFieldTypes) then
                raise EMemTableError.Create(Format(kbmUnknownFieldErr1+kbmUnknownFieldErr2,[TName,Word]));

             // Add field definition.
             FieldDefs.Add(FName,FT,FSize,REQ);

             // Setup other properties.
             i:=FieldDefs.IndexOf(FName);
             with FieldDefs.Items[i].CreateField(self) do
             begin
                  DisplayLabel:=DName;
                  EditMask:=EMask;
                  ReadOnly:=RO;
                  DisplayWidth:=DSize;
                  Visible:=not INV;
             end;
        end;
     finally
        slist.free;
     end;

     ResetAutoInc;

     // Read all lines in CSV format.
     FLoadCount:=0;
     FLoadedCompletely:=true;
     nf:=Fieldcount;
     while true do
     begin
          if (FLoadLimit>0) and (FLoadCount>=FLoadLimit) then
          begin
               FLoadedCompletely:=false;
               break;
          end;

          GetLine;
          if Line='' then break;

          append;

          i:=0;
          while (lptr<elptr) and (i<nf) do
          begin
               if Fields[i].FieldKind<>fkData then
               begin
                    inc(i);
                    continue;
               end;

               s:=GetWord(null);
               if null then
                   Fields[i].Clear
               else if Fields[i].DataType in kbmStringTypes then
                   Fields[i].AsString:=CodedStringToString(s)
               else if Fields[i].DataType in kbmBinaryTypes then
                   Fields[i].AsString:=Base64ToString(s)
               else
                   Fields[i].AsString:=s;

               if Assigned(FOnLoadField) then FOnLoadField(self,i,Fields[i]);
               inc(i);
          end;

          Accept:=true;
          if Assigned(FOnLoadRecord) then FOnLoadRecord(self,Accept);
          if Accept then
          begin
               Post;
               inc(FLoadCount);
          end
          else
               Cancel;
     end;
  finally
     FIgnoreReadOnly:=false;
     FreeMem(buf);
     if oStream<>nil then Stream.free;
     GotoBookmark(bm);
     DateSeparator:=Ods;
     DecimalSeparator:=Oms;
     TimeSeparator:=Ots;
     ThousandSeparator:=Oths;
     CurrencyFormat:=Ocf;
     NegCurrFormat:=Onf;
     ShortDateFormat:=Osdf;
     CurrencyString:=Ocs;

     FPersistent:=oPersistence;
     FEnableIndexes:=oEnableIndexes;
     UpdateIndexes;
     EnableControls;
     Progress(100,mtpcLoad);
     FreeBookmark(bm);
     FState:=mtstBrowse;
  end;
end;

procedure TkbmCustomMemTable.InternalLoadFromBinaryStream(Stream: TStream);
var
   FileVersion:integer;
   i:integer;
   nf:integer;
   FName,TName,DName,EMask:string;
   FSize,DSize:integer;
   REQ,RO:boolean;
   FT:TFieldType;
   Accept:boolean;
   bNull:boolean;
   oStream:TStream;
   Reader : TReader;
   InitTableDef,InitIndexDef:boolean;
   Date:double;
{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
   ioptions:TIndexOptions;
   FFields:string;
{$ENDIF}
   oPersistence:boolean;
   oEnableIndexes:boolean;
   NewestVersion:boolean;
   lst:TList;
   pRec:PkbmRecord;
   StreamSize:longint;
   ApproxRecs:integer;
   ProgressCnt:integer;
begin
     // Dont let persistence react on internal open/close statements.
     oPersistence:=FPersistent;
     FPersistent:=false;
     oEnableIndexes:=EnableIndexes;
     EnableIndexes:=false;

     oStream:=nil;
     Reader := nil;
     FIgnoreReadOnly:=true;
     Progress(0,mtpcLoad);
     ProgressCnt:=0;
     FState:=mtstLoad;
     try
        DisableControls;

        // If to decompress stream, create memory stream to load from instead.
        if Assigned(FOnDeCompressLoad) then
        begin
             oStream:=Stream;
             Stream:=TMemoryStream.Create;
             FOnDecompressLoad(oStream,Stream);
             Stream.Position:=0;
        end;

        StreamSize:=Stream.Size;

        Reader := TReader.Create(Stream, 16384);
        Reader.ReadSignature;

{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
        FileVersion:=Reader.ReadInteger;
{$ELSE}
        FileVersion:=0;
{$ENDIF}

        // Read all definitions if any saved.
        InitTableDef:=false;
        InitIndexDef:=false;
        try
           Reader.ReadListBegin;

           while not(Reader.EndofList) do
           begin
                // Clear previous setup if not cleared yet.
                if not InitTableDef then
                begin
                     Close;
                     FieldDefs.clear;
                     DeleteTable;
                     InitTableDef:=true;
                end;

                // read field definition.
                FName := Reader.ReadString;
                TName := Reader.ReadString;
                FSize := Reader.ReadInteger;
                DName := Reader.ReadString;
                EMask := Reader.ReadString;
                DSize := Reader.ReadInteger;
                REQ := Reader.ReadBoolean;
                RO := Reader.ReadBoolean;

                // Find fieldtype from fieldtypename.
                for i:=0 to ord(High(FieldTypeNames)) do
                    if FieldTypeNames[TFieldType(i)]=TName then break;

                FT:=TFieldType(i);

                if not (FT in kbmSupportedFieldTypes) then
                   raise EMemTableError.Create(Format(kbmUnknownFieldErr1,[TName]));

                // Add field definition.
                FieldDefs.Add(FName,FT,FSize,REQ);

                // Setup other properties.
                i:=FieldDefs.IndexOf(FName);
                with FieldDefs.Items[i].CreateField(self) do
                begin
                     DisplayLabel:=DName;
                     EditMask:=EMask;
                     ReadOnly:=RO;
                     DisplayWidth:=DSize;
                end;
           end;
           Reader.ReadListEnd;

{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
           // Read all index definitions if any saved.
           Reader.ReadListBegin;

           while not(Reader.EndofList) do
           begin
                // Clear previous setup if not cleared yet.
                if not InitIndexDef then
                begin
                     DestroyIndexes;
                     FIndexDefs.Clear;
                     InitIndexDef:=true;
                end;

                // read index definition.
                FName := Reader.ReadString;
                FFields := Reader.ReadString;
                DName := Reader.ReadString;

                ioptions:=[];
                if Reader.ReadBoolean then ioptions:=ioptions+[ixDescending];
                if Reader.ReadBoolean then ioptions:=ioptions+[ixCaseInSensitive];

{$IFNDEF LEVEL3}
                if Reader.ReadBoolean then ioptions:=ioptions+[ixNonMaintained];
{$ELSE}
                Reader.ReadBoolean;     // Skip ixNonMaintained info since not supported for D3/BCB3.
{$ENDIF}
                if Reader.ReadBoolean then ioptions:=ioptions+[ixUnique];

{$IFNDEF LEVEL3}
                // Add field definition.
                with IndexDefs.AddIndexDef do
                begin
                     Name:=FName;
                     Fields:=FFields;
                     Options:=ioptions;
                     DisplayName:=DName;
                end;
{$ELSE}
                IndexDefs.Add(FName,FFields,ioptions);
{$ENDIF}
           end;
           Reader.ReadListEnd;
{$ENDIF}

        finally
           if InitTableDef then Open;
        end;

        ResetAutoInc;

        // Try to determine approx how many records in stream + add some slack.
        if RecordSize>0 then
        begin
             ApproxRecs:=StreamSize div RecordSize;
             ApproxRecs:=ApproxRecs + (ApproxRecs div 50) + RecordCount;
        end
        else
            ApproxRecs:=0;

        // Read all records.
        FLoadCount:=0;
        FLoadedCompletely:=true;
        lst:=FRecords.LockList;
        if ApproxRecs>0 then lst.Capacity:=ApproxRecs; // For speed reason try to preallocate room for all records.

        try
           nf:=Fieldcount;
           Reader.ReadListBegin;
           SetTempState(dsinsert);
           while not(Reader.EndofList) do
           begin
                // Show progress.
                inc(ProgressCnt);
                ProgressCnt:=ProgressCnt mod 100;
                if (ProgressCnt=0) then
                   Progress(trunc((Stream.Position / Stream.Size) * 100),mtpcLoad);

                if (FLoadLimit>0) and (FLoadCount>=FLoadLimit) then
                begin
                     FLoadedCompletely:=false;
                     break;
                end;

                pRec:=_InternalAllocRecord;
                FOverrideActiveRecordBuffer:=pRec;

                NewestVersion:=true;
{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
 {$IFNDEF BINARY_FILE_200_COMPATIBILITY}                         // New for v. 2.24.

                // Loop for all versions of record if versioning is used (2.30 and forth).
                if FileVersion>=230 then Reader.ReadListBegin;
                while true do
                begin
                     if FileVersion>=230 then FOverrideActiveRecordBuffer^.UpdateStatus:=TUpdateStatus(Reader.ReadInteger);
 {$ENDIF}
{$ENDIF}

                     // Read fields for current record version.
                     for i:=0 to nf-1 do
                     begin
                          if Fields[i].FieldKind<>fkData then continue;

{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
 {$IFNDEF BINARY_FILE_200_COMPATIBILITY}
  {$IFNDEF BINARY_FILE_230_COMPATIBILITY}                     // New for v. 2.49.
                          // Check if null values saved in binary file.
                          if (FileVersion>=249) then
                             bNull:=Reader.ReadBoolean
                          else
  {$ENDIF}
 {$ENDIF}
{$ENDIF}
                             bNull:=false;

                          // Check if null field.
                          if bNull then
                             Fields[i].Clear
                          else
                          begin
                               // Not null, load data.
                               case Fields[i].DataType of
                                    ftBoolean : Fields[i].AsBoolean := Reader.ReadBoolean;

{$IFNDEF LEVEL3}
                                    ftLargeInt: Fields[i].AsFloat := Reader.ReadFloat;
{$ENDIF}

                                    ftSmallInt,
                                    ftInteger,
                                    ftWord : Fields[i].AsInteger := Reader.ReadInteger;

                                    ftAutoInc : with Fields[i] do begin
                                                     AsInteger:=Reader.ReadInteger;
                                                     if FAutoIncMax<AsInteger then
                                                     FAutoIncMax:=AsInteger;
                                                end;

                                    ftFloat : Fields[i].AsFloat := Reader.ReadFloat;

                                    ftBCD,
                                    ftCurrency : Fields[i].AsCurrency := Reader.ReadFloat;

                                    ftDate,
                                    ftTime,
                                    ftDateTime : begin
                                                    Date:=Reader.ReadFloat;
                                                    if Date=0 then Fields[i].Clear
                                                    else Fields[i].AsFloat:=Date;
                                                 end;
                               else
                                   Fields[i].AsString := Reader.ReadString;
                               end;
                          end;

                          if NewestVersion and Assigned(FOnLoadField) then FOnLoadField(self,i,Fields[i]);
{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
 {$IFNDEF BINARY_FILE_200_COMPATIBILITY}                         // New for v. 2.24.
                     end;

                     // Previous file versions didnt contain versions, so just break loop.
                     if FileVersion<230 then break;

                     // Prepare for reading next version if any. (introduced in v. 2.30)
                     if Reader.EndOfList then break;

                     // Prepare next version.
                     NewestVersion:=false;
                     FOverrideActiveRecordBuffer^.PrevRecordVersion:=_InternalAllocRecord;
                     FOverrideActiveRecordBuffer:=FOverrideActiveRecordBuffer^.PrevRecordVersion;

                end;
                if FileVersion>=230 then Reader.ReadListEnd;
 {$ENDIF}
{$ENDIF}

                Accept:=true;
                if Assigned(FOnLoadRecord) then FOnLoadRecord(self,Accept);
                if Accept then
                begin
                     pRec^.RecordID:=FRecordID;
                     inc(FRecordID);
                     pRec^.UniqueRecordID:=FUniqueRecordID;
                     inc(FUniqueRecordID);
                     lst.Add(pRec);
                     if pRec^.UpdateStatus=usDeleted then inc(FDeleteCount);
                     inc(FLoadCount);
                end
                else
                   _InternalFreeRecord(pRec,true,true);
           end;

           // Now create indexes as defined.
           if InitIndexDef then CreateIndexes;
        finally
           RestoreState(dsBrowse);
           FRecords.UnlockList;
        end;
        Reader.ReadListEnd;
     finally
{$IFNDEF BINARY_FILE_1XX_COMPATIBILITY}
 {$IFNDEF BINARY_FILE_200_COMPATIBILITY}                         // New for v. 2.24.
        FOverrideActiveRecordBuffer:=nil;
 {$ENDIF}
{$ENDIF}

        FIgnoreReadOnly:=false;
        if Assigned(Reader) then reader.Free;
        if oStream<>nil then Stream.free;
        UpdateIndexes;
        FPersistent:=oPersistence;
        FEnableIndexes:=oEnableIndexes;
        EnableControls;
        Progress(100,mtpcLoad);
        FState:=mtstBrowse;
     end;
end;

procedure TkbmCustomMemTable.EmptyTable;
begin
     DisableControls;
     Cancel;
     Progress(0,mtpcEmpty);
     FState:=mtstEmpty;
     try
        _InternalEmpty(true);
        First;
     finally
        EnableControls;
        Progress(100,mtpcEmpty);
        FState:=mtstBrowse;
     end;
end;

procedure TkbmCustomMemTable.PackTable;
begin
     DisableControls;
     Cancel;
     Commit;
     CheckPoint;
     Progress(0,mtpcPack);
     FState:=mtstPack;
     try
        _InternalPackRecords;
        First;
     finally
        EnableControls;
        Progress(100,mtpcPack);
        FState:=mtstBrowse;
     end;
end;

// Define checkpoint for versioning.
// Throws away old version records, and actually removes delete marked records.
procedure TkbmCustomMemTable.CheckPoint;
var
   i:integer;
   lst:TList;
   pRec:PkbmRecord;
   oEnableVersioning:boolean;
   ProgressCnt:integer;
begin
     if FAttachedTo<>nil then raise EMemTableError.Create(kbmCantCheckpointAttached);
     UpdateCursorPos;

     // Make sure operations are really happening and not just versioned.
     oEnableVersioning:=FEnableVersioning;
     FEnableVersioning:=false;
     FState:=mtstCheckPoint;
     Progress(0,mtpcCheckPoint);
     ProgressCnt:=0;
     lst:=FRecords.LockList;
     try
        for i:=lst.Count-1 downto 0 do
        begin
             inc(ProgressCnt);
             ProgressCnt:=ProgressCnt mod 100;
             if ProgressCnt=0 then Progress(trunc(i/lst.Count * 100),mtpcCheckPoint);

             pRec:=lst.Items[i];
             if pRec=nil then continue;

             // Check if versioning data, remove them.
             if pRec^.PrevRecordVersion<>nil then
             begin
                  _InternalFreeRecord(pRec^.PrevRecordVersion,true,true);
                  pRec^.PrevRecordVersion:=nil
             end;

             // Check if deleted record, delete it real this time.
             if pRec^.UpdateStatus=usDeleted then
             begin
                  DoCascadeUpdateIndexes(mtiuhDelete,pRec,nil,i);
                  _InternalDeleteRecord(pRec);
             end
             else
                 // Reset status flag.
                 pRec^.UpdateStatus:=usUnModified;
        end;

     finally
        FDeleteCount:=0;
        FRecords.UnlockList;
        FEnableVersioning:=oEnableVersioning;
        First;
        Progress(100,mtpcCheckPoint);
        FState:=mtstBrowse;
     end;
end;

procedure TkbmCustomMemTable.SetCommaText(AString: String);
var
   stream:TMemoryStream;
begin
     EmptyTable;
     stream:=TMemoryStream.Create;
     try
        stream.Write(Pointer(AString)^,length(AString));
        stream.Seek(0,soFromBeginning);
        InternalLoadFromStream(stream);
     finally
        stream.free;
     end;
end;

function TkbmCustomMemTable.GetCommaText: String;
var
   stream:TMemoryStream;
   sz:integer;
   p:PChar;
begin
     Result:='';
     stream:=TMemoryStream.Create;
     try
        SaveToStream(stream,FCommaTextOptions);
        stream.Seek(0,soFromBeginning);
        sz:=stream.Size;
        p:=stream.Memory;
        setstring(Result,p,sz);
     finally
        stream.free;
     end;
end;

// Save persistent table.
procedure TkbmCustomMemTable.SavePersistent;
var
   TempFile:string;
begin
     // If persistent, save info to file.
     if (not FPersistentSaved) and (not (csDesigning in ComponentState)) and FPersistent and (FPersistentFile <> '') then
     begin
          TempFile:=ChangeFileExt(FPersistentFile, '.$$$');
          case FPersistentSaveFormat of
             mtsfCSV: SaveToFile(TempFile,FPersistentSaveOptions);
             mtsfBinary: SaveToBinaryFile(TempFile,FPersistentSaveOptions);
          end;
          if FPersistentBackup then
            SysUtils.RenameFile(FPersistentFile, ChangeFileExt(FPersistentFile, FPersistentBackupExt))
          else
            SysUtils.DeleteFile(FPersistentFile);
          SysUtils.RenameFile(TempFile,FPersistentFile);
          FPersistentSaved:=true;
     end;
end;

// Load persistent table.
procedure TkbmCustomMemTable.LoadPersistent;
begin
     if FPersistent and (FPersistentFile <> '') and FileExists(FPersistentFile) then
     begin
          case FPersistentSaveFormat of
             mtsfCSV: LoadFromFile(FPersistentFile);
             mtsfBinary: LoadFromBinaryFile(FPersistentFile);
          end;
          first;
     end;
     FPersistentSaved:=false;
end;

// Sneak in before the table is closed.
procedure TkbmCustomMemTable.DoBeforeClose;
begin
     // Check if not in browse mode.
     if (State in [dsEdit,dsInsert]) then Cancel;

     if not FBeforeCloseCalled then inherited;
     SavePersistent;
     FBeforeCloseCalled:=true;
end;

// Sneak in before the table is opened.
procedure TkbmCustomMemTable.DoBeforeOpen;
begin
     inherited;
end;

// Sneak in after the table is opened.
procedure TkbmCustomMemTable.DoAfterOpen;
begin
     // DoAfterOpen is not reentrant. Thus prevent that situation.
     if FDuringAfterOpen then exit;

     FDuringAfterOpen:=true;
     try
        // Switch index.
        if FIndexFieldNames<>'' then
           SetIndexFieldNames(FIndexFieldNames)
        else if FIndexName<>'' then
           SetIndexName(FIndexName)
        else if FAttachedTo<>nil then
           UpdateIndexes;

        // If to load data from form, do it.
        if FTempDataStorage<>nil then
        begin
             if FStoreDataOnForm then InternalLoadFromBinaryStream(FTempDataStorage);
             FTempDataStorage.free;
             FTempDataStorage:=nil;
        end;

        // If persistent, read info from file.
        LoadPersistent;

   {$IFDEF LEVEL5}
        // If filtering, build filter.
        if Filter<>'' then BuildFilter(Filter);
   {$ENDIF}

        inherited;
     finally
        FDuringAfterOpen:=false;
     end;
end;

// Sneak in after a post to update attached tables.
procedure TkbmCustomMemTable.DoAfterPost;
begin
     if FAttachedAutoRefresh then
     begin
          // Update attached children.
          if FAttachedTo<>nil then
          begin
               if FAttachedTo.State in [dsBrowse] then FAttachedTo.Refresh;
               FAttachedTo.AttachedChildrenRefresh(Self);
          end
          else
              AttachedChildrenRefresh(Self);
     end;

     // Check if to reposition.
     if FAutoReposition and (FReposRecNo>=0) then
     begin
          FRecNo:=FReposRecNo;
          FReposRecNo:=-1;
          Resync([]);
     end;
     
     inherited;
end;

// Sneak in after a delete to update attached tables.
procedure TkbmCustomMemTable.DoAfterDelete;
begin
     if FAttachedAutoRefresh then
     begin
          // Update attached children.
          if FAttachedTo<>nil then
          begin
               if FAttachedTo.State in [dsBrowse] then FAttachedTo.Refresh;
               FAttachedTo.AttachedChildrenRefresh(Self);
          end
          else
              AttachedChildrenRefresh(Self);
     end;

     inherited;
end;

// Locate record.
// If the keyfields are the same as sorted fields and the table is currently sorted,
// it will make a fast binary search. Otherwise it will make a sequential search.
// Binary searches dont take partial record in account.
function TkbmCustomMemTable.LocateRecord(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Integer;
var
   KeyFieldsList: TList;
   KeyRecord:PkbmRecord;
   i:integer;
   Index:integer;
begin
     Result := -1;
     I := VarArrayDimCount(KeyValues);
     if I > 1 then
        raise EMemTableError.Create(kbmVarArrayErr);

     CheckBrowseMode;
     CursorPosChanged;

     // Setup key options.
     FKeyOptions:=[];
     if loCaseInsensitive in Options then FKeyOptions:=FkeyOptions+[mtcoCaseInsensitive];
     if loPartialKey in Options then FKeyOptions:=FKeyOptions+[mtcoPartialKey];

     // Prepare list of fields representing the keys to search for.
     KeyFieldsList := TList.Create;
     try
        BuildFieldList(self,KeyFieldsList, KeyFields);

        // Populate a keyrecord.
        KeyRecord:=_InternalAllocRecord;
        try
           // Fill it with values.
           PopulateRecord(KeyRecord,KeyFields,KeyValues);

           // Locate record.
           Index:=-1;
           FIndexes.Search(KeyFieldsList,KeyRecord,false,true,Index,FKeyOptions);
           if Index>=0 then Result:=Index;

        finally
           // Free reference record.
           _InternalFreeRecord(KeyRecord,false,false);
        end;

     finally
        KeyFieldsList.Free;
     end;
end;

function TkbmCustomMemTable.Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant;
var
   n:integer;
begin
     Result := Null;
     n:=LocateRecord(KeyFields, KeyValues, []);
     SetFound(n>=0);
     if n>=0 then
     begin
          SetTempState(dsCalcFields);
          try
             CalculateFields(FCurIndex.FReferences.Items[n]);
             Result := FieldValues[ResultFields];
          finally
             RestoreState(dsBrowse);
          end;
     end;
end;

function TkbmCustomMemTable.Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean;
var
   n:integer;
begin
     DoBeforeScroll;
     n:=LocateRecord(KeyFields, KeyValues, Options);
     Result:=(n>=0);
     SetFound(Result);
     if n>=0 then
     begin
          FRecNo:=n;
          Resync([rmExact, rmCenter]);
          DoAfterScroll;
     end;
end;

// Copy properties from source to destination.
// Handles different fieldorder between the two datasets.
procedure TkbmCustomMemTable.CopyFieldsProperties(Source,Destination:TDataSet);
var
   i:integer;
   fc:integer;
   f:TField;
begin
     // Did we get valid parameters.
     if (Source=nil) or (Destination=nil) or (Source=Destination) then exit;

     // Copy constraints from source to destination.
     fc:=Destination.FieldCount-1;
     for i:=0 to fc do
     begin
          // Find matching fieldnames on both sides. If fieldname not found, dont copy it.
          f:=Source.FindField(Destination.Fields[i].FieldName);
          if f=nil then continue;

          // Copy general properties.
          Fields[i].EditMask:=f.EditMask;
          Fields[i].DisplayWidth:=f.DisplayWidth;
          Fields[i].DisplayLabel:=f.DisplayLabel;
          Fields[i].Required:=f.Required;
          Fields[i].ReadOnly:=f.ReadOnly;
          Fields[i].Visible:=f.Visible;
          Fields[i].DefaultExpression:=f.DefaultExpression;
          Fields[i].Alignment:=f.Alignment;

          // Copy field type specific properties.
          if f is TNumericField then
             with TNumericField(f) do
             begin
                  TNumericField(Fields[i]).DisplayFormat:=DisplayFormat;
                  TNumericField(Fields[i]).EditFormat:=EditFormat;
             end;

          if f is TIntegerField then
             with TIntegerField(f) do
             begin
                  TIntegerField(Fields[i]).MaxValue:=MaxValue;
                  TIntegerField(Fields[i]).MinValue:=MinValue;
             end;

          if f is TDateTimeField then
             with TDateTimeField(f) do
                  TDateTimeField(Fields[i]).DisplayFormat:=DisplayFormat;

          if f is TBooleanField then
             with TBooleanField(f) do
                  TBooleanField(Fields[i]).DisplayValues:=DisplayValues;

          if f is TStringField then
             with TStringField(f) do
                  TStringField(Fields[i]).Transliterate:=Transliterate;

          if f is TFloatField then
             with TFloatField(f) do
             begin
                  TFloatField(Fields[i]).MaxValue:=MaxValue;
                  TFloatField(Fields[i]).MinValue:=MinValue;
                  TFloatField(Fields[i]).Precision:=Precision;
                  TFloatField(Fields[i]).currency:=currency;
             end;

          if f is TBCDField then
             with TBCDField(f) do
             begin
                  TBCDField(Fields[i]).MaxValue:=MaxValue;
                  TBCDField(Fields[i]).MinValue:=MinValue;
{$IFDEF LEVEL4}
                  TBCDField(Fields[i]).Precision:=Precision;
{$ENDIF}
                  TBCDField(Fields[i]).currency:=currency;
             end;

          if f is TBlobField then
             with TBlobField(f) do
             begin
                  TBlobField(Fields[i]).BlobType:=BlobType;
                  TBlobField(Fields[i]).Transliterate:=Transliterate;
             end;
     end;
end;

// Copy records from source to destination.
// Handles different fieldorder between the two datasets.
// Returns the number of records copied.
function TkbmCustomMemTable.CopyRecords(Source,Destination:TDataSet;Count:longint):longint;
var
   i:integer;
   fc:integer;
   f:TField;
   fi:array [0..KBM_MAX_FIELDS-1] of integer;
   Accept:boolean;
   RecCnt:integer;
   ProgressCnt:integer;
begin
     Result:=0;

     // Did we get valid parameters.
     if (Source=nil) or (Destination=nil) or (Source=Destination) then exit;

     // Build name index relations between destination and source dataset.
     fc:=Destination.FieldCount-1;
     Progress(0,mtpcCopy);
     for i:=0 to fc do
     begin
          // Check if not a datafield or not a supported field, dont copy it.
          case Destination.Fields[i].FieldKind of
               fkLookup: fi[i]:=-2; // Dont copy, dont clearout.
               fkData,fkCalculated:
                 begin
                      // If unknown datatype, dont copy, just clearout.
                      if not (Destination.Fields[i].DataType in kbmSupportedFieldTypes) then
                      begin
                           fi[i]:=-1;
                           continue;
                      end;

                      // Find matching fieldnames on both sides. If fieldname not found, dont copy it, just clearout.
                      f:=Source.FindField(Destination.Fields[i].FieldName);
                      if f=nil then
                      begin
                           fi[i]:=-1;
                           continue;
                      end;

{ Commented out to allow copying non datafields.
                      // If not a datafield just clearout.
                      if f.FieldKind<>fkData then
                      begin
                           fi[i]:=-1;
                           continue;
                      end;
}

                      // Else copy the field.
                      fi[i]:=f.Index;
                 end;
          else
              // Other fieldkind, dont copy, just clearout.
              fi[i]:=-1;
          end;
     end;

     // Copy data.
     FLoadedCompletely:=true;
     RecCnt:=Source.RecordCount;
     if (RecCnt<=0) then Progress(50,mtpcCopy);
     ProgressCnt:=0;
     while not Source.EOF do
     begin
          // Update progress.
          if (RecCnt>0) then
          begin
               inc(ProgressCnt);
               if (ProgressCnt mod 100)=0 then Progress(trunc(ProgressCnt/RecCnt*100),mtpcCopy);
          end;

          // Check acceptance of record.
          Accept:=true;
          if Assigned(FOnSaveRecord) and (Source=self) then FOnSaveRecord(Self,Accept);
          if not Accept then
          begin
               Source.Next;
               continue;
          end;

          Destination.Append;
          for i:=0 to fc do
          begin
               if Assigned(FOnSaveField) and (Source=self) then FOnSaveField(Self,i,Source.Fields[i]);
               if fi[i]>=0 then Destination.Fields[i].Value:=Source.Fields[fi[i]].Value;
               if Assigned(FOnLoadField) and (Destination=self) then FOnLoadField(Self,i,Destination.Fields[i]);
          end;

          Accept:=true;
          if Assigned(FOnLoadRecord) and (Destination=self) then FOnLoadRecord(Self,Accept);
          if Accept then Destination.post
          else Destination.Cancel;

          Source.next;
          inc(Result);
          if (Count>0) and (Result>=Count) then
          begin
               FLoadedCompletely:=false;
               break;
          end;
     end;
     Progress(100,mtpcCopy);
end;

// Update destination with records not matching or exising in source.
function TkbmCustomMemTable.UpdateRecords(Source, Destination: TDataSet; KeyFields: String; Count: Integer): longint;
var
   i:integer;
   fc:integer;
   f:TField;
   fi:array [0..KBM_MAX_FIELDS-1] of integer;
   Accept:boolean;
   KeyValues:Variant;
   KeyFieldsList:TList;
   RecCnt:integer;
   ProgressCnt:integer;
begin
     Progress(0,mtpcUpdate);
     FState:=mtstUpdate;
     KeyFieldsList := TList.Create;
     try
        BuildFieldList(self,KeyFieldsList, KeyFields);
        if KeyFieldsList.Count > 1 then
           KeyValues:=VarArrayCreate([0, KeyFieldsList.Count-1 ], varVariant);
        Result:=0;

        // Did we get valid parameters.
        if (Source=nil) or (Destination=nil) or (Source=Destination) then exit;

        // Build name index relations between destination and source dataset.
        fc:=Destination.FieldCount-1;
        for i:=0 to fc do
        begin
             // Check if not a datafield or not a supported field, dont copy it.
             case Destination.Fields[i].FieldKind of
                  fkLookup: fi[i]:=-2; // Dont copy, dont clearout.
                  fkData,fkCalculated:
                    begin
                         // If unknown datatype, dont copy, just clearout.
                         if not (Destination.Fields[i].DataType in kbmSupportedFieldTypes) then
                         begin
                              fi[i]:=-1;
                              continue;
                         end;

                         // Find matching fieldnames on both sides. If fieldname not found, dont copy it, just clearout.
                         f:=Source.FindField(Destination.Fields[i].FieldName);
                         if f=nil then
                         begin
                              fi[i]:=-1;
                              continue;
                         end;

                         // Else copy the field.
                         fi[i]:=f.Index;
                    end;
             else
                 // Other fieldkind, dont copy, just clearout.
                 fi[i]:=-1;
             end;
        end;

        // Copy data.
        Source.First;
        RecCnt:=Source.RecordCount;
        if (RecCnt<=0) then Progress(50,mtpcCopy);
        ProgressCnt:=0;
        while not Source.EOF do
        begin
             // Update progress.
             if (RecCnt>0) then
             begin
                  inc(ProgressCnt);
                  if (ProgressCnt mod 100)=0 then Progress(trunc(ProgressCnt/RecCnt*100),mtpcCopy);
             end;

             Accept:=true;
             if Assigned(FOnSaveRecord) and (Source=self) then FOnSaveRecord(Self,Accept);
             if not Accept then
             begin
                  Source.Next;
                  continue;
             end;

             // Convert variant array of values to a list of values.
             if KeyFieldsList.Count > 1 then
             begin
                  for i:=0 to KeyFieldsList.count-1 do
                      KeyValues[i]:=TField(KeyFieldsList[i]).AsVariant;
             end
             else
                 KeyValues:=TField(KeyFieldsList[0]).AsVariant;

             // Look for record in dest. dataset to determine if to append or update record.
             if Not Destination.Locate(KeyFields,KeyValues,[]) then
                Destination.Append
             else
                Destination.Edit;

             // Update record fields.
             for i:=0 to fc do
             begin
                  if Assigned(FOnSaveField) and (Source=self) then FOnSaveField(Self,i,Source.Fields[i]);
                  if fi[i]>=0 then Destination.Fields[i].Value:=Source.Fields[fi[i]].Value;
                  if Assigned(FOnLoadField) and (Destination=self) then FOnLoadField(Self,i,Destination.Fields[i]);
             end;

             Accept:=true;
             if Assigned(FOnLoadRecord) and (Destination=self) then FOnLoadRecord(Self,Accept);
             if Accept then Destination.post
             else Destination.Cancel;

             Source.next;
             inc(Result);
             if (Count>0) and (Result>Count) then break;
        end;

     finally
        KeyFieldsList.Free;
        Progress(100,mtpcUpdate);
        FState:=mtstBrowse;
     end;
end;

procedure TkbmCustomMemTable.UpdateToDataSet(Destination: TDataSet; KeyFields: String);
var
   DestActive:boolean;
   DestDisabled:boolean;
begin
     if Destination=self then exit;

     if (assigned(FOnSave)) then FOnSave(self,mtstDataSet,nil);

     // Remember state of destination.
     DestActive:=Destination.Active;
     DestDisabled:=Destination.ControlsDisabled;

     // Dont update controls while appending to destination
     if not DestDisabled then Destination.DisableControls;

     try
        DisableControls;
        try
           // Open destination
           if not DestActive then Destination.Open;
           Destination.CheckBrowseMode;
           Destination.UpdateCursorPos;

           // Open this if not opened.
           Open;
           CheckBrowseMode;

           // Move to first record in this.
           First;
           UpdateRecords(self,Destination,KeyFields,-1);
        finally
           Destination.First;
        end;
     finally
        EnableControls;
        if not DestActive then Destination.Close;
        if not DestDisabled then Destination.EnableControls;
     end;
end;

// Fill the memorytable with data from another dataset.
procedure TkbmCustomMemTable.LoadFromDataSet(Source:TDataSet; CopyOptions:TkbmMemTableCopyTableOptions);
var
   SourceActive:boolean;
   SourceDisabled:boolean;
   OldMasterSource:TDataSource;
   OldFiltered:boolean;
   OldEnableIndexes:boolean;
   BM:TBookmark;
begin
     if Source=self then exit;

     // Check if specified append together with structure. Not allowed.
     if (mtcpoAppend in CopyOptions) and ((mtcpoStructure in CopyOptions) or (mtcpoProperties in CopyOptions)) then
        raise EMemTableError.CreateFmt(kbmIndexNotExist,[IndexName]);

     FState:=mtstLoad;

     if (assigned(FOnLoad)) then FOnLoad(self,mtstDataSet,nil);

     // If not to append, close this table.
     if not (mtcpoAppend in CopyOptions) then Close;

     // Remember state of source.
     SourceActive:=Source.Active;
     SourceDisabled:=Source.ControlsDisabled;

     // Dont update controls while scrolling through source.
     if not SourceDisabled then Source.DisableControls;

     // Remember state of this.
     OldFiltered:=Filtered;
     OldMasterSource:=MasterSource;
     OldEnableIndexes:=EnableIndexes;
     EnableIndexes:=false;

     FIgnoreReadOnly:=true;
     try
        DisableControls;
        if not SourceActive then Source.Open;
        BM:=Source.GetBookmark;
        try

           // Dont want to check filtering while copying.
           Filtered := False;
           MasterSource:=nil;

           // Open source.
           Source.CheckBrowseMode;
           Source.UpdateCursorPos;

           // Create this memorytable as a copy of the other one.
           if mtcpoStructure in CopyOptions then CreateTableAs(Source,CopyOptions);
           Open;

           // Copy fieldproperties from source after open to also copy properties of default fields.
           if (not (mtcpoAppend in CopyOptions)) and (mtcpoProperties in CopyOptions) then
              CopyFieldsProperties(Source,self);

           CheckBrowseMode;

           // Move to first record in source.
           Source.First;
           FLoadCount:=CopyRecords(Source,self,FLoadLimit);
           Source.GotoBookmark(BM);
           First;
        finally
           Source.FreeBookmark(BM);
           EnableIndexes:=OldEnableIndexes;
           UpdateIndexes;
        end;
     finally
        FIgnoreReadOnly:=false;
        EnableControls;
        if not SourceActive then Source.Close;
        if not SourceDisabled then Source.EnableControls;
        Filtered:=OldFiltered;
        MasterSource:=OldMasterSource;
        UpdateCursorPos;
        CursorPosChanged;
        FState:=mtstBrowse;
     end;
end;

// Append the data in this memory table to another dataset.
procedure TkbmCustomMemTable.SaveToDataSet(Destination:TDataSet);
var
   DestActive:boolean;
   DestDisabled:boolean;
begin
     if Destination=self then exit;

     FState:=mtstSave;
     if (assigned(FOnSave)) then FOnSave(self,mtstDataSet,nil);

     // Remember state of destination.
     DestActive:=Destination.Active;
     DestDisabled:=Destination.ControlsDisabled;

     // Dont update controls while appending to destination
     if not DestDisabled then Destination.DisableControls;

     try
        DisableControls;
        try
           // Open destination
           if not DestActive then Destination.Open;
           Destination.CheckBrowseMode;
           Destination.UpdateCursorPos;

           // Open this if not opened.
           Open;
           CheckBrowseMode;

           // Move to first record in this.
           First;
           CopyRecords(self,Destination,-1);
        finally
           Destination.First;
        end;
     finally
        EnableControls;
        if not DestActive then Destination.Close;
        if not DestDisabled then Destination.EnableControls;
        FState:=mtstBrowse;
     end;
end;

function TkbmCustomMemTable.IsSequenced: Boolean;
begin
     Result:=not Filtered;
end;

// Record rearranging.

// Move record from one place in table to another.
// Only rearranges the roworder index.
function TkbmCustomMemTable.MoveRecord(Source, Destination: Integer): Boolean;
var
   p: Pointer;
begin
     Result := False;
     if FCurIndex<>FIndexes.FRowOrderIndex then exit;
     
     {Because property RecNo has values 1..FRecords.Count
      and FRecNo has values 0..FRecords.Count - 1}
     Dec(Source);
     Dec(Destination);

     if (Source <> Destination) and (Source > -1) and (Source < FCurIndex.FReferences.Count)
        and (Destination > -1) and (Destination < FCurIndex.FReferences.Count) then
     begin
          p:=FCurIndex.FReferences[Source];
          FCurIndex.FReferences.Delete(Source);
          FCurIndex.FReferences.Insert(Destination,p);
          Result:=true;
     end;
end;

// Move record to the specified destination.
function TkbmCustomMemTable.MoveCurRecord(Destination: Integer): Boolean;
begin
     Result := MoveRecord(RecNo,Destination);
end;

// Sorting.

// Callback function for TDataset to know if specified field is an index.
function TkbmCustomMemTable.GetIsIndexField(Field:TField):Boolean;
begin
     Result:=FIndexList.IndexOf(Field)>=0;
end;

// Compare two field lists.
// Returns true if they are exactly equal, otherwise false.
function TkbmCustomMemTable.IsFieldListsEqual(List1,List2:TList):boolean;
var
   i:integer;
begin
     Result:=false;

     if List1.Count<>List2.Count then exit;

     for i:=0 to List1.Count-1 do
         if List1.Items[i]<>List2.Items[i] then exit;
     Result:=true;
end;

// Build field list from list of fieldnames.
procedure TkbmCustomMemTable.BuildFieldList(Dataset:TDataset; List:TList; const FieldNames:string);
var
   p:integer;
   fld:TField;
begin
     List.Clear;
     p:=1;
     FRecalcOnIndex:=false;
     while p<=length(FieldNames) do
     begin
          fld:=Dataset.FieldByName(ExtractFieldName(FieldNames,p));
          if ((fld.FieldKind=fkData) or (fld.FieldKind=fkCalculated)) and (fld.DataType in (kbmSupportedFieldTypes-kbmBlobTypes)) then
             List.Add(fld)
          else
              DatabaseErrorFmt(kbmIndexErr,[fld.DisplayName]);
          if fld.FieldKind=fkCalculated then FRecalcOnIndex:=true;
     end;
end;

// Find field from list.
function TkbmCustomMemTable.FindFieldInList(List:TList; FieldName:string):TField;
var
   fld:TField;
   i:Integer;
begin
     Result:=nil;
     for i:=0 to List.Count-1 do
     begin
          fld:=TField(List[i]);
          if fld.FieldName = FieldName then
          begin
               Result:=fld;
               break;
          end;
     end;
end;

// Sort using specified sortfields and options.
procedure TkbmCustomMemTable.SortDefault;
begin
     Sort(FSortOptions);
end;

// Do sort on specified sortfields.
procedure TkbmCustomMemTable.Sort(Options:TkbmMemTableCompareOptions);
var
   o:TIndexOptions;
   OldRange:boolean;
begin
     if not Active then exit;
     FSortOptions:=Options;

     OldRange:=FRangeActive;
     FRangeActive:=false;
     try
        // Check if old sort index defined, remove it.
        if FSortIndex<>nil then
        begin
             FIndexes.DeleteIndex(FSortIndex);
             FSortIndex.free;
             FSortIndex:=nil;
        end;

        // Is any sort fields setup.
        if (Trim(FSortFIeldNames)<>'') then
        begin
             // Convert old memtable option type to TIndexOptions.
             o:=[];
             if mtcoDescending in Options then o:=o+[ixDescending];
             if mtcoCaseInsensitive in Options then o:=o+[ixCaseInsensitive];

             // Now add a new index.
             FSortIndex:=TkbmIndex.Create(kbmDefSortIndex,self,FSortFieldNames,o,mtitSorted,true);
             FIndexes.AddIndex(FSortIndex);
             FSortIndex.Rebuild;
        end
        else
            FSortIndex:=nil;
        SwitchToIndex(FSortIndex);
     finally
        FRangeActive:=OldRange;
     end;
end;

// Do sort on specifed fieldnames.
procedure TkbmCustomMemTable.SortOn(const FieldNames:string; Options:TkbmMemTableCompareOptions);
var
   o:TIndexOptions;
   OldRange:boolean;
begin
     if not Active then exit;
     FSortOptions:=Options;
     FSortedOn:=FieldNames;

     OldRange:=FRangeActive;
     FRangeActive:=false;
     try
        // Check if old sort index defined, remove it.
        if FSortIndex<>nil then
        begin
             FIndexes.DeleteIndex(FSortIndex);
             FSortIndex.free;
             FSortIndex:=nil;
        end;

        // If specifying new fields to sort on, create index on those fields, otherwise select roworderindex.
        if (Trim(FieldNames)<>'') then
        begin
             // Convert old memtable option type to TIndexOptions.
             o:=[];
             if mtcoDescending in Options then o:=o+[ixDescending];
             if mtcoCaseInsensitive in Options then o:=o+[ixCaseInsensitive];

             // Now add a new index.
             FSortIndex:=TkbmIndex.Create(kbmDefSortIndex,self,FieldNames,o,mtitSorted,true);
             FIndexes.AddIndex(FSortIndex);
             FSortIndex.Rebuild;
        end
        else
            FSortIndex:=nil;
        SwitchToIndex(FSortIndex);
     finally
        FRangeActive:=OldRange;
     end;
end;

{$IFNDEF LEVEL3}
// Get specified rows as a variant.
function TkbmCustomMemTable.GetRows(Rows:Integer; Start:Variant; Fields:Variant):Variant;
var
   FldList:TList;
   FldCnt,RowCnt,RealCnt:integer;
   i,j:integer;
   FRows:array of array of variant;
begin
     Result:=Unassigned;

     // If Start parameter is Unassigned or kbmBookMarkCurrent
     // retrieving starts at current position.
     // If it is assigned anything other than the bookmark consts
     // a valid TBookmark is assumed (casted to LongInt when called)
     if not VarIsEmpty(Start) then
     begin
          if Start=kbmBookMarkLast then Last // doesnt make too much sense...
          else if Start=kbmBookMarkFirst then First
          else
            try
               GoToBookMark(Pointer(LongInt(Start)))
            except
            end; // raise?
     end;

     // If Rows parameter matches kbmGetRowsRest the table is scanned to the end.
     if Rows=Integer(kbmGetRowsRest) then
        RowCnt:=GetRecordCount-GetRecNo+1
     else
        RowCnt:=Rows;

     FldList:=TList.Create;
     try
        // Fields parameter can be
        // - single fieldname
        // - single fieldpos
        // - array of fieldnames
        // - array of fieldpos
        // - Unassigned (=all fields)
        if VarIsEmpty(Fields) then
        begin
             for i:=0 to pred(self.Fields.Count) do
               FldList.Add(self.Fields[i]);
        end
        else if VarIsArray(Fields) then
        begin
             if VarType(Fields[0])=varInteger then
                for i:=0 to VarArrayHighBound(Fields,1) do
                    FldList.Add(FieldByNumber(Fields[i]))
             else
                for i:=0 to VarArrayHighBound(Fields,1) do
                    FldList.Add(FieldByName(VarToStr(Fields[i])));
        end
        else
        begin
             if VarType(Fields)=varInteger then
                FldList.Add(FieldByNumber(Fields))
             else
                FldList.Add(FieldByName(VarToStr(Fields)));
        end;

        RealCnt:=0;
        FldCnt:=FldList.Count;
        SetLength(FRows,FldCnt,RowCnt);

        for j:=0 to pred(RowCnt) do
        begin
             for i:=0 to pred(FldCnt) do
             begin
                  // TBlobField.AsVariant doesnt return NULL for empty blobs
                  if TField(FldList[i]).IsNull then
                     FRows[i,j]:=Null
                  else
                     FRows[i,j]:=TField(FldList[i]).AsVariant;
             end;
             inc(RealCnt);
             Next;
             if EOF then Break;
        end;
     finally
        FldList.Free;
     end;

     if RealCnt<>RowCnt then
       SetLength(FRows,FldCnt,RealCnt);
     Result:=FRows;
end;

procedure TkbmCustomMemTable.Reset;
begin
     Close;
     IndexName:='';
     MasterFields:='';
     IndexFieldNames:='';
     SetDataSource(nil);
     FIndexes.Clear;
     Fields.Clear;
     FIndexDefs.Clear;
     FieldDefs.Clear;
     FIndexDefs.Update;
     FieldDefs.Update;
end;
{$ENDIF}

// -----------------------------------------------------------------------------------
// TkbmVarLength
// -----------------------------------------------------------------------------------

{$ifdef KBM}
constructor TkbmVarLength.Create;
begin
     inherited;
     FLength:=0;
     FBuffer:=nil;
end;

destructor TkbmVarLength.Destroy;
begin
     FLength:=0;
     if FBuffer<>nil then
     begin
          FreeMem(FBuffer);
          FBuffer:=nil;
     end;
     inherited;
end;

procedure TkbmVarLength.LoadFromStream(stream:TMemoryStream);
begin
     FLength:=stream.Size;
     FBuffer:=Allocmem(FLength);
     stream.Seek(0,soFromBeginning);
     stream.Read(FBuffer^,FLength);
end;

procedure TkbmVarLength.SaveToStream(stream:TMemoryStream);
begin
     stream.SetSize(FLength);
     stream.Seek(0,soFromBeginning);
     stream.Write(FBuffer^,FLength);
     stream.Seek(0,soFromBeginning);
end;
{$endif}

// -----------------------------------------------------------------------------------
// TkbmBlobStream
// -----------------------------------------------------------------------------------

// On create, make a stream access to the specified blobfield in the current record.
constructor TkbmBlobStream.Create(Field:TBlobField;Mode:TBlobStreamMode);
var
   CurRec,ActRec:PkbmRecord;
   RecNo:longint;
begin
     FField:=Field;
     FFieldNo:=FField.FieldNo;
     FDataSet:=FField.DataSet as TkbmCustomMemTable;
     FMode:=Mode;

     // If the blob pointer is null, get the blob from the 'database'.
     // If the blob pointer is not null, the blob is during edit but not posted.
     ActRec:=PkbmRecord(FDataSet.GetActiveRecord);
     FPField:=FDataSet.GetFieldPointer(ActRec,Field);
     if FPField=nil then Exit;
     FPBlob:=PPkbmVarLength(FPField+1);

     // Prepare read or write.
     if Mode<>bmRead then
     begin
          if (not FDataSet.FIgnoreReadOnly) and (FField.ReadOnly) then DatabaseErrorFmt(kbmReadOnlyErr,[FField.DisplayName]);
          if not (FDataSet.State in [dsEdit, dsInsert]) then DatabaseError(kbmEditModeErr);
     end;
     if Mode=bmWrite then
          Truncate
     else
     begin
          // Check if this record buffer contains a blob. If it does, its as a non posted blob.
          // Otherwise copy the original blob from the database to the recordbuffer.
          RecNo:=ActRec^.RecordNo;
          if (RecNo>0) then
          begin
               CurRec:=PkbmRecord(FDataSet.FCurIndex.FReferences.Items[RecNo-1]);
               FPBlob:=PPkbmVarLength(FPField+1);
               if (FPBlob^ = nil) then
                  FDataSet._InternalCopyVarLength(CurRec,ActRec,FField);
          end;
          ReadBlobData;
     end;
end;

// On destroy, update the blobfield in the current record if the blob has changed.
destructor TkbmBlobStream.Destroy;
begin
     if FModified then
     try
        WriteBlobData;
        FField.Modified:=true;

        FDataSet.DataEvent(deFieldChange,Longint(FField));
     except
        Application.HandleException(Self);
     end;
     inherited Destroy;
end;

procedure TkbmBlobStream.WriteBlobData;
var
   pblob:PkbmVarLength;
   Stream:TMemoryStream;
begin
     // Get old allocation if any, and free it.
     if FPBlob^<>nil then
     begin
          FreeVarLength(FPBlob^);
          FPBlob^:=nil;
     end;

     // If to compress the blob data, do it.
     if Assigned(FDataSet.FOnCompressBlobStream) then
     begin
          Stream:=TMemoryStream.Create;
          try
             FDataSet.FOnCompressBlobStream(self,Stream);
             pblob:=AllocVarLengthAs(Stream.Memory,Stream.Size);
          finally
             Stream.free;
          end;
     end
     else
         // Otherwise just save raw data to the inmemory blob.
         pblob:=AllocVarLengthAs(self.Memory,self.Size);

     FPBlob^:=pblob;

     // Set Null flag in record.
     if Size<>0 then FPField[0]:=#1
     else FPField[0]:=#0;
end;

procedure TkbmBlobStream.ReadBlobData;
var
   blob:PkbmVarLength;
   Stream:TMemoryStream;
   sz:longint;
begin
     // Get allocation.
     blob:=FPBlob^;
     if blob=nil then exit;

     sz:=GetVarLengthSize(blob);

     // If to decompress stream, save the blob in a memory stream and decompress it.
     if Assigned(FDataSet.FOnDeCompressBlobStream) then
     begin
          Stream:=TMemoryStream.Create;
          try
             Stream.SetSize(sz);
             move(GetVarLengthData(blob)^,Stream.Memory^,sz);
             FDataSet.FOnDecompressBlobStream(Stream,self);
          finally
             Stream.free;
          end;
     end
     else
     begin
          // Copy the data to the stream.
          self.SetSize(sz);
          move(GetVarLengthData(blob)^,self.Memory^,sz);
     end;
     self.Position:=0;
end;

function TkbmBlobStream.Write(const Buffer;Count:Longint): Longint;
begin
     Result:=inherited Write(Buffer,Count);
     if FMode=bmWrite then FModified:=true;
end;

procedure TkbmBlobStream.Truncate;
begin
     Clear;

     // If blob allocated, remove allocation.
     if FPBlob^<>nil then
     begin
          FreeVarLength(FPBlob^);
          FPBlob^:=nil;
     end;

     FModified:=true;
end;

// -----------------------------------------------------------------------------------
// TkbmThreadDataSet
// -----------------------------------------------------------------------------------

constructor TkbmThreadDataSet.Create(AOwner:TComponent);
begin
     inherited;
     FLockCount:=0;
     FSemaphore:=CreateSemaphore(nil,1,1,nil);
end;

destructor TkbmThreadDataSet.Destroy;
begin
     CloseHandle(FSemaphore);
     inherited;
end;

// Take control of the attached dataset.
// Wait for as much as TimeOut msecs to get the control.
// Setting TimeOut to INFINITE (DWORD($FFFFFFFF)) will make the lock wait for ever.
function TkbmThreadDataSet.TryLock(TimeOut:DWORD):TDataset;
var
   n:DWORD;
begin
     // Wait for critical section.
     inc(FLockCount);
     n:=WaitForSingleObject(FSemaphore,TimeOut);
     if (n=WAIT_TIMEOUT) or (n=WAIT_FAILED) then
     begin
          Result:=nil;
          dec(FLockCount);
          exit;
     end;
     Result:=FDataset;
end;

function TkbmThreadDataSet.Lock:TDataset;
begin
     Result:=TryLock(INFINITE);
end;

procedure TkbmThreadDataSet.Unlock;
begin
     dec(FLockCount);
     ReleaseSemaphore(FSemaphore,1,nil);
end;

procedure TkbmThreadDataSet.Notification(AComponent: TComponent; Operation: TOperation);
var
   WasLocked:boolean;
begin
     if (Operation=opRemove) and (AComponent=FDataSet) then
     begin
          WasLocked:=IsLocked;
          while IsLocked do Unlock;
          FDataset:=nil;
          if WasLocked then raise Exception.Create(kbmDatasetRemoveLockedErr);
     end;
     inherited;
end;

procedure TkbmThreadDataSet.SetDataset(ds:TDataset);
begin
     if IsLocked then raise Exception.Create(kbmSetDatasetLockErr);
     FDataSet:=ds;
end;

function TkbmThreadDataSet.GetIsLocked:boolean;
begin
     Result:=(FLockCount>0);
end;

// -----------------------------------------------------------------------------------
// Handler for resolving delta's. Must be overridden to be usable.
// -----------------------------------------------------------------------------------

procedure TkbmCustomDeltaHandler.CheckDataSet;
begin
     if FDataSet=nil then raise EMemTableError.Create(kbmDeltaHandlerAssign);
end;

procedure TkbmCustomDeltaHandler.Resolve;
var
   lst:TList;
   i:integer;
   pRec,pOrigRec:PkbmRecord;
   st:TUpdateStatus;
begin
     CheckDataSet;
     lst:=FDataSet.FRecords.LockList;
     try
        for i:=0 to lst.Count-1 do
        begin
             // Check status of record.
             pRec:=PkbmRecord(lst.Items[i]);
             if pRec=nil then continue;

             // Find oldest version.
             pOrigRec:=pRec;
             while pOrigRec^.PrevRecordVersion<>nil do
                   pOrigRec:=pOrigRec^.PrevRecordVersion;

             // Check what status to react on.
             if pRec^.UpdateStatus=usDeleted then
             begin
                  // Dont resolve inserts that were deleted again.
                  if pOrigRec^.UpdateStatus=usInserted then st:=usUnmodified
                  else st:=usDeleted;
             end
             else if pOrigRec^.UpdateStatus=usInserted then st:=usInserted
             else st:=pRec^.UpdateStatus;

             FPRecord:=pRec;
             FPOrigRecord:=pOrigRec;

             case st of
               usDeleted:    DeleteRecord;
               usInserted:   InsertRecord;
               usModified:   ModifyRecord;
               usUnModified: UnmodifiedRecord;
             end;
        end;
     finally
        FDataSet.FRecords.UnlockList;
     end;
end;

procedure TkbmCustomDeltaHandler.InsertRecord;
begin
end;

procedure TkbmCustomDeltaHandler.DeleteRecord;
begin
end;

procedure TkbmCustomDeltaHandler.ModifyRecord;
begin
end;

procedure TkbmCustomDeltaHandler.UnmodifiedRecord;
begin
end;

function TkbmCustomDeltaHandler.GetFieldCount:integer;
begin
     CheckDataSet;
     Result:=FDataSet.FieldCount;
end;

function TkbmCustomDeltaHandler.GetOrigValues(Index:integer):Variant;
begin
     CheckDataSet;
     FDataSet.FOverrideActiveRecordBuffer:=FPOrigRecord;
     try
        Result:=FDataSet.Fields[Index].AsVariant;
     finally
        FDataSet.FOverrideActiveRecordBuffer:=nil;
     end;
end;

function TkbmCustomDeltaHandler.GetValues(Index:integer):Variant;
begin
     CheckDataSet;
     FDataSet.FOverrideActiveRecordBuffer:=FPRecord;
     try
        Result:=FDataSet.Fields[Index].AsVariant;
     finally
        FDataSet.FOverrideActiveRecordBuffer:=nil;
     end;
end;

function TkbmCustomDeltaHandler.GetOrigValuesByName(Name:string):Variant;
var
   fld:TField;
begin
     CheckDataSet;
     FDataSet.FOverrideActiveRecordBuffer:=FPOrigRecord;
     try
        fld:=FDataSet.FieldByName(Name);
        Result:=fld.AsVariant;
     finally
        FDataSet.FOverrideActiveRecordBuffer:=nil;
     end;
end;

function TkbmCustomDeltaHandler.GetValuesByName(Name:string):Variant;
var
   fld:TField;
begin
     CheckDataSet;
     FDataSet.FOverrideActiveRecordBuffer:=FPRecord;
     try
        fld:=FDataSet.FieldByName(Name);
        Result:=fld.AsVariant;
     finally
        FDataSet.FOverrideActiveRecordBuffer:=nil;
     end;
end;

function TkbmCustomDeltaHandler.GetFieldNames(Index:integer):string;
begin
     CheckDataSet;
     Result:=FDataSet.Fields[Index].FieldName;
end;

function TkbmCustomDeltaHandler.GetFields(Index:integer):TField;
begin
     CheckDataSet;
     Result:=FDataSet.Fields[Index];
end;

// -----------------------------------------------------------------------------------
// Registration for Delphi 3 / C++ Builder 3
// -----------------------------------------------------------------------------------

{$ifdef LEVEL3}
procedure Register;
begin
     RegisterComponents('Data Access', [TkbmMemTable]);
end;
{$endif}

end.




