// Last update : 28th September, 2000 ( Thursday )
// Documentaion & Demo included
// contact : jayanck@email.com
unit JQryTool;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, Menus, StdCtrls, DbTables, Bde, DbGrids, DbCtrls, kbmMemTable;

const
  QT_VERSION = '1.0, Updated on 26Sep2000';
  CritSep = '<|>'; // Seperator between fieldname,relational operator and value
   { Relational Operator Constants }
  opEqualTo = ' = ';
  opNotEqualTo = ' <> ';
  opGreaterThan = ' > ';
  opLesserThan = ' < ';
  opBetween = ' B';
  opNotBetween = '!B';
  opIn = ' I';
  opNotIn = '!I';
  opContains = 'C';
  opNotContains = '!C';
  opLike = 'L';
  opNotLike = '!L';
  opNull = 'N';
  opNotNull = '!N';

type
  TQTRelOp = (roNotEqual, roGreaterThan, roLesserThan, roBetween,
    roNotBetween, roIsNull, roIsNotNull, roIn, roNotIn,
    roContains, roNotContains, roLike, roNotLike,
    roAscOrder, roDescOrder, roClearOrder);
  TQTRelOps = set of TQTRelOp;

  TQTType = (qtQueryByForm, qtFilterByForm, qtQueryByGrid, qtFilterByGrid);
  TQTMatchMode = (mmMatchAll, mmMatchAny);
  TQTState = (qsInactive, qsGetCriteria, qsExecuted);
  TRelationalOperatorType
    = (rtCompare, rtBetween, rtNull, rtContains, rtLike, rtIn, rtNone);
//  TDataBaseType = (dtStandard, dtAccess, dtInterBase); Needed for TQueryBySQL
//  TOrderType = (otAsc, otDesc, otClear); Needed for TQueryBySQL

   { Record to store the Relational Operator info of Grid}
  TQbgData = record
    RelType: TRelationalOperatorType;
    RelOpInfo: string;
//    Order: TOrderType; Needed for TQueryBySQL
  end;
  PQbgData = ^TQbgData;

{ ********************************************************************** }
  TCustQueryTools = class(TComponent)
  private
    FTempTable: TkbmMemTable; { Temporary Memory Table }
    FOwnerKeyDown: TKeyEvent;
    FDummyStr: string;
    FQTDataSet: TDataSet;
    FDataSource: TDataSource;
    FQTRelOps: TQTRelOps;
    FQTType: TQTType;
    FMatchMode: TQTMatchMode;
    FCriteria: TStringList;
    FCritField, FCritValue: ShortString;
    FQTState: TQTState;
    FCaseSensitive: Boolean;
    FQTPopUp: TPopUpMenu;
    FQTMenuItem: array[0..23] of TMenuItem;
    FQTInEffect: Boolean;
    function GetVersion: string;
    procedure QTPopupHandler(Sender: TObject);
    procedure SetMatchMode(mmValue: TQTMatchMode);
    procedure SetVisRelOps(roValue: TQTRelOps);
    procedure BlockInsert(DataSet: TDataSet);
    procedure InsertNewRecord(DataSet: TDataSet);
//    procedure ClearTempTableFields;
    procedure AddFieldToTempTable(FieldName: string; DataType: TFieldType; Size: Word);
    procedure CreateTempTable;
    procedure CloseTempTable;
    procedure PopUpUpdate(SelOp: Byte; RelOp: string;
      RelType: TRelationalOperatorType); virtual;
    function ParseFilterInExp(RangeValue: string; FilterField: string): string;
    procedure QTKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);

{ Needed for TQueryBySQL
function ParseSQL( sSql :AnsiString;
                              var FSelectPart : AnsiString;
                              var FFromPart   : AnsiString;
                              var FWherePart  : AnsiString;
                              var FGroupPart  : AnsiString;
                              var FHavingpart : AnsiString;
                              var FOrderpart  : AnsiString
                             ): Boolean;
    function RPos(InStr: string; SearchStr: string): Integer;
    function ConvertToSQLDate(strDate: string): string;
}
  public
    constructor Create(AOwner: Tcomponent); override;
    destructor Destroy; override;
    property QTState: TQTState read FQTState;
    property QTInEffect: Boolean read FQTInEffect;
    property Criteria: TStringList read FCriteria;
    property CaseSensitive: Boolean read FCaseSensitive write FCaseSensitive;
    property MatchMode: TQTMatchMode read FMatchMode write SetMatchMode;
    property VisibleRelOps: TQTRelOps read FQTRelOps write SetVisRelOps;
    property Version: string read GetVersion write FDummyStr;
  end; { TCustQueryTools }


  TQueryByFilter = class(TCustQueryTools)
  private
//    FGridPopUp: TPopUpMenu;
    FQTGrid: TDBGrid;
    FControlDS: TDataSource;
    FQTFilter: string;
    FAsteriskAsWildCard: Boolean;
    { To save Table's Filter related properties }
    FDBFilterOptions: TFilterOptions;
    FDBFiltered: Boolean;
    FDBFilter: string;
    function BuildFilterExp(CurrField: Integer): string;
    procedure PopUpUpdate(SelOp: Byte; RelOp: string; RelType: TRelationalOperatorType); override;
    function GetCurrentField: string;
    procedure SetQTGrid(AGrid: TDBGrid);
    procedure SetDataSource(ADataSource: TDataSource);
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: Tcomponent); override;
    destructor Destroy; override;
    function GetCriteria: Boolean;
    function SetFilter: Boolean;
    procedure ClearFilter;
    property QTFilter: string read FQTFilter;
  published
    property Grid: TDBGrid read FQTGrid write SetQTGrid;
    property DataSource: TDataSource read FControlDS write SetDataSource;
    property AsteriskAsWildCard: Boolean read FAsteriskAsWildCard write FAsteriskAsWildCard;
    property CaseSensitive;
    property MatchMode;
    property VisibleRelOps;
    property Version;
  end;

{ ********************************************************************* }


procedure Register;

{ ********************************************************************* }

implementation

{ ******************** Start of TCustQueryTools Methods ********************* }

function TCustQueryTools.GetVersion: string;
begin
  Result := QT_VERSION;
end;

function TCustQueryTools.ParseFilterInExp(RangeValue: string; FilterField: string): string;
var
  s: string;
  EndOfCurrentString: byte;
begin
  Result := '';
  repeat
    EndOfCurrentString := Pos(',', RangeValue);
//    ShowMessage(IntToStr(EndofCurrentString));
    if EndOfCurrentString = 0 then
      Result := Result + '(' + FilterField + '=' + RangeValue + ')'
    else
    begin
      s := Copy(RangeValue, 1, EndOfCurrentString - 1);
      Result := Result + '(' + FilterField + '=' + s + ') or ';
    end;
    RangeValue := Copy(RangeValue
      , EndOfCurrentString + 1
      , length(RangeValue) - EndOfCurrentString
      );
  until EndOfCurrentString = 0;
end; // ParseFilterInExp

constructor TCustQueryTools.Create(AOwner: TComponent);
var
  i: integer; { iterate through PopupMenu }
begin
  inherited Create(AOwner);
  FQTRelOps :=
    [roNotEqual, roGreaterThan, roLesserThan,
    roBetween, roNotBetween, roIn, roNotIn, roContains, roNotContains,
    roLike, roNotLike, roIsNull, roIsNotNull,
    roAscOrder, roDescOrder, roClearOrder
    ];

  FQTPopUp := TPopUpMenu.Create(Self);
  { Create & Set the Relational Operator PopUp }
  for i := 0 to 23 do FQTMenuItem[i] := TMenuItem.Create(self);
  FQTMenuItem[0].Caption := 'Match All';
  FQTMenuItem[1].Caption := 'Match Any';
  FQTMenuItem[2].Caption := '-';
  FQTMenuItem[3].Caption := 'Equal To';
  FQTMenuItem[4].Caption := 'Not Equal To';
  FQTMenuItem[5].Caption := 'Greater Than';
  FQTMenuItem[6].Caption := 'Lesser Than';
  FQTMenuItem[7].Caption := '-';
  FQTMenuItem[8].Caption := 'Between';
  FQTMenuItem[9].Caption := 'Not Between';
  FQTMenuItem[10].Caption := 'In';
  FQTMenuItem[11].Caption := 'Not In';
  FQTMenuItem[12].Caption := '-';
  FQTMenuItem[13].Caption := 'Contains';
  FQTMenuItem[14].Caption := 'Not Contains';
  FQTMenuItem[15].Caption := 'Like';
  FQTMenuItem[16].Caption := 'Not Like';
  FQTMenuItem[17].Caption := '-';
  FQTMenuItem[18].Caption := 'Is NULL';
  FQTMenuItem[19].Caption := 'Is Not NULL';
  FQTMenuItem[20].Caption := '-';
  FQTMenuItem[21].Caption := 'Ascending Order';
  FQTMenuItem[22].Caption := 'Descending Order';
  FQTMenuItem[23].Caption := 'Clear Order';

  for i := 0 to 23 do
  begin
    FQTMenuItem[i].OnClick := QTPopUpHandler;
    FQTPopUp.Items.Add(FQTMenuItem[i]);
  end; { for i }

  FCriteria := TStringList.Create;
  FTempTable := TkbmMemTable.Create(self); { Temporary Table }
  MatchMode := mmMatchAll;
  FQTState := qsInactive;
  FCaseSensitive := False;
end; { Constructor TCustQueryTools }

{--------------------------------------------------------------------}
destructor TCustQueryTools.Destroy;
var
  i: Byte; { iterate through PopupMenu }
begin
  FTempTable.Close; FTempTable.DeleteTable;
  FTempTable.Free;
  FCriteria.Free;

  for i := 0 to 23 do FQTMenuItem[i].Free;
  FQTPopUp.Free;
  inherited Destroy;
end; {Destructor TCustQueryTools}

{--------------------------------------------------------------------}
procedure TCustQueryTools.QTKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
var
  l, t: Integer;
begin
  l := Screen.ActiveControl.Left + Screen.ActiveControl.width + TForm(Owner).Left;
  t := Screen.ActiveControl.top + TForm(Owner).top;
  if (ssAlt in Shift) and (ssCtrl in Shift) then
//   if (Key = VK_F4) And ( ssCtrl in Shift ) then
    FQTPopUp.Popup(l, t); //0, 0);
  if Assigned(FOwnerKeyDown) then FOwnerKeyDown(Sender, Key, Shift);
end;

{--------------------------------------------------------------------}
procedure TCustQueryTools.SetVisRelOps(roValue: TQTRelOps);
begin
  if FQTType in [qtFilterByForm, qTFilterByGrid] then
    roValue :=
      roValue - [roContains, roNotContains, roLike, roNotLike,
      roAscOrder, roDescOrder, roClearOrder];

  if roValue <> FQTRelOps then
  begin
    FQTRelOps := roValue;
    with FQTPopUp do
    begin
      Items[4].Visible := roNotEqual in FQTRelOps;
      Items[5].Visible := roGreaterThan in FQTRelOps;
      Items[6].Visible := roLesserThan in FQTRelOps;

      Items[8].Visible := roBetween in FQTRelOps;
      Items[9].Visible := roNotBetween in FQTRelOps;
      Items[10].Visible := roIn in FQTRelOps;
      Items[11].Visible := roNotIn in FQTRelOps;
      if Items[8].Visible or Items[9].Visible or Items[10].Visible
        or Items[11].Visible then Items[12].Visible := True
      else Items[12].Visible := False;

      Items[13].Visible := roContains in FQTRelOps;
      Items[14].Visible := roNotContains in FQTRelOps;
      Items[15].Visible := roLike in FQTRelOps;
      Items[16].Visible := roNotLike in FQTRelOps;
      if Items[13].Visible or Items[14].Visible or Items[15].Visible
        or Items[16].Visible then Items[17].Visible := True
      else Items[17].Visible := False;

      Items[18].Visible := roIsNull in FQTRelOps;
      Items[19].Visible := roIsNotNull in FQTRelOps;
      if Items[18].Visible or Items[19].Visible then
        Items[20].Visible := True
      else Items[20].Visible := False;

      Items[21].Visible := roAscOrder in FQTRelOps;
      Items[22].Visible := roDescOrder in FQTRelOps;
      Items[23].Visible := roClearOrder in FQTRelOps;
    end; // with FQTPopUp
  end; // if roValue
end; { Set the Visible Relational Operators in PopUpMenu }

{--------------------------------------------------------------------}

procedure TCustQueryTools.SetMatchMode(mmValue: TQTMatchMode);
begin
  if mmValue = mmMatchAll then
  begin
    FMatchMode := mmMatchAll;
    FQTPopUp.Items[0].Visible := False;
    FQTPopup.Items[1].Visible := True;
  end // if mmValue
  else
  begin
    FMatchMode := mmMatchAny;
    FQTPopUp.Items[0].Visible := True;
    FQTPopup.Items[1].Visible := False;
  end; // else mmValue
end; // SetMatchMode

{========== Temporary Memory Table related Methods ==================}
{ procedure TCustQueryTools.ClearTempTableFields;
begin
     FTempTable.FieldDefs.Clear;
end;
}

{--------------------------------------------------------------------}

procedure TCustQueryTools.AddFieldToTempTable(FieldName: string; DataType: TFieldType; Size: Word);
begin
  FTempTable.FieldDefs.Add(FieldName, DataType, Size, False);
end; // AddFieldToTempTable
//bm
{--------------------------------------------------------------------}

procedure TCustQueryTools.CreateTempTable;
var
  QTData: PQbgData;
  i: Word;
begin
  FTempTable.FieldDefs.Clear;

  for i := 0 to fQTDataSet.FieldCount - 1 do
    with fQTDataSet.fields[i] do
    begin
      if DataType = ftAutoInc then
        AddFieldToTempTable(Fieldname, ftInteger, Size)
      else AddFieldToTempTable(Fieldname, DataType, Size);

    end; // with

  FTempTable.CreateTable; FTempTable.Close;

    // Support for FieldKind fkLookUp fields
  for i := 0 to fQTDataSet.FieldCount - 1 do
  begin
    New(QTData); // To store Col Info
    QTData^.RelOpInfo := opEqualTo; {default}
    if FTempTable.Fields[i].DataType in [ftString, ftSmallint, ftInteger,
      ftWord, ftBoolean, ftFloat, ftCurrency,
      ftBCD, ftDate, ftTime, ftDateTime,
      ftBytes, ftAutoInc] then
      QTData^.RelType := rtCompare {default}
    else
      QTData^.RelType := rtNone;
    FTempTable.Fields[i].Tag := LongInt(QTData);

    with fQTDataSet.fields[i] do
    begin
      FTempTable.Fields[i].FieldKind := FieldKind;
      FTempTable.Fields[i].LookUpDataSet := LookUpDataSet;
      FTempTable.Fields[i].KeyFields := KeyFields;
      FTempTable.Fields[i].LookUpKeyFields := LookUpKeyFields;
      FTempTable.Fields[i].LookUpResultField := LookUpResultField;
      FTempTable.Fields[i].Visible := Visible;
    end; // with
  end; // for
  FTempTable.Open; FTempTable.Insert; FTempTable.Post; {Add Blank Record}

  FTempTable.AfterInsert := BlockInsert;
  FTempTable.AfterDelete := InsertNewRecord;
  FTempTable.Edit; //FTempTable.ClearFields;
end; // CreateTempTable

{--------------------------------------------------------------------}

procedure TCustQueryTools.CloseTempTable;
begin
  FTempTable.AfterInsert := nil;
  FTempTable.AfterDelete := nil;
  FTempTable.Close; FTempTable.DeleteTable;
end; // CloseTempTable

{--------------------------------------------------------------------}
{ These events will help in stopping the user from fooling around with
  the  Insert and Delete while our temporary Table is in Effect.

  Method for the Temporary Table's AfterInsert Event }

procedure TCustQueryTools.BlockInsert(DataSet: TDataSet);
begin
  if DataSet.State in [dsEdit, dsInsert] then DataSet.Cancel;
end; // BlockInsert

{--------------------------------------------------------------------}
{ Method for the Temporary Table's AfterDelete Event }

procedure TCustQueryTools.InsertNewRecord;
begin
  FTempTable.AfterInsert := nil;
  FTempTable.Insert; FTempTable.Post;
  FTempTable.AfterInsert := BlockInsert;
end; // InsertNewRecord

{--------------------------------------------------------------------}

procedure TCustQueryTools.QTPopupHandler(Sender: TObject);
const
  BetMsg = 'FROM Entered in the Field. TO to be Entered Here';
var
  SelOp: Byte;
  RelOp: string;
  RelType: TRelationalOperatorType;
begin
  SelOp := (Sender as TMenuItem).MenuIndex;

  case SelOp of
    0: MatchMode := mmMatchAll;
    1: MatchMode := mmMatchAny;
    3: begin RelOp := opEqualTo; RelType := rtCompare; end;
    4: begin RelOp := opNotEqualTo; RelType := rtCompare; end;
    5: begin RelOp := opGreaterThan; RelType := rtCompare; end;
    6: begin RelOp := opLesserThan; RelType := rtCompare; end;
    8: begin RelOp := opBetween + InputBox('Between', BetMsg, '');
        RelType := rtBetween;
      end;
    9: begin RelOp := opNotBetween + InputBox('Not Between', BetMsg, '');
        RelType := rtBetween;
      end;
    10: begin RelOp := opIn + InputBox('In : Enter List Seperated by Comma',
          'Strings in Quotes', '');
        RelType := rtIn;
      end;
    11: begin RelOp := opNotIn + InputBox('Not In : Enter List Seperated by Comma',
          'Strings in Quotes', '');
        RelType := rtIn;
      end;
    13: begin RelOp := opContains; RelType := rtContains; end;
    14: begin RelOp := opNotContains; RelType := rtContains; end;
    15: begin RelOp := opLike; RelType := rtLike; end;
    16: begin RelOp := opNotLike; RelType := rtLike; end;
    18: begin RelOp := opNull; RelType := rtNull; end;
    19: begin RelOp := opNotNull; RelType := rtNull; end;
  end; // case SelOp
  if (SelOp > 1) and (SelOp < 21) then PopUpUpdate(Selop, RelOp, RelType);
end; { Method QTPopupHandler }

{--------------------------------------------------------------------}

procedure TCustQueryTools.PopUpUpdate(SelOp: Byte; RelOp: string;
  RelType: TRelationalOperatorType);
begin
     { Virtual function - Code written in sub-classes }
end; // PopUpdate


{ ******************** End of TCustQueryTools Methods ********************* }

{ ******************** Start of TQueryByFilter Methods ********************* }

constructor TQueryByFilter.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAsteriskAsWildCard := True;
  FQTType := qtFilterByForm;
  VisibleRelOps := [roNotEqual, roGreaterThan, roLesserThan,
    roBetween, roNotBetween, roIn, roNotIn,
    roIsNull, roIsNotNull];
end; // Constructor

{--------------------------------------------------------------------}

destructor TQueryByFilter.Destroy;
begin
  inherited Destroy;
end; // Destructor

procedure TQueryByFilter.SetQTGrid(AGrid: TDBGrid);
begin
  if FQTState <> qsInActive then
  begin
    MessageDlg('QueryByFilter should be in InActive State', mtWarning, [mbOk], 0);
    Exit;
  end;
  if FControlDS <> nil then FControlDS := nil;
  FQTGrid := AGrid;
  FQTType := qtFilterByGrid;
end;

procedure TQueryByFilter.SetDataSource(ADataSource: TDataSource);
begin
  if FQTState <> qsInActive then
  begin
    MessageDlg('QueryByFilter should be in InActive State', mtWarning, [mbOk], 0);
    Exit;
  end;
  if FQTGrid <> nil then FQTGrid := nil;
  FControlDS := ADataSource;
  FQTType := qtFilterByForm;
end;

{---------------------------------------------------------------------}

procedure TQueryByFilter.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
//  If FQTState <> qsInActive then Reset;
  if FQTType = qtFilterByGrid then
  begin
    if (Operation = opRemove) and (FQTGrid <> nil) and
      (AComponent = Grid) then
      Grid := nil;
  end
  else
  begin
    if (Operation = opRemove) and (FControlDS <> nil) and
      (AComponent = DataSource) then
      FControlDS := nil;
  end;

end; // Notification

{--------------------------------------------------------------------}

procedure TQueryByFilter.PopUpUpdate(SelOp: Byte; RelOp: string; RelType: TRelationalOperatorType);
var
  CurrField: string;
  i: Integer;
begin
  CurrField := GetCurrentField();
  for i := 0 to FTempTable.FieldCount - 1 do
    if FTempTable.Fields[i].FieldName = CurrField then
    begin
      PQbgData(FTempTable.Fields[i].Tag)^.RelOpINfo := RelOp;
      PQbgData(FTempTable.Fields[i].Tag)^.RelType := RelType;
      Exit;
    end;
  // MessageDlg('QueryByFilter Error - Field Not found in TempTable', mtWarning, [mbOk], 0);
end;

{--------------------------------------------------------------------}

function TQueryByFilter.GetCriteria: Boolean;
begin
  if FQTState <> qsInActive then ClearFilter;
  Result := False;

  if FQTType = qTFilterByGrid then
  begin
    if FQTGrid = nil then begin
      MessageDlg('No Grid Selected', mtWarning, [mbOk], 0);
      Exit;
    end;
    FDataSource := FQTGrid.DataSource;
  end
  else FDataSource := FControlDS;

  if FDataSource = nil then
  begin
    MessageDlg('No DataSource Selected', mtWarning, [mbOk], 0);
    Exit;
  end; { if no FDataSource }

  if FDataSource.DataSet = nil then
  begin
    MessageDlg('No Table/Query Selected in the DataSource DataSet', mtWarning, [mbOk], 0);
    Exit;
  end; { if no FDataSource.DataSet }

  fQTDataSet := FDataSource.DataSet;

  if not fQTDataSet.Active then begin
    MessageDlg('Table/Query should be Active', mtWarning, [mbOk], 0);
    Exit;
  end; { if FQTQuery Not Active }

  CreateTempTable; // From fQTDataSet

  with fQTDataSet do
  begin
    FDBFilter := Filter;
    FDBFiltered := Filtered;
    Filtered := True;
    FDbFilterOptions := FilterOptions;
    FilterOptions := [];
    if not CaseSensitive then FilterOptions := [foCaseInSensitive];
    if not FAsteriskAsWildCard then
      FilterOptions := FilterOptions + [foNoPartialCompare];
  end; { with fQTDataSet }

//  if FQTType = qTFilterByGrid then
//  Begin
//    FGridPopUp := FQTGrid.PopupMenu;
//    FQTGrid.PopupMenu := FQTPopUp;
//  End;
//  Else SaveCurrentState;

  FDataSource.DataSet := FTempTable;
  FQTState := qsGetCriteria; FQTInEffect := False;

  FOwnerKeyDown := TForm(Owner).OnKeyDown;
  TForm(Owner).OnKeyDown := QTKeyDown;
  TForm(Owner).KeyPreview := True;

  Result := True;
end;

{---------------------------------------------------------------------}

procedure TQueryByFilter.ClearFilter;
var
  QTData: PQbgData;
  i: word;
  Save_Cursor: TCursor;
begin
  TForm(Owner).OnKeyDown := FOwnerKeyDown;

  if FQTState <> qsInActive then
  begin
    Save_Cursor := Screen.Cursor;
    Screen.Cursor := crHourglass;
    fQTDataSet.DisableControls;
    FDataSource.DataSet := fQTDataSet;

   { Restore Orignal Filter }
    if QTState = qsExecuted then begin
      with fQTDataSet do begin
        Filter := FDBFilter;
        FilterOptions := FDbFilterOptions;
        Filtered := FDBFiltered;
      end; // with fQTDataSet
      FQTFilter := '';
    end; // if

    fQTDataSet.EnableControls;

    for i := 0 to FTempTable.FieldCount - 1 do begin
      QTData := PQbgData(FTempTable.Fields[i].Tag);
      Dispose(QTData);
    end;
    CloseTempTable;
    FCriteria.clear;

//  if FQTType = qTFilterByGrid then
  //    FQTGrid.PopupMenu := FGridPopUp
//  Else
//      ReSetSavedState;

    FQTState := qsInActive;
    Screen.Cursor := Save_Cursor;
  end; { if }

end;

{---------------------------------------------------------------------}

function TQueryByFilter.SetFilter;
var
  i: Word;
  FiltExp: string;
  MatchStr: string[5];
  Save_Cursor: TCursor;
begin
  Result := False;
  if FQTState <> qsGetCriteria then Exit; {GetCriteria Method Not Called}

  Save_Cursor := Screen.Cursor;
  Screen.Cursor := crHourglass;
  FDataSource.DataSet := fQTDataSet;
  fQTDataSet.DisableControls;
  if FMatchMode = mmMatchAll then MatchStr := ' AND ' else MatchStr := ' OR ';

  FQTFilter := '';
  FCriteria.Clear;
  for i := 0 to FTempTable.Fieldcount - 1 do // for each column in the grid
  begin
    FiltExp := BuildFilterExp(i);
    if FiltExp <> '' then
    begin
      FCriteria.Add(FCritValue);
      if FQTFilter = '' then FQTFilter := FiltExp
      else FQTFilter := FQTFilter + MatchStr + FiltExp;
    end; // if FiltExp <> ''
  end; // for each column in the FTempTable

{ if table already has a filter - Add BEFORE our QT filter }
  if (FQTFilter <> '') then begin
    if (FDBFilter <> '') then FQTFilter := '(' + FDbFilter + ') AND (' + FQTFilter + ')';
    FQTInEffect := True;
    try
      fQTDataSet.Filter := FQTFilter;
    except
      MessageDlg('Filter Error' + #13#10 + #13#10 +
        'Criteria entered does not seem to be valid' + #13#10 +
        'Criteria to be entered again.', mtWarning, [mbOK], 0);
      FQTInEffect := False;
    end;
  end; { FQTFilter not Empty }

  fQTDataSet.EnableControls;
  Screen.Cursor := Save_Cursor;

  if FQTInEffect then begin
    Result := True; { Execute Successful }
    FQTState := qsExecuted;
  end
  else ClearFilter;
end; // Execute

{---------------------------------------------------------------}
{ Called by the Execute Method }

function TQueryByFilter.BuildFilterExp(CurrField: Integer): string;
var
  AField: TField;
  CritRangeValue, FilterField, FilterValue, RelOp, RangeValue: string;
  RelType: TRelationalOperatorType;
begin
  Result := '';
  RangeValue := '';

  RelType := PQbgData(FTempTable.Fields[CurrField].tag)^.RelType;

  if RelType = rtNone then Exit;

  RelOp := PQbgData(FTempTable.Fields[CurrField].tag)^.RelOpInfo;

{
  if RelType = rtBetween then begin
    RangeValue := '''' + Copy( RelOp, 3, Length(RelOp)-2 ) + '''';
    RelOp := Copy(RelOp, 1, 2);
  end;
}
  case RelType of
    rtBetween:
      begin
        RangeValue := Copy(RelOp, 3, Length(RelOp) - 2);
        RelOp := Copy(RelOp, 1, 2);
      end;
    rtIn:
      begin
        RangeValue := Copy(RelOp, 3, Length(RelOp) - 2);
        RelOp := Copy(RelOp, 1, 2);
      end;
  end; // case RelType

  AField := FTempTable.Fields[CurrField];

  if AField.FieldKind = fkLookup then FilterField := AField.keyFields
  else FilterField := AField.FieldName;
  FCritField := AField.DisplayLabel;
  FilterValue := FTempTable.FieldByName(FilterField).AsString;
  FCritValue := FilterValue; CritRangeValue := RangeValue;
//  if FilterValue <> '' then
  FilterField := '[' + FilterField + ']';

  if Trim(FilterValue) <> '' then
  begin
    FilterValue := '''' + FilterValue + '''';
    case RelType of
      rtCompare: begin
          FCritValue := FCritField + CritSep + RelOp + CritSep + FCritValue;
          Result := '(' + FilterField + RelOp + FilterValue + ')';
        end;
      rtBetween: begin
          if RelOp = opBetween then begin
            FCritValue := FCritField + CritSep + RelOp + CritSep +
              FCritValue + CritSep + CritRangeValue;
            Result := FilterField + ' >= ' + FilterValue + ' And '
              + FilterField + ' <= ' + RangeValue;
          end
          else begin
            FCritValue := FCritField + CritSep + RelOp +
              FCritValue + RelOp + CritRangeValue;
            Result := ' NOT(' + FilterField + ' >= ' + FilterValue + ' And '
              + FilterField + ' <= ' + RangeValue + ')';
          end;
          Result := '(' + Result + ')';
        end; { rtBetween }
    end; { case }
  end; { if Trim(FilterValue) <> '' }

  if RelType = rtIn then
  begin
    if RelOp = opIn then
    begin
      FCritValue := FCritField + CritSep + RelOp + CritSep + CritRangeValue;
      Result := '(' + ParseFilterInExp(RangeValue, FilterField) + ')';
//      ShowMessage(Result);
    end
    else
    begin
      FCritValue := FCritField + CritSep + RelOp + CritSep + CritRangeValue;
      Result := '(Not (' + ParseFilterInExp(RangeValue, FilterField) + '))';
    end;
    Result := '(' + Result + ')';
  end; // RelType = rtIn

  if RelType = rtNull then begin
    if RelOp = opNull then begin
      FCritValue := FCritField + CritSep + RelOp;
      Result := FilterField + ' = NULL';
    end
    else begin
      FCritValue := FCritField + CritSep + RelOp;
      Result := FilterField + ' <> NULL';
    end;
    Result := '(' + Result + ')';
  end; { If RelType = rtNull }


end; { Function BuildFilterExp }

function TQueryByFilter.GetCurrentField: string;
begin
  with Screen do
  begin
    if ActiveControl is TDBGrid then
      Result := TDBGrid(ActiveControl).Columns[TDBGrid(ActiveControl).SelectedIndex].FieldName
    else
      if (ActiveControl is TDbEdit) then Result := TDBEdit(ActiveControl).Field.FieldName;
  end; // With Screen.ActiveControl
//  ShowMessage(Result);
end; // GetCurrentField

{ ******************** End of TQueryByFilter Methods ********************* }

procedure Register;
begin
  RegisterComponents('Query Tools', [TQueryByFilter]);
//  RegisterComponents('Jayan Controls', [TQueryBySQL]);
end;


end. // Unit JQryTool.Pas

