unit Iscard;

{(C) Patrik Spanel 2001}

interface

uses
  Windows,Sysutils;

{$I ISCARD.INC}

const DACB10=0;
      DACU10=1;
      DACB5=2;
SOFTWAREKEYNAME='SOFTWARE\Instrument Interface\ISCARD';

var RTD:PRTData;
    hISCardVxd:THandle;

var DACRanges:packed array[0..MAXCARDS-1,0..MAXCH-1] of Byte;
var DefOutput:packed array[0..MAXCARDS-1] of Word;

function ADVoltage(ci,i:integer):double;
function DAVoltage(ci,i:integer):double;
function SetDAVoltage(ci,i:integer; v:double):word;
procedure SetDigOut(ci,i:integer; v:wordbool);
function GetDigOut(ci,i:integer):wordbool;
function GetDigInp(ci,i:integer):wordbool;

procedure SetCallBack(add:integer);


function ISCardActivate:integer;
function ISCardEnable(en:boolean):integer;
function ISCardUpdate:integer;
function ISCardSaveRegistry:boolean;


implementation

uses registry;

function IscardActivate:integer;
var
    Retinfo:array[0..32] of longint;
    RetBytes:DWORD;
    Parm:array[0..1] of longint;
begin
  DeviceIOCOntrol(hISCardVxd,2,@Parm,sizeof(Parm),@Retinfo,sizeof(Retinfo),RetBytes,nil);
  RTD:=PRTData(Retinfo[1]);
  RTD^.Card[0].ADFlags:=1;
  RTD^.Card[1].ADFlags:=1;
  RTD^.Card[2].ADFlags:=1;
  RTD^.Card[3].ADFlags:=1;
  result:=Retinfo[0];
end;

function ISCardEnable(en:boolean):integer;
var
    Retinfo:array[0..32] of longint;
    RetBytes:DWORD;
    Parm:array[0..1] of longint;
begin
  if en then Parm[0]:=1 else Parm[0]:=0;
  DeviceIOCOntrol(hISCardVxd,3,@Parm,sizeof(Parm),@Retinfo,sizeof(Retinfo),RetBytes,nil);
  RTD:=PRTData(Retinfo[1]);
  result:=Retinfo[0];
end;

function ISCardUpdate:integer;
var
    Retinfo:array[0..32] of longint;
    RetBytes:DWORD;
    Parm:array[0..1] of longint;
begin
  Parm[0]:=0;
  DeviceIOCOntrol(hISCardVxd,4,@Parm,sizeof(Parm),@Retinfo,sizeof(Retinfo),RetBytes,nil);
  RTD:=PRTData(Retinfo[1]);
  result:=Retinfo[0];
end;


function ADVoltage(ci,i:integer):double;
begin
 result:=0;
 if (i>=0) and (i<8) and (ci>=0) and (ci<MAXCARDS) then
 if RTD<>nil then result:=SmallInt(RTD^.card[ci].ADValue[i])/$7FFF*10;
end;

function DAVoltage(ci,i:integer):double;
begin
 result:=0;
 if (i>=0) and (i<16) and (ci>=0) and (ci<MAXCARDS) then
 if RTD<>nil then begin
  case DACRanges[ci,i] of
    DACB10: result:=Smallint(RTD^.card[ci].DAValue[i])/$7FFF*10;
    DACU10: result:=WORD(RTD^.card[ci].DAValue[i])/$FFFF*10;
    DACB5: result:=SmallInt(RTD^.card[ci].DAValue[i])/$7FFF*5;
  else
    result:=RTD^.card[ci].DAValue[i]/$7FFF*10;
  end;
 end;
end;

function SetDAVoltage(ci,i:integer; v:double):word;
begin
 result:=0;
 if RTD<>nil then begin
  case DACRanges[ci,i] of
    DACB10: RTD^.card[ci].DAValue[i]:=round($7FFF*v/10);
    DACU10: RTD^.card[ci].DAValue[i]:=round($FFFF*v/10);
    DACB5:  RTD^.card[ci].DAValue[i]:=round($7FFF*v/ 5);
  end;
  result:=RTD^.card[ci].DAValue[i];
 end;
end;

procedure SetDigOut(ci,i:integer; v:wordbool);
begin
 if (i>=0) and (i<16) and (ci>=0) and (ci<MAXCARDS) then begin
   if assigned(RTD) then
     with RTD^.card[ci] do
       if v then DigOut:=DigOut or (1 shl i)
            else DigOut:=DigOut and not (1 shl i);
 end;
end;


function GetDigOut(ci,i:integer):wordbool;
begin
 result:=false;
 if (i>=0) and (i<16) and (ci>=0) and (ci<MAXCARDS) then begin
   if assigned(RTD) then
     with RTD^.card[ci] do
       result:=(1 and (DigOut shr i))<>0;
 end;
end;

function GetDigInp(ci,i:integer):wordbool;
begin
 result:=false;
 if (i>=0) and (i<8) and (ci>=0) and (ci<MAXCARDS) then begin
   if assigned(RTD) then
     with RTD^.card[ci] do
       result:=(1 and (DigIn shr i))<>0;
 end;
end;


procedure SetCallBack(add:integer);
begin
 if RTD<>nil then begin
  RTD^.UserCallBack:=add;
 end;
end;


function ISCardSaveRegistry:boolean;
var reg:TRegistry;
begin
 reg:=TRegistry.Create;
 reg.RootKey:=HKEY_LOCAL_MACHINE;
 result:=reg.OpenKey(SOFTWAREKEYNAME,true);
 if RTD<>nil then
 with RTD^ do begin
  reg.WriteBinaryData('Fscan',Fscan,sizeof(Fscan));
  reg.WriteBinaryData('Mainsf',Mainsf,sizeof(Mainsf));
  reg.WriteBinaryData('NCards',NCards,sizeof(NCards));
  reg.WriteBinaryData('Port0',Card[0].Baseport,sizeof(Card[0].Baseport));
  reg.WriteBinaryData('Port1',Card[1].Baseport,sizeof(Card[1].Baseport));
  reg.WriteBinaryData('Port2',Card[2].Baseport,sizeof(Card[2].Baseport));
  reg.WriteBinaryData('Port3',Card[3].Baseport,sizeof(Card[3].Baseport));
 end;
 reg.WriteBinaryData('DACrange0',DACRanges[0],MAXCH);
 reg.WriteBinaryData('DACrange1',DACRanges[1],MAXCH);
 reg.WriteBinaryData('DACrange2',DACRanges[2],MAXCH);
 reg.WriteBinaryData('DACrange3',DACRanges[3],MAXCH);
 reg.WriteBinaryData('Output0',DefOutput[0],sizeof(DefOutput[0]));
 reg.WriteBinaryData('Output1',DefOutput[1],sizeof(DefOutput[1]));
 reg.WriteBinaryData('Output2',DefOutput[2],sizeof(DefOutput[2]));
 reg.WriteBinaryData('Output3',DefOutput[3],sizeof(DefOutput[3]));
 reg.CloseKey;
 reg.Free;
end;

var
    Retinfo:array[0..32] of longint;
    RetBytes:DWORD;
    Parm:array[0..1] of longint;
    ci,i:integer;
    reg:TRegistry;

initialization
begin
 hISCardVxd:=CreateFile( '\\.\ISCARD',GENERIC_READ,0,nil,0,FILE_FLAG_DELETE_ON_CLOSE,0);
 if hISCardVxd=INVALID_HANDLE_VALUE then
   hISCardVxd:=CreateFile( '\\.\ISCARD.VXD',GENERIC_READ,0,nil,0,FILE_FLAG_DELETE_ON_CLOSE,0);
 if hISCardVxd<>INVALID_HANDLE_VALUE then begin
  Retinfo[1]:=0;
  DeviceIOCOntrol(hISCardVxd,1,@Parm,sizeof(Parm),@Retinfo,sizeof(Retinfo),RetBytes,nil);
  RTD:=PRTData(Retinfo[1]);
  if (RTD=nil) or (RTD^.signature<>9999) then   MessageBox(0,'Data signature is corrupt', 'ISCARD.VXD',0);
 end
 else
 begin
   MessageBox(0,'Could not open ISCARD.VXD', '',0);
   RTD:=nil;
 end;
 for ci:=0 to MAXCARDS-1 do
   for i :=0  to MAXCH-1 do DACRanges[ci,i]:=dacb10;
 reg:=TRegistry.Create;
 reg.RootKey:=HKEY_LOCAL_MACHINE;
 reg.OpenKey(SOFTWAREKEYNAME,true);
 reg.ReadBinaryData('DACrange0',DACRanges[0],MAXCH);
 reg.ReadBinaryData('DACrange1',DACRanges[1],MAXCH);
 reg.ReadBinaryData('DACrange2',DACRanges[2],MAXCH);
 reg.ReadBinaryData('DACrange3',DACRanges[3],MAXCH);
 reg.ReadBinaryData('Output0',DefOutput[0],sizeof(DefOutput[0]));
 reg.ReadBinaryData('Output1',DefOutput[1],sizeof(DefOutput[1]));
 reg.ReadBinaryData('Output2',DefOutput[2],sizeof(DefOutput[2]));
 reg.ReadBinaryData('Output3',DefOutput[3],sizeof(DefOutput[3]));
 reg.CloseKey;
 reg.Free;
end;
finalization
 CloseHandle(hISCardVxd);
end.
