const MAXCARDS=4;
      MAXCH=16;

type
  TCardData=packed record
// configuration data
       BasePort,                 // Base port (i.e. 0x300)
       Mode:WORD;                     // defines the software mode, reserved
// input data
       Code,                     // read from System Code
       Status:BYTE;                   // read from System Staus
       CntHrdw:WORD;                 // two bytes from the counter
       CntPeriods, CntCounts:DWORD  ;   // accumulated totals
       ADData1,                   // hardware value
       ADData4:WORD;                   // hardware value
       ADValue:array[0..MAXCH-1]of WORD;            // 16b values from the ADS chips (now only 8 used)

       DigIn:DWORD;                   // 32b of digital input (now only the low 8 used

// output data
      Control,                 // will be written to SystemControl
      ADMux:BYTE  ;                   // prepares the MUX conversion for the next cycle
      DAValue:array[0..MAXCH-1]of WORD;             // 16b values for the DAC chips (now only 12 used)
      DigOut:DWORD;                  // 32b of digital outpu (now only the low 16 used

// state and context information
      CntOld:WORD;                  // previous two bytes from the counter
      ADMux1, ADMux0,           // previous of ADMux values
      DAData,                   // hardware value
      DAControl:BYTE;                // hardware value
      ADFlags:WORD;                  // AD status flags
      DAFrame:array[0..48-1] of BYTE;              // frame for loading 12 bit quad DACs (48bits)
      DAFrameJ:WORD;                 // index in this frame
      DAFlags:WORD;                  // DA control flags (low byte negates the MSBs in DAData)
      Reserved: array[0..51-1] of WORD;             // make the size 256 bytes
 end;

 PCardData=^TCardData;

type
  TRTData=packed record
      Size,   //total size of the structure
      Irq,
      Fscan,
      Mainsf:WORD;
      IrqCounter:DWORD;
      IsIRQactive,  //keeps the mask/unmask status
      UserTag:WORD ;      //for communication with the callback
      UserCallback:DWORD ; //address to callback
      PerfMin,
      PerfMax,
      PerfDuration:DWORD ;
      PerfMissed,
      Reserved,
      Signature,
      NCards:WORD ;                  //how many cards the driver serves
      Card:array[0..MAXCARDS-1]of TCardData;             //data for maximum of 4 cards
 end;

 PRTData=^TRTData;
