unit IS1006;

{(C)2001 Patrik Spanel}

interface

{$R ISCRDICO.RES}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Iscard;

type
  TAnalogOut=class(TPersistent)
    private
     FSelectedCard:integer;
     FOutput: array[0..15] of double;
     function GetOutPut(i:integer):double;
     procedure SetOutput(i:integer; v:double);
    public
      property Output[i:integer]:double read GetOutput write SetOutput;default;
    published
      property Output01:double index 0 read GetOutput write SetOutput;
      property Output02:double index 1 read GetOutput write SetOutput;
      property Output03:double index 2 read GetOutput write SetOutput;
      property Output04:double index 3 read GetOutput write SetOutput;
      property Output05:double index 4 read GetOutput write SetOutput;
      property Output06:double index 5 read GetOutput write SetOutput;
      property Output07:double index 6 read GetOutput write SetOutput;
      property Output08:double index 7 read GetOutput write SetOutput;
      property Output09:double index 8 read GetOutput write SetOutput;
      property Output10:double index 9 read GetOutput write SetOutput;
      property Output11:double index 10 read GetOutput write SetOutput;
      property Output12:double index 11 read GetOutput write SetOutput;
      property Output13:double index 12 read GetOutput write SetOutput;
      property Output14:double index 13 read GetOutput write SetOutput;
      property Output15:double index 14 read GetOutput write SetOutput;
      property Output16:double index 15 read GetOutput write SetOutput;
  end;

type
  TDigitalOut=class(TPersistent)
    private
     FSelectedCard:integer;
     FOutput: array[0..15] of boolean;
     function GetOutPut(i:integer):boolean;
     procedure SetOutput(i:integer; v:boolean);
    public
     property Output[i:integer]:boolean read GetOutput write SetOutput;default;
    published
      property Output01:boolean index 0 read GetOutput write SetOutput;
      property Output02:boolean index 1 read GetOutput write SetOutput;
      property Output03:boolean index 2 read GetOutput write SetOutput;
      property Output04:boolean index 3 read GetOutput write SetOutput;
      property Output05:boolean index 4 read GetOutput write SetOutput;
      property Output06:boolean index 5 read GetOutput write SetOutput;
      property Output07:boolean index 6 read GetOutput write SetOutput;
      property Output08:boolean index 7 read GetOutput write SetOutput;
      property Output09:boolean index 8 read GetOutput write SetOutput;
      property Output10:boolean index 9 read GetOutput write SetOutput;
      property Output11:boolean index 10 read GetOutput write SetOutput;
      property Output12:boolean index 11 read GetOutput write SetOutput;
      property Output13:boolean index 12 read GetOutput write SetOutput;
      property Output14:boolean index 13 read GetOutput write SetOutput;
      property Output15:boolean index 14 read GetOutput write SetOutput;
      property Output16:boolean index 15 read GetOutput write SetOutput;
  end;

type
  TIS1006 = class(TCustomControl)
  private
    { Private declarations }
    FActive:boolean;
    FOnActivate:TNotifyEvent;
    FSelectedCard,FPeriods,FCounts:cardinal;
    FAnalogOut:TAnalogOut;
    FDigitalOut:TDigitalOut;
    Bitmap1006,Bitmap1006r:TBitmap;
    function GetAnalogOut(i:integer):double;
    procedure SetAnalogOut(i:integer; v:double);
  protected
    { Protected declarations }
    procedure Paint;override;
    procedure SetActive(a:boolean);
    function GetBasePort:integer;
    function GetCountPulses:cardinal;
    function GetCountTime:double;
    function GetDigitalIn(i:integer):boolean;
    function GetAnalogIn(i:integer):double;
    procedure SelectCard(ASelectedCard:cardinal);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy;override;
    property BasePort:integer read GetBasePort;
    property AnalogIn[i:integer]:double read GetAnalogIn;
    property DigitalIn[i:integer]:boolean read GetDigitalIn;
    property CountPulses:cardinal read GetCountPulses;
    property CountTime:double read GetCountTime;
    procedure ResetCount;
  published
    { Published declarations }
    property Active:boolean read FActive write SetActive;
    property SelectedCard:cardinal read FSelectedCard write SelectCard;
    property AnalogOut:TAnalogOut read FAnalogOut write FAnalogOut;
      property AnalogOut01:double index 0 read GetAnalogOut write SetAnalogOut;
      property AnalogOut02:double index 1 read GetAnalogOut write SetAnalogOut;
      property AnalogOut03:double index 2 read GetAnalogOut write SetAnalogOut;
      property AnalogOut04:double index 3 read GetAnalogOut write SetAnalogOut;
      property AnalogOut05:double index 4 read GetAnalogOut write SetAnalogOut;
      property AnalogOut06:double index 5 read GetAnalogOut write SetAnalogOut;
      property AnalogOut07:double index 6 read GetAnalogOut write SetAnalogOut;
      property AnalogOut08:double index 7 read GetAnalogOut write SetAnalogOut;
      property AnalogOut09:double index 8 read GetAnalogOut write SetAnalogOut;
      property AnalogOut10:double index 9 read GetAnalogOut write SetAnalogOut;
      property AnalogOut11:double index 10 read GetAnalogOut write SetAnalogOut;
      property AnalogOut12:double index 11 read GetAnalogOut write SetAnalogOut;
      property AnalogOut13:double index 12 read GetAnalogOut write SetAnalogOut;
      property AnalogOut14:double index 13 read GetAnalogOut write SetAnalogOut;
      property AnalogOut15:double index 14 read GetAnalogOut write SetAnalogOut;
      property AnalogOut16:double index 15 read GetAnalogOut write SetAnalogOut;
    property DigitalOut:TDigitalOut read FDigitalOut write FDigitalOut;
    property OnActivate:TNotifyEvent read FOnActivate write FOnActivate;
    property Visible;
  end;

procedure Register;

implementation

function TAnalogOut.GetOutput(i:integer):double;
begin
 if (i>=0) and (i<16) then
  result:=FOutput[i]
 else
  result:=0;
end;

procedure TAnalogOut.SetOutput(i:integer; v:double);
begin
  if (i>=0) and (i<16) then begin
   if (v<-10) then v:=-10 else
   if (v>+10) then v:=+10;
   if assigned(RTD) then SetDAVoltage(FSelectedCard, i, v);
   FOutput[i]:=v;
  end;
end;

function TDigitalOut.GetOutput(i:integer):boolean;
begin
 if (i>=0) and (i<16) then
  result:=FOutput[i]
 else
  result:=false;
end;

procedure TDigitalOut.SetOutput(i:integer; v:boolean);
begin
 if (i>=0) and (i<16) then begin
   if assigned(RTD) then
     with RTD^.card[FSelectedCard] do
       if v then DigOut:=DigOut or (1 shl i)
            else DigOut:=DigOut and not (1 shl i);
   FOutput[i]:=v;
 end;
end;


constructor TIS1006.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 height:=24;
 width:=24;
 FAnalogOut:=TANalogOut.Create;
 FDigitalOut:=TDigitalOut.Create;
 Bitmap1006:=TBitmap.Create;
 Bitmap1006.handle:=LoadBitmap(Hinstance,'YELLOWBM');
 Bitmap1006r:=TBitmap.Create;
 Bitmap1006r.handle:=LoadBitmap(Hinstance,'REDBM');
end;

procedure TIS1006.Paint;
begin
  Inherited Paint;
  Canvas.Rectangle(0,0,width-1,height-1);
  if assigned(RTD) and (RTD^.IsIrqActive<>0) then
   Canvas.Draw(0,0,Bitmap1006)
  else Canvas.Draw(0,0,Bitmap1006r);
  if width<>24 then width:=24;
  if height<>24 then height:=24;
end;


destructor TIS1006.Destroy;
begin
 FAnalogOut.Free;
 FDigitalOut.Free;
 inherited Destroy;
end;

procedure TIS1006.SetActive(a:boolean);
begin
 if (a<>FActive) and assigned(RTD) then with RTD^ do begin
   FActive:=a;
   ISCardEnable(a);
   Invalidate;
   if a then begin
     if RTD^.IrqCounter<3 then IscardActivate;
     ResetCount;
     if assigned(OnActivate) then OnActivate(self);
   end
 end;
end;


function TIS1006.GetBasePort:integer;
begin
if assigned(RTD) then
  result:=RTD^.card[FSelectedCard].baseport
else result:=0;
end;

function TIS1006.GetCountPulses:cardinal;
begin
if assigned(RTD) then
  result:=cardinal(RTD^.card[FSelectedCard].CntCounts-FCounts)
else
  result:=0;
end;

function TIS1006.GetCountTime:double;
begin
result:=0;
if assigned(RTD) then with RTD ^ do if (FScan<>0) then
  result:=(card[FSelectedCard].CntPeriods-FPeriods)/FScan
end;

procedure TIS1006.ResetCount;
begin
  if assigned(RTD) then with RTD ^ do begin
    FPeriods:=card[FSelectedCard].CntPeriods;
    FCounts:=card[FSelectedCard].CntCounts;
  end
end;

function TIS1006.GetAnalogOut(i:integer):double;
begin
 if (i>=0) and (i<16) then
  result:=FAnalogOut[i]
 else
  result:=0;
end;

procedure TIS1006.SetAnalogOut(i:integer; v:double);
begin
  if (i>=0) and (i<16) then begin
   if (v<-10) then v:=-10 else
   if (v>+10) then v:=+10;
   if assigned(RTD) then SetDAVoltage(FSelectedCard, i, v);
   FAnalogOut[i]:=v;
  end;
end;



function TIS1006.GetDigitalIn(i:integer):boolean;
begin
 if assigned(RTD) and (i>=0) and (i<8) then
  result:=((RTD^.card[FSelectedCard].DigIn shr i) and 1)<>0
 else
  result:=false;
end;

function TIS1006.GetAnalogIn(i:integer):double;
begin
result:=0;
if assigned(RTD) then
  result:=ADVoltage(FSelectedCard,i);
end;


procedure TIS1006.SelectCard(ASelectedCard:cardinal);
begin
  if   ASelectedCard<>FSelectedCard then begin
    FSelectedCard:= ASelectedCard;
    AnalogOut.FSelectedCard:=FSelectedCard;
    DigitalOut.FSelectedCard:=FSelectedCard;
  end;
end;


procedure Register;
begin
  RegisterComponents('Instrument', [TIS1006]);
end;

end.
