{======================================================================
   LsComp.inc
   ----------
      Compiler directives to be used by all Ls-Component units
=======================================================================}

{$IFDEF WIN32}
  {$DEFINE D2_OR_HIGHER}
{$ENDIF}

{$IFNDEF VER80}  //If not D1
  {$DEFINE D2_OR_HIGHER}
  {$IFNDEF VER90}  //If not D2
    {$DEFINE BCB1_OR_HIGHER}
    {$IFNDEF VER93}  //If not BCB1
      {$DEFINE D3_OR_HIGHER}
      {$IFNDEF VER100}  //If not D3
        {$DEFINE BCB3_OR_HIGHER}
        {$IFNDEF VER110}  //IF not BCB3
          {$DEFINE D4_OR_HIGHER}
          {$IFNDEF VER120}  //If not D4
            {$DEFINE BCB4_OR_HIGHER}
            {$IFNDEF VER125}  //If not BCB4
              {$DEFINE D5_OR_HIGHER}
              {$IFNDEF VER130}  //If not D5
                {$DEFINE D6_OR_HIGHER}
              {$ENDIF}
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}
      {$ENDIF}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

{$IFDEF VER93}
  {$DEFINE BCB_COMPILER}
{$ENDIF}
{$IFDEF VER110}
  {$DEFINE BCB_COMPILER}
  {$OBJEXPORTALL ON}
{$ENDIF}
{$IFDEF VER125}
  {$DEFINE BCB_COMPILER}
  {$OBJEXPORTALL ON}
{$ENDIF}
{$IFDEF VER130}
  {$DEFINE BCB_COMPILER}    {D5 AND BCB5 use the same DCC32 compiler}
  {$OBJEXPORTALL ON}
{$ENDIF}

{== Code Generation Directives ==}

{$F-}    { Force Far Calls }
{$A+}    { Word Align Data }
{$U-}    { Pentium-Save FDIV }
{$K-}    { Smart Callbacks }
{$W-}    { Windows Stack Frame }


{== Runtime Errors ==}

{$IFOPT D+}
  {$R+}    { Range Checking - On - if compiled with Debug Information }
{$ELSE}
  {$R-}    { Range Checking - Off - if compiled without Debug Information }
{$ENDIF}
{$R-}    { Range Checking }
{$S-}    { Stack Checking }
{$I+}    { I/O Checking }
{$Q-}    { Overflow Checking }


{== Syntax Options ==}

{$V-}    { Strict Var-Strings }
{$B-}    { Complete Boolean Evaluation }
{$X+}    { Extended Syntax }
{$T-}    { Typed @ Operator }
{$P+}    { Open Parameters }
{$IFDEF D4_OR_HIGHER}
{$J+}    { Writeable Typed Constants }
{$ENDIF}

{== Miscellaneous Directives ==}

{$C MOVEABLE DEMANDLOAD DISCARDABLE}    { Code Segment Attribute }
{$G+}    { Delphi 1: 286 Instructions / Delphi 3 & later: Imported Data }
{$N+}    { Numeric Coprocessor }
{$Z-}    { Word Size Enumerated Types }

{$IFDEF WIN32}
{$H+}    { Long String Support }
{$ENDIF}

