
{$INCLUDE LSCOMP.INC}

unit LsIconEditorRegD6;

interface

uses Forms, SysUtils, Controls, Graphics, TypInfo,
{$IFDEF D6_OR_HIGHER}
  DEsignIntf, DesignEditors;
{$ELSE}
  DsgnIntf;
{$ENDIF}


type
 TLsIconEditor = class(TClassProperty)
 public
  function GetAttributes: TPropertyAttributes; override;
  procedure Edit; override;
 end;

procedure Register;

implementation

uses LsIconEditorMainD6, SaveIconDlgD6, AboutIconEditorD6;

function TLsIconEditor.GetAttributes: TPropertyAttributes;
begin
 Result := [paDialog]
end;

procedure TLsIconEditor.Edit;
begin
 Application.CreateForm(TLsIconEditorForm, LsIconEditorForm);
 Application.CreateForm(TSaveIconForm, SaveIconForm);
 Application.CreateForm(TAboutForm, AboutForm);
 with LsIconEditorForm do
 try
  Image1.Picture.Graphic := TIcon(GetOrdValue);
  if ShowModal = mrOk then
   if (GetPropType^.Name = 'TIcon') then
    SetOrdValue(LongInt(Image1.Picture))
 finally
   Close;
 end;
 LsIconEditorForm.Close;
end;

procedure Register;
begin
 RegisterPropertyEditor(TypeInfo(TIcon), nil, '', TLsIconEditor);
end;

end.