unit SaveIconDlgD45;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Spin, ExtCtrls;

type
  TSaveIconForm = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    GBoxBmp: TGroupBox;
    SpEdtHeight: TSpinEdit;
    SpEdtWidth: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    RadioGroup1: TRadioGroup;
    RBtnIco: TRadioButton;
    RBtnBmp: TRadioButton;
    GBoxIcon: TGroupBox;
    RBtn16Color: TRadioButton;
    RBtn256Color: TRadioButton;
    RBtnHiColor: TRadioButton;
    Bevel1: TBevel;

    procedure RBtnIcoClick(Sender: TObject);
    procedure RBtnBmpClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SetBtnState(Sender: TObject);
    procedure RBtn16ColorClick(Sender: TObject);
    procedure RBtn256ColorClick(Sender: TObject);
    procedure RBtnHiColorClick(Sender: TObject);
  private
  { Private declarations }
  public
  { Public declarations }
    Colors: integer;
  end;

var
  SaveIconForm: TSaveIconForm;


implementation

{$R *.DFM}

uses LsIconEditorMainD45;


procedure TSaveIconForm.SetBtnState(Sender: TObject);
begin
  LsIconEditorForm.IsIco := RBtnIco.Checked;
  LsIconEditorForm.IsBmp := RBtnBmp.Checked;
  GBoxIcon.Enabled := (RBtnIco.Checked = True) or
                      (RBtnBmp.Checked = True);
  SpEdtHeight.Enabled := RBtnBmp.Checked = True;
  SpEdtWidth.Enabled := RBtnBmp.Checked = True;
  GBoxBmp.Enabled := RBtnBmp.Checked = True;
  if RBtnBmp.Checked = True then
  begin
    SpEdtHeight.Color := clWindow;
    SpEdtWidth.Color := clWindow;
//    RBtnHiColor.Enabled := True;  //3.1
  end
  else begin
    SpEdtHeight.Color := clBtnFace;
    SpEdtWidth.Color := clBtnFace;
//    RBtnHiColor.Enabled := False;  //3.1
  end;
end;

procedure TSaveIconForm.RBtnIcoClick(Sender: TObject);
begin
  if RBtnIco.Checked = True then
  begin
    RBtnBmp.Checked := False;
    LsIconEditorForm.IsIco := True;
    LsIconEditorForm.IsBmp := False;
    SetBtnState(Sender);
  end;
end;

procedure TSaveIconForm.RBtnBmpClick(Sender: TObject);
begin
  if RBtnBmp.Checked = True then
  begin
    RBtnIco.Checked := False;
    LsIconEditorForm.IsIco := False;
    LsIconEditorForm.IsBmp := True;
    SpEdtHeight.Update;
    SpEdtWidth.Update;
    SetBtnState(Sender);
  end;
end;

procedure TSaveIconForm.FormShow(Sender: TObject);
begin
  RBtnIco.Checked := True;
  LsIconEditorForm.IsIco := True;
  LsIconEditorForm.IsBmp := False;
  SetBtnState(Sender);
end;



procedure TSaveIconForm.RBtn16ColorClick(Sender: TObject);
begin
  Colors := 16;
end;

procedure TSaveIconForm.RBtn256ColorClick(Sender: TObject);
begin
  Colors := 256;
end;

procedure TSaveIconForm.RBtnHiColorClick(Sender: TObject);
begin
  Colors := 65536; //3.1
end;

end.

