unit LsIconEditorRegD3;

interface

uses DsgnIntf, Forms, SysUtils, Controls, Graphics, TypInfo;

type
 TLsIconEditor = class(TClassProperty)
 public
  function GetAttributes: TPropertyAttributes; override;
  procedure Edit; override;
 end;

procedure Register;

implementation

uses LsIconEditorMainD3, SaveIconDlgD3, AboutIconEditorD3;

function TLsIconEditor.GetAttributes: TPropertyAttributes;
begin
 Result := [paDialog]
end;

procedure TLsIconEditor.Edit;
begin
 Application.CreateForm(TLsIconEditorForm, LsIconEditorForm);
 Application.CreateForm(TSaveIconForm, SaveIconForm);
 Application.CreateForm(TAboutForm, AboutForm);
 with LsIconEditorForm do
 try
  Image1.Picture.Graphic := TIcon(GetOrdValue);
  if ShowModal = mrOk then
   if (GetPropType^.Name = 'TIcon') then
    SetOrdValue(LongInt(Image1.Picture))
 finally
   Close;
 end;
 LsIconEditorForm.Close;
end;

procedure Register;
begin
 RegisterPropertyEditor(TypeInfo(TIcon), nil, '', TLsIconEditor);
end;

end.