{$I Param.Inc}
{$IFDEF apGDI}
 this unit works only with DirectX or WDosX
{$ENDIF}

{
  ############################################################################
  ## Input64 unit for Delphi 2/3/4/5 and WDosX 0.95/96                      ##
  ##                                                                        ##
  ## Copyright (c)1999 Pavol Stugel (http://www.graph64.miesto.sk           ##
  ## This unit is free. My e-mail: pstugel@pobox.sk                         ##
  ############################################################################

 --------
  History:
  --------
   11.08.2000 - DirectX 7 code added.
   02.04.2000 - Infos :-)
   08.01.2000 - added AllKeysUp (TRUE if all keys is up)
   24.12.1999 - Any modification for my scholl project
              - added ReleasedKey
   18.11.1999 - First version for WDosX and DirectX, only Keyboard supported now

Example of using:

uses input64;
begin
 InputInit;
  repeat until IsKeyDown( Key_ESC);
 InputDone;
end;
}
unit Input64;


interface

{$IFDEF win9x}
 uses
//  DInput,
//  DirectDraw,
  Direct64,
  DirectInput,
  Sysutils,
  Windows;
{  Forms;}
  var _DirectInput: IDirectInput2;
      DIKeyboard: IDirectInputDevice2;

{$ELSE}
 uses
  Dos;
  var
    HookedKeyb:boolean;  {keyboard is actived???}
    keybh:pointer;

{$ENDIF}
const
  Key_ESC = 1;
  Key_Space= 57;
  Key_Enter= 28;
  Key_Right= 77;
  Key_Left= 75;
  Key_Up= 72;
  Key_Down= 80;
  key_Plus= 78;
  Key_Point= 52;
  Key_Divider= 51;
  Key_F1= 59;
  Key_F2= 60;
  Key_F11= 87;
  Key_F12= 88;
  Key_A= 30;
  Key_S= 31;
  Key_D= 32;
  Key_W= 17;
  Key_M= 50;
  Key_CTRL= 29;

var
  Keys: array [0..127] of byte;
  TempKeys: array[0..127] of byte;
  ReleasedKeys: array[0..127] of byte;

procedure InputInit;
procedure InputDone;
Function IsKeyDown( key: byte): boolean;
Function WasKeyDown( key: byte): boolean;
Function AllKeysUP: boolean;
function GetKey: byte;

implementation

{$IFDEF win9x}
{this si for windoze}
function CheckDIRes(Res: HResult; const Msg: String): Boolean;
begin
  Result := SUCCEEDED(Res);
  if not Result then raise Exception.Create(Msg+': '{+ErrorString(Res)});
end;

function PropDWord(Value, ObjType: Integer): TDIPropDWord;
begin
  FillChar(Result,SizeOf(Result),0);
  Result.dwData := Value;
  with Result.diph do
  begin
    dwSize := SizeOf(Result); dwHeaderSize := SizeOf(Result.diph);
    if ObjType = -1 then dwHow := DIPH_DEVICE  // dwObj = 0
    else
    begin
      dwHow := DIPH_BYID; dwObj := ObjType;
    end;
  end;
end;

Procedure InitAll;
var DIDevice1: IDirectInputDevice; Prop: TDIPropDWord;
begin
  if DIKeyboard = nil then  {if we are here first}
  begin
   { Create Device for Keyboard}
    CheckDIRes(_DirectInput.CreateDevice(Guid_SysKeyboard, DIDevice1, nil),'CreateDevice');
    // Query for IDirectInputDevice2
    CheckDIRes(DIDevice1.QueryInterface(IID_IDirectInputDevice2,DIKeyboard),
      'QueryInterface for DirectInputDevice2');
    CheckDIRes(DIKeyboard.SetCooperativeLevel(h_wnd, DISCL_BACKGROUND or DISCL_NONEXCLUSIVE),
      'Set cooperative level');
    CheckDIRes(DIKeyboard.SetDataFormat(c_dfDIKeyboard),'SetDataFormat');
    Prop := PropDWord(100,-1); {buffer for input (100)}
    CheckDIRes(DIKeyboard.SetProperty(DIPROP_BUFFERSIZE,Prop.diph),'Set buffer size');
  end;
  CheckDIRes(DIKeyboard.Acquire,'Acquire');
end;

{$ELSE}
{and this is for dos}
procedure ISR; // by Wuschel Tippach, modifed me
var key:byte;
    xx: byte;
begin

for xx:= 0 to 127 do TempKeys[xx]:= Keys[xx];

  key:=port[$60];
  if key <> $E0 then begin
    if key > 127 then
         Keys[key and 127]:=0
        else
        begin
         for xx:= 0 to 127 do ReleasedKeys[xx]:= 0;
         Keys[key]:=1;
        end;
  end;

for xx:= 0 to 127 do
    if (TempKeys[xx]=1) and (Keys[xx]=0) then
      ReleasedKeys[xx]:= 1;

  port[$61]:=port[$61] or $80;
  port[$61]:=port[$61] and $7F;
  port[$20]:=$20;
end;
{$ENDIF}


Procedure InputInit;
var
{$IFDEF win9x}
  DI1: IDirectInput;
{$ENDIF}
  xx: word;
begin
for xx:= 0 to 127 do keys[xx]:= 0; //clear buffer
for xx:= 0 to 127 do ReleasedKeys[xx]:= 0; //clear buffer

{$IFDEF win9x}
  if not Assigned(DirectInputCreate) then raise Exception.Create('DInput.dll not found');
  if SUCCEEDED(DirectInputCreate(hInstance,DIRECTINPUT_VERSION,DI1,nil)) then
    DI1.QueryInterface(IID_IDirectInput2,_DirectInput);
  if _DirectInput = nil then raise Exception.Create('DX3 -- need DX5');
  InitAll;
{$ELSE}
  if not HookedKeyb then
  begin
    HookedKeyb:= true;
    GetIntVec($9, keybh);
    SetIntVec($9, @ISR);
  end;
{$ENDIF}

end;

{$IFDEF win9x}
Procedure DGetKey;
var ItemCount: DWord;
    ObjData: TDIDeviceObjectData;
    xx: Word;
begin
 for xx:= 0 to 127 do TempKeys[xx]:= Keys[xx];

  repeat
    ItemCount := 1;
    CheckDIRes(DIKeyboard.GetDeviceData(SizeOf(TDIDeviceObjectData),
      @ObjData, ItemCount, 0),'Get Data');
    if ItemCount = 0 then Break;  // queue empty
    with ObjData do
    begin
     if dwData and $80<>0 then
      begin
         for xx:= 0 to 127 do ReleasedKeys[xx]:= 0;
         Keys[dwOfs and 127]:= 1
      end else Keys[dwOfs and 127]:= 0;
     // dwTimeStamp,dwSequence
    end;
    for xx:= 0 to 127 do if (TempKeys[xx]=1) and (Keys[xx]=0) then ReleasedKeys[xx]:= 1;
  until False;

end;
{$ENDIF}

Function WasKeyDown( key: byte): boolean;
begin
 {$IFDEF win9x}DGetKey;{$ENDIF}
  result:= (ReleasedKeys[key and 127] = 1);
  ReleasedKeys[ key and 127]:= 0;
end;

Function AllKeysUP: boolean;
var xx: word;
begin
{$IFDEF win9x} DGetKey;{$ENDIF}
 xx:= 0;
 while (Keys[xx]=0)and(xx<128) do Inc( xx);
 If xx=128 then result:= true else result:= false;
end;

function GetKey: byte;
var xx: word;
begin
{$IFDEF win9x} DGetKey;{$ENDIF}
 xx:= 0;
 while (Keys[xx]=0)and(xx<128) do Inc( xx);
 If xx=128 then result:= 0 else result:= xx;
end;

function IsKeyDown(key: byte):boolean;
begin
 {$IFDEF win9x}DGetKey;{$ENDIF}
  IsKeyDown:= (Keys[key and 127] = 1);
end;


procedure InputDone;
begin
{$IFDEF win9x}
 DIKeyboard := nil;
{$ELSE}
  if HookedKeyb then SetIntVec($9, keybh);
  HookedKeyb:= false;
{$ENDIF}
end;

begin
{$IFNDEF win9x}
  HookedKeyb:= false;
{$ENDIF}

end.
