{
  ############################################################################
  ## Fonts unit for Delphi 2/3/4/5 and WDosX 0.95/96                        ##
  ##                                                                        ##
  ## Copyright (c)1999 Pavol Stugel (http:// www.graph64.miesto.sk          ##
  ## This unit is free. My e-mail: pstugel@pobox.sk                         ##
  ############################################################################

  --------
  History:
  --------
  23.01.2000 - Modification for new version graph64 TFont to TFont64
  12.12.1999 - Added overload DrawText for blending or normal draw
               TFont. TextWidth
  xx-xx-1999 - First version
}

{(c) Pavol Stugel 1999}
unit fonts;

interface

uses graph64,sysutils;
                       {12345678901234}
const charsMap: string='ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.,:'' "!?[]abcdefghijklmnopqrstuvwxyz';

Type
      TFont64= Class( TObject)
       chars: array[0..128]of  {for each char}
              record
                Data: TBitmap64;  {bitmap}
                Width: integer;
              end;
       constructor Create( fontName: string;_bpp: TPixelFormat; SmoothFont: boolean);
       procedure   DrawText( bitmap: TBitmap64; x,y: longint; what: string);
       procedure   DrawBlendText( bitmap: TBitmap64; x,y: longint; what: string;sfactor,dfactor: real);
       function    TextWidth( what: string): longint;
       function    TranslateChar( ch: char): longint;
       destructor  Destroy;override;
     end;

implementation

Constructor TFont64. Create;
var TempB: TBitmap64;
    w: PWord;
    sep,tc: Word;
    xx,where,
    sizex: integer;
{    f: text;}
begin

 if (_bpp<>pf15bit)and(_bpp<>pf16bit) then exit; {support only 15 and 16bpp modes}
 TempB:= TBitmap64. Create(0,0, _bpp);
 TempB. LoadFromTGAFile( FontName);
 w:= TempB. ScanLine[1]; {from second line get transparent color}

 tc:= w^;  {transparent color}

 w:= TempB. ScanLine[0];
 Sep:= w^;                  {set separator color}

 inc( w);
 where:= 1;

{ AssignFile( f, 'temp');
 Rewrite( f);
  Writeln(f, 'Separator: ', sep);
  Writeln(f, 'Transparent color: ', tc);
  Writeln(f, 'Size of CHARSMAP: ', Length( charsMap));
 }
               {13}
 for xx:= 0 to length( charsMap)-1 do
     begin
      sizex:= 0;
      while w^<>sep do begin inc( sizex);inc(w);end;  {search 'where' char data start}
      inc( w);
      chars[xx].width:= sizex;
      chars[xx].data:= TBitmap64. Create( sizex, TempB. Height, _bpp);
{      Writeln(f, Format( 'Creating %d image, with %dx%dx%d. OK', [xx,sizex,tempb. height, _bpp]));}
      chars[xx].data. Draw( -where, 0, TempB);
      if SmoothFont then chars[xx].data. MotionBlur;
      chars[xx].data. Transparent:= true;
      chars[xx].data. TransparentColor:= tc;
      inc( where,sizex+1);
     end;

{     Writeln( f, 'We are here');
 closeFile( f);}
 TempB. Destroy;

end;

function  TFont64. TranslateChar( ch: char): longint;
begin
          case ch of
           'A'..'Z': result:= ord( ch)-65;
           'a'..'z': result:= (ord( ch)-97)+46;
           '0'..'9': result:= (ord( ch)-48)+26;
           '.':  result:= 36;
           ',':  result:= 37;
           ':':  result:= 38;
           '''': result:= 39;
           '"':  result:= 41;
           ' ':  result:= 40;
           '!':  result:=42;
           '?':  result:= 43;
           else
            result:= $ffff; {skip this}
          end;
end;

procedure TFont64. DrawText( bitmap: TBitmap64; x,y: longint; what: string);
var c,xx: longint;
    where: longint;
begin
where:= 0;
 if length(what)>0 then
    for xx:= 1 to length( what) do
        begin
          c:= translateChar( what[xx]);
          if c<>$ffff then
          begin
           bitmap. Draw( x+where, y, chars[ c].data);
           inc( where, chars[ c]. width);
          end;
        end;
end;

procedure TFont64. DrawBlendText( bitmap: TBitmap64; x,y: longint; what: string;sfactor,dfactor: real);
var c,xx: longint;
    where: longint;
begin
where:= 0;
 if length(what)>0 then
    for xx:= 1 to length( what) do
        begin
          c:= translateChar( what[xx]);
          if c<>$ffff then
          begin
           bitmap. DrawBlend( x+where, y, chars[ c].data, sfactor, dfactor);
           inc( where, chars[ c]. width);
          end;
        end;
end;

function TFont64. TextWidth( what: string): longint;
var c,xx: longint;
begin
 result:= 0;
 if length(what)>0 then
    for xx:= 1 to length( what) do
        begin
          c:= translateChar( what[xx]);
          if c<>$ffff then
          begin
           result:= result + chars[ c]. width;
          end;
        end;
end;

Destructor TFont64. Destroy;
var xx: longint;
begin
 for xx:= length( charsMap)-1 downto 0 do chars[xx]. data . destroy;
 inherited destroy;
end;

end.
