{$I Param.Inc}
{
  ############################################################################
  ## Direct64 unit for Delphi 2/3/4 and WDosX 0.95/96                       ##
  ##                                                                        ##
  ## Copyright (c)1999/2000 Pavol Stugel (http://www.graph64.miesto.sk      ##
  ## This unit is free. If you need something mail me:   pstugel@pobox.sk   ##
  ##                                                                        ##
  ##                                                                        ##
  ############################################################################

  --------
  History:
  --------

  11.08.2000 - Complety new code (from DirectX 7 examples)
  05.04.2000 - Added support for exotic color resolutions... :-) (or corrected big bug)
  xx.xx.xxxx - Xxxxx xxxxxxx xx xxxx xxxx.  
}

Unit Direct64;

interface

uses
  Windows,
  Messages,
  DirectDraw,
  SysUtils;

var
  boTerminate       : Boolean = False;
  applicationActive : Boolean = False;             // Is application active?
    
  h_Wnd : HWND;
  function DxInitAll( Xsize, Ysize, bpp: longint;var RBit,GBit,BBit: cardinal; var RStart,GStart,BStart: byte): THandle;
  procedure DxDoneAll;
  procedure DxRefresh;
  procedure DxUnlock;
  procedure Operate;
  function  DxLock: pointer;

implementation

const
  //---------------------------------------------------------------------------
  // Local definitions
  //---------------------------------------------------------------------------
  TITLE : PChar = '';
  NAME  : PChar = 'Graph64 engine';
  //---------------------------------------------------------------------------
  // Default settings
  //---------------------------------------------------------------------------
  TIMER_ID   = 1;
  TIMER_RATE = 500;

var
  //---2------------------------------------------------------------------------
  // Global data
  //---------------------------------------------------------------------------
  DDraw         : IDirectDraw7;                // DirectDraw object
  PrimaryBuffer : IDirectDrawSurface7;         // DirectDraw primary surface
  BackBuffer    : IDirectDrawSurface7;         // DirectDraw back surface
//  g_pDDPal      : IDIRECTDRAWPALETTE;          // The primary surface palette


  ddsd :    TDDSurfaceDesc2;
  ddscaps : TDDSCaps2;
//-----------------------------------------------------------------------------
// Name: ReleaseAllObjects
// Desc: Finished with all objects we use; release them
//-----------------------------------------------------------------------------
procedure DxDoneAll;
begin
  if Assigned(DDraw) then
    begin
      if Assigned(BackBuffer) then
        begin
          BackBuffer:= nil;
        end;
      if Assigned(PrimaryBuffer) then
        begin
          PrimaryBuffer:= nil;
        end;
{      if Assigned(g_pDDPal) then
        begin
          g_pDDPal := nil;
        end;
      g_pDD := nil;
}
    end;
end;

function IsLost : Boolean;
var DDRVAL : HRESULT;
begin
  DDRVAL := PrimaryBuffer.IsLost;
  if DDRVAL <> 0 then begin
    Result := True;
    boTerminate := Result;
  end else
    Result := False;
end;

//-----------------------------------------------------------------------------
// Name: InitFail
// Desc: This function is called if an initialization function fails
//-----------------------------------------------------------------------------
function InitFail(h_Wnd : HWND; hRet : HRESULT; Text : string) : HRESULT;
begin
  DxDoneAll;
  MessageBox(h_Wnd, PChar(Text + ': ' + DDErrorString(hRet)), TITLE, MB_OK);
  DestroyWindow(h_Wnd);
  Result := hRet;
end;

//-----------------------------------------------------------------------------
// Name: UpdateFrame
// Desc: Displays the proper text for the page
//-----------------------------------------------------------------------------
var
  phase : Boolean = False;

procedure UpdateFrame(h_Wnd : HWND);
var
  h_DC    : HDC;
  rc      : TRect;
  size    : TSize;
begin
(*
  // The back buffer already has a loaded bitmap, so don't clear it
  if BackBuffer.GetDC(h_DC) = DD_OK then
    begin
      SetBkColor(h_DC, RGB(0, 0, 255));
      SetTextColor(h_DC, RGB(255, 255, 0));
      if phase then
        begin
          GetClientRect(h_Wnd, rc);
          GetTextExtentPoint(h_DC, szMsg, StrLen(szMsg), size);
          TextOut(h_DC, (rc.right - size.cx) div 2, (rc.bottom - size.cy) div 2, szMsg, StrLen(szMsg));
          TextOut(h_DC, 0, 0, szFrontMsg, StrLen(szFrontMsg));
          phase := False;
        end
      else
        begin
          TextOut(h_DC, 0, 0, szBackMsg, StrLen(szBackMsg));
          phase := True;
        end;
      g_pDDSBack.ReleaseDC(h_DC);
    end;
*)
end;

//-----------------------------------------------------------------------------
// Name: WindowProc
// Desc: The Main Window Procedure
//-----------------------------------------------------------------------------
function WindowProc(h_Wnd: HWND; aMSG: Cardinal; wParam: Cardinal; lParam: Integer) : Integer; stdcall;
var
  hRet : HRESULT;
begin
  case aMSG of
    // Pause if minimized
    WM_ACTIVATE:
      begin
        if HIWORD(wParam) = 0 then
          applicationActive := True
        else
          applicationActive:= False;
        Result := 0;
        Exit;
      end;
    // Clean up and close the app
    WM_DESTROY:
      begin
        DxDoneAll;
        PostQuitMessage(0);
        Result := 0;
        Exit;
      end;
    // Handle any non-accelerated key commands
    WM_KEYDOWN:
      begin
        case wParam of
//          VK_ESCAPE,
          VK_F12:
            begin
              PostMessage(h_Wnd, WM_CLOSE, 0, 0);
              Result := 0;
              Exit;
            end;
        end;
      end;
    // Turn off the cursor since this is a full-screen app
    WM_SETCURSOR:
      begin
        SetCursor(0);
        Result := 1;
        Exit;
      end;
    // Update and flip surfaces
{    WM_TIMER:
      begin
        if g_bActive and (TIMER_ID = wParam) then
          begin
            UpdateFrame(h_Wnd);
          end;
      end;}
    end;

  Result := DefWindowProc(h_Wnd, aMSG, wParam, lParam);
end;


procedure DxRefresh;
var hRet: HResult;
    aMSG : MSG;
begin

  while True do
    begin
      hRet := PrimaryBuffer.Flip(nil, 0);
      if hRet = DD_OK then
          Break;
        if hRet <> DDERR_WASSTILLDRAWING then
          Break;
    end;

{  GetMessage(aMSG, 0, 0, 0);
    begin
      TranslateMessage(aMSG);
      DispatchMessage(aMSG);
    end;}

end;

procedure DxUnlock;
begin
  BackBuffer. Unlock( nil);
end;

Function DxLock: pointer;
var res: HResult;
begin
  Res := BackBuffer.Lock(nil, ddsd, DDLOCK_WAIT,0);
  if SUCCEEDED(Res) then
  begin
    Result := ddsd. lpSurface;
  end else result:= nil;
end;

//-----------------------------------------------------------------------------
// Name: WinMain
// Desc: Initialization, message loop
//-----------------------------------------------------------------------------
{$DEFINE debug}
function DxInitAll( Xsize, Ysize, bpp: longint;var RBit,GBit,BBit: cardinal; var RStart,GStart,BStart: byte): THandle;

var
  aMSG : MSG;
  hInst: THandle;
  nCmdShow: Integer;
  wc : WNDCLASS;
  hRet : HRESULT;
  pixelformat: TDDPixelFormat;
  {$IFDEF debug}
    f: TextFile;
  {$ENDIF}  
  function DecodeColorStart( color: word): byte;
  var
    st: byte;
    col: word;
  begin
    result:= 0; col:= color;
    while (col and 1=0)and(result<24) do begin col:= (col shr 1);inc( result);end;
   end;

begin
  hInst:= GetModuleHandle( nil);
  nCmdShow:= SW_SHow;
  // Set up and register window class
  wc.style := CS_HREDRAW or CS_VREDRAW;
  wc.lpfnWndProc := @WindowProc;
  wc.cbClsExtra := 0;
  wc.cbWndExtra := 0;
  wc.hInstance := hInst;
  wc.hIcon := LoadIcon(hInst, 'MAINICON');
  wc.hCursor := LoadCursor(0, IDC_ARROW);
  wc.hbrBackground := GetStockObject(BLACK_BRUSH);
  wc.lpszMenuName := NAME;
  wc.lpszClassName := NAME;
  RegisterClass(wc);

  // Create a window
  h_Wnd := CreateWindowEx(WS_EX_TOPMOST,
                          NAME,
                          TITLE,
                          WS_POPUP,
                          0,
                          0,
                          GetSystemMetrics(SM_CXSCREEN),
                          GetSystemMetrics(SM_CYSCREEN),
                          0,
                          0,
                          hInst,
                          nil);

  if h_Wnd = 0 then
    begin
      Result := 0;
      Exit;
    end;

  ShowWindow(h_Wnd, nCmdShow);
  UpdateWindow(h_Wnd);
  SetFocus(h_Wnd);

  ///////////////////////////////////////////////////////////////////////////
  // Create the main DirectDraw object
  ///////////////////////////////////////////////////////////////////////////
  hRet := DirectDrawCreateEx(nil, DDraw, IDirectDraw7, nil);
  if hRet <> DD_OK then
    begin
      Result := InitFail(h_Wnd, hRet, 'DirectDrawCreateEx FAILED');
      Exit;
    end;

  // Get exclusive mode
  hRet := DDraw.SetCooperativeLevel(h_Wnd, DDSCL_EXCLUSIVE or DDSCL_FULLSCREEN);
  if hRet <> DD_OK then
    begin
      Result := InitFail(h_Wnd, hRet, 'SetCooperativeLevel FAILED');
      Exit;
    end;

  // Set fullscreen video mode
  hRet := DDraw.SetDisplayMode(Xsize, YSize, bpp, 0, 0);
  if hRet <> DD_OK then
    begin
      Result := InitFail(h_Wnd, hRet, 'SetDisplayMode FAILED');
      Exit;
    end;

  // Create the primary surface with 1 back buffer
  FillChar(ddsd, SizeOf(ddsd), 0);
  ddsd.dwSize := SizeOf(ddsd);
  ddsd.dwFlags := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
  ddsd.ddsCaps.dwCaps := DDSCAPS_PRIMARYSURFACE or DDSCAPS_FLIP or DDSCAPS_COMPLEX or  DDSCAPS_SYSTEMMEMORY;
  ddsd.dwBackBufferCount := 1;
  hRet := DDraw.CreateSurface(ddsd, PrimaryBuffer, nil);
  if hRet <> DD_OK then
    begin
      Result := InitFail(h_Wnd, hRet, 'CreateSurface FAILED');
      Exit;
    end;

  // Get a pointer to the back buffer
  FillChar(ddscaps, SizeOf(ddscaps), 0);
  ddscaps.dwCaps := DDSCAPS_BACKBUFFER;
  hRet := PrimaryBuffer.GetAttachedSurface(ddscaps, BackBuffer);
  if hRet <> DD_OK then
    begin
      Result := InitFail(h_Wnd, hRet, 'GetAttachedSurface FAILED');
      Exit;
    end;

  // Create and set the palette
(*  g_pDDPal := DDLoadPalette(g_pDD, szBackground);
  if g_pDDPal = nil then
    begin
      Result := InitFail(h_Wnd, hRet, 'DDLoadPalette FAILED');
      Exit;
    end;

  hRet := g_pDDSPrimary.SetPalette(g_pDDPal);
  if hRet <> DD_OK then
    begin
      Result := InitFail(h_Wnd, hRet, 'SetPalette FAILED');
      Exit;
    end;
*)
  // Load a bitmap into the back buffer.

{  hRet := DDReLoadBitmap(g_pDDSBack, szBackground);
  if hRet <> DD_OK then
    begin
      Result := InitFail(h_Wnd, hRet, 'DDReLoadBitmap FAILED');
      Exit;
    end;
}

  FillChar(PixelFormat, SizeOf(PixelFormat), 0);
  PixelFormat.dwSize := SizeOf(PixelFormat);
  BackBuffer. GetPixelFormat(PixelFormat);

  {********only for internal********}
  {$IFDEF debug}
   assignFile( f, 'dxstuff.report');
   rewrite( f);
   With pixelformat do
    begin
     Writeln( f, 'Pixel format =', dwRGBBitCount);
     Writeln( f, 'Size =', dwSize);


     Writeln( f, 'XSize =',  ddsd.dwLinearSize);
     Writeln( f, 'YSize =', Ysize);
     Writeln( f, 'dwRBitMask =', dwRBitMask);
     Writeln( f, 'dwGBitMask =', dwGBitMask);
     Writeln( f, 'dwBBitMask =', dwBBitMask);
     Writeln( f, 'dwRGBAlphaBitMask =',  dwRGBAlphaBitMask);
//     DecodeTime( now, hour, min,sec,dummy);
//     Writeln( f, hour,':',min,':',sec);
    end;
   CloseFile( f);
  {$ENDIF}

with pixelformat do
begin
 RBit:= dwRBitMask;
 GBit:= dwGBitMask;
 BBit:= dwBBitMask;

 RStart:= DecodeColorStart( RBit);
 GStart:= DecodeColorStart( GBit);
 BStart:= DecodeColorStart( BBIt);
end;


  // Create a timer to flip the pages
{  if TIMER_ID <> SetTimer(h_Wnd, TIMER_ID, TIMER_RATE, nil) then
    begin
      Result := InitFail(h_Wnd, hRet, 'SetTimer FAILED');
      Exit;
    end;}
        SetCursor(0);
  Result := DD_OK;
end;

procedure Operate;
var  aMSG : MSG;

begin

{  while} GetMessage(aMSG, 0, 0, 0);// do
    begin
      TranslateMessage(aMSG);
      DispatchMessage(aMSG);
    end;

end;

end.

