unit Unit1;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  Graph64,
  Jpeg, ComCtrls, ExtCtrls, Spin;

const DefaultPixelFormat: TPixelFormat = pf15bit;

type
  TMyLine= record
    FontSize,
    StartX: Integer;
    Text: String;
  end;

const Lines:array[0..5] of TMyLine=(
  (FontSize:24;StartX:10;Text:'Graph64 example'),
  (FontSize:8;StartX:150;Text:'(c) Pavol Stugel 2000,'),
  (FontSize:12;StartX:100;Text:'This only simple example how to work with Graph64 under GDI'),
  (FontSize:50;StartX:100;Text:' '),
  (FontSize:12;StartX:50;Text:'You can add some features like loading/saving to file or GIF animations'),
  (FontSize:12;StartX:10;Text:'Visit my homepage: http://graph64.home.sk or http://www.graph64.miesto.sk')
  );

   LightColor: TRGB=(b:255;g:255;r:255);
   BackgroundColor: TRGB=(b:0;g:0;r:0);
   FontColor: TRGB=( b:0;g:255;r:255);
   LineColor: TRGB=( b:0;g:0;r:255);


type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Timer1: TTimer;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    ColorDialog1: TColorDialog;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    CheckBox3: TCheckBox;
    Button9: TButton;
    FontDialog1: TFontDialog;
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
//    procedure WMEraseBkgnd(var m: TWMEraseBkgnd); message WM_ERASEBKGND;
    procedure UpdateMe;
  public
    { Public declarations }
    mx,my: Integer; //mouse coordinates
    FX: TBitmap64;
    Image1,Image2,
    Buffer: TScreen64;

    Tick: Integer;
    CurLine: Integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
{procedure TForm1.WMEraseBkgnd(var m : TWMEraseBkgnd); //flicker free
begin
  m.Result := LRESULT(False);
end;}

procedure TForm1.FormPaint(Sender: TObject);
begin
  Buffer.Refresh;
end;

procedure TForm1.UpdateMe;
var cx,cy: Integer;
begin
   Buffer.ClearSurface( Buffer.RGB( BackgroundColor.r, BackgroundColor.g, BackgroundColor.b){Buffer.RGB( 128,128,0)});

   //begin of rendering scroll text
   Image1.ClearSurface( Image1.TransparentColor);
   cy:= 0;

   Image1.BackBuffer.Canvas.Font.Color:= RGB( FontColor.r, FontColor.g, FontColor.b);   
   With Image1.BackBuffer.Canvas do
   for cx:= Low( Lines) to High( Lines) do
   begin
     Font.Size:= Lines[cx].FontSize;
     TextOut( Lines[cx].StartX,Buffer.Height-tick+cy, Lines[cx].Text);
     Inc( Cy, TextHeight( Lines[cx].Text));
   end;


   if CheckBox3.Checked then
     for cx:=  0 to Buffer.Height div 2 do
       // Tick mod 2 - this trick remove flickering effect while scrolling text :-)
       Buffer.LensHline(0, -1+(Tick mod 2)+cx*2, Buffer.Width+1, Buffer.RGB( LineColor.R, LineColor.G, LineColor.B));

   Buffer.DrawLens( 0,0, Image1);
          
   if CheckBox2.Checked then
     for cx:= 0 to SpinEdit1.Value do
       Buffer.LensPixels[random(Buffer.Width), Random(Buffer.Height)]:= $ffff;

   Buffer.DrawBlendRGB( mx-FX.Width div 2, my- FX.Height div 2,FX, LightColor.R /255, LightColor.G/255,LightColor.B/255);


   if CheckBox1.Checked then Buffer.DrawGrayscale(0,0, Buffer);

   Buffer.Refresh;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Buffer:= TScreen64.Create( PaintBox1.Canvas, PaintBox1.Width, PaintBox1.Height, DefaultPixelFormat);
  Image1:= TScreen64.Create( Buffer.Width, Buffer.Height, DefaultPixelFormat);
  Image2:= TScreen64.Create( Buffer.Width, Buffer.Height, DefaultPixelFormat);
  FX:= TBitmap64.Create(0,0, DefaultPixelFormat);
  FX.LoadFromTGAFile( 'fire2.tga');
  FX.DrawGrayscale(0,0, FX);

  Tick:= 0;
  with Image1.BackBuffer.Canvas do
  begin
    Brush.Color:= clAqua;
    Brush.Style:= bsClear;
    Font.Color:= RGB( FontColor.r, FontColor.g, FontColor.b);
    Font.Style:= [fsBold];
    Font.Size:= 16;
    Font.Name:= 'Arial';
  end;
  Image1.Transparent:= true;
  Image1.TransparentColor:= Image1.WinColor( clAqua);

  CheckBox2.Checked:= True;
  CheckBox2.OnClick(self);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Image2.Destroy;
  Image1.Destroy;
  Buffer.Destroy;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled:= false;
  try
    UpdateMe;
  finally
  end;
  if Button7.Enabled then Inc( Tick);
  Timer1.Enabled:= true;
end;

procedure TForm1.Button1Click(Sender: TObject);
var cl: TColor;
begin
  if ColorDialog1.Execute then
  begin
    cl:=  ColorDialog1.color;
    FontColor.R:= GetRValue( cl);
    FontColor.G:= GetGValue( cl);
    FontColor.B:= GetBValue( cl);
  end;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  Label1.Enabled:= CheckBox2.Checked;
  SpinEdit1.Enabled:= CheckBox2.Checked;
end;

procedure TForm1.PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  mx:= x;
  my:= y;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  Tick:= 0;
end;

procedure TForm1.Button2Click(Sender: TObject);
var cl: TColor;
begin
  if ColorDialog1.Execute then
  begin
    cl:=  ColorDialog1.color;
    BackgroundColor.R:= GetRValue( cl);
    BackgroundColor.G:= GetGValue( cl);
    BackgroundColor.B:= GetBValue( cl);
  end;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  Button7.Enabled:= false;
  Button8.Enabled:= true;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  Button7.Enabled:= True;
  Button8.Enabled:= false;
end;

procedure TForm1.Button3Click(Sender: TObject);
var cl: TColor;
begin
  if ColorDialog1.Execute then
  begin
    cl:=  ColorDialog1.color;
    LightColor.R:= GetRValue( cl);
    LightColor.G:= GetGValue( cl);
    LightColor.B:= GetBValue( cl);
  end;

end;

procedure TForm1.Button9Click(Sender: TObject);
var cl: TColor;
begin
  if ColorDialog1.Execute then
  begin
    cl:=  ColorDialog1.color;
    LineColor.R:= GetRValue( cl);
    LineColor.G:= GetGValue( cl);
    LineColor.B:= GetBValue( cl);
  end;

end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  if FontDialog1.Execute then
  begin
    Image1.BackBuffer.Canvas.Font:= FontDialog1.Font;
  end
end;

end.

