unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Graph64, ExtCtrls, StdCtrls, Jpeg, Spin;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    SpinEdit1: TSpinEdit;
    Button6: TButton;
    procedure FormCreate(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    procedure RenderText;
    { Public declarations }
  end;

var
  Form1: TForm1;
  DefaultPixelFormat: TPixelFormat=pf15bit;
  Scr,
  TxtBuffer,
  Image: TScreen64;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  jpg:TJpegImage;
  bmp:TBitmap64;

begin
  {set handler into PainBox1}
  Scr:= TScreen64.Create( PaintBox1.Canvas, PaintBox1.Width,PaintBox1.Height, DefaultPixelFormat);
//  jpg:= TJpegImage.Create;
  bmp:= TBitmap64.Create(0,0, DefaultPixelFormat);
  try
//    jpg.LoadFromFile('test3.jpg');  //here is example how to load Jpeg image into TBitamp64
    bmp.LoadFromBMPFile('plant.bmp');
    Image:= TScreen64.Create( bmp.Width, bmp.Height, DefaultPixelFormat);
    TxtBuffer:= TScreen64.Create( Scr.Width, Scr.Height, DefaultPixelFormat);
    Image.Draw(0,0, bmp);
    Image.Transparent:= true;
    Image.TransparentColor:= Image.Pixels[0,0];


  finally
    bmp.Destroy;
//    jpg.Free;
  end;
  RenderText;
end;

procedure TForm1.RenderText;
begin

  Scr.ClearSurface( Scr.WinColor(clBlack));
  Scr.Draw(0,0, Image);
  TxtBuffer.ClearSurface(0);
  TxtBuffer.Transparent:= True;
  TxtBuffer.TransparentColor:= 0;
  with TxtBuffer.BackBuffer.canvas do
  begin
    font.Color:= clWhite;
    font.Name:='Arial';
    brush.style:= bsClear;
    font.Size:=40;
    TextOut(0,0, Edit1.Text);
  end;
  
  Scr.DrawLens(0,0,TxtBuffer);

  Scr.Refresh;
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
  Scr.Refresh;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  RenderText;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Scr.DrawGrayScale(0,0, Scr);
  Scr.Refresh;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Scr.SwapRGB;
  Scr.Refresh;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Scr.Antialiasing2;
  Scr.Refresh;
end;

procedure TForm1.Button4Click(Sender: TObject);
var xx,yy:Integer;
begin

  for yy:= 0 to 5 do
    for xx:= 0 to 8 do
      Scr.DrawColorize(xx*50,10+yy*50, Image, random(2){Red factor [0,1]}, random(2){Green factor [0,1]}, random(2){Blue factor [0,1]}, random(10){light [1..10]});

  Scr.Refresh;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  RenderText;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  Scr.DrawColorize(0,0, Scr, 1,1,1, SpinEdit1.value);
  Scr.Refresh;
end;

end.
