unit Unit1;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  Graph64,  
  Jpeg, ComCtrls;

const DefaultPixelFormat: TPixelFormat = pf15bit;

type
  TForm1 = class(TForm)
    ScrollBar1: TScrollBar;
    CheckBox1: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ScrollBar1Change(Sender: TObject);
  private
    { Private declarations }
    procedure WMEraseBkgnd(var m: TWMEraseBkgnd); message WM_ERASEBKGND;
    procedure UpdateMe;
  public
    { Public declarations }
    mx,my: Integer; //mouse coordinates
    Image1,
    LogoImage: TBitmap64;
    Image2,Buffer: TScreen64;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
procedure TForm1.WMEraseBkgnd(var m : TWMEraseBkgnd); //flicker free
begin
  m.Result := LRESULT(False);
end;

procedure TForm1.FormCreate(Sender: TObject);
var xx: integer;
    jpg: TJpegImage;
begin
  Jpg:= TJpegImage.Create;
  Jpg.LoadFromFile('dog.jpg'); //example of loading JPG file
  ClientWidth:= Jpg.Width;
  ClientHeight:= Jpg.Height;

  try
    Image2:= TScreen64.Create(Jpg.Width,Jpg.Height, DefaultPixelFormat);
    Image2.BackBuffer.Canvas.Draw(0,0, Jpg);
  finally
    Jpg.Free;
  end;

  Buffer:= TScreen64.Create(Image2.Width,Image2.Height,DefaultPixelFormat);
  Buffer.ClearSurface( Buffer.WinColor( clBlack));

  LogoImage:= TBitmap64.Create(0,0, DefaultPixelFormat);
  LogoImage.LoadFromTGAFile('g64logo.tga');

  Image1:= TBitmap64.Create(0,0, DefaultPixelFormat);
  Image1.LoadFromTGAFile('fire2.tga');  //this is not fastest because image is too large and can't be stored in L1 cache in CPU
  Image1.DrawGrayscale(0,0, Image1); //convert image into grayscale
  Image2.DrawBlendRGB( -128,-128, Image1,1,1,1);
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  Canvas.Draw(0,0, Buffer.BackBuffer);
end;

procedure TForm1.UpdateMe;
var cx,cy: Integer;
begin

   //compute center coordinates first
   cx:= Image1.Width div 2;
   cy:= Image1.Height div 2;

   //draw background image
   Buffer.Draw(0,0, Image2);
   
   //draw blended image on background image
   Buffer.DrawBlend(20,20, LogoImage,1- ScrollBar1.Position / 100, ScrollBar1.Position/100);

   //draw flares
   Buffer.DrawBlendRGB( mx- cx, my - cy, Image1,1,1,1);
   Buffer.DrawBlendRGB( my- cx, mx - cy, Image1,1,1,0.5);
   Buffer.DrawBlendRGB( my + mx  - cx, mx - cy, Image1,0,1,1);



   if CheckBox1.Checked then Buffer.DrawColorize(0,0, Buffer, 1,1,1,1);
   Paint; //repaint form
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  mx:= x;
  my:= y;
  UpdateMe;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  UpdateMe;
end;

end.

