unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, winsock,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

procedure GetIPList(const List: TStrings);
var
  WSAData: TWSAData;
  HostName: array[0..255] of Char;
  HostInfo: PHostEnt;
  InAddr: ^PInAddr;
begin
  List.Clear;
  if WSAStartup($0101, WSAData) = 0 then
  try
    if gethostname(HostName, SizeOf(HostName)) = 0 then
    begin
      HostInfo := gethostbyname(HostName);
      if HostInfo <> nil then
      begin
        InAddr := Pointer(HostInfo^.h_addr_list);
        if (InAddr <> nil) then
          while InAddr^ <> nil do
          begin
            List.Add(inet_ntoa(InAddr^^));
            Inc(InAddr);
          end;
      end;
    end;
  finally
    WSACleanup;
  end;
end;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
        GetIpList (Memo1.Lines);
end;

end.
