unit FIBKillerBDE;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   DB,DbTables,pFIBDataSet,FIBDataSet,FIBDatabase,pFIBQuery ;

type
  TFIBKillerBDE = class(TComponent)
  private
    FFIBDatabase   :TFIBDatabase;
    FFIBTransaction:TFIBTransaction;
    function GetDatabase: TFIBDatabase;
    procedure SetFIBDatabase(Value: TFIBDatabase);
    function  GetTransaction: TFIBTransaction;
    procedure SetTransaction(Value:TFIBTransaction );
  protected
    procedure Notification(AComponent: TComponent;  Operation: TOperation); override;
    procedure AssignEvents(DataSet:TFIBDataSet;MustDie:TBDEDataSet);
    procedure MoveFields(vDataSet:TFIBDataSet;MustDie:TBDEDataSet);
  public
    procedure  KillBDE;
    procedure  AfterCreateFibComp(MustDie:TBDEDataSet;FIBcmp:TComponent); virtual;
    procedure  CreateFibComp(MustDie:TBDEDataSet);
  published
    property FIBDatabase:TFIBDatabase  read GetDatabase write SetFIBDatabase;
    property FIBTransaction:TFIBTransaction  read GetTransaction write SetTransaction;
  end;

procedure Register;

implementation

uses dsgnintf;

function TFIBKillerBDE.GetDatabase: TFIBDatabase;
begin
  Result := FFIBDatabase;
end;

procedure TFIBKillerBDE.SetFIBDatabase(Value: TFIBDatabase);
begin
  FFIBDatabase:=Value;
  if Value<>nil then Value.FreeNotification(Self)
end;

function  TFIBKillerBDE.GetTransaction: TFIBTransaction;
begin
 Result :=FFIBTransaction;
end;

procedure TFIBKillerBDE.SetTransaction(Value:TFIBTransaction );
begin
 FFIBTransaction:=Value;
 if Value<>nil then Value.FreeNotification(Self);
end;

procedure TFIBKillerBDE.Notification(AComponent: TComponent;  Operation: TOperation);
begin
 if  Operation=opRemove then begin
  if AComponent=FFIBDatabase then FFIBDatabase:=nil;
 end;
 inherited Notification(AComponent,Operation)
end;



procedure TFIBKillerBDE.AssignEvents(DataSet:TFIBDataSet;MustDie:TBDEDataSet);
begin
 with MustDie do begin
   DataSet.BeforeOpen :=BeforeOpen;
   DataSet.AfterOpen  :=AfterOpen ;
   DataSet.BeforeClose:=BeforeClose;
   DataSet.AfterClose :=AfterClose;
   DataSet.BeforeInsert:=BeforeInsert;
   DataSet.AfterInsert :=AfterInsert ;
   DataSet.BeforeEdit  :=BeforeEdit  ;
   DataSet.AfterEdit   :=AfterEdit   ;
   DataSet.BeforePost  :=BeforePost  ;
   DataSet.AfterPost   :=AfterPost   ;
   DataSet.BeforeCancel:=BeforeCancel;
   DataSet.AfterCancel :=AfterCancel ;
   DataSet.BeforeDelete:=BeforeDelete;
   DataSet.AfterDelete :=AfterDelete ;
   DataSet.BeforeScroll:=BeforeScroll;
   DataSet.AfterScroll :=AfterScroll;
   DataSet.OnCalcFields  :=OnCalcFields  ;
   DataSet.OnDeleteError :=OnDeleteError ;
   DataSet.OnEditError   :=OnEditError   ;
   DataSet.OnFilterRecord:=OnFilterRecord;
   DataSet.OnNewRecord   :=OnNewRecord   ;
   DataSet.OnPostError   :=OnPostError   ;
//Clear 
    BeforeOpen:=nil;
    AfterOpen :=nil;
    BeforeClose:=nil;
    AfterClose :=nil;
    BeforeInsert:=nil;
    AfterInsert :=nil;
    BeforeEdit  :=nil;
    AfterEdit   :=nil;
    BeforePost  :=nil;
    AfterPost   :=nil;
    BeforeCancel:=nil;
    AfterCancel :=nil;
    BeforeDelete:=nil;
    AfterDelete :=nil;
    BeforeScroll:=nil;
    AfterScroll :=nil;
    OnCalcFields :=nil;
    OnDeleteError:=nil;
    OnEditError   :=nil;
    OnFilterRecord:=nil;
    OnNewRecord:=nil;
    OnPostError:=nil;
 end;
end;

procedure TFIBKillerBDE.MoveFields(vDataSet:TFIBDataSet;MustDie:TBDEDataSet);
begin
 if MustDie.DefaultFields then Exit;
 with MustDie do
  while FieldCount>0 do begin
    Fields[0].DataSet:=vDataSet
  end;
end;

procedure  TFIBKillerBDE.AfterCreateFibComp(MustDie:TBDEDataSet;FIBcmp:TComponent);
begin
 // for override 
end;

procedure  TFIBKillerBDE.CreateFibComp(MustDie:TBDEDataSet);
var vDataSet :TpFIBDataSet;
    vQuery   :TpFIBQuery;
    isDataSet:boolean;
    L,i:integer;
    SpPars :string;
begin
 with MustDie do begin
  if MustDie is TQuery then begin
   isDataSet:=Copy(UpperCase(Trim((MustDie as TQuery).SQL.Text)),1,6)='SELECT';
  end
  else isDataSet:=MustDie is TTable;
  MustDie.Close;
  if isDataSet then begin
   vDataSet:=TpFIBDataSet.Create(Owner);
   vDataSet.DesignInfo:=DesignInfo;
   MustDie.Owner.RemoveComponent( vDataSet );
   MustDie.Owner.InsertComponent( vDataSet );
   vDataSet.DataBase   :=FFIBDatabase ;
   vDataSet.Transaction:=FFIBTransaction;
   if MustDie is TQuery then vDataSet.SelectSQL:=(MustDie as TQuery).SQL
   else
    if MustDie is TTable then
     vDataSet.SelectSQL.Text:='SELECT * FROM '+ TTable(MustDie).TableName;
   with vDataSet.SelectSQL do
    for i := 0 to Pred(Count) do
    begin
     SpPars := Strings[i];
     repeat
      L := Pos(':',SpPars);
      if L = 0 then break;
      SpPars[L] := '?';
     until False;
     Strings[i] := SpPars;
    end;
   AssignEvents(vDataSet,MustDie);
   MoveFields  (vDataSet,MustDie);
   vDataSet.DataSource:=DataSource;
   vDataSet.CachedUpdates:=CachedUpdates;
   Name:='Die_'+Name;
   vDataSet.Name:=Copy(Name,5,1000);
   L:=Length(vDataSet.Name);
   with vDataSet do
     for i:=0 to Pred(FieldCount) do begin
       Fields[i].Name:=Copy(Fields[i].Name,L+1,1000);
     end;
   if Assigned(UpdateObject) then
    if (UpdateObject is TUpdateSQL) then
    with (UpdateObject as TUpdateSQL) do    begin
     vDataSet.UpdateSQL:=ModifySQL;
     vDataSet.InsertSQL:=InsertSQL;
     vDataSet.DeleteSQL:=DeleteSQL;
    end;
   AfterCreateFibComp(MustDie,vDataSet);
  end //isDataset End
  else begin
   vDataSet:=nil;
   vQuery   :=TpFIBQuery.Create(Owner);
   vQuery.DesignInfo := DesignInfo;
   MustDie.Owner.RemoveComponent( vQuery );
   MustDie.Owner.InsertComponent( vQuery );
   vQuery.DataBase   :=FFIBDatabase ;
   vQuery.Transaction:=FFIBTransaction;
   MustDie.Name:='Die_'+Name;
   vQuery.Name:=Copy(MustDie.Name,5,1000);
   if MustDie is TQuery then vQuery.SQL.Text:=(MustDie as TQuery).SQL.Text
   else
   if MustDie is TStoredProc then
   with  (MustDie as TStoredProc) do   begin
     vQuery.SQL.Text:='EXECUTE PROCEDURE '+StoredProcName;
     if ParamCount=0 then Prepare;
     if ParamCount>0 then begin
      SpPars :='';
      for i:=0 to Pred(ParamCount) do
       if Params[i].ParamType=ptInput then SpPars :=SpPars+'?'+Params[i].Name+',';
      if SpPars<>'' then SpPars :='('+Copy(SpPars,1,Length(SpPars)-1)+')';
      vQuery.SQL.Text:=vQuery.SQL.Text+SpPars;
     end;
   end;
   AfterCreateFibComp(MustDie,vQuery);
  end;

  if vDataSet <> nil then
   with MustDie.Owner do
   begin
    for i := 0 to Pred(ComponentCount) do
     if (Components[i] is TDataSource) and
        ((Components[i] as TDataSource).DataSet = MustDie) then
      (Components[i] as TDataSource).DataSet := vDataSet;
   end;
 end;
end;
       
procedure  TFIBKillerBDE.KillBDE;
var i:integer;
begin
 if not Assigned(FIBDatabase) then raise Exception.Create('Database not assigned');
 if not Assigned(FIBTransaction) then raise Exception.Create('Transaction not assigned'); 

 with Owner do begin
  for i:=0 to Pred(ComponentCount)  do
   if Components[i] is TBDEDataSet then
    CreateFibComp(Components[i] as TBDEDataSet);
  i:=0;
  
 while i<ComponentCount  do begin
   if (Components[i] is TBDEDataSet) or (Components[i] is TUpdateSQL) then
    Components[i].Free
   else
   Inc(i)
 end;
end;
end;

type
  TFIBKillBDE = class(TComponentEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;      

  function TFIBKillBDE.GetVerbCount: Integer;
  begin
   Result:=1;
  end;

  function TFIBKillBDE.GetVerb(Index: Integer): string;
  begin
    Result := 'Kill BDE components!!!';
  end;

  procedure TFIBKillBDE.ExecuteVerb(Index: Integer);
  begin
    TFIBKillerBDE(Component).KillBDE;
  end;

procedure Register;
begin
  RegisterComponents('FIBPlus', [TFIBKillerBDE]);
  RegisterComponentEditor(TFIBKillerBDE, TFIBKillBDE);
end;

end.


