unit pFIBProps;

interface

 uses Classes,SysUtils;

type

  TFormatFields = class(TPersistent)
  private
     FDisplayFormatDateTime:string;
     FDisplayFormatDate:string;
     FDisplayFormatTime:string;
     FDisplayFormatNumeric :string;
     FEditFormatNumeric    :string;
    function StoreDfDt:boolean;
    function StoreDfN:boolean;
    function StoreEfN:boolean;
    function StoreDfD:boolean;
    function StoreDfT:boolean;        
  public
   constructor Create;
  published
    property DateTimeDisplayFormat:string read FDisplayFormatDateTime
                                   write FDisplayFormatDateTime  stored  StoreDfDt ;
    property NumericDisplayFormat :string read FDisplayFormatNumeric
                                   write FDisplayFormatNumeric   stored  StoreDfN ;
    property NumericEditFormat    :string read FEditFormatNumeric
                                   write FEditFormatNumeric     stored  StoreEfN ;
    property DisplayFormatDate:string read FDisplayFormatDate
                               write FDisplayFormatDate  stored StoreDfD;
    property DisplayFormatTime:string read FDisplayFormatTime
                               write FDisplayFormatTime stored StoreDfT;
  end;

  TAutoUpdateOptions= class (TPersistent)
  private
   FOwner     :Tcomponent;
   FUpdateTableName:string;
   FKeyFields      :string; //  
   FAutoReWriteSqls:boolean; // UpdateSQL?
   FGeneratorName :string; // 
   FSelectGenID:boolean;//  
   FGenBeforePost:boolean;//   Post,  OnNewRecord
   procedure SetUpdateTableName(Value:string);
  protected

  public
   constructor Create(Owner:TComponent);
   property Owner:Tcomponent  read    FOwner     ;
  published
   property    UpdateTableName:string  read  FUpdateTableName write SetUpdateTableName;
   property    KeyFields  :string read  FKeyFields write FKeyFields;
   property    AutoReWriteSqls:boolean read  FAutoReWriteSqls write FAutoReWriteSqls default false;

   property    GeneratorName :string read FGeneratorName write FGeneratorName;
   property    SelectGenID:boolean read FSelectGenID write FSelectGenID default false;
   property    GenBeforePost:boolean read FGenBeforePost write FGenBeforePost default true;

  end;

implementation


constructor TAutoUpdateOptions.Create;
begin
 inherited Create;
 FOwner:=Owner;
 FGeneratorName :='';
 FSelectGenID:=false;
 FGenBeforePost:=true;
end;

procedure TAutoUpdateOptions.SetUpdateTableName(Value:string);
begin
 FUpdateTableName:=AnsiUpperCase(Value);
 if FGeneratorName='' then
  FGeneratorName:='GEN_'+FUpdateTableName
end;



// TFormatFields
constructor TFormatFields.Create;
begin
 FDisplayFormatDateTime:='dd.mm.yyyy';
 FDisplayFormatNumeric :='#,###0.' ;
 FEditFormatNumeric    :='0.';
 FDisplayFormatDate:='dd.mm.yyyy';
 FDisplayFormatTime:='00:00';
end;

function TFormatFields.StoreDfT:boolean;
begin
 Result:= FDisplayFormatTime<>'00:00';
end;

function TFormatFields.StoreDfD:boolean;
begin
 Result:= FDisplayFormatDate<>'dd.mm.yyyy';
end;

function TFormatFields.StoreDfDt:boolean;
begin
 Result:= FDisplayFormatDateTime<>'dd.mm.yyyy';
end;

function TFormatFields.StoreDfN:boolean;
begin
 Result:= FDisplayFormatNumeric <>'#,###0.' ;
end;

function TFormatFields.StoreEfN:boolean;
begin
 Result:= FEditFormatNumeric<>'0.';
end;

end.
