{*******************************************************}
{                                                       }
{ This unit based on  StrUtils.pas from RX Library      }
{ and SoWldStr.pas from SOHOLIB                         }
{                                                       }
{*******************************************************}

unit StrUtil;

interface
 uses SysUtils,Classes;

type
 TCharSet= Set of Char;
 
const
     CLRF=#13#10;
 // from RX
function MakeStr(C: Char; N: Integer): string;
function StrAsFloat(S:string):double;
function ReplaceStr(const S, Srch, Replace: string): string;
function ReplaceCIStr(const S, Srch, Replace: string): string;

function ExtractWord(Num:integer;const Str: string;const  WordDelims:TCharSet):string;
function ExtractLastWord(const Str: string;const  WordDelims:TCharSet):string;
function WordCount(const S: string; const WordDelims: TCharSet): Integer;
//from SOHOLIB
function WildStringCompare( FirstString,SecondString : string ) : boolean;
function WldIndexOf(ts:TStrings;const Value:string;CaseSensitive:boolean):integer;

//from Me 
function iifStr(Condition:boolean;const Str1,Str2:string ):string;
function iifVariant(Condition:boolean;const Var1,Var2:Variant ):Variant;
function StrOnMask(const StrIn, MaskIn, MaskOut: string):string;
function EasyLikeStr(Str1,Str2:string) :boolean; // Only Russian texts

function FormatIdentifierValue(Dialect: Integer; const Value: String): String;
function FormatIdentifier(Dialect: Integer; const Value: String): String;
function NeedQuote(const Name:string):boolean;
function EasyNeedQuote(const Name:string):boolean;
function PosCI(const Substr,Str:string):integer;

implementation

const
   NonQuotedChars=['A'..'Z','0'..'9', '_', '$','%','#'];
   
function FormatIdentifierValue(Dialect: Integer;const Value: String): String;
begin
  if Dialect = 1 then
    Result := AnsiUpperCase(Trim(Value))
  else
    Result := Value;
end;

function FormatIdentifier(Dialect: Integer;const Value: String): String;
begin
  if Dialect = 1 then
    Result := AnsiUpperCase(Trim(Value))
  else
  if NeedQuote(Value) then
    Result := '"'+Value+'"'
  else
    Result := Value
end;

function NeedQuote(const Name:string):boolean;
var i,l:integer;
begin
 Result:=Name[1]='"';
 if Result then Exit;
 Result:=false;
 l:=Length(Name);
 for i:=1 to l do begin
  Result:=not (Name[i] in NonQuotedChars);
  if Result then Exit;
 end;
end;


function EasyNeedQuote(const Name:string):boolean;
var i,l:integer;
begin
 Result:=Name[1]='"';
 if Result then Exit;
 Result:=false;
 l:=Length(Name);
 for i:=1 to l do begin
  Result:=not (Name[i] in NonQuotedChars+['a'..'z']);
  if Result then Exit;
 end;
end;

function PosCI(const Substr,Str:string):integer;
begin
 Result:=Pos(AnsiUpperCase(Substr),AnsiUpperCase(Str))
end;


function MakeStr(C: Char; N: Integer): string;
begin
  if N < 1 then Result := ''
  else begin
    SetLength(Result, N);
    FillChar(Result[1], Length(Result), C);
  end;
end;

function StrAsFloat(S:string):double;
begin
 S:=ReplaceStr(S, '.', DecimalSeparator);
 S:=ReplaceStr(S, ',', DecimalSeparator);
 Result:=StrToFloat(S)
end;

function ReplaceCIStr(const S, Srch, Replace: string): string;
var
  I: Integer;
  Source: string;
begin
  Source := S;
  Result := '';
  repeat
    I := Pos(AnsiUpperCase(Srch), AnsiUpperCase(Source));
    if I > 0 then begin
      Result := Result + Copy(Source, 1, I - 1) + Replace;
      Source := Copy(Source, I + Length(Srch), MaxInt);
    end
    else Result := Result + Source;
  until I <= 0;
end;

function ReplaceStr(const S, Srch, Replace: string): string;
var
  I: Integer;
  Source: string;
begin
  Source := S;
  Result := '';
  repeat
    I := Pos(Srch, Source);
    if I > 0 then begin
      Result := Result + Copy(Source, 1, I - 1) + Replace;
      Source := Copy(Source, I + Length(Srch), MaxInt);
    end
    else Result := Result + Source;
  until I <= 0;
end;



function ExtractWord(Num:integer;const Str: string;const  WordDelims:TCharSet):string;
var
  SLen, I: Cardinal;
  wc: Integer;
begin
  Result := '';
  I := 1; wc:=0;
  SLen := Length(Str);
  while I <= SLen do begin
    while (I <= SLen) and (Str[I] in WordDelims) do Inc(I);
    if I <= SLen then Inc(wc);
    if wc=Num then Break;
    while (I <= SLen) and not(Str[I] in WordDelims) do Inc(I);
  end;
  if (wc=0) and (Num=1) then Result:=Str
  else
  if wc<>0 then begin
     while (I <= SLen) and not (Str[I] in WordDelims) do begin
       Result:=Result+Str[I];
       Inc(I);
     end;
  end;
end;

function ExtractLastWord(const Str: string;const  WordDelims:TCharSet):string;
var
  SLen, I: Cardinal;
begin
  Result := '';
  SLen := Length(Str);
  for i:= SLen downTo 1 do begin
    if not(Str[I] in WordDelims) then
     Result := Str[I]+Result
    else
     Exit
  end;
end;

function WordCount(const S: string; const WordDelims: TCharSet): Integer;
var
  SLen, I: Cardinal;
begin
  Result := 0;
  I := 1;
  SLen := Length(S);
  while I <= SLen do begin
    while (I <= SLen) and (S[I] in WordDelims) do Inc(I);
    if I <= SLen then Inc(Result);
    while (I <= SLen) and not(S[I] in WordDelims) do Inc(I);
  end;
end;

function iifStr(Condition:boolean;const Str1,Str2:string ):string;
begin
 if Condition then Result:=Str1 else Result:=Str2
end;


function iifVariant(Condition:boolean;const Var1,Var2:Variant ):Variant;
begin
 if Condition then Result:=Var1 else Result:=Var2
end;



// WildStringCompare by Sergey Blinov

var Res : boolean;

function Identical (FLine,SLine : string) : boolean;
begin
  if (FLine = '*') or (SLine = '*') or (FLine=SLine) then Identical := true
  else Identical := false;
end;

function Different (FLine,SLine : string ) : boolean;
begin
  Different:=false;
  if (Length(FLine)>0) and (Length(SLine)>0) then begin
      if    (FLine[1]<>'*') and (SLine[1]<>'*')
        and (FLine[1]<>'?') and (SLine[1]<>'?')
        and (FLine[1]<>SLine[1]) then Different := true;
  end
  else begin
    if (Length(FLine)=0) and (SLine<>'*') then Different := true;
    if (Length(SLine)=0) and (FLine<>'*') then Different := true;
  end;
end;

function WildCompare (FLine,SLine : string) : boolean;
var k : integer;
begin
  if Identical(FLine,SLine) then begin
    WildCompare := true;
    exit;
  end;
  if Different(FLine,SLine) then begin
    WildCompare := false;
    exit;
  end;
  if (FLine[1]='*') then
   for k := 1 to Length(SLine) do
     if (SLine[k]='*') or (SLine[k]=FLine[2]) or (SLine[k]='?') then
       Res := Res or WildCompare(Copy(FLine,2,Length(FLine)-1),    Copy(SLine,k,Length(SLine)-k+1));

  if (SLine[1]='*') then
   for k := 1 to Length(FLine) do
    if (FLine[k]='*')or(FLine[k]=SLine[2])or(FLine[k]='?') then
       Res  := Res or WildCompare(Copy(FLine,k,Length(FLine)-k+1), Copy(SLine,2,Length(SLine)-1));

  if (FLine[1]<>'*') and (SLine[1]<>'*') and ((FLine[1] = SLine[1])
      or((FLine[1]='?') or (SLine[1]='?'))) then
       Res  := Res or WildCompare(Copy(FLine,2,Length(Fline)-1),   Copy(SLine,2,Length(SLine)-1));
  WildCompare := Res;
end;

function DoResultLine (TLine : string ) : string;
var i : integer;
begin
  i := 1;

  {for i := 1 to Length(TLine) do}
  while i<=length(TLine) do
   if (Copy(TLine,i,2)='**') or
      (Copy(TLine,i,2)='*?') or
      (Copy(TLine,i,2)='?*') then begin
         TLine := Copy(TLine,1,i-1)+'*'+Copy(TLine,i+2,Length(TLine)-i-1);
     {i := 0;}
      i := 0;
   end
   else inc(i);
  DoResultLine := TLine;
end;

function WildStringCompare( FirstString,SecondString : string ) : boolean;
begin
  Res               := false;
  FirstString       := DoResultLine(FirstString);
  SecondString      := DoResultLine(SecondString);
  WildStringCompare := WildCompare(FirstString,SecondString);
end;


//
function WldIndexOf(ts:TStrings;const Value:string;CaseSensitive:boolean):integer;
var i:integer;
begin
 Result:=-1;
 for i:=0 to Pred(ts.Count) do
  if WildStringCompare( iifStr(CaseSensitive, ts[i],AnsiUpperCase(ts[i])),
   iifStr(CaseSensitive, Value,AnsiUpperCase(Value))
  ) then begin
   Result:=i; Exit
  end;
end;

//


function StrOnMask(const StrIn, MaskIn, MaskOut: string):string;
var  k,j,len:integer;
begin
  len:=Length(StrIn);
  Result:='';
  for j:=1 to Len do begin
    k:=Pos(StrIn[j],MaskIn);
    if k = 0 then
     Result:=Result+StrIn[j]
    else
     if Length(MaskOut)>k then      Result:=Result+MaskOut[k]
  end;
end;

function EasyLikeStr( Str1,Str2:string) :boolean; // Only Russian texts

procedure DoSpoilString(var str:string);
const
 MaskSymbols=['A'..'Z','0'..'9',''..''];
 IgnoreSymbols=['',''];
var i:integer;
    bufStr:string;
    LastChar:char;
begin
 bufStr:='';
 lastChar:=#0;
 for i:=1 to Length(Str) do
  if     (Str[i] in MaskSymbols)
     and not (Str[i] in IgnoreSymbols)
     and (Str[i]<>LastChar)
   then   begin
    bufStr:=bufStr+Str[i];
    lastChar:=Str[i]
   end;
  Str:=StrOnMask(bufStr,'','E');
 // 
end;


begin
 Str1:=AnsiUpperCase(Str1); Str2:=AnsiUpperCase(Str2);
 if (Length(Str1)>8) and (Length(Str2)>8) then begin
 //  
  Str1:= StrOnMask(Str1,'','          ');
  Str2:= StrOnMask(Str2,'','          ');
 end;
 DoSpoilString(Str1); DoSpoilString(Str2);
 Result:=(Pos(Str2,Str1)>0) or (Pos(Str1,Str2)>0)
end;



end.



