unit SqlTxtRtns;

interface
 uses Windows,SysUtils,Classes,StrUtil;

const
   space='    ';
   ForceNewStr=#13#10+space;
   QuotMarks=#39;

 function DispositionFrom(const SQLText:string):TPoint;

 procedure AllTables(const SQLText:string;FTables:Tstrings);
 function  AddToWhereClause(SQLText,NewClause:string):string;
 function  GetWhereClause(SQLText:string;N:integer):string;
 function WhereCount(SQLText:string):integer; 
//
 function PrepareConstraint(Src:Tstrings):string;
 procedure DeleteEmptyStr(Src:Tstrings);

implementation

const
  BeginWhere =' WHERE ';

function RemoveSP(const FromStr:string):string;
var pBrIn,pBrOut:integer;
    cBrIn,cBrOut:integer;

begin
 Result:=FromStr;
 pBrIn:=Pos('(',Result);
 while pBrIn >0 do begin
  pBrOut:=pBrIn+1;
  cBrIn :=1;     cBrOut:=0;
  while (cBrOut<cBrIn)  do begin
   if Result[pBrOut]=')' then Inc(cBrOut)
   else
   if Result[pBrOut]='(' then Inc(cBrIn);
   Inc(pBrOut);
  end;
  while (pBrIn>1) and not (Result[pBrIn] in [',']) do Dec(pBrIn);
  while (pBrOut<=Length(Result)) and not (Result[pBrOut] in [',']) do Inc(pBrOut);
  Result:=Copy(Result,1,pBrIn-1) +Copy(Result,pBrOut,MaxInt);
  pBrIn:=Pos('(',Result);
 end;
end;

function RemoveJoins(const FromStr:string):string;
var pON,pComa,pJOIN:integer;
    tmpStr:string;
begin
 Result:=FromStr;
 pJOIN:=Pos(' JOIN ',Result);
 if pJOIN=0 then Exit;
 Result:=Copy(Result,1,pJOIN)+', '+Copy(Result,PJOIN+6,MaxInt);
 Result:=ReplaceStr(Result, ' LEFT ' , ' ');
 Result:=ReplaceStr(Result, ' RIGHT ', ' ');
 Result:=ReplaceStr(Result, ' FULL ' , ' ');
 Result:=ReplaceStr(Result, ' INNER ', ' ');
 Result:=ReplaceStr(Result, ' OUTER ', ' ');
 Result:=ReplaceStr(Result, ' JOIN ', ' , ');
 pON:=Pos(' ON ',Result);
 tmpStr:='';
 while pOn >0 do begin
  tmpStr:=Copy(Result,pOn+3,MaxInt);
  pComa:=Pos(',',tmpStr);
  if pComa>0 then
   Result:=Copy(Result,1,pOn-1)+Copy(tmpStr,pComa,MaxInt)
  else
   Result:=Copy(Result,1,pOn-1) ;
  pON:=Pos(' ON ',Result);
 end;
end;           

function DispositionFrom(const SQLText:string):TPoint;
var FromText:string;
begin
{
 FromText:=UpperCase(SQLText);
 FromText:=ReplaceStr(UpperCase(SQLText),Chr(13),' ');
 FromText:=ReplaceStr(FromText,Chr(10),' ');
 Result.X:=Pos('FROM ',FromText);
 if Result.X=0 then Exit;
 Result.Y:=Pos('WHERE ',FromText)-1;
     if Result.Y=0 then
     begin
      Result.Y:=Pos('GROUP ',FromText)-1;
      if Result.Y=0 then
      begin
       Result.Y:=Pos('ORDER ',FromText)-1
      end;
     end;
 if Result.Y=-1 then Result.Y:=Length(FromText)+1
 else begin
  while FromText[Result.Y] in [' ',#13,#10] do Dec(Result.Y);
  Inc(Result.Y)
 end;}

  FromText:=ReplaceStr(UpperCase(SQLText),Chr(13),' ');
  FromText:=ReplaceStr(FromText,Chr(10),' ');
  Result.X:=Pos('FROM ',FromText);
  if Result.X=0 then Exit;
  Result.Y:=Pos('WHERE ',FromText);
  if Result.Y=0 then
  begin
    Result.Y:=Pos('GROUP ',FromText);
    if Result.Y=0 then
      Result.Y:=Pos('ORDER ',FromText)
  end;
  if Result.Y=0 then Result.Y:=Length(FromText)
  else begin
    Dec(Result.Y);
    while FromText[Result.Y] = ' ' do Dec(Result.Y)
  end;
  Inc(Result.Y)
end;


procedure AllTables(const SQLText:string;FTables:Tstrings);
var s,FromText:string;
      i,p:integer;
      DFrom       :TPoint;
begin
 FTables.Clear;
 if Trim(SQLText)='' then Exit;
 DFrom:=DispositionFrom(SQLText);
 FromText:=Copy(SQLText,DFrom.X+4,DFrom.Y-DFrom.X-3);
 FromText:=ReplaceStr(Trim(FromText),Chr(13),' ');
 FromText:=ReplaceStr(Trim(FromText),Chr(10),' ');

 if FromText='' then Exit;
 if Pos(' JOIN ',FromText)>0 then FromText:=RemoveJoins(FromText);
 if Pos('(',FromText)>0 then FromText:=RemoveSP(FromText);
 p:=WordCount(FromText,[',']);
 for  i:=1  to p do   begin
  s:=ExtractWord(i, FromText,[',']);
  s:=Trim(s);
  FTables.Add(s);
 end;
end;

function AdapteSQLText(const SQLText:string):string;
begin
  Result:=ReplaceStr(UpperCase(SQLText), #13,' ');
  Result:=ReplaceStr(Result, #10,' ');
end;

function WhereCount(SQLText:string):integer;
var p:integer;
begin
  SQLText:=AdapteSQLText(SQLText);
  Result:=0;
  p:=Pos(BeginWhere,SQLText);
  while p>0 do begin
   Inc(Result);
   SQLText:=Copy(SQLText,p+7,10000);
   p:=Pos(BeginWhere,SQLText);
  end;
end;


function  GetWhereClause(SQLText:string;N:integer):string;
var p,p1,p2:integer;
begin
//  N  where clause
  Result:='';
  SQLText:=AdapteSQLText(SQLText);
  p1:=0;  p:=Pos(BeginWhere,SQLText);
  while  (p>0) and (p1<N) do begin
   Inc(p1);
   SQLText:=Copy(SQLText,p+7,10000);
   p:=Pos(BeginWhere,SQLText);
  end;
  if (p1<N) then Exit;
  p:=1; p1:=0; p2:=0;
  // p1= count of '('; p2= count of ')'
  while (p<Length(SQLText)) and (p2<=p1) do begin
   if SQLText[p]='(' then Inc(p1)
   else
   if SQLText[p]=')' then Inc(p2);
   Inc(p)
  end;
  if p2>p1 then SQLText:=Copy(SQLText,1,p-1);
  Result:=SQLText;
  p:=Pos(' GROUP ',SQLText);
  if p>0 then begin
   Result:=Copy(SQLText,1,p-1); Exit
  end
  else begin
   p:=Pos(' PLAN ',UpperCase(SQLText));
   if p>0 then begin
    Result:=Copy(SQLText,1,p-1); Exit
   end
   else begin
    p:=Pos(' ORDER ',UpperCase(SQLText));
    if p>0 then  Result:=Copy(SQLText,1,p-1);
   end
  end
end;

function  AddToWhereClause(SQLText,NewClause:string):string;
var p:integer;
begin
  if Trim(NewClause)='' then begin
    Result:=SQLText;  Exit
  end;
  p:=Pos('WHERE ',UpperCase(SQLText));
  if p>0 then begin
   Result:=Copy(SQLText,1,p+5)+ForceNewStr+NewClause;
   if Trim(Copy(SQLText,p+6,MaxInt))<>'' then
   Result:=Result+' and '+ForceNewStr+Copy(SQLText,p+6,MaxInt);
  end
  else begin
   p:=Pos('GROUP ',UpperCase(SQLText));
   if p=0 then p:=Pos('ORDER ',UpperCase(SQLText));
   if p>0 then
     Result:=Copy(SQLText,1,p-1)+BeginWhere+ForceNewStr+NewClause+ForceNewStr+
      Copy(SQLText,p,MaxInt)
   else
     Result:=SQLText+BeginWhere+ForceNewStr+NewClause;
  end
end;

function PrepareConstraint(Src:Tstrings):string;
var i,pos_no: integer;
begin
//      
//    
//   
    Result := Trim(Src.Text);
    pos_no := Pos('(',Trim(Result))+1;
    Result:=Copy(Result,Pos_no,Length(Result));
    pos_no :=-1;
    for i := Length(Result) downto 1 do
     if Result[i]=')' then begin pos_no := i; Break; end;
    Result:=Copy(Result,1,Pos_no-1);
    Result:=
     ReplaceStr(Copy(Result,Pos_no,Length(Result)-Pos_no), '"',QuotMarks)
end;

procedure DeleteEmptyStr(Src:Tstrings);
var I:integer;
begin
 i:=0;
 while i<Src.Count do
  if Src[i]='' then Src.Delete(i)
  else Inc(i)
end;

end.
