{********************************************************************}
{                                                                    }
{        Routine work with TRegistry                                 }
{     Copyright (c) 04.1999 by Serge Buzadzhy                        }
{     email:  serge_buzadzhy@mail.ru,                                }
{             FidoNet: 2:467/44.37                                   }
{                                                                    }
{********************************************************************}

unit RegUtils;

interface
 uses Windows,SysUtils,Classes,registry;

 procedure DefWriteToRegistry( const OtherKeys , ParamNames: array of string;
  const Values: array of Variant
 );

 procedure WriteToRegistry(aRootKey:HKEY; const OtherKeys,ParamNames: array of string;
  const Values: array of Variant
 );

 function ReadFromRegistry(aRootKey:HKEY;
  const OtherKeys,  ParamNames: array of string
 ):Variant;

 function DefReadFromRegistry(const OtherKeys, ParamNames: array of string):Variant;

 function AllSubKey(aRootKey:HKEY; const ForPath: array of string):Variant;
 function DefAllSubKey(const ForPath: array of string):Variant;
implementation

{ HKEY  VALUES :
  HKEY_CURRENT_USER // Default
  HKEY_LOCAL_MACHINE
  HKEY_CLASSES_ROOT
  HKEY_USERS
  HKEY_PERFORMANCE_DATA
  HKEY_CURRENT_CONFIG
  HKEY_DYN_DATA
}

 procedure DefWriteToRegistry( const OtherKeys , ParamNames: array of string;
  const   Values: array of Variant
 );
 begin
  WriteToRegistry(HKEY_CURRENT_USER,OtherKeys,ParamNames,Values)
 end;

 procedure WriteToRegistry(aRootKey:HKEY;const  OtherKeys,ParamNames: array of string;
  const Values: array of Variant
 );
 var RegObj:TRegistry;
     i,minPar:integer;
 begin
   RegObj:=TRegistry.Create;
   with RegObj do
   try
    RootKey:=aRootKey;
    for i:=Low(OtherKeys) to High(OtherKeys) do   OpenKey(OtherKeys[i],true);
    minPar:=High(ParamNames);
    if minPar>High(Values) then minPar:=High(Values);
    for i:=0 to minPar do
     case VarType(Values[i]) of
      varSmallint,varInteger:WriteInteger(ParamNames[i],Values[i]);
      varSingle,  varDouble :WriteFloat(ParamNames[i],Values[i]);
      varCurrency           :WriteCurrency(ParamNames[i],Values[i]);
      varBoolean            :WriteBool(ParamNames[i],Values[i]);
      varString             :WriteString(ParamNames[i],Values[i]);
      varDate               :WriteDateTime(ParamNames[i],Values[i]);
     end
   finally
    Free
   end;
end;

function ReadFromRegistry(aRootKey:HKEY;
 const  OtherKeys,  ParamNames: array of string
):Variant;
 var RegObj:TRegistry;
     i,cPar:integer;
begin
   RegObj:=TRegistry.Create;
   with RegObj do
   try
    Result:=false;
    RootKey:=aRootKey;
    for i:=Low(OtherKeys) to High(OtherKeys) do
     if not OpenKey(OtherKeys[i],false) then  Exit;
    cPar:=High(ParamNames);
    Result:=VarArrayCreate([0, 1, 0, cPar], varVariant);
    for i:=0 to cPar do try
     Result[0,i]:=ReadString(ParamNames[i]);
     Result[1,i]:=Result[0,i]<>'';
    except
     Result[1,i]:=false //can't read as string
    end;
   finally
    Free
   end;
end;



function DefReadFromRegistry(const OtherKeys, ParamNames: array of string):Variant;
begin
 Result:=ReadFromRegistry(HKEY_CURRENT_USER,OtherKeys,ParamNames)
end;

function AllSubKey(aRootKey:HKEY; const ForPath: array of string):Variant;
var RegObj:TRegistry;
    i:integer;
    SubKeys:TStrings;
begin
   RegObj:=TRegistry.Create;
   SubKeys:=TStringList.Create;
   with RegObj do
   try
    Result:=false;
    RootKey:=aRootKey;
    for i:=Low(ForPath) to High(ForPath) do
     if not OpenKey(ForPath[i],false) then  Exit;
    GetKeyNames(SubKeys);
    if SubKeys.Count=0 then Exit;
    Result:=VarArrayCreate([0,Pred(SubKeys.Count)], varOleStr);
    for i:=0 to Pred(SubKeys.Count) do   Result[i]:=SubKeys[i];
   finally
    SubKeys.Free;
    Free
   end;
end;

function DefAllSubKey(const ForPath: array of string):Variant;
begin
 Result:=AllSubKey(HKEY_CURRENT_USER,ForPath)
end;

end.



