unit RegFIBPlusEditors;

interface
{$I FIBPlus.INC}
 uses Classes,Sysutils,DB,Dialogs,Controls,
  pFIBDataSet,pFIBDatabase,FIBSqlEd,
  pFIBQuery, DSContainer,FIBSQLMonitor,pFIBErrorHandler,
  DsgnIntf,
  {$IFDEF INSTALL_EVENTALERT}
   pFIBEvent,  pFIBEvedt,
  {$ENDIF}
  {$IFDEF FOR_ALL} pFIBProps {$ELSE}sbFIBProps {$ENDIF}

  // Added by Serg Vostrikov
  {$IFDEF CAN_DYN_ARRAY}
   {$IFDEF  INC_SERVICE_SUPPORT}
  ,IB_Services
   {$ENDIF}
  {$ENDIF}
  ;

type
  TFieldInfoEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;
  

procedure Register;

implementation

uses RegUtils,FIBDataSet,FIBQuery,FIBDatabase,SqlTxtRtns,StrUtil,
 EdFieldInfo,pFIBDataInfo,EdDataSetInfo
;

const FIBPalette='FIBPlus';

type
  TFIBAliasEdit =class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  function TFIBAliasEdit.GetAttributes: TPropertyAttributes;
  begin
   Result:=inherited GetAttributes;
   Result:=Result+[paValueList]
  end;

  procedure TFIBAliasEdit.GetValues(Proc: TGetStrProc);
  var i:integer;
      Keys:Variant;
  begin
   if PropCount>1 then Exit;
   Keys:=DefAllSubKey(['Software','FIBC_Software','Aliases']);
   if VarType(Keys)=varBoolean then Exit;
   for i:=VarArrayLowBound(Keys,1) to VarArrayHighBound(Keys,1) do Proc(Keys[i])
  end;
//

type
  TDataSet_ID_Edit =class(TIntegerProperty)
  public
   function GetAttributes: TPropertyAttributes;override;
   procedure Edit; override;
  end;

function TDataSet_ID_Edit.GetAttributes: TPropertyAttributes;
begin
 Result:= inherited GetAttributes +[paDialog];
end;

procedure TDataSet_ID_Edit.Edit;
var OldID:integer;
begin
 OldID:=TpFIBDataSet(GetComponent(0)).DataSet_ID;
 ChooseDSInfo(TpFIBDataSet(GetComponent(0)));
 if OldID<>TpFIBDataSet(GetComponent(0)).DataSet_ID then
  Modified
end;
//
  type TTableNameEdit =class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  function TTableNameEdit.GetAttributes: TPropertyAttributes;
  begin
   Result:=inherited GetAttributes;
   Result:=Result+[paValueList]
  end;

  procedure TTableNameEdit.GetValues(Proc: TGetStrProc);
  var i:integer;
      Tables:TStrings;
  begin
   if PropCount>1 then Exit;
   if not (TAutoUpdateOptions(GetComponent(0)).Owner is TpFIBDataSet) then Exit;
   Tables:=TStringList.Create;
   with TpFIBDataSet(TAutoUpdateOptions(GetComponent(0)).Owner) do try
     AllTables(SelectSQL.Text,Tables);
     for i:=0 to Pred(Tables.Count) do  Proc(ExtractWord(1,Tables[i],[' ']));
   finally
    Tables.Free
   end
  end;
//

  type TKeyFieldNameEdit =class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  function TKeyFieldNameEdit.GetAttributes: TPropertyAttributes;
  begin
   Result:=inherited GetAttributes;
   Result:=Result+[paValueList]
  end;

  procedure TKeyFieldNameEdit.GetValues(Proc: TGetStrProc);
  var i:integer;
      Tables:TStrings;
  begin
   if PropCount>1 then Exit;
   if not (TAutoUpdateOptions(GetComponent(0)).Owner is TpFIBDataSet) then Exit;
   Tables:=TStringList.Create;
   with TpFIBDataSet(TAutoUpdateOptions(GetComponent(0)).Owner),
    TAutoUpdateOptions(GetComponent(0))
    do try
     if Trim(UpdateTableName)='' then Exit;
     FieldDefs.Update;
     for i:=0 to Pred(FieldCount) do begin
      if (Fields[i] is TIntegerField) and
       (ExtractWord(1,GetFieldOrigin(Fields[i]),['.'])=UpperCase(UpdateTableName)) then
      Proc(Fields[i].FieldName);
     end;
   finally
    Tables.Free
   end
  end;






procedure TFieldInfoEditor.ExecuteVerb(Index: Integer);
begin
 if not ExistFRepositaryTable(TFIBDataBase(Component)) then begin
   if
    MessageDlg('Table FIB$FIELDS_INFO not exist.'+#13#10+
     'Create it?', mtConfirmation	,[mbOK ,mbCancel], 0
    )<>mrOk
   then Exit;
   CreateFRepositaryTable(TFIBDataBase(Component));
 end;
 ShowFieldInfo(TFIBDataBase(Component))
end;

function TFieldInfoEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := 'Edit Field info table';
  end;
end;

function TFieldInfoEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;


// DataSet component editors

type
  PClass = ^TClass;
  
  TFIBGenSQlEd = class(TComponentEditor)
    DefaultEditor:TComponentEditor;
  public
   {$IFDEF VER100}
     constructor Create(AComponent: TComponent;ADesigner: TFormDesigner); override;
   {$ELSE}
     constructor Create(AComponent: TComponent;ADesigner: IFormDesigner); override;
   {$ENDIF}
    destructor Destroy;  override;
    procedure ExecuteVerb(Index: Integer); override;
    function  GetVerb(Index: Integer): string; override;
    function  GetVerbCount: Integer; override;
    procedure SaveDataSetInfo;
  end;

 {$IFDEF VER100}
  constructor TFIBGenSQlEd.Create(AComponent: TComponent;ADesigner: TFormDesigner);
 {$ELSE}
  constructor TFIBGenSQlEd.Create(AComponent: TComponent;ADesigner: IFormDesigner);
 {$ENDIF}
  var CompClass:TClass;
  begin
   inherited Create(AComponent,ADesigner);
   CompClass:=PClass(Acomponent)^;
   try
    PClass(AComponent)^:=TDataSet;
    DefaultEditor:=GetComponentEditor(AComponent,ADesigner);
   finally
    PClass(AComponent)^:=CompClass;
   end;
  end;

  destructor TFIBGenSQlEd.Destroy;
  begin
   DefaultEditor.Free;
   inherited Destroy
  end;

  function TFIBGenSQlEd.GetVerbCount: Integer;
  begin
   if (Component is TpFIBDataSet) then
    Result:=DefaultEditor.GetVerbCount+2
   else
    Result:=DefaultEditor.GetVerbCount+1;
  end;

  function TFIBGenSQlEd.GetVerb(Index: Integer): string;
  begin
    if Index < DefaultEditor.GetVerbCount then
      Result:=DefaultEditor.GetVerb(Index)
    else
    case Index-DefaultEditor.GetVerbCount  of
     0:  Result := 'Generator SQls';
     1:  Result := 'Edit DataSets info table';
    end;
  end;

  procedure TFIBGenSQlEd.ExecuteVerb(Index: Integer);
  begin
   if Index < DefaultEditor.GetVerbCount then
    DefaultEditor.ExecuteVerb(Index)
   else
    case Index  -DefaultEditor.GetVerbCount of
     0:  if ShowGenSQL(TFIBDataSet(Component)) then  Designer.Modified;
     1:  SaveDataSetInfo
    end
  end;

  procedure TFIBGenSQlEd.SaveDataSetInfo;
  begin
   with Component as TpFibDataSet do
    if DataSet_ID= 0 then ShowMessage(Name+'.DataSet_ID must be greater 0')
    else
    if DataBase=nil then  ShowMessage('DataBase not assigned')
    else  begin
       if not ExistDRepositaryTable(TFIBDataset(Component).DataBase) then begin
        if
         MessageDlg('Table FIB$DATASETS_INFO not exist.'+#13#10+
           'Create it?', mtConfirmation	,[mbOK ,mbCancel], 0
         )<>mrOk
        then Exit;
         CreateDRepositaryTable(TFibDataSet(Component).DataBase);
       end;
      SaveFIBDataSetInfo(TpFibDataSet(Component));
   end;
  end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string),TpFIBDatabase,'AliasName',TFIBAliasEdit);
  {$IFDEF INSTALL_EVENTALERT}
  RegisterPropertyEditor(TypeInfo(TStrings), TpFIBEventer, 'Events', TEventsProperty);
  {$ENDIF}
  RegisterPropertyEditor(TypeInfo(string),TAutoUpdateOptions,
    'UpdateTableName',TTableNameEdit
  );
  RegisterPropertyEditor(TypeInfo(string),TAutoUpdateOptions,
    'KeyFields',TKeyFieldNameEdit
  );
  RegisterPropertyEditor(TypeInfo(integer),TpFIBDataSet,
    'DataSet_ID',TDataSet_ID_Edit
  );

  RegisterComponentEditor(TpFIBDatabase, TFieldInfoEditor);
  RegisterComponentEditor(TFIBDataSet, TFIBGenSQlEd);
end;

end.
