{********************************************************************}
{                                                                    }
{                    TFIBGenSQlEd                                    }
{ Generator SQls for TFIBDataSet from Free IB components             }
{                                                                    }
{     Copyright (c) 04.1999 by Serge Buzadzhy                        }
{     email:  serge_buzadzhy@mail.ru,                                }
{             FidoNet: 2:467/44.37                                   }
{                                                                    }
{                                                                    }
{********************************************************************}

unit FIBSqlEd;

interface
{$I FIBPlus.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB,FIBDataSet, StdCtrls, ExtCtrls, FIBQuery, FIBSQLMonitor,
  Buttons, ComCtrls, Menus, pFIBQuery, pFIBDataSet;

type
  TfrmGenSQL = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel1: TPanel;
    cmbTables: TComboBox;
    btnGetFields: TButton;
    Panel2: TPanel;
    Label1: TLabel;
    LstKeyFields: TListBox;
    Splitter1: TSplitter;
    Panel3: TPanel;
    Label2: TLabel;
    LstUpdFields: TListBox;
    qryTabFields: TpFIBDataSet;
    btnGenSql: TButton;
    grSQLKind: TRadioGroup;
    Panel4: TPanel;
    Button1: TButton;
    Button2: TButton;
    viewSQL: TMemo;
    btnClearSQLs: TButton;
    btnPrepareSQL: TButton;
    qryCheck: TpFIBQuery;
    GroupBox1: TGroupBox;
    chCheck: TCheckBox;
    FindDialog1: TFindDialog;
    qryPrimaryFields: TpFIBQuery;
    GroupBox2: TGroupBox;
    chByPrimary: TCheckBox;
    chNonUpdPrKey: TCheckBox;
    btnSave1SQL: TButton;
    btnCheckSQls: TButton;
    chFieldOrigin: TCheckBox;
    TabSheet3: TTabSheet;
    qryAllTables: TpFIBDataSet;
    ViewBufText: TMemo;
    lstAllTables: TListBox;
    Splitter2: TSplitter;
    PopupMenu1: TPopupMenu;
    miTables: TMenuItem;
    miSP: TMenuItem;
    qrySPs: TpFIBDataSet;
    qrySPparams: TpFIBDataSet;
    Panel5: TPanel;
    cmbOutPut: TComboBox;
    Label3: TLabel;
    EdTabSyn: TEdit;
    LbTableSyn: TLabel;
    procedure btnGetFieldsClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure grSQLKindClick(Sender: TObject);
    procedure btnGenSqlClick(Sender: TObject);
    procedure btnClearSQLsClick(Sender: TObject);
    procedure btnPrepareSQLClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure btnPrepareSQLMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnPrepareSQLKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure viewSQLKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FindDialog1Find(Sender: TObject);
    procedure cmbTablesChange(Sender: TObject);
    procedure viewSQLChange(Sender: TObject);
    procedure btnSave1SQLClick(Sender: TObject);
    procedure btnCheckSQlsClick(Sender: TObject);
    procedure miTablesClick(Sender: TObject);
    procedure lstAllTablesDblClick(Sender: TObject);
    procedure lstAllTablesMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lstAllTablesKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    FFIBDataSet:TFIBDataSet;
    FTables    :TStringList;
    FAllFields :Tstrings;
    FPrimKeyFields:Tstrings;
    FUpdTableSynonym:string;
    procedure WMGetMinMaxInfo(var M: TWMGetMinMaxInfo); message WM_GetMinMaxInfo;
    function FindInTabFields(const vFieldName:string):boolean;
    procedure FillTableList;
    procedure FillPrimKeyFields;
    procedure FillAllFields;
    function  GetFieldOrigin(const tfdName:string):string;
    function  ShortRealName(const FieldName:string):string;
    procedure ShowSQL;
    procedure CheckSQL(SQL:Tstrings; const ErrMessage:string);
    procedure SaveFieldsOrigin;
  private
    FSelectSQL:Tstrings;
    FInsertSQL:Tstrings;
    FUpdateSQL:Tstrings;
    FDeleteSQL:Tstrings;
    FRefreshSQL:Tstrings;
    function GetSelectSQL:Tstrings;
    procedure SetSelectSQL(Value:TStrings);
    function WhereClause(withSyn:boolean):string;
    procedure GenerateInsertSQL;
    procedure GenerateUpdateSQL;
    procedure GenerateDeleteSQL;
    procedure GenerateRefreshSQL;
    property SelectSQL:Tstrings read GetSelectSQL write  SetSelectSQL ;
  private
    function  GetDialect: integer;
    procedure CalcOptionsPage;
    procedure GenerateSQLs;
    function  GetOutPutText:TStrings;
    procedure GenTemplate(isSP:boolean);
    property  Dialect:integer read GetDialect;
  public
  end;

function  ShowGenSQL(aDataSet:TFIBDataSet):boolean;



implementation

{$R *.DFM}
uses dsgnintf,TypInfo,StrUtil,SqlTxtRtns,pFIBDataInfo;

const
   errPrefix='Error  in ';


var
   LastTop, LastLeft,   LastWidth,LastHeight:integer;

function  ShowGenSQL(aDataSet:TFIBDataSet):boolean;
var frmGenSQL:TfrmGenSQL;
begin
  Result:=false;
  if aDataSet=nil then Exit;
  if (aDataSet.DataBase=nil) or (aDataSet.Transaction=nil) then
   raise Exception.Create('Database(or Transaction) not assigned');
  if not aDataSet.DataBase.Connected then
       raise Exception.Create('Database not connected');
  Application.CreateForm(TfrmGenSQL,frmGenSQL);
  with frmGenSQL,aDataSet do begin
   if LastTop<>0 then  Top:=LastTop;
   if LastLeft<>0 then Left:=LastLeft;
   if LastWidth<>0 then Width:=LastWidth;
   if LastHeight<>0 then Height:=LastHeight;
   FTables:=TStringList.Create;
   FAllFields    :=TStringList.Create;
   FPrimKeyFields:=TStringList.Create;
   FInsertSQL    :=TStringList.Create;FUpdateSQL:=TStringList.Create;
   FDeleteSQL    :=TStringList.Create;FRefreshSQL:=TStringList.Create;
   FSelectSQL    :=TStringList.Create;
   FUpdTableSynonym:='';
   FFIBDataSet:=aDataSet;
    with aDataSet do begin
     qryTabFields.DataBase         :=DataBase;
     qryTabFields.Transaction      :=Transaction;
     qryCheck    .DataBase         :=DataBase;
     qryCheck    .Transaction      :=Transaction;
     qryAllTables.DataBase         :=DataBase;
     qryAllTables.Transaction      :=Transaction;
     qryPrimaryFields.DataBase     :=DataBase;
     qryPrimaryFields.Transaction  :=Transaction;
     qrySPs          .DataBase     :=DataBase;
     qrySPs          .Transaction  :=Transaction;
     qrySPparams     .DataBase     :=DataBase;
     qrySPparams     .Transaction  :=Transaction;
    end;
    FSelectSQL.Assign(SelectSQL);
    FInsertSQL.Assign(InsertSQL);
    FUpdateSQL.Assign(UpdateSQL);
    FDeleteSQL.Assign(DeleteSQL);
    FRefreshSQL.Assign(RefreshSQL);
    cmbOutPut.ItemIndex:=0;
    CalcOptionsPage;
    Result:=ShowModal=mrOk;
    LastTop:=Top;
    LastLeft   :=Left;
    LastWidth  :=Width;
    LastHeight :=Height;

     FAllFields.Free;  FTables.Free;
     FPrimKeyFields.Free;
     FInsertSQL.Free;  FUpdateSQL.Free;
     FDeleteSQL.Free;  FRefreshSQL.Free; FSelectSQL.Free;
    frmGenSQL.Free;
  end;
end;


procedure TfrmGenSQL.WMGetMinMaxInfo(var M: TWMGetMinMaxInfo);
begin
    inherited;
    with M.MinMaxInfo^ do begin
     ptMinTrackSize.X:=466;
     ptMinTrackSize.Y:=360;
    end;
end;

function  TfrmGenSQL.GetDialect: integer;
begin
 Result:=qryTabFields.DataBase.SQLDialect;
end;

function TfrmGenSQL.GetSelectSQL:Tstrings;
begin
 Result:=FFIBDataSet.SelectSQL
end;

procedure TfrmGenSQL.SetSelectSQL(Value:Tstrings);
begin
 with FFIBDataSet do begin
  if Active then Close;
  SelectSQL:=Value
 end;
end;

procedure TfrmGenSQL.FillPrimKeyFields;
begin
 FPrimKeyFields.Clear;
 if cmbTables.Text='' then Exit;
 with qryPrimaryFields do begin
   Params[0].AsString := cmbTables.Text;
   Close;
   ExecQuery;
   while not eof do begin
    FPrimKeyFields.Add(Trim(Fields[0].asString));
    Next
   end;
  end;
end;

procedure TfrmGenSQL.FillTableList;
begin
 AllTables(SelectSQL.Text,FTables);
end;

procedure TfrmGenSQL.CalcOptionsPage;
var i:integer;
begin
 with cmbTables do begin
  FillTableList;
  Items:=FTables;
  for i:=0 to Pred(Items.Count) do begin
   if Pos('"',Items[i])>0 then begin
    Items[i]:=Copy(Items[i],2,MaxInt);
    Items[i]:=Copy(Items[i],1,Pos('"',Items[i])-1);
   end
   else
   Items[i]:=ExtractWord(1, Items[i],[' ']);
  end;

  if Items.Count>0 then  begin
   ItemIndex:=0;
   cmbTablesChange(cmbTables)
  end;
  LstKeyFields.Clear;  LstUpdFields.Clear;
 end;
end;

function TfrmGenSQL.GetFieldOrigin(const tfdName:string):string;
var fPos:integer;
    curName:string;
begin
  Result:='';
  fPos:=0;
with FFIBDataSet do begin
  if not Prepared then Prepare;
  with QSelect do
   while fPos<Current.Count do
   with Current[fPos].Data^ do
   begin
    SetString(curName, aliasname, aliasname_length);
    if tfdName=curName then Break;
    Inc(fPos)
   end;
  if fPos=QSelect.Current.Count then Exit;
  with QSelect.Current[fPos].Data^ do begin
    SetString(curName, relname, relname_length);
    SetString(Result, sqlname, sqlname_length);
    Result:=curName+'.'+Result;
  end
end;

end;



function  TfrmGenSQL.ShortRealName(const FieldName:string):string;
begin
 Result:=ExtractWord(2,GetFieldOrigin(FieldName),['.'])
end;

procedure TfrmGenSQL.SaveFieldsOrigin;
var i:integer;
begin
 with FFIBDataSet do begin
   if DefaultFields or (not Active and (FieldCount=0)) then Exit;
   for i:=0 to Pred(FieldCount) do
     Fields[i].Origin:=GetFieldOrigin(Fields[i].FieldName);
 end;
end;

function TfrmGenSQL.FindInTabFields(const vFieldName:string):boolean;
begin
 Result:=false;
 with qryTabFields do begin
  First;
  while not eof do begin
   Result:=Trim(Fields[0].asString)=vFieldName;
   if Result then Exit;
   Next
  end;
 end;
end;

procedure TfrmGenSQL.FillAllFields;
var j:integer;
    tfd:TFieldDef;
    rfn:string;
    NeedField:boolean;
begin
 if cmbTables.Text='' then exit;
 with FFIBDataSet,FFIBDataSet.FieldDefs do begin
  try
   Update; 
  except
    btnCheckSQlsClick(nil)
  end;
  FAllFields.Clear; 
  with qryTabFields do begin
   Params[0].Asstring := cmbTables.Text;
   Close;Open;
  end;
  for  j:=0   to Count-1 do  begin
    tfd:=FieldDefs[j];
    NeedField:=(FieldCount=0);
    if not NeedField then  NeedField:=FindField(tfd.Name)<>nil;
    if not NeedField then Continue;
    rfn:=GetFieldOrigin(tfd.Name);
    NeedField:=(cmbTables.Text=ExtractWord(1,rfn,['.']));
    rfn:=ExtractWord(2,rfn,['.']);
    if NeedField then NeedField:=FindInTabFields(rfn);
    if NeedField then begin
     FAllFields.AddObject(tfd.Name,tfd);
    end;
  end;                            
 end;
end;

procedure TfrmGenSQL.ShowSQL;
begin
 case grSQLKind.ItemIndex of
  0:viewSQL.Lines:=FSelectSQL;
  1:viewSQL.Lines:=FUpdateSQL;
  2:viewSQL.Lines:=FInsertSQL;
  3:viewSQL.Lines:=FDeleteSQL;
  4:viewSQL.Lines:=FRefreshSQL;
 end;
end;

procedure TfrmGenSQL.GenerateDeleteSQL;
begin
 with  FDeleteSQL,LstKeyFields do begin
  FDeleteSQL.Clear;
  Add('DELETE FROM '+  FormatIdentifier(Dialect,cmbTables.Text));
  Add(' WHERE '+WhereClause(false));
 end;
end;


procedure TfrmGenSQL.GenerateInsertSQL;
var j:integer;
    pn,rfn,tmpStr,tmpStr1:string;
    vpFIBTableInfo:TpFIBTableInfo;
    vFi:TpFIBFieldInfo;
begin
 with  FInsertSQL,LstUpdFields do begin
  FInsertSQL.Clear;
  tmpStr:='';tmpStr1:='';
  vpFIBTableInfo:=ListTableInfo.
                   GetTableInfo(qryTabFields.Database,
                      cmbTables.Text
                   );

  for j:=0 to Pred(Items.Count) do begin
   rfn:=ShortRealName(Items[j]);

   vFi:=vpFIBTableInfo.FieldInfo(rfn);
   if (vFi=nil) or  vFi.IsComputed or vFi.IsTriggered then
    Continue;
   rfn:=FormatIdentifier(Dialect,rfn);
   pn :=FormatIdentifier(Dialect,Items[j]);
   if Selected[j]  then  begin
     tmpStr :=tmpStr+ForceNewStr+rfn+',';
     tmpStr1:=tmpStr1+ForceNewStr+'?'+pn+',';
   end;
  end;
  if tmpStr<>'' then
   if tmpStr[Length(tmpStr)]=','   then tmpStr :=Copy(tmpStr,1,Length(tmpStr)-1);
  if tmpStr1<>'' then
   if tmpStr1[Length(tmpStr1)]=',' then tmpStr1:=Copy(tmpStr1,1,Length(tmpStr1)-1);
  Add('INSERT INTO '+FormatIdentifier(Dialect,cmbTables.Text)+'('+tmpStr); Add(')');
  Add('VALUES('+tmpStr1); Add(')');
 end;
end;

procedure TfrmGenSQL.GenerateUpdateSQL;
var j:integer;
    pn,rfn,tmpStr:string;
    vpFIBTableInfo:TpFIBTableInfo;
    vFi:TpFIBFieldInfo;

begin
 with  FUpdateSQL,LstUpdFields do begin
  FUpdateSQL.Clear;
  tmpStr:='';
  vpFIBTableInfo:=ListTableInfo.
                   GetTableInfo(qryTabFields.Database,
                      cmbTables.Text
                   );
  
  for j:=0 to Pred(Items.Count) do begin
   rfn:=ShortRealName(Items[j]);
   vFi:=vpFIBTableInfo.FieldInfo(rfn);
   if (vFi=nil) or  vFi.IsComputed or vFi.IsTriggered then
    Continue;
   rfn:=FormatIdentifier(Dialect,rfn);
   pn :=FormatIdentifier(Dialect,Items[j]);
   if Selected[j] then  begin
     if not chNonUpdPrKey.Checked or
        (FPrimKeyFields.IndexOf(rfn)=-1)
     then
      tmpStr :=tmpStr+ForceNewStr+rfn+' = ?'+pn+',';
   end;
  end;
  if tmpStr<>'' then
   if tmpStr[Length(tmpStr)]=','   then tmpStr :=Copy(tmpStr,1,Length(tmpStr)-1);
  Add('UPDATE '+FormatIdentifier(Dialect,cmbTables.Text)+' SET '+tmpStr);
  Add(' WHERE '+WhereClause(false))
 end;
end;



procedure TfrmGenSQL.GenerateRefreshSQL;
begin
  FRefreshSQL.Text:=AddToWhereClause(SelectSQL.Text,'('+WhereClause(true)+')')
end;

function TfrmGenSQL.WhereClause(withSyn:boolean):string;
var i,j:integer;
    pn,rfn:string;
begin
 with  LstKeyFields do begin
  i:=0;Result:=ForceNewStr+space+space;
  for j:=0 to Pred(Items.Count) do begin
   if Selected[j] then  begin
    Inc(i);
    if (Items.Objects[j]<>nil) and
       (TFieldDef(Items.Objects[j]).DataType=ftBlob) or
       (TFieldDef(Items.Objects[j]).DataType=ftMemo) or
       (TFieldDef(Items.Objects[j]).DataType=ftBytes)
    then
     Continue;   

    rfn:=ShortRealName(Items[j]);
    rfn:=FormatIdentifier(Dialect,rfn);
    pn :=FormatIdentifier(Dialect,'OLD_'+Items[j]);
    if withSyn and (FUpdTableSynonym<>'.') then
     Result:=Result+FUpdTableSynonym+rfn+' = ?'+pn+ForceNewStr
    else
     Result:=Result+rfn+' = ?'+pn+ForceNewStr;

    if i<SelCount then Result:=Result+' and '
   end;
  end;
 end;
 Result:=space+Result
end;

procedure TfrmGenSQL.GenerateSQLs;
begin
 GenerateInsertSQL;
 GenerateUpdateSQL;
 GenerateDeleteSQL;
 GenerateRefreshSQL;
end;                               

//
procedure TfrmGenSQL.btnGetFieldsClick(Sender: TObject);
var i:integer;
    rfn:string;
begin
 FillAllFields;
 LstKeyFields.Items:=FAllFields;
 LstUpdFields.Items:=FAllFields;
 if chByPrimary.Checked or chNonUpdPrKey.Checked then FillPrimKeyFields;
 try
    LstKeyFields.Items.BeginUpdate;
    LstUpdFields.Items.BeginUpdate;
    with LstKeyFields,LstKeyFields.Items do begin
     i:=0;
     while i<Count do begin
      if (Objects[i]<>nil) and
        (TFieldDef(Objects[i]).DataType=ftBlob) or
        (TFieldDef(Objects[i]).DataType=ftMemo) or
        (TFieldDef(Objects[i]).DataType=ftBytes)
      then begin
       Delete(i);
       Continue;
      end;

      rfn:=ShortRealName(Items[i]);
      Selected[i]:=not chByPrimary.Checked or (FPrimKeyFields.IndexOf(rfn)>-1);
      Inc(i)
     end;
    end;
    for i:=0 to Pred(LstUpdFields.Items.Count) do  LstUpdFields.Selected[i]:=true;
 finally
    LstKeyFields.Items.EndUpdate;
    LstUpdFields.Items.EndUpdate;
 end
end;                               

procedure TfrmGenSQL.Button1Click(Sender: TObject);
var NeedReOpen:boolean;
begin
 if chCheck.Checked then btnCheckSQlsClick(btnCheckSQls);
 with FFIBDataSet do begin
  if chFieldOrigin.Checked then  SaveFieldsOrigin;
  NeedReOpen:=Active;
  if NeedReOpen then Close;
  SelectSQL.Text :=FSelectSQL.Text;
  InsertSQL.Text :=FInsertSQL.Text;
  UpdateSQL.Text :=FUpdateSQL.Text;
  DeleteSQL.Text :=FDeleteSQL.Text;
  RefreshSQL.Text:=FRefreshSQL.Text;
  if (FFIBDataSet is TpFIBDataSet) then
  begin
     if TpFibDataSet(FFIBDataSet).DataSet_Id>0 then
      if ExistDRepositaryTable(FFIBDataSet.Database) and
       not SaveFIBDataSetInfo(TpFibDataSet(FFIBDataSet)) then
        TpFibDataSet(FFIBDataSet).DataSet_Id:=0
  end;
  if NeedReOpen then Open;
 end;
 ModalResult:=mrOk
end;

procedure TfrmGenSQL.Button2Click(Sender: TObject);
begin
 Close
end;

procedure TfrmGenSQL.grSQLKindClick(Sender: TObject);
begin
 ShowSQL
end;

procedure TfrmGenSQL.btnGenSqlClick(Sender: TObject);
begin
  GenerateSQLs;
  ShowSQL;
  PageControl1.ActivePage:=TabSheet2
end;

procedure TfrmGenSQL.btnClearSQLsClick(Sender: TObject);
var NeedReopen:boolean;
begin
 with FFIBDataSet do begin
  NeedReopen:=Active;
  if NeedReopen then Close;
  InsertSQL.Clear;   UpdateSQL.Clear;
  DeleteSQL.Clear;   RefreshSQL.Clear;
  FInsertSQL.Clear;  FUpdateSQL.Clear;
  FDeleteSQL.Clear;  FRefreshSQL.Clear;
  if NeedReopen then begin
   Open; FillAllFields
  end;
 end;
end;

procedure TfrmGenSQL.btnCheckSQlsClick(Sender: TObject);
begin
  CheckSQL(FSelectSQL, errPrefix+'SelectSQL');
  CheckSQL(FUpdateSQL, errPrefix+'UpdateSQL');
  CheckSQL(FInsertSQL, errPrefix+'InsertSQL');
  CheckSQL(FDeleteSQL, errPrefix+'DeleteSQL');
  CheckSQL(FRefreshSQL,errPrefix+'RefreshSQL');
end;

procedure TfrmGenSQL.CheckSQL(SQL:Tstrings; const ErrMessage:string);
var LineErr,LineErrPos:integer;
    ErrCol,NumLineErr:string;
    i,l:integer;
    errType:byte;
begin
  if SQL.Text='' then exit;
  qryCheck.SQL.Text:=SQL.Text;
  try
   qryCheck.Prepare
  except
  ON E:Exception do
   if ErrMessage='' then begin
    //   viewSQL.Lines
    //      
    //   :)
    LineErrPos:=Pos('line',E.Message);
    if LineErrPos>0 then begin
         NumLineErr:=Copy(E.Message,LineErrPos+5,255);
         NumLineErr:=ExtractWord(1, NumLineErr,[' ',',']);
         LineErr:= StrToIntDef(NumLineErr, -1);
         if LineErr>-1 then begin
          l:=0;
          for i:=0 to LineErr-2 do L:=L+2+Length(SQL[i]);
          viewSQL.SelStart :=L;
          viewSQL.SelLength:=Length(SQL[LineErr-1])
        end;
    end                    
    else    begin
     LineErrPos:=Pos('Column unknown',E.Message);
     if LineErrPos>0 then begin
      errType:=1;
      ErrCol    :=Copy(E.Message,LineErrPos+17,255)
     end
     else begin
      LineErrPos:=Pos('Table unknown',E.Message);
      ErrCol    :=Copy(E.Message,LineErrPos+16,255);
      errType:=2;
     end;
     if LineErrPos=0 then raise;
     ErrCol    :=Copy(ErrCol,1,Length(ErrCol)-3);
     l:=0;
     for i:=0 to Pred(SQL.Count) do begin
      if (errType=2) and (Pos('FROM',UpperCase(SQL[i]))<>0) then errType:=1;
      if errType=1 then begin
       LineErrPos:=Pos(ErrCol,UpperCase(SQL[i]));
       if LineErrPos<>0 then Break;
      end;
      L:=L+2+Length(SQL[i]);
     end;
     if LineErrPos<>0 then begin
          viewSQL.SelStart :=L+LineErrPos-1;
          viewSQL.SelLength:=Length(ErrCol)
     end;
    end;
    raise
   end
    else raise Exception.Create(ErrMessage);
  end
end;

procedure TfrmGenSQL.btnPrepareSQLClick(Sender: TObject);
begin
  if viewSQL.Lines.Text='' then
    raise Exception.Create('SQL is empty.');
  CheckSQL(viewSQL.Lines,'');
  ShowMessage('It is correct SQL');
end;

procedure TfrmGenSQL.FormResize(Sender: TObject);
begin
 btnPrepareSQL.Top :=Height-154;
 btnSave1SQL.Top   :=btnPrepareSQL.Top+29;
 btnSave1SQL.Left  :=Width-137;
 btnPrepareSQL.Left:=btnSave1SQL.Left;
 Panel3.Width:=Trunc((Width-174)/2);
end;

procedure TfrmGenSQL.PageControl1Change(Sender: TObject);
begin
 ShowSQL
end;

type
  THackRadioGroup = class(TCustomGroupBox)
  private
    FButtons: TList;
  end;

procedure TfrmGenSQL.viewSQLChange(Sender: TObject);
var CanHack:boolean;
begin
 if viewSQL.Focused then
  case grSQLKind.ItemIndex of
   0:FSelectSQL.Assign(viewSQL.Lines);
   1:FUpdateSQL.Assign(viewSQL.Lines);
   2:FInsertSQL.Assign(viewSQL.Lines);
   3:FDeleteSQL.Assign(viewSQL.Lines);
   4:FRefreshSQL.Assign(viewSQL.Lines);
  end;

{$IFDEF VER100}                {Borland Delphi 3.0 }
 CanHack:=true;
{$ELSE}
 {$IFDEF VER120}               {Borland Delphi 4.0 }
   CanHack:=true;
 {$ELSE}
 {$IFDEF VER130}               {Borland Delphi 5.0 }
   CanHack:=true;
 {$ELSE}
   CanHack:=false;
 {$ENDIF}
 {$ENDIF}
{$ENDIF}

if CanHack then
 with THackRadioGroup(grSQLKind),FFIBDataSet do begin
    if FSelectSQL.Text <> SelectSQL.Text then
       TRadioButton(FButtons[0]).Font.Color:=clRed
    else
       TRadioButton(FButtons[0]).Font.Color:=clBlack;

    if FUpdateSQL.Text <> UpdateSQL.Text then
       TRadioButton(FButtons[1]).Font.Color:=clRed
    else
       TRadioButton(FButtons[1]).Font.Color:=clBlack;

    if FInsertSQL.Text <> InsertSQL.Text then
       TRadioButton(FButtons[2]).Font.Color:=clRed
    else
       TRadioButton(FButtons[2]).Font.Color:=clBlack;

    if FDeleteSQL.Text <> DeleteSQL.Text then
       TRadioButton(FButtons[3]).Font.Color:=clRed
    else
       TRadioButton(FButtons[3]).Font.Color:=clBlack;

    if FRefreshSQL.Text <> RefreshSQL.Text then
       TRadioButton(FButtons[4]).Font.Color:=clRed
    else
       TRadioButton(FButtons[4]).Font.Color:=clBlack;
end;

end;

procedure TfrmGenSQL.btnSave1SQLClick(Sender: TObject);
var DestStrs:Tstrings;
    NeedReOpen:boolean;
begin
 with FFIBDataSet do    begin
   case grSQLKind.ItemIndex of
    0:DestStrs:=SelectSQL;
    1:DestStrs:=UpdateSQL;
    2:DestStrs:=InsertSQL;
    3:DestStrs:=DeleteSQL;
   else
    DestStrs:=RefreshSQL;
   end;
   CheckSQL(viewSQL.Lines,'');
   NeedReOpen:=Active;
   if NeedReOpen then Close;
   DestStrs.Text:=viewSQL.Lines.Text;
   if NeedReopen then begin
    Open; FillAllFields
   end;
   if   grSQLKind.ItemIndex=0   then CalcOptionsPage;
 end;
 viewSQLChange(viewSQL)
end;

procedure TfrmGenSQL.cmbTablesChange(Sender: TObject);
begin
 with cmbTables do
  if ItemIndex>-1 then
   FUpdTableSynonym:=ExtractLastWord(FTables[ItemIndex],[' ']) +'.'
  else
   FUpdTableSynonym:='';
end;

procedure TfrmGenSQL.btnPrepareSQLMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 viewSQL.SetFocus;
end;

procedure TfrmGenSQL.btnPrepareSQLKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key=VK_RETURN then  viewSQL.SetFocus;
end;

procedure TfrmGenSQL.viewSQLKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if ssCtrl in Shift then
  if Chr(Key) in ['F','f','',''] then
    FindDialog1.Execute;
 if Key=VK_F3 then FindDialog1Find(FindDialog1)
end;

procedure TfrmGenSQL.FindDialog1Find(Sender: TObject);
var L,p,j:integer;
    curL:integer;
    lv:string;
    CurMemo:TMemo;
begin
  //  . 
  L:=0;
  if viewSQL.Focused then   CurMemo:=viewSQL  else CurMemo:=ViewBufText;
  with CurMemo do
  for j:=0 to Pred(Lines.Count) do begin
    curL:=Length(Lines[j]);
    if (L+curL)<SelStart then L:=L+curL+2
    else begin
       if (L-1)< SelStart then begin
        lv:=Copy(Lines[j],SelStart+SelLength-L,MaxInt);
        p:=Pos(AnsiUpperCase(FindDialog1.FindText),AnsiUpperCase(lv));
        if p>0 then p:=p+SelStart+SelLength-L-1;
       end
       else begin
        lv:=Lines[j];
        p:=Pos(AnsiUpperCase(FindDialog1.FindText),AnsiUpperCase(lv));
       end;
       if (p=0)  then L:=L+curL+2
       else begin
         if L=0 then SelStart :=p else SelStart :=L+p-1;
         SelLength:=Length(FindDialog1.FindText);
         SetFocus;
         FindDialog1.CloseDialog;
         Exit;
       end;
    end;
  end;
  FindDialog1.CloseDialog;
end;

procedure TfrmGenSQL.miTablesClick(Sender: TObject);
var DS:TFIBDataSet;
begin
 miTables.Checked:=Sender=miTables;
 miSP    .Checked:=Sender=miSP;
 if miTables.Checked then  DS:=qryAllTables
 else
 if miSP.Checked then  DS:=qrySPs
 else Exit;
 with DS,lstAllTables.Items do begin
  with Transaction do if not Active then begin
   if MessageDlg('Transaction is not Active. Activate?', mtWarning, [mbYes, mbNo], 0) = mrYes then
    Active := True
   else
    Abort;
  end;
  if not Active then Open;
  Clear;  First;
  while not Eof do begin
   Add(Fields[0].asString);
   Next
  end;
 end;
end;

function  TfrmGenSQL.GetOutPutText:TStrings;
begin
 case cmbOutPut.ItemIndex of
  1,2:Result:=FSelectSQL
 else
  Result:=ViewBufText.Lines
 end;
end;

function GetLinePosition(SQL:TStrings;Position:integer):integer;
var L:integer;
begin
 Result:=0; L:=0;
 while (L<Position) and (Result<SQL.Count) do begin
   L:=L+Length(SQL[Result])+2;
   Inc(Result);   
 end;
end;

procedure TfrmGenSQL.GenTemplate(isSP:boolean);
var DefSyn:string;
    Dest:TStrings;
    DFrom:TPoint;
    SysTab:TFIBDataSet;
    LineFrom:integer;
    fn,pars:string;
    IsExecSP:boolean;
begin
 LineFrom:=0;
 with lstAllTables do begin
  if (ItemIndex<0) or (Items[ItemIndex]='') then Exit;
  if EdTabSyn.Text='' then DefSyn:=Copy(Items[ItemIndex],1,3)
  else DefSyn:=EdTabSyn.Text;
 end;
 Dest:=GetOutPutText;
 if isSP then SysTab:=qrySPparams else SysTab:=qryTabFields;
 with SysTab,Dest do begin
   SysTab.Prepare;
   Params[0].AsString :=lstAllTables.Items[lstAllTables.ItemIndex];
   Close;Open;
   if RecordCount=0 then Exit;
   if cmbOutPut.ItemIndex=1 then Dest.Clear;
   ViewBufText.Lines.Add(MakeStr('=',15));
   IsExecSP:=IsSP and (Fields[2].asInteger=0) ;
   if IsExecSP then begin
     Dest:=ViewBufText.Lines;
     Add('EXECUTE PROCEDURE ');DefSyn:=' ';
     cmbOutPut.ItemIndex:=0
   end;

   if cmbOutPut.ItemIndex<>2 then begin
    if not IsExecSP then  Add('SELECT')
   end
   else begin
    DFrom:=DispositionFrom(Dest.Text);
    if DFrom.X=0 then raise Exception.Create('Clause "FROM" not found')
    else  begin
     Dest.Text:=Copy(Dest.Text,1,DFrom.X-1)+#13#10+
                Copy(Dest.Text,DFrom.X,DFrom.Y-DFrom.X)+ForceNewStr+
                Copy(Dest.Text,DFrom.Y+1,MaxInt)
                ;
     LineFrom:=GetLinePosition(Dest,DFrom.X+2)-1;
    end;
   end;
   while not eof and (not IsSP or (Fields[2].asInteger<>0)) do begin
    fn:=FormatIdentifier(Dialect,Fields[0].asString);
    if cmbOutPut.ItemIndex<>2 then
     Add(Space+DefSyn+'.'+fn+',')
    else begin
     Dest[LineFrom-1]:=Dest[LineFrom-1]+',';
     Insert(LineFrom,Space+DefSyn+'.'+fn);
     Inc(LineFrom)
    end;
    Next
   end;

   pars:='';
   if IsSP then   begin
     //Input SP params
       while not eof  do begin
        pars:=pars+ForceNewStr+'?'+Trim(Fields[0].asString)+',';
        Next
       end;
       if pars<>'' then
        pars:=ForceNewStr+'('+Copy(pars,1,Length(pars)-1)+ForceNewStr+')';
   end;

   if cmbOutPut.ItemIndex<>2 then begin
    Strings[Pred(Count)]:=Copy(Strings[Pred(Count)],1,Length(Strings[Pred(Count)])-1);
    Add('FROM');
    Add(Space+ FormatIdentifier(Dialect,lstAllTables.Items[lstAllTables.ItemIndex])+pars+' '+DefSyn)
   end
   else begin
    DFrom:=DispositionFrom(Dest.Text);
    LineFrom :=GetLinePosition(Dest,DFrom.Y);
    Insert(LineFrom,Space+ 'JOIN '+
      Trim(lstAllTables.Items[lstAllTables.ItemIndex])+pars+' '+DefSyn+ ' ON ( )')
   end;
  end;
  DeleteEmptyStr(Dest);
  if cmbOutPut.ItemIndex>0 then ViewBufText.Lines.AddStrings(Dest)
end;


procedure TfrmGenSQL.lstAllTablesDblClick(Sender: TObject);
begin
 GenTemplate(miSP.Checked)
end;

procedure TfrmGenSQL.lstAllTablesKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then  lstAllTablesDblClick(Sender)
end;

procedure TfrmGenSQL.lstAllTablesMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var p:TPoint;
begin
 if not(miTables.Checked or miSP.Checked )then begin
  p.X:=X; p.Y:=Y;
  p:=lstAllTables.ClientToScreen(p);
  with p do  PopupMenu1.Popup(X,Y);
 end;
end;


initialization
 LastTop:=0;   LastLeft:=0;
 LastWidth:=0; LastHeight:=0
end.




