unit EdDataSetInfo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FIBDatabase, pFIBDatabase, Db, FIBDataSet, pFIBDataSet, Grids, DBGrids,
  StdCtrls, ExtCtrls, DBCtrls, Mask;

type
  TfrmEdDataSetInfo = class(TForm)
    trDSInfo: TpFIBTransaction;
    qryDSInfo: TpFIBDataSet;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Edit1: TEdit;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Panel2: TPanel;
    cmbKindSQL: TComboBox;
    DBMemo1: TDBMemo;
    DBEdit1: TDBEdit;
    Label1: TLabel;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    procedure qryDSInfoFilterRecord(DataSet: TDataSet;
      var Accept: Boolean);
    procedure Edit1Change(Sender: TObject);
    procedure cmbKindSQLChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmEdDataSetInfo: TfrmEdDataSetInfo;

function ChooseDSInfo(ForDataSet:TpFIBDataSet):boolean;

implementation

uses StrUtil,pFIBDataInfo;

{$R *.DFM}

function ChooseDSInfo(ForDataSet:TpFIBDataSet):boolean;
begin
 Result:=false;
 if ForDataSet=nil then Exit;
 if frmEdDataSetInfo=nil then
  frmEdDataSetInfo:=TfrmEdDataSetInfo.Create(nil);
 with frmEdDataSetInfo,frmEdDataSetInfo.qryDSInfo do
 try
  trDSInfo.DefaultDataBase:=ForDataSet.DataBase;
  DataBase      :=ForDataSet.DataBase;
  Open;
  if ForDataSet.DataSet_ID>0 then
   ExtLocate('DS_ID',ForDataSet.DataSet_ID,[eloInSortedDS]);
   Result:=ShowModal=mrOk;
   if Result then begin
    ForDataSet.DataSet_ID:=qryDSInfo.FN('DS_ID').asInteger;
    ListDataSetInfo.ClearDSInfo(ForDataSet);
    if ForDataSet.Active then begin
     ForDataSet.Close;
     ForDataSet.Open
    end;
   end;
 finally  
   frmEdDataSetInfo.Free;
   frmEdDataSetInfo:=nil
 end;
end;

procedure TfrmEdDataSetInfo.qryDSInfoFilterRecord(DataSet: TDataSet;
  var Accept: Boolean);
begin
 Accept:=Trim(Edit1.Text)='';
 if not Accept then begin
  Accept:=PosCI(Edit1.Text,DataSet.FieldByName('DESCRIPTION').asString)>0
 end;
end;

procedure TfrmEdDataSetInfo.Edit1Change(Sender: TObject);
begin
 qryDSInfo.Filtered:=Trim(Edit1.Text)<>''
end;

procedure TfrmEdDataSetInfo.cmbKindSQLChange(Sender: TObject);
begin
 with  DBMemo1 do
 case cmbKindSQL.ItemIndex of
  0: DataField:='SELECT_SQL';
  1: DataField:='UPDATE_SQL';
  2: DataField:='INSERT_SQL';
  3: DataField:='DELETE_SQL';
  4: DataField:='REFRESH_SQL';
 end;
end;

procedure TfrmEdDataSetInfo.FormCreate(Sender: TObject);
begin
 cmbKindSQL.ItemIndex:=0;
end;

procedure TfrmEdDataSetInfo.Button1Click(Sender: TObject);
begin
  if qryDSInfo.State in [dsEdit,dsInsert] then qryDSInfo.Post;
  trDSInfo.CommitRetaining;
end;

procedure TfrmEdDataSetInfo.Button2Click(Sender: TObject);
begin
 trDSInfo.RollBack
end;

end.
